/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.lib.gui.checkboxtree;

import com.sap.engine.configtool.lib.gui.checkboxtree.CheckBoxTreeNodeInfo;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;

public class CheckBoxTreeCellEditor
extends AbstractCellEditor
implements TreeCellEditor {
    public Object getCellEditorValue() {
        return null;
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        JLabel result = new JLabel();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        CheckBoxTreeNodeInfo info = (CheckBoxTreeNodeInfo)node.getUserObject();
        if (info.getStatus() == 2) {
            this.rememberCustoms(node);
        }
        byte status = info.getNextStatus();
        info.setStatus(status);
        result.setIcon(info.getIcon());
        result.setText(info.toString());
        result.setBackground(isSelected ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground"));
        result.setForeground(isSelected ? UIManager.getColor("Tree.selectionForeground") : UIManager.getColor("Tree.textForeground"));
        this.calcChildren(node, status);
        this.calcParent(node, status);
        tree.repaint();
        return result;
    }

    private void calcChildren(DefaultMutableTreeNode node, byte status) {
        if (status != 2) {
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                ((CheckBoxTreeNodeInfo)child.getUserObject()).setStatus(status);
                this.calcChildren(child, status);
            }
        } else {
            this.getFromLastCustom(node);
        }
    }

    private void calcParent(DefaultMutableTreeNode node, byte status) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        if (parent == null) {
            return;
        }
        CheckBoxTreeNodeInfo info = (CheckBoxTreeNodeInfo)parent.getUserObject();
        if (status == 2) {
            info.setStatus((byte)2);
            info.setHasCustom(true);
            this.calcParent(parent, (byte)2);
            return;
        }
        Enumeration<TreeNode> children = parent.children();
        while (children.hasMoreElements()) {
            if (((CheckBoxTreeNodeInfo)((DefaultMutableTreeNode)children.nextElement()).getUserObject()).getStatus() == status) continue;
            info.setStatus((byte)2);
            info.setHasCustom(true);
            this.calcParent(parent, status);
            return;
        }
        info.setStatus(status);
        info.setHasCustom(false);
        this.calcParent(parent, status);
    }

    private void rememberCustoms(DefaultMutableTreeNode node) {
        CheckBoxTreeNodeInfo info = (CheckBoxTreeNodeInfo)node.getUserObject();
        byte status = info.getStatus();
        info.setLastCustomStatus(status);
        info.setHasCustom(status == 2);
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            this.rememberCustoms((DefaultMutableTreeNode)children.nextElement());
        }
    }

    private void getFromLastCustom(DefaultMutableTreeNode node) {
        CheckBoxTreeNodeInfo info = (CheckBoxTreeNodeInfo)node.getUserObject();
        info.setStatus(info.getLastCustomStatus());
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            this.getFromLastCustom((DefaultMutableTreeNode)children.nextElement());
        }
    }
}

