/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.lib;

import java.util.Hashtable;
import java.util.Properties;

public final class PropertiesUtil {
    public static Properties getDBProperties(String driverLocation, int dbIC, int dbMC, String dbUrl, String dbUser, String dbPassword) {
        return PropertiesUtil.getDBProperties(null, null, null, null, null, driverLocation, dbIC, dbMC, dbUrl, dbUser, dbPassword);
    }

    public static Properties getDBProperties(String secStoreFile, String secStoreKey, String secStoreSystemName, String secStoreLib, String rdbmsConnection, String driverLocation, int dbIC, int dbMC) {
        return PropertiesUtil.getDBProperties(secStoreFile, secStoreKey, secStoreSystemName, secStoreLib, rdbmsConnection, driverLocation, dbIC, dbMC, null, null, null);
    }

    public static Properties getDBProperties(String secStoreFile, String secStoreKey, String secStoreSystemName, String secStoreLib, String rdbmsConnection, String driverLocation, int dbIC, int dbMC, String dbUrl, String dbUser, String dbPassword) {
        Properties props = new Properties();
        PropertiesUtil.setProperty(props, "secstorefs.secfile", secStoreFile);
        PropertiesUtil.setProperty(props, "secstorefs.keyfile", secStoreKey);
        PropertiesUtil.setProperty(props, "system.name", secStoreSystemName);
        PropertiesUtil.setProperty(props, "secstorefs.lib", secStoreLib);
        PropertiesUtil.setProperty(props, "rdbms.connection", rdbmsConnection);
        PropertiesUtil.setProperty(props, "rdbms.driverLocation", driverLocation);
        PropertiesUtil.setIntegerProperty(props, "rdbms.initial_connections", dbIC);
        PropertiesUtil.setIntegerProperty(props, "rdbms.maximum_connections", dbMC);
        PropertiesUtil.setProperty(props, "rdbms.url", dbUrl);
        PropertiesUtil.setProperty(props, "rdbms.user", dbUser);
        PropertiesUtil.setProperty(props, "rdbms.password", dbPassword);
        return props;
    }

    public static Properties mergeProperties(Properties oldProps, Properties newProps) {
        Properties result = null;
        if (oldProps != null) {
            result = new Properties();
            ((Hashtable)result).putAll(oldProps);
        }
        if (newProps != null) {
            if (result == null) {
                result = new Properties();
            }
            ((Hashtable)result).putAll(newProps);
        }
        return result;
    }

    public static Boolean getBooleanProperty(Properties properties, String key, String yesValue) {
        return PropertiesUtil.getBooleanProperty(properties, key, null, yesValue);
    }

    public static Boolean getBooleanProperty(Properties properties, String key, String defaultValue, String yesValue) {
        Boolean result = null;
        try {
            result = new Boolean(properties.getProperty(key, defaultValue).equals(yesValue));
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public static boolean getVisualBooleanProperty(Properties properties, String key, String yesValue) {
        return PropertiesUtil.getBooleanProperty(properties, key, "ivkrasfam", yesValue);
    }

    public static void setBooleanProperty(Properties properties, String key, Boolean value, String yesValue) {
        if (value != null) {
            properties.setProperty(key, value != false ? yesValue : "no");
        }
    }

    public static void setBooleanProperty(Properties properties, String key, boolean value, String yesValue) {
        PropertiesUtil.setBooleanProperty(properties, key, new Boolean(value), yesValue);
    }

    public static Integer getIntegerProperty(Properties properties, String key) {
        return PropertiesUtil.getIntegerProperty(properties, key, null);
    }

    public static Integer getIntegerProperty(Properties properties, String key, String defaultValue) {
        Integer result = null;
        try {
            result = Integer.valueOf(properties.getProperty(key, defaultValue));
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public static int getVisualIntegerProperty(Properties properties, String key) {
        return PropertiesUtil.getIntegerProperty(properties, key, "0");
    }

    public static void setIntegerProperty(Properties properties, String key, Integer value) {
        if (value != null) {
            properties.setProperty(key, value.toString());
        }
    }

    public static void setIntegerProperty(Properties properties, String key, int value) {
        PropertiesUtil.setIntegerProperty(properties, key, new Integer(value));
    }

    public static String getProperty(Properties properties, String key) {
        return PropertiesUtil.getProperty(properties, key, null);
    }

    public static String getProperty(Properties properties, String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static String getVisualProperty(Properties properties, String key) {
        return PropertiesUtil.getProperty(properties, key, "");
    }

    public static void setProperty(Properties properties, String key, String value) {
        if (value != null) {
            properties.setProperty(key, value);
        }
    }

    public static void putAll(Properties properties, Properties newProperties) {
        if (properties != null && newProperties != null) {
            ((Hashtable)properties).putAll(newProperties);
        }
    }
}

