/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.lib;

import java.util.ArrayList;
import java.util.Properties;

public final class PortsCalculator {
    private static final String CLUSTER_NAME_PREFIX = "SAP J2EEngine Cluster";
    private static final String DISPATCHER_NAME_PREFIX = "Dispatcher";
    private static final String SERVER_NAME_PREFIX = "Server";
    public static final int MAX_DISPATCHERS_COUNT = 1;
    public static final int MAX_SERVERS_COUNT = 16;
    public static final int DISPATCHER_ELEMENT_ID_PREFIX = 0;
    public static final int SERVER_ELEMENT_ID_PREFIX = 50;
    private static final int BN_DIGITS = 5;
    private static final int TEN_POWER_BN_DIGITS = (int)Math.pow(10.0, 5.0);
    private static final int PI = 31415;
    private static final int PORT_BASE = 50000;
    private static final int DISP_SERVICE_HTTP_PORT_INDEX = 0;
    private static final int DISP_SERVICE_HTTP_SSL_PORT_INDEX = 1;
    private static final int DISP_SERVICE_P4_PORT_INDEX = 4;
    private static final int DISP_SERVICE_P4_HTTP_TUNNELING_INDEX = 5;
    private static final int DISP_SERVICE_P4_SSL_INDEX = 6;
    private static final int DISP_SERVICE_IIOP_PORT_INDEX = 7;
    private static final int DISP_SERVICE_IIOP_INITIAL_CONTEXT_PORT_INDEX = 2;
    private static final int DISP_SERVICE_IIOP_SSL_SOCKET_INDEX = 3;
    private static final int DISP_SERVICE_TELNET_PORT_INDEX = 8;
    private static final int DISP_SERVICE_LOG_VIEWER_PORT_INDEX = 9;
    private static final int DISP_SERVICE_JMS_PORT_INDEX = 10;
    private static final int SERV_MANAGER_CLUSTER_ELEMENT_JOIN_PORT_INDEX = 0;
    private static final int SERV_DEBUG_PORT_INDEX = 1;
    public static final String ELEMENT_ID = "give me my ID please";
    public static final String FULL_ELEMENT_ID = "give me my full ID please";
    public static final String DISP_MANAGER_CLUSTER_CLUSTER_NAME = "disp.manager.cluster.cluster.name";
    public static final String DISP_MANAGER_CLUSTER_ELEMENT_NAME = "disp.manager.cluster.element.name";
    public static final String DISP_MANAGER_CLUSTER_ELEMENT_CLUSTER_ID = "disp.manager.cluster.element.clusterId";
    public static final String DISP_MANAGER_CLUSTER_ELEMENT_GROUP_ID = "disp.manager.cluster.element.groupId";
    public static final String DISP_SERVICE_HTTP_PORT = "disp.service.http.Port";
    public static final String DISP_SERVICE_HTTP_SSL_PORT = "disp.service.http.SslPort";
    public static final String DISP_SERVICE_IIOP_PORT = "disp.service.iiop.port";
    public static final String DISP_SERVICE_IIOP_INITIAL_CONTEXT_PORT = "disp.service.iiop.initialContextPort";
    public static final String DISP_SERVICE_IIOP_SSL_SOCKET = "disp.service.iiop.ssl_socket";
    public static final String DISP_SERVICE_LOG_VIEWER_PORT = "disp.service.log.viewer.port";
    public static final String DISP_SERVICE_P4_PORT = "disp.service.p4.port";
    public static final String DISP_SERVICE_P4_SSL = "disp.service.p4.ssl";
    public static final String DISP_SERVICE_P4_HTTP_TUNNELING = "disp.service.p4.httptunneling";
    public static final String DISP_SERVICE_TELNET_PORT = "disp.service.telnet.port";
    public static final String DISP_SERVICE_JMS_PORT = "disp.service.jms.port";
    public static final String SERV_MANAGER_CLUSTER_CLUSTER_NAME = "serv.manager.cluster.cluster.name";
    public static final String SERV_MANAGER_CLUSTER_ELEMENT_NAME = "serv.manager.cluster.element.name";
    public static final String SERV_MANAGER_CLUSTER_ELEMENT_CLUSTER_ID = "serv.manager.cluster.element.clusterId";
    public static final String SERV_MANAGER_CLUSTER_ELEMENT_GROUP_ID = "serv.manager.cluster.element.groupId";
    public static final String SERV_MANAGER_CLUSTER_ELEMENT_JOIN_PORT = "serv.manager.cluster.element.joinPort";
    public static final String SERV_DEBUG_PORT = "serv.debug.port";
    private int sid;
    private int bn;
    private int idPrefix;
    private int portPrefix;

    public PortsCalculator(int sid, String bn, String elementType) {
        if (sid < 0) {
            throw new NumberFormatException("sid must be positive " + sid);
        }
        this.sid = sid;
        this.bn = this.getPositiveBoxNumber(bn);
        this.idPrefix = (sid * TEN_POWER_BN_DIGITS + this.bn) * 100;
        if (elementType.equals("dispatcher")) {
            this.idPrefix += 0;
            this.portPrefix = 50000 + sid * 100;
        } else if (elementType.equals("server")) {
            this.idPrefix += 50;
            this.portPrefix = 50000 + sid * 100 + 20;
        } else {
            throw new IllegalArgumentException("elementType unknown: " + elementType);
        }
    }

    public String getElementIdPrefix() {
        return "ID" + String.valueOf(this.idPrefix / 100);
    }

    public Properties getNewDispatcherConfiguration(int[] allocatedIds) throws IndexOutOfBoundsException {
        Properties result = null;
        ArrayList freeIds = this.getFreeIds(allocatedIds, 1);
        if (freeIds.size() == 0) {
            throw new IndexOutOfBoundsException("No more free IDs for new Dispatchers");
        }
        int firstFreeId = (Integer)freeIds.get(0);
        int elementId = firstFreeId % 100 - 0;
        result = new Properties();
        result.setProperty(FULL_ELEMENT_ID, String.valueOf(firstFreeId));
        result.setProperty(ELEMENT_ID, String.valueOf(elementId));
        result.setProperty(DISP_MANAGER_CLUSTER_CLUSTER_NAME, "SAP J2EEngine Cluster " + String.valueOf(this.sid));
        result.setProperty(DISP_MANAGER_CLUSTER_ELEMENT_NAME, "Dispatcher " + String.valueOf(elementId) + " " + String.valueOf(this.sid) + "_" + String.valueOf(this.bn));
        result.setProperty(DISP_MANAGER_CLUSTER_ELEMENT_CLUSTER_ID, String.valueOf(firstFreeId));
        result.setProperty(DISP_MANAGER_CLUSTER_ELEMENT_GROUP_ID, String.valueOf(this.bn));
        result.setProperty(DISP_SERVICE_HTTP_PORT, String.valueOf(this.portPrefix + 0));
        result.setProperty(DISP_SERVICE_HTTP_SSL_PORT, String.valueOf(this.portPrefix + 1));
        result.setProperty(DISP_SERVICE_IIOP_PORT, String.valueOf(this.portPrefix + 7));
        result.setProperty(DISP_SERVICE_IIOP_INITIAL_CONTEXT_PORT, String.valueOf(this.portPrefix + 2));
        result.setProperty(DISP_SERVICE_IIOP_SSL_SOCKET, String.valueOf(this.portPrefix + 3));
        result.setProperty(DISP_SERVICE_LOG_VIEWER_PORT, String.valueOf(this.portPrefix + 9));
        result.setProperty(DISP_SERVICE_P4_PORT, String.valueOf(this.portPrefix + 4));
        result.setProperty(DISP_SERVICE_P4_SSL, String.valueOf(this.portPrefix + 6));
        result.setProperty(DISP_SERVICE_P4_HTTP_TUNNELING, String.valueOf(this.portPrefix + 5));
        result.setProperty(DISP_SERVICE_TELNET_PORT, String.valueOf(this.portPrefix + 8));
        result.setProperty(DISP_SERVICE_JMS_PORT, String.valueOf(this.portPrefix + 10));
        return result;
    }

    public Properties getNewServerConfiguration(int[] allocatedIds) throws IndexOutOfBoundsException {
        Properties result = null;
        ArrayList freeIds = this.getFreeIds(allocatedIds, 16);
        if (freeIds.size() == 0) {
            throw new IndexOutOfBoundsException("No more free IDs for new Servers");
        }
        int firstFreeId = (Integer)freeIds.get(0);
        int elementId = firstFreeId % 100 - 50;
        this.portPrefix += 5 * elementId;
        result = new Properties();
        result.setProperty(ELEMENT_ID, String.valueOf(elementId));
        result.setProperty(FULL_ELEMENT_ID, String.valueOf(firstFreeId));
        result.setProperty(SERV_MANAGER_CLUSTER_CLUSTER_NAME, "SAP J2EEngine Cluster " + String.valueOf(this.sid));
        result.setProperty(SERV_MANAGER_CLUSTER_ELEMENT_NAME, "Server " + String.valueOf(elementId) + " " + String.valueOf(this.sid) + "_" + String.valueOf(this.bn));
        result.setProperty(SERV_MANAGER_CLUSTER_ELEMENT_CLUSTER_ID, String.valueOf(firstFreeId));
        result.setProperty(SERV_MANAGER_CLUSTER_ELEMENT_GROUP_ID, String.valueOf(this.bn));
        result.setProperty(SERV_MANAGER_CLUSTER_ELEMENT_JOIN_PORT, String.valueOf(this.portPrefix + 0));
        result.setProperty(SERV_DEBUG_PORT, String.valueOf(this.portPrefix + 1));
        return result;
    }

    public ArrayList getFreeIds(int[] allocatedIds, int maxCount) {
        ArrayList<Integer> allocatedIdsArrayList = new ArrayList<Integer>(allocatedIds.length);
        int i = 0;
        while (i < allocatedIds.length) {
            allocatedIdsArrayList.add(new Integer(allocatedIds[i]));
            ++i;
        }
        ArrayList<Integer> freeIdsArrayList = new ArrayList<Integer>(11);
        int i2 = 0;
        while (i2 < maxCount) {
            Integer possibleId = new Integer(this.idPrefix + i2);
            if (!allocatedIdsArrayList.contains(possibleId)) {
                freeIdsArrayList.add(possibleId);
            }
            ++i2;
        }
        return freeIdsArrayList;
    }

    public String getFirstDispatcherID() {
        return this.idPrefix + "00";
    }

    private int getPositiveBoxNumber(String bn) {
        int result;
        try {
            result = Integer.parseInt(bn);
        }
        catch (NumberFormatException nfe) {
            result = Math.abs(bn.hashCode());
        }
        if ((result %= TEN_POWER_BN_DIGITS) / (TEN_POWER_BN_DIGITS / 10) == 0) {
            result += 31415;
        }
        return result;
    }

    public static String appendIntToString(String str, int size) {
        int zerosToAppend = size - str.length();
        int i = 0;
        while (i < zerosToAppend) {
            str = "0" + str;
            ++i;
        }
        return str;
    }
}

