/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.lib;

import com.sap.engine.configtool.Property;
import com.sap.engine.configtool.PropertyMap;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class ConfigurationUtil {
    public static PropertyEntry createPropertyEntry(PropertySheet sheet, String key, String defaultValue, String description, boolean isSecure) throws ConfigurationException {
        PropertyEntry result = isSecure ? sheet.createSecurePropertyEntry(key, (Object)defaultValue, description) : sheet.createPropertyEntry(key, (Object)defaultValue, description);
        return result;
    }

    public static Properties getProperties(Configuration cfg, String bootstrapPrefix, Properties instanceProperties) {
        Properties result = ConfigurationUtil.getProperties(cfg);
        if (result == null) {
            result = new Properties();
        }
        if (instanceProperties != null) {
            Enumeration keys = ((Hashtable)instanceProperties).keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith(bootstrapPrefix)) continue;
                ((Hashtable)result).put(key, ((Hashtable)instanceProperties).get(key));
            }
        }
        return result;
    }

    public static Properties getProperties(Configuration cfg) {
        Properties result = null;
        if (cfg != null) {
            try {
                if (cfg.getPropertySheetInterface() != null) {
                    result = cfg.getPropertySheetInterface().getProperties();
                }
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return result;
    }

    public static PropertyMap getPropertyEntries(Configuration cfg) {
        PropertyMap result = null;
        if (cfg != null) {
            try {
                PropertyEntry[] entries;
                if (cfg.getPropertySheetInterface() != null && (entries = cfg.getPropertySheetInterface().getAllPropertyEntries()) != null) {
                    result = new PropertyMap();
                    int i = 0;
                    while (i < entries.length) {
                        String customValue;
                        String defaultValue;
                        String name = entries[i].getName();
                        String description = entries[i].getDescription();
                        if (entries[i].isSecure()) {
                            defaultValue = entries[i].getDefault() == null ? null : "**********";
                            customValue = entries[i].getCustom() == null ? null : "**********";
                            result.put(name, new Property(name, defaultValue, customValue, description, true));
                        } else {
                            defaultValue = (String)entries[i].getDefault();
                            customValue = (String)entries[i].getCustom();
                            result.put(name, new Property(name, defaultValue, customValue, description, false));
                        }
                        ++i;
                    }
                }
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSecureProperty(ConfigurationHandler cfgHandler, String cfgPath, String propertyEntryName) throws ConfigurationException {
        boolean isSecure = false;
        Configuration cfg = cfgHandler.openConfiguration(cfgPath, 0);
        try {
            try {
                isSecure = cfg.getPropertySheetInterface().getPropertyEntry(propertyEntryName).isSecure();
            }
            catch (NameNotFoundException nnfe) {
                Object var8_6 = null;
                cfgHandler.closeConfiguration(cfg);
                return isSecure;
            }
            catch (ConfigurationException ce) {
                Object var8_7 = null;
                cfgHandler.closeConfiguration(cfg);
                return isSecure;
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            cfgHandler.closeConfiguration(cfg);
            throw throwable;
        }
        cfgHandler.closeConfiguration(cfg);
        return isSecure;
    }

    public static Configuration getSubConfiguration(Configuration cfg, String subConfigName) {
        Configuration result;
        try {
            result = cfg.getSubConfiguration(subConfigName);
        }
        catch (ConfigurationException ce) {
            result = null;
        }
        return result;
    }

    public static Map getAllSubConfigurations(Configuration cfg) {
        Map result;
        try {
            result = cfg.getAllSubConfigurations();
        }
        catch (ConfigurationException ce) {
            result = null;
        }
        return result;
    }

    public static void getFile(Configuration cfg, String filename, String localPath) throws ConfigurationException, IOException {
        FileOutputStream fileout = new FileOutputStream(localPath + File.separatorChar + filename);
        InputStream in = cfg.getFile(filename);
        byte[] buf = new byte[1024];
        int received = 0;
        while ((received = in.read(buf)) != -1) {
            fileout.write(buf, 0, received);
        }
        fileout.close();
    }

    public static ZipOutputStream openZipFileForWrite(String fileName) throws IOException {
        File dir;
        int pos = fileName.lastIndexOf(47);
        if (pos != -1 && !(dir = new File(fileName.substring(0, pos + 1))).exists() && !dir.mkdirs()) {
            throw new IOException("Can't create archive directory " + dir + "!");
        }
        return new ZipOutputStream(new FileOutputStream(fileName));
    }

    public static void addToZip(Configuration cfg, ZipOutputStream zout) throws IOException, ConfigurationException, InconsistentReadException {
        String tmpFileName = "export_tmp_file";
        File tmpFile = new File(tmpFileName);
        cfg.export(tmpFileName);
        if (tmpFile.exists()) {
            zout.putNextEntry(new ZipEntry(cfg.getPath()));
            FileInputStream in = new FileInputStream(tmpFile);
            byte[] buffer = new byte[10000];
            while (in.available() != 0) {
                int readed = in.read(buffer);
                if (readed <= 0) continue;
                zout.write(buffer, 0, readed);
            }
            zout.closeEntry();
            in.close();
            tmpFile.delete();
        }
    }

    public static void addToZip(Configuration cfg, String fileName, ZipOutputStream zout) throws IOException, ConfigurationException, InconsistentReadException {
        zout.putNextEntry(new ZipEntry(cfg.getPath() + '/' + fileName));
        InputStream in = cfg.getFile(fileName);
        byte[] buffer = new byte[10000];
        int readed = 0;
        while (readed != -1) {
            readed = in.read(buffer);
            if (readed <= 0) continue;
            zout.write(buffer, 0, readed);
        }
        zout.closeEntry();
        in.close();
    }
}

