/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.console.menu;

import com.sap.engine.configtool.console.menu.ConsoleMenu;
import com.sap.engine.configtool.console.menu.ConsoleMenuEvent;
import com.sap.engine.configtool.console.menu.ConsoleMenuListener;
import com.sap.engine.configtool.console.menu.ConsoleMenuSeparator;
import com.sap.engine.configtool.console.menu.DefaultConsoleMenuListener;
import java.util.Enumeration;
import java.util.Vector;

public class ConsoleMenuItem {
    private static ConsoleMenuEvent event = new ConsoleMenuEvent();
    private Vector listeners;
    private ConsoleMenuItem parent;
    private ConsoleMenu mainMenu;
    protected int level;
    private Vector subMenus;
    private String name;
    private int actionCommand;

    public ConsoleMenuItem(String name, int actionCommand) {
        this.name = name;
        this.actionCommand = actionCommand;
        this.listeners = new Vector();
    }

    public boolean isSeparator() {
        return false;
    }

    public int getActionCommand() {
        return this.actionCommand;
    }

    public int getLevel() {
        return this.level;
    }

    public ConsoleMenuItem getParent() {
        return this.parent;
    }

    private void setParent(ConsoleMenuItem parent) {
        this.parent = parent;
        this.mainMenu = parent.getMainMenu();
        this.level = parent.getLevel() + 1;
    }

    public ConsoleMenu getMainMenu() {
        return this.mainMenu;
    }

    public Vector getSubMenus() {
        return this.subMenus;
    }

    public void addSubMenu(ConsoleMenuItem menu) {
        if (this.subMenus == null) {
            this.subMenus = new Vector();
        }
        this.subMenus.addElement(menu);
        menu.setParent(this);
    }

    public void addSeparator() {
        this.addSubMenu(new ConsoleMenuSeparator());
    }

    public void removeSubMenu(ConsoleMenuItem menu) {
        this.subMenus.removeElement(menu);
    }

    public void addListener(ConsoleMenuListener listener) {
        this.listeners.addElement(listener);
    }

    public void addDefaultListener() {
        this.listeners.addElement(DefaultConsoleMenuListener.getInstance());
    }

    public void fireActionPerformed() {
        event.setActionCommand(this.actionCommand);
        event.setCurrentMenu(this);
        event.setMainMenu(this.mainMenu);
        Enumeration elements = this.listeners.elements();
        while (elements.hasMoreElements()) {
            ConsoleMenuListener listener = (ConsoleMenuListener)elements.nextElement();
            listener.actionPerformed(event);
        }
    }

    public boolean checkVisible() {
        event.setActionCommand(this.actionCommand);
        event.setCurrentMenu(this);
        event.setMainMenu(this.mainMenu);
        Enumeration elements = this.listeners.elements();
        while (elements.hasMoreElements()) {
            ConsoleMenuListener listener = (ConsoleMenuListener)elements.nextElement();
            if (listener.checkVisible(event)) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        if (this.subMenus == null) {
            return this.name;
        }
        return this.name + " ...";
    }
}

