/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.console.menu;

import com.sap.engine.configtool.console.menu.ConsoleMenuEvent;
import com.sap.engine.configtool.console.menu.ConsoleMenuItem;
import com.sap.engine.configtool.console.menu.ConsoleMenuListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class ConsoleMenu
extends ConsoleMenuItem
implements ConsoleMenuListener {
    private static final int ACTION_BACK_TO_PREVIOUS = -1;
    private static final int ACTION_BACK_TO_MAIN = -2;
    public static final int ACTION_EXIT = -3;
    private static final String NAME_BACK_TO_PREVIOUS = "Back to the previous menu";
    private static final String NAME_BACK_TO_MAIN = "Back to the main menu";
    private static final String NAME_EXIT = "Exit";
    private static final String SUBMENU_PREFIX = "   ";
    private BufferedReader in;
    private PrintStream out;
    private Vector visibleElements;
    private Object[] visibleArray;
    private boolean exit = false;
    private ConsoleMenuListener exitListener;

    public ConsoleMenu(InputStream in, OutputStream out) {
        super("", 0);
        this.level = -1;
        this.in = new BufferedReader(new InputStreamReader(in));
        this.out = new PrintStream(out);
    }

    public Vector getVisibleElements() {
        return this.visibleElements;
    }

    public ConsoleMenu getMainMenu() {
        return this;
    }

    private void addReturnSubMenus() {
        this.addSeparator();
        ConsoleMenuItem menu = new ConsoleMenuItem(NAME_BACK_TO_PREVIOUS, -1);
        menu.addListener(this);
        this.addSubMenu(menu);
        menu = new ConsoleMenuItem(NAME_BACK_TO_MAIN, -2);
        menu.addListener(this);
        this.addSubMenu(menu);
        this.addSeparator();
        menu = new ConsoleMenuItem(NAME_EXIT, -3);
        menu.addListener(this);
        this.addSubMenu(menu);
    }

    public void setExitListener(ConsoleMenuListener listener) {
        this.exitListener = listener;
    }

    private void printMenus() {
        this.visibleArray = this.visibleElements.toArray();
        this.out.println();
        boolean lastIsSeparator = false;
        int i = 0;
        while (i < this.visibleArray.length) {
            ConsoleMenuItem menu = (ConsoleMenuItem)this.visibleArray[i];
            if (menu.checkVisible()) {
                int j;
                if (menu.isSeparator()) {
                    if (!lastIsSeparator) {
                        j = 0;
                        while (j < menu.getLevel()) {
                            this.out.print(SUBMENU_PREFIX);
                            ++j;
                        }
                        this.out.println("-------------------------");
                        lastIsSeparator = true;
                    }
                } else {
                    j = 0;
                    while (j < menu.getLevel()) {
                        this.out.print(SUBMENU_PREFIX);
                        ++j;
                    }
                    this.out.println(i + 1 + ") " + menu);
                    lastIsSeparator = false;
                }
            }
            ++i;
        }
        this.out.println();
    }

    private int getUserChoice() throws IOException {
        while (true) {
            this.out.print("Your choice: ");
            String line = this.in.readLine();
            try {
                int result = Integer.parseInt(line);
                if (result < 1 || result > this.visibleArray.length) {
                    throw new NumberFormatException();
                }
                return result;
            }
            catch (NumberFormatException e) {
                this.out.println("Invalid input! You should choise number between 1 and " + this.visibleArray.length + ".");
                continue;
            }
            break;
        }
    }

    public String getUserResponce(String question) throws IOException {
        this.out.print(question);
        return this.in.readLine();
    }

    public void pause() throws IOException {
        this.getUserResponce("Press Enter to continue ... ");
    }

    public boolean getUserConfirmation(String question) throws IOException {
        this.out.print(question + "(y/n)");
        String line = this.in.readLine();
        return line.equalsIgnoreCase("y") || line.equalsIgnoreCase("yes");
    }

    public int getSimpleChoise(String question, Object[] possibilitys) throws IOException {
        this.out.println(question);
        int i = 0;
        while (i < possibilitys.length) {
            this.out.println(i + 1 + ") " + possibilitys[i]);
            ++i;
        }
        this.out.println(++i + ") Cancel");
        int result = -1;
        while (result == -1) {
            this.out.print("Your choice: ");
            String line = this.in.readLine();
            try {
                result = Integer.parseInt(line);
                if (result == i) {
                    return -1;
                }
                if (result >= 1 && result <= i) continue;
                throw new NumberFormatException();
            }
            catch (NumberFormatException e) {
                this.out.println("Invalid input! You should choose number between 1 and " + (possibilitys.length + 1) + ".");
                result = -1;
            }
        }
        return result - 1;
    }

    public void start() throws IOException {
        this.addReturnSubMenus();
        this.visibleElements = new Vector(this.getSubMenus());
        while (!this.exit) {
            this.printMenus();
            int choice = this.getUserChoice();
            ConsoleMenuItem selectedMenu = (ConsoleMenuItem)this.visibleArray[choice - 1];
            if (selectedMenu.checkVisible()) {
                selectedMenu.fireActionPerformed();
                continue;
            }
            this.out.println("You are not able to select unvisible menus.");
        }
    }

    public void exit() {
        this.exit = true;
    }

    public void actionPerformed(ConsoleMenuEvent event) {
        switch (event.getActionCommand()) {
            case -1: {
                int max = -1;
                int i = 0;
                while (i < this.visibleArray.length) {
                    int level = ((ConsoleMenuItem)this.visibleArray[i]).getLevel();
                    if (level > max) {
                        max = level;
                    }
                    ++i;
                }
                this.removeAllHigher(max - 1);
                break;
            }
            case -2: {
                this.visibleElements.clear();
                this.visibleElements.addAll(this.getSubMenus());
                break;
            }
            case -3: {
                if (this.exitListener != null) {
                    this.exitListener.actionPerformed(event);
                }
                System.exit(0);
            }
        }
    }

    void removeAllHigher(int currentLevel) {
        int i = 0;
        while (i < this.visibleElements.size()) {
            ConsoleMenuItem menu = (ConsoleMenuItem)this.visibleElements.elementAt(i);
            if (menu != null && menu.getLevel() > currentLevel) {
                this.visibleElements.removeElementAt(i);
                --i;
            }
            ++i;
        }
    }

    public boolean checkVisible(ConsoleMenuEvent event) {
        switch (event.getActionCommand()) {
            case -2: 
            case -1: {
                int i = 0;
                while (i < this.visibleArray.length) {
                    if (((ConsoleMenuItem)this.visibleArray[i]).getLevel() > 0) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        }
        return true;
    }
}

