/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.console;

import com.sap.engine.configtool.ClusterData;
import com.sap.engine.configtool.ClusterElement;
import com.sap.engine.configtool.Instance;
import com.sap.engine.configtool.Manager;
import com.sap.engine.configtool.Property;
import com.sap.engine.configtool.PropertyMap;
import com.sap.engine.configtool.Service;
import com.sap.engine.configtool.batch.Scanner;
import com.sap.engine.configtool.batch.descriptor.BatchConfigDescriptor;
import com.sap.engine.configtool.batch.task.ChangeInstancePropsTask;
import com.sap.engine.configtool.batch.task.ChangeManagerPropsTask;
import com.sap.engine.configtool.batch.task.ChangeServicePropsTask;
import com.sap.engine.configtool.batch.task.CreateNewElementTask;
import com.sap.engine.configtool.batch.task.ElementInfoTask;
import com.sap.engine.configtool.batch.task.RemoveElementTask;
import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.batch.task.TasksManager;
import com.sap.engine.configtool.console.menu.ConsoleMenu;
import com.sap.engine.configtool.console.menu.ConsoleMenuEvent;
import com.sap.engine.configtool.console.menu.ConsoleMenuItem;
import com.sap.engine.configtool.console.menu.ConsoleMenuListener;
import com.sap.engine.configtool.console.menu.DefaultConsoleMenuListener;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.configtool.log.Log;
import com.sap.engine.configtool.log.LogListener;
import com.sap.engine.core.configuration.bootstrap.ConfigurationManagerBootstrapImpl;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class ConsoleConfigTool
implements ConsoleMenuListener,
LogListener {
    private static final String CONFIG_PROPERTIES_FILE_NAME = "config.properties";
    private BatchConfigDescriptor configDescriptor;
    private TasksManager tasksManager = new TasksManager();
    private Properties dbProperties;
    private ConfigurationHandler cfgHandler;
    private ClusterData clusterData;
    private ConsoleMenu mainMenu;
    private boolean hasConnected = false;

    public ConsoleConfigTool() {
        this.configDescriptor = new BatchConfigDescriptor();
        this.dbProperties = new Properties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(CONFIG_PROPERTIES_FILE_NAME));
            this.dbProperties.load(in);
            in.close();
            this.clusterData = this.loadClusterData();
            this.mainMenu = this.initMenus();
        }
        catch (Exception e) {
            System.out.println("Default DB connection failed");
            this.mainMenu = new ConsoleMenu(System.in, System.out);
            ConsoleMenuItem menu = new ConsoleMenuItem("Connect to DB", 1);
            menu.addListener(this);
            this.mainMenu.addSubMenu(menu);
        }
        this.start();
    }

    private void connect() {
        try {
            this.exit();
            this.dbProperties.setProperty("secstorefs.secfile", this.mainMenu.getUserResponce("Secure store file: "));
            this.dbProperties.setProperty("secstorefs.keyfile", this.mainMenu.getUserResponce("Secure store key file: "));
            this.dbProperties.setProperty("system.name", this.mainMenu.getUserResponce("System name: "));
            this.dbProperties.setProperty("secstorefs.lib", this.mainMenu.getUserResponce("Secure store lib: "));
            this.dbProperties.setProperty("rdbms.connection", this.mainMenu.getUserResponce("Rdbms connection: "));
            this.dbProperties.setProperty("rdbms.driverLocation", this.mainMenu.getUserResponce("Rdbms driver location: "));
            this.dbProperties.setProperty("rdbms.initial_connections", this.mainMenu.getUserResponce("Rdbms initial connections: "));
            this.dbProperties.setProperty("rdbms.maximum_connections", this.mainMenu.getUserResponce("Rdbms max connections: "));
            this.clusterData = this.loadClusterData();
            try {
                this.dbProperties.store(new FileOutputStream(CONFIG_PROPERTIES_FILE_NAME), "Config Tool properties");
            }
            catch (IOException e) {
                System.out.println("Warning: I/O Error occured when saving DB properties: " + e.getMessage());
            }
            this.mainMenu.exit();
            this.mainMenu = this.initMenus();
            this.start();
        }
        catch (Exception e) {
            System.out.println("Connection failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private ClusterData loadClusterData() throws ConfigurationException {
        System.out.print("Connecting to database ... ");
        ConfigurationManagerBootstrapImpl cfgFactory = new ConfigurationManagerBootstrapImpl(this.dbProperties);
        this.cfgHandler = cfgFactory.getConfigurationHandler();
        System.out.print("OK\nScanning cluster data ... ");
        ClusterData result = new Scanner(this.cfgHandler).scan();
        System.out.println("OK");
        return result;
    }

    private ConsoleMenu initMenus() {
        System.out.print("Initializing menus ... ");
        ConsoleMenu mainMenu = new ConsoleMenu(System.in, System.out);
        mainMenu.setExitListener(this);
        ConsoleMenuItem menu = new ConsoleMenuItem("Connect to DB", 1);
        menu.addListener(this);
        mainMenu.addSubMenu(menu);
        mainMenu.addSeparator();
        ConsoleMenuItem applyMenu = new ConsoleMenuItem("Apply changes", 2);
        applyMenu.addListener(this);
        mainMenu.addSubMenu(applyMenu);
        ConsoleMenuItem exportMenu = new ConsoleMenuItem("Export to XML", 3);
        exportMenu.addListener(this);
        mainMenu.addSubMenu(exportMenu);
        mainMenu.addSeparator();
        ConsoleMenuItem gdMenu = new ConsoleMenuItem("Global dispatcher configuration", 4);
        gdMenu.addDefaultListener();
        mainMenu.addSubMenu(gdMenu);
        this.addServicesAndManagersMenus(gdMenu);
        ConsoleMenuItem gsMenu = new ConsoleMenuItem("Global server configuration", 5);
        gsMenu.addDefaultListener();
        mainMenu.addSubMenu(gsMenu);
        this.addServicesAndManagersMenus(gsMenu);
        TreeMap instances = this.clusterData.getInstances();
        Iterator instanceNames = instances.keySet().iterator();
        while (instanceNames.hasNext()) {
            String instanceName = (String)instanceNames.next();
            Instance instance = (Instance)instances.get(instanceName);
            int actionCommand = Integer.parseInt(instanceName.substring(2));
            ConsoleMenuItem instanceMenu = new ConsoleMenuItem("Instance " + instanceName, actionCommand);
            instanceMenu.addDefaultListener();
            mainMenu.addSubMenu(instanceMenu);
            ConsoleMenuItem addServerMenu = new ConsoleMenuItem("Create new server", 8);
            addServerMenu.addListener(this);
            instanceMenu.addSubMenu(addServerMenu);
            ConsoleMenuItem removeServerMenu = new ConsoleMenuItem("Remove server", 9);
            removeServerMenu.addListener(this);
            instanceMenu.addSubMenu(removeServerMenu);
            instanceMenu.addSeparator();
            ConsoleMenuItem messageServerMenu = new ConsoleMenuItem("Message server settings", 10);
            messageServerMenu.addListener(this);
            instanceMenu.addSubMenu(messageServerMenu);
            ConsoleMenuItem bootstrapMenu = new ConsoleMenuItem("Bootstrap settings", 11);
            bootstrapMenu.addListener(this);
            instanceMenu.addSubMenu(bootstrapMenu);
            ConsoleMenuItem generalServersMenu = new ConsoleMenuItem("General servers settings", 12);
            generalServersMenu.addListener(this);
            instanceMenu.addSubMenu(generalServersMenu);
            ConsoleMenuItem debugServersMenu = new ConsoleMenuItem("Debug servers settings", 13);
            debugServersMenu.addListener(this);
            instanceMenu.addSubMenu(debugServersMenu);
            instanceMenu.addSeparator();
            TreeMap elements = instance.getInstanceElements();
            Iterator names = elements.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                ClusterElement element = (ClusterElement)elements.get(name);
                this.createClusteElementMenu(instanceMenu, instanceName, element);
            }
        }
        System.out.println("OK");
        return mainMenu;
    }

    private void createClusteElementMenu(ConsoleMenuItem instanceMenu, String instanceName, ClusterElement element) {
        ConsoleMenuItem elementMenu = new ConsoleMenuItem(("server".equals(element.getType()) ? "Server " : "Dispatcher ") + element.getName(), Integer.parseInt(instanceName.substring(2)));
        elementMenu.addDefaultListener();
        instanceMenu.addSubMenu(elementMenu);
        ConsoleMenuItem generalMenu = new ConsoleMenuItem("General", 15);
        generalMenu.addListener(this);
        elementMenu.addSubMenu(generalMenu);
        ConsoleMenuItem bootstrapElementMenu = new ConsoleMenuItem("Bootstrap", 16);
        bootstrapElementMenu.addListener(this);
        elementMenu.addSubMenu(bootstrapElementMenu);
        if ("server".equals(element.getType())) {
            ConsoleMenuItem debugMenu = new ConsoleMenuItem("Debug", 17);
            debugMenu.addListener(this);
            elementMenu.addSubMenu(debugMenu);
        }
        elementMenu.addSeparator();
        this.addServicesAndManagersMenus(elementMenu);
    }

    private void addServicesAndManagersMenus(ConsoleMenuItem menu) {
        ConsoleMenuItem managersMenu = new ConsoleMenuItem("Managers", 7);
        managersMenu.addDefaultListener();
        menu.addSubMenu(managersMenu);
        ConsoleMenuItem managerInfoMenu = new ConsoleMenuItem("Get manager info", 18);
        managerInfoMenu.addListener(this);
        managersMenu.addSubMenu(managerInfoMenu);
        ConsoleMenuItem editManagerMenu = new ConsoleMenuItem("Edit manager info", 20);
        editManagerMenu.addListener(this);
        managersMenu.addSubMenu(editManagerMenu);
        ConsoleMenuItem servicesMenu = new ConsoleMenuItem("Services", 6);
        servicesMenu.addDefaultListener();
        menu.addSubMenu(servicesMenu);
        ConsoleMenuItem serviceInfoMenu = new ConsoleMenuItem("Get service info", 19);
        serviceInfoMenu.addListener(this);
        servicesMenu.addSubMenu(serviceInfoMenu);
        ConsoleMenuItem editServiceMenu = new ConsoleMenuItem("Edit service info", 21);
        editServiceMenu.addListener(this);
        servicesMenu.addSubMenu(editServiceMenu);
    }

    private void start() {
        try {
            this.mainMenu.start();
        }
        catch (IOException e) {
            System.out.println("I/O Error occured:");
            e.printStackTrace();
        }
    }

    public void actionPerformed(ConsoleMenuEvent event) {
        try {
            switch (event.getActionCommand()) {
                case 1: {
                    this.connect();
                    break;
                }
                case 2: {
                    this.apply();
                    break;
                }
                case 3: {
                    this.export();
                    break;
                }
                case 8: {
                    this.createNewServer(event);
                    break;
                }
                case 9: {
                    this.removeServer(event);
                    break;
                }
                case 10: {
                    this.changeMessageServerSettings(event);
                    break;
                }
                case 11: {
                    this.changeInstanceBootstrap(event);
                    break;
                }
                case 16: {
                    this.changeElementBootstrap(event);
                    break;
                }
                case 12: {
                    this.editGlobalServersInfo(event);
                    break;
                }
                case 15: {
                    this.editLocalElementInfo(event);
                    break;
                }
                case 13: {
                    this.editGlobalServersDebug(event);
                    break;
                }
                case 17: {
                    this.editLocalDebug(event);
                    break;
                }
                case 18: {
                    this.printManagerInfo(event);
                    break;
                }
                case 19: {
                    this.printServiceInfo(event);
                    break;
                }
                case 20: {
                    this.editManagerInfo(event);
                    break;
                }
                case 21: {
                    this.editServiceInfo(event);
                    break;
                }
                case -3: {
                    this.exit();
                }
            }
        }
        catch (IOException e) {
            System.out.println("I/O Error occured:");
            e.printStackTrace();
        }
    }

    public boolean checkVisible(ConsoleMenuEvent event) {
        switch (event.getActionCommand()) {
            case 2: 
            case 3: {
                return this.tasksManager.getTasks().size() > 0;
            }
            case 9: {
                ConsoleMenuItem instanceMenu = event.getCurrentMenu().getParent();
                String instancePrefix = instanceMenu.getName().substring("Instance ".length());
                Instance instance = (Instance)this.clusterData.getInstances().get(instancePrefix);
                TreeMap elements = instance.getInstanceElements();
                Iterator elementNames = elements.keySet().iterator();
                if (elementNames.hasNext()) {
                    elementNames.next();
                    if (elementNames.hasNext()) {
                        elementNames.next();
                        if (elementNames.hasNext()) {
                            return true;
                        }
                    }
                }
                return false;
            }
        }
        return true;
    }

    private void exit() throws IOException {
        if (this.tasksManager.getTasks().size() > 0 && this.mainMenu.getUserConfirmation("All changes you have made will be lost. Do you like to apply?")) {
            this.apply();
        }
    }

    private void apply() throws IOException {
        if (!this.tasksManager.isEmpty()) {
            System.out.println("Applying changes ...");
            ArrayList tasks = this.tasksManager.getTasks();
            ArrayList<ConsoleConfigTool> listeners = new ArrayList<ConsoleConfigTool>();
            listeners.add(this);
            int i = 0;
            while (i < tasks.size()) {
                Task task = (Task)tasks.get(i);
                task.setLogListeners(listeners);
                task.go(this.cfgHandler);
                ++i;
            }
            this.tasksManager.clear();
            System.out.println();
            System.out.println("In order for the changes to take effect, please restart the cluster.");
            this.mainMenu.pause();
        }
    }

    private void export() {
        try {
            String fileName = this.mainMenu.getUserResponce("Path and name for XML file: ");
            fileName = fileName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            int pos = fileName.lastIndexOf(File.separatorChar);
            String path = pos != -1 ? fileName.substring(0, fileName.lastIndexOf(File.separatorChar)) : fileName;
            new File(path).mkdirs();
            if (fileName != null && fileName.length() > 0) {
                if (!fileName.endsWith(".xml")) {
                    fileName = fileName + ".xml";
                }
                this.configDescriptor.setDbProperties(this.dbProperties);
                this.configDescriptor.setTasks(this.tasksManager.getTasks());
                this.configDescriptor.saveToFile(fileName);
            }
        }
        catch (IOException ioe) {
            System.out.println("Error occurred while exporting the xml\nMsg: " + ioe.getMessage());
        }
    }

    private void createNewServer(ConsoleMenuEvent event) throws IOException {
        ConsoleMenuItem instanceMenu = event.getCurrentMenu().getParent();
        String instancePrefix = instanceMenu.getName().substring("Instance ".length());
        if (!this.mainMenu.getUserConfirmation("Do you want to create a server in instance '" + instancePrefix + "'?")) {
            return;
        }
        String bn = instancePrefix.substring(instancePrefix.length() - 5);
        String sid = instancePrefix.substring(2, instancePrefix.indexOf(bn));
        if (sid.length() == 0) {
            sid = "0";
        }
        ArrayList<ConsoleConfigTool> logListeners = new ArrayList<ConsoleConfigTool>();
        logListeners.add(this);
        CreateNewElementTask task = new CreateNewElementTask();
        task.loadLogConfiguration(false);
        task.setType("server");
        task.setSid(new Integer(sid));
        task.setBn(bn);
        task.setDbDriverLocation(PropertiesUtil.getProperty(this.dbProperties, "rdbms.driverLocation"));
        task.setDbUrl(PropertiesUtil.getProperty(this.dbProperties, "rdbms.url"));
        task.setDbUser(PropertiesUtil.getProperty(this.dbProperties, "rdbms.user"));
        task.setDbPassword(PropertiesUtil.getProperty(this.dbProperties, "rdbms.password"));
        task.setDbIC(PropertiesUtil.getIntegerProperty(this.dbProperties, "rdbms.initial_connections"));
        task.setDbMC(PropertiesUtil.getIntegerProperty(this.dbProperties, "rdbms.maximum_connections"));
        task.setSecstoreFSLib(PropertiesUtil.getProperty(this.dbProperties, "secstorefs.lib"));
        task.setSecstoreFSSecfile(PropertiesUtil.getProperty(this.dbProperties, "secstorefs.secfile"));
        task.setSecstoreFSKeyfile(PropertiesUtil.getProperty(this.dbProperties, "secstorefs.keyfile"));
        task.setRdbmsConnection(PropertiesUtil.getProperty(this.dbProperties, "rdbms.connection"));
        task.setSysName(PropertiesUtil.getProperty(this.dbProperties, "system.name"));
        task.setLogListeners(logListeners);
        task.go(this.cfgHandler);
        ClusterElement element = task.getNewClusterElement();
        if (element != null) {
            Instance instance = (Instance)this.clusterData.getInstances().get(instancePrefix);
            instance.addInstanceElement(element, this.clusterData.getGlobalServer());
            this.createClusteElementMenu(instanceMenu, instancePrefix, element);
            event.setCurrentMenu(instanceMenu);
            DefaultConsoleMenuListener.getInstance().actionPerformed(event);
        }
    }

    public void logPerformed(Log log) {
        System.out.println(log.getMsg());
    }

    private void removeServer(ConsoleMenuEvent event) throws IOException {
        ConsoleMenuItem instanceMenu = event.getCurrentMenu().getParent();
        String instancePrefix = instanceMenu.getName().substring("Instance ".length());
        Instance instance = (Instance)this.clusterData.getInstances().get(instancePrefix);
        ArrayList<String> serverNames = new ArrayList<String>();
        TreeMap elements = instance.getInstanceElements();
        Iterator elementNames = elements.keySet().iterator();
        while (elementNames.hasNext()) {
            String elementName = (String)elementNames.next();
            ClusterElement element = (ClusterElement)elements.get(elementName);
            if (!"server".equals(element.getType())) continue;
            serverNames.add(elementName);
        }
        Object[] namesArray = serverNames.toArray();
        int position = this.mainMenu.getSimpleChoise("Choose the server: ", namesArray);
        if (position == -1) {
            return;
        }
        String elementName = (String)namesArray[position];
        if (!this.mainMenu.getUserConfirmation("Do you want to remove server '" + elementName + "'?")) {
            return;
        }
        RemoveElementTask task = new RemoveElementTask();
        task.setElementId(elementName);
        task.setElementType("server");
        ArrayList<ConsoleConfigTool> logListeners = new ArrayList<ConsoleConfigTool>();
        logListeners.add(this);
        task.setLogListeners(logListeners);
        task.go(this.cfgHandler);
        instance.removeInstanceElement(elementName);
        Vector menus = instanceMenu.getSubMenus();
        Enumeration enumeration = menus.elements();
        String menuName = "Server " + elementName;
        while (enumeration.hasMoreElements()) {
            ConsoleMenuItem menu = (ConsoleMenuItem)enumeration.nextElement();
            if (!menu.getName().equals(menuName)) continue;
            instanceMenu.removeSubMenu(menu);
            event.setCurrentMenu(instanceMenu);
            DefaultConsoleMenuListener.getInstance().actionPerformed(event);
            return;
        }
    }

    private void printManagerInfo(ConsoleMenuEvent event) throws IOException {
        Manager manager = this.getManager(event);
        if (manager == null) {
            return;
        }
        String managerName = manager.getName();
        PropertyMap properties = manager.getProperties();
        String clusterElementMenuName = event.getCurrentMenu().getParent().getParent().getName();
        if (clusterElementMenuName.startsWith("Server ")) {
            Manager globalManager = (Manager)this.clusterData.getGlobalServer().getManagers().get(managerName);
            PropertyMap globalProps = globalManager.getProperties();
            globalProps = (PropertyMap)globalProps.clone();
            globalProps.putAll((Map)properties);
            properties = globalProps;
        } else if (clusterElementMenuName.startsWith("Dispatcher ")) {
            Manager globalManager = (Manager)this.clusterData.getGlobalDispatcher().getManagers().get(managerName);
            PropertyMap globalProps = globalManager.getProperties();
            globalProps = (PropertyMap)globalProps.clone();
            globalProps.putAll((Map)properties);
            properties = globalProps;
        }
        System.out.println();
        System.out.println(managerName + " properties:");
        System.out.println("-------------------------");
        this.printProperties(properties);
        System.out.println("-------------------------");
        this.mainMenu.pause();
    }

    private Manager getManager(ConsoleMenuEvent event) throws IOException {
        ConsoleMenuItem clusterElementMenu = event.getCurrentMenu().getParent().getParent();
        ConsoleMenuItem instanceMenu = null;
        TreeMap managers = null;
        String menuName = clusterElementMenu.getName();
        if (menuName.equals("Global server configuration")) {
            managers = this.clusterData.getGlobalServer().getManagers();
        } else if (menuName.equals("Global dispatcher configuration")) {
            managers = this.clusterData.getGlobalDispatcher().getManagers();
        } else {
            String clusterName = null;
            clusterName = menuName.startsWith("Server ") ? menuName.substring("Server ".length()) : menuName.substring("Dispatcher ".length());
            instanceMenu = clusterElementMenu.getParent();
            String instanceName = instanceMenu.getName().substring("Instance ".length());
            Instance instance = (Instance)this.clusterData.getInstances().get(instanceName);
            ClusterElement clusterElement = (ClusterElement)instance.getInstanceElements().get(clusterName);
            managers = clusterElement.getManagers();
        }
        TreeSet set = new TreeSet();
        Iterator managerNames = managers.keySet().iterator();
        while (managerNames.hasNext()) {
            set.add(managerNames.next());
        }
        Object[] managerNamesArray = set.toArray();
        int position = this.mainMenu.getSimpleChoise("Choose manager:", managerNamesArray);
        if (position == -1) {
            return null;
        }
        return (Manager)managers.get(managerNamesArray[position]);
    }

    private void printServiceInfo(ConsoleMenuEvent event) throws IOException {
        Service service = this.getService(event);
        if (service == null) {
            return;
        }
        String serviceName = service.getName();
        PropertyMap properties = service.getProperties();
        String clusterElementMenuName = event.getCurrentMenu().getParent().getParent().getName();
        if (clusterElementMenuName.startsWith("Server ")) {
            Service globalService = (Service)this.clusterData.getGlobalServer().getServices().get(serviceName);
            PropertyMap globalProps = globalService.getProperties();
            globalProps = (PropertyMap)globalProps.clone();
            globalProps.putAll((Map)properties);
            properties = globalProps;
        } else if (clusterElementMenuName.startsWith("Dispatcher ")) {
            Service globalService = (Service)this.clusterData.getGlobalDispatcher().getServices().get(serviceName);
            PropertyMap globalProps = globalService.getProperties();
            globalProps = (PropertyMap)globalProps.clone();
            globalProps.putAll((Map)properties);
            properties = globalProps;
        }
        System.out.println();
        System.out.println(service.getName() + " startup mode - " + service.getStartupMode());
        System.out.println("-------------------------");
        System.out.println(service.getName() + " properties:");
        System.out.println("-------------------------");
        this.printProperties(properties);
        System.out.println("-------------------------");
        this.mainMenu.pause();
    }

    private Service getService(ConsoleMenuEvent event) throws IOException {
        ConsoleMenuItem clusterElementMenu = event.getCurrentMenu().getParent().getParent();
        ConsoleMenuItem instanceMenu = null;
        TreeMap services = null;
        String menuName = clusterElementMenu.getName();
        if (menuName.equals("Global server configuration")) {
            services = this.clusterData.getGlobalServer().getServices();
        } else if (menuName.equals("Global dispatcher configuration")) {
            services = this.clusterData.getGlobalDispatcher().getServices();
        } else {
            String clusterName = null;
            clusterName = menuName.startsWith("Server ") ? menuName.substring("Server ".length()) : menuName.substring("Dispatcher ".length());
            instanceMenu = clusterElementMenu.getParent();
            String instanceName = instanceMenu.getName().substring("Instance ".length());
            Instance instance = (Instance)this.clusterData.getInstances().get(instanceName);
            ClusterElement clusterElement = (ClusterElement)instance.getInstanceElements().get(clusterName);
            services = clusterElement.getServices();
        }
        TreeSet set = new TreeSet();
        Iterator serviceNames = services.keySet().iterator();
        while (serviceNames.hasNext()) {
            set.add(serviceNames.next());
        }
        Object[] serviceNamesArray = set.toArray();
        int position = this.mainMenu.getSimpleChoise("Choose service:", serviceNamesArray);
        if (position == -1) {
            return null;
        }
        return (Service)services.get(serviceNamesArray[position]);
    }

    private void printProperties(PropertyMap map) {
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            Property prop = (Property)map.get(keys.next());
            if (prop.isSecure()) {
                System.out.println(prop.getName() + " = **********");
                continue;
            }
            String value = prop.getCustomValue();
            if (value == null) {
                value = prop.getDefaultValue();
            }
            System.out.println(prop.getName() + " = " + value);
        }
    }

    private void editManagerInfo(ConsoleMenuEvent event) throws IOException {
        PropertyMap result;
        String elementName;
        Manager manager = this.getManager(event);
        if (manager == null) {
            return;
        }
        String managerName = manager.getName();
        PropertyMap properties = manager.getProperties();
        String clusterElementMenuName = event.getCurrentMenu().getParent().getParent().getName();
        if (clusterElementMenuName.equals("Global dispatcher configuration")) {
            elementName = "dispatcher";
            result = this.editProperties(properties);
        } else if (clusterElementMenuName.equals("Global server configuration")) {
            elementName = "server";
            result = this.editProperties(properties);
        } else {
            PropertyMap globalProps = null;
            if (clusterElementMenuName.startsWith("Server ")) {
                elementName = clusterElementMenuName.substring("Server ".length());
                Manager globalManager = (Manager)this.clusterData.getGlobalServer().getManagers().get(managerName);
                globalProps = globalManager.getProperties();
            } else {
                elementName = clusterElementMenuName.substring("Dispatcher ".length());
                Manager globalManager = (Manager)this.clusterData.getGlobalDispatcher().getManagers().get(managerName);
                globalProps = globalManager.getProperties();
            }
            result = this.editProperties(properties, globalProps);
        }
        if (result != null) {
            ChangeManagerPropsTask task = new ChangeManagerPropsTask();
            task.setElementName(elementName);
            task.setManagerName(managerName);
            task.addManagerProperties(result);
            this.tasksManager.addTask(task);
        }
    }

    private void editServiceInfo(ConsoleMenuEvent event) throws IOException {
        PropertyMap result;
        String startupMode;
        String elementName;
        Service service = this.getService(event);
        if (service == null) {
            return;
        }
        String serviceName = service.getName();
        PropertyMap properties = service.getProperties();
        String clusterElementMenuName = event.getCurrentMenu().getParent().getParent().getName();
        if (clusterElementMenuName.equals("Global dispatcher configuration")) {
            elementName = "dispatcher";
            startupMode = this.editStartupMode(service.getStartupMode());
            result = this.editProperties(properties);
        } else if (clusterElementMenuName.equals("Global server configuration")) {
            elementName = "server";
            startupMode = this.editStartupMode(service.getStartupMode());
            result = this.editProperties(properties);
        } else {
            PropertyMap globalProps = null;
            if (clusterElementMenuName.startsWith("Server ")) {
                elementName = clusterElementMenuName.substring("Server ".length());
                Service globalService = (Service)this.clusterData.getGlobalServer().getServices().get(serviceName);
                globalProps = globalService.getProperties();
            } else {
                elementName = clusterElementMenuName.substring("Dispatcher ".length());
                Service globalService = (Service)this.clusterData.getGlobalDispatcher().getServices().get(serviceName);
                globalProps = globalService.getProperties();
            }
            startupMode = this.editStartupMode(service.getStartupMode());
            result = this.editProperties(properties, globalProps);
        }
        if (result != null || startupMode != null) {
            ChangeServicePropsTask task = new ChangeServicePropsTask();
            task.setElementName(elementName);
            task.setServiceName(serviceName);
            if (startupMode != null) {
                task.setStartupMode(startupMode);
                service.setStartupMode(startupMode);
            }
            if (result != null) {
                task.setServiceProperties(result);
            }
            this.tasksManager.addTask(task);
        }
    }

    private String editStartupMode(String startupMode) throws IOException {
        System.out.println();
        System.out.println("Current startup mode: " + startupMode);
        if (this.mainMenu.getUserConfirmation("Do you want to change startup mode?")) {
            Object[] startupModes = new String[]{"always", "automatic", "manual"};
            System.out.println();
            int position = this.mainMenu.getSimpleChoise("Choose startup mode:", startupModes);
            if (position != -1) {
                return startupModes[position];
            }
        }
        return null;
    }

    private PropertyMap editProperties(PropertyMap properties) throws IOException {
        PropertyMap result = null;
        Iterator keys = properties.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Property prop = (Property)properties.get(key);
            System.out.println();
            System.out.println("Property name: " + key);
            System.out.println("Default value: " + prop.getDefaultValue());
            System.out.println("Custom value: " + prop.getCustomValue());
            String userChoise = this.mainMenu.getUserResponce("Your choise ((E)dit custom | reset to (D)efault | (N)ext | (S)kip all):");
            if (userChoise.equalsIgnoreCase("e") || userChoise.equalsIgnoreCase("edit")) {
                String newValue = this.mainMenu.getUserResponce("New value for '" + key + "':");
                prop.setCustomValue(newValue);
                if (result == null) {
                    result = new PropertyMap();
                }
                result.put(prop);
                continue;
            }
            if (userChoise.equalsIgnoreCase("d") || userChoise.equalsIgnoreCase("default")) {
                System.out.println("Reset to default");
                prop.setCustomValue(null);
                prop.setActionRestoreDefault();
                if (result == null) {
                    result = new PropertyMap();
                }
                result.put(prop);
                continue;
            }
            if (!userChoise.equalsIgnoreCase("n") && !userChoise.equalsIgnoreCase("next") && (userChoise.equalsIgnoreCase("s") || userChoise.equalsIgnoreCase("skip"))) break;
        }
        return result;
    }

    private PropertyMap editProperties(PropertyMap local, PropertyMap global) throws IOException {
        PropertyMap result = null;
        Iterator keys = global.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Property gProp = (Property)global.get(key);
            Property lProp = (Property)local.get(key);
            System.out.println();
            System.out.println("Property name: " + key);
            System.out.println("Global default value: " + gProp.getDefaultValue());
            System.out.println("Global custom value: " + gProp.getCustomValue());
            if (lProp != null) {
                System.out.println("Local default value: " + lProp.getDefaultValue());
                System.out.println("Local custom value: " + lProp.getCustomValue());
            } else {
                System.out.println("Local default value: null");
                System.out.println("Local custom value: null");
            }
            String userChoise = this.mainMenu.getUserResponce("Your choise ((E)dit custom | reset to (D)efault | reset to (G)lobal | (N)ext | (S)kip all):");
            if (userChoise.equalsIgnoreCase("e") || userChoise.equalsIgnoreCase("edit")) {
                String newValue = this.mainMenu.getUserResponce("New value for '" + key + "':");
                lProp.setCustomValue(newValue);
                if (result == null) {
                    result = new PropertyMap();
                }
                result.put(lProp);
                continue;
            }
            if (userChoise.equalsIgnoreCase("d") || userChoise.equalsIgnoreCase("default")) {
                System.out.println("Reset to default");
                lProp.setCustomValue(null);
                lProp.setActionRestoreDefault();
                if (result == null) {
                    result = new PropertyMap();
                }
                result.put(lProp);
                continue;
            }
            if (userChoise.equalsIgnoreCase("g") || userChoise.equalsIgnoreCase("global")) {
                System.out.println("Reset to global");
                local.remove(key);
                lProp.setActionDelete();
                if (result == null) {
                    result = new PropertyMap();
                }
                result.put(lProp);
                continue;
            }
            if (!userChoise.equalsIgnoreCase("n") && !userChoise.equalsIgnoreCase("next") && (userChoise.equalsIgnoreCase("s") || userChoise.equalsIgnoreCase("skip"))) break;
        }
        return result;
    }

    private void changeMessageServerSettings(ConsoleMenuEvent event) throws IOException {
        String instanceName = event.getCurrentMenu().getParent().getName().substring("Instance ".length());
        Instance instance = (Instance)this.clusterData.getInstances().get(instanceName);
        Properties instanceProperties = instance.getInstanceProperties();
        System.out.println();
        System.out.println("Message server host: " + instanceProperties.getProperty("instance.ms.host"));
        System.out.println("Message server port: " + instanceProperties.getProperty("instance.ms.port"));
        if (this.mainMenu.getUserConfirmation("Do you want to edit message server settings?")) {
            ChangeInstancePropsTask task = new ChangeInstancePropsTask();
            String host = this.mainMenu.getUserResponce("New message server host: ");
            task.setMsHost(host);
            instanceProperties.setProperty("instance.ms.host", host);
            while (true) {
                try {
                    Integer port = new Integer(this.mainMenu.getUserResponce("New message server port: "));
                    if (port <= 1024 || port >= 65536) {
                        throw new NumberFormatException();
                    }
                    task.setMsPort(port);
                    instanceProperties.setProperty("instance.ms.port", port.toString());
                }
                catch (NumberFormatException e) {
                    System.out.println("Wrong data! Port must be number between 1024 and 65536.");
                    continue;
                }
                break;
            }
            task.setInstancePrefix(instanceName);
            this.tasksManager.addTask(task);
        }
    }

    private void changeElementBootstrap(ConsoleMenuEvent event) throws IOException {
        ConsoleMenuItem clusterMenu = event.getCurrentMenu().getParent();
        String elemetMenuName = clusterMenu.getName();
        String elementName = elemetMenuName.startsWith("Server ") ? elemetMenuName.substring("Server ".length()) : elemetMenuName.substring("Dispatcher ".length());
        String instanceName = clusterMenu.getParent().getName().substring("Instance ".length());
        Instance instance = (Instance)this.clusterData.getInstances().get(instanceName);
        Properties instanceProperties = instance.getInstanceProperties();
        String prefix = "bootstrap_" + elementName + '.';
        System.out.println();
        System.out.println("Java home: " + instanceProperties.getProperty(prefix + "JavaPath"));
        System.out.println("Max heap size (in MB): " + instanceProperties.getProperty(prefix + "MaxHeapSize"));
        System.out.println("Java parameters: " + instanceProperties.getProperty(prefix + "JavaParameters"));
        System.out.println("Classpath: " + instanceProperties.getProperty(prefix + "ClassPath"));
        System.out.println("Parameters: " + instanceProperties.getProperty(prefix + "Parameters"));
        if (this.mainMenu.getUserConfirmation("Do you want to edit bootstrap settings?")) {
            String params;
            boolean changed = false;
            ElementInfoTask task = new ElementInfoTask();
            System.out.println();
            System.out.println("Java home: " + instanceProperties.getProperty(prefix + "JavaPath"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Java home'?")) {
                changed = true;
                String javaPath = this.mainMenu.getUserResponce("New 'Java home': ");
                task.setBootstrapJavaPath(javaPath);
                instanceProperties.setProperty(prefix + "JavaPath", javaPath);
            }
            System.out.println();
            System.out.println("Max heap size (in MB): " + instanceProperties.getProperty(prefix + "MaxHeapSize"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Max heap size'?")) {
                changed = true;
                while (true) {
                    try {
                        Integer size = new Integer(this.mainMenu.getUserResponce("New 'Max heap size (in MB)' :"));
                        if (size <= 16) {
                            throw new NumberFormatException();
                        }
                        task.setBootstrapJavaMaxHeapSize(size);
                        instanceProperties.setProperty(prefix + "MaxHeapSize", size.toString());
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Wrong data! Max heap size must be number not less then 16.");
                        continue;
                    }
                    break;
                }
            }
            System.out.println();
            System.out.println("Java parameters: " + instanceProperties.getProperty(prefix + "JavaParameters"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Java parameters'?")) {
                changed = true;
                params = this.mainMenu.getUserResponce("New 'Java parameters': ");
                task.setBootstrapJavaParams(params);
                instanceProperties.setProperty(prefix + "JavaParameters", params);
            }
            System.out.println();
            System.out.println("Classpath: " + instanceProperties.getProperty(prefix + "ClassPath"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Classpath'?")) {
                changed = true;
                String classpath = this.mainMenu.getUserResponce("New 'Classpath': ");
                task.setBootstrapJavaClassPath(classpath);
                instanceProperties.setProperty(prefix + "ClassPath", classpath);
            }
            System.out.println();
            System.out.println("Parameters: " + instanceProperties.getProperty(prefix + "Parameters"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Parameters'?")) {
                changed = true;
                params = this.mainMenu.getUserResponce("New 'Parameters': ");
                task.setBootstrapJavaMainClassParams(params);
                instanceProperties.setProperty(prefix + "Parameters", params);
            }
            if (changed) {
                task.setElementName(elementName);
                task.setInstallation(new Boolean(false));
                this.tasksManager.addTask(task);
            }
        }
    }

    private void changeInstanceBootstrap(ConsoleMenuEvent event) throws IOException {
        String instanceName = event.getCurrentMenu().getParent().getName().substring("Instance ".length());
        Instance instance = (Instance)this.clusterData.getInstances().get(instanceName);
        Properties instanceProperties = instance.getInstanceProperties();
        String prefix = "bootstrap.";
        System.out.println();
        System.out.println("Java home: " + instanceProperties.getProperty(prefix + "JavaPath"));
        System.out.println("Max heap size (in MB): " + instanceProperties.getProperty(prefix + "MaxHeapSize"));
        System.out.println("Java parameters: " + instanceProperties.getProperty(prefix + "JavaParameters"));
        System.out.println("Classpath: " + instanceProperties.getProperty(prefix + "ClassPath"));
        System.out.println("Parameters: " + instanceProperties.getProperty(prefix + "Parameters"));
        if (this.mainMenu.getUserConfirmation("Do you want to edit bootstrap settings?")) {
            String params;
            boolean changed = false;
            ChangeInstancePropsTask task = new ChangeInstancePropsTask();
            System.out.println();
            System.out.println("Java home: " + instanceProperties.getProperty(prefix + "JavaPath"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Java home'?")) {
                changed = true;
                String javaPath = this.mainMenu.getUserResponce("New 'Java home': ");
                task.setBootstrapJavaPath(javaPath);
                instanceProperties.setProperty(prefix + "JavaPath", javaPath);
            }
            System.out.println();
            System.out.println("Max heap size (in MB): " + instanceProperties.getProperty(prefix + "MaxHeapSize"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Max heap size'?")) {
                changed = true;
                while (true) {
                    try {
                        Integer size = new Integer(this.mainMenu.getUserResponce("New 'Max heap size (in MB)' :"));
                        if (size <= 16) {
                            throw new NumberFormatException();
                        }
                        task.setBootstrapJavaMaxHeapSize(size);
                        instanceProperties.setProperty(prefix + "MaxHeapSize", size.toString());
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Wrong data! Max heap size must be number not less then 16.");
                        continue;
                    }
                    break;
                }
            }
            System.out.println();
            System.out.println("Java parameters: " + instanceProperties.getProperty(prefix + "JavaParameters"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Java parameters'?")) {
                changed = true;
                params = this.mainMenu.getUserResponce("New 'Java parameters': ");
                task.setBootstrapJavaParams(params);
                instanceProperties.setProperty(prefix + "JavaParameters", params);
            }
            System.out.println();
            System.out.println("Classpath: " + instanceProperties.getProperty(prefix + "ClassPath"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Classpath'?")) {
                changed = true;
                String classpath = this.mainMenu.getUserResponce("New 'Classpath': ");
                task.setBootstrapJavaClassPath(classpath);
                instanceProperties.setProperty(prefix + "ClassPath", classpath);
            }
            System.out.println();
            System.out.println("Parameters: " + instanceProperties.getProperty(prefix + "Parameters"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Parameters'?")) {
                changed = true;
                params = this.mainMenu.getUserResponce("New 'Parameters': ");
                task.setBootstrapJavaMainClassParams(params);
                instanceProperties.setProperty(prefix + "Parameters", params);
            }
            if (changed) {
                task.setMsHost(instanceProperties.getProperty("instance.ms.host"));
                task.setMsPort(new Integer(instanceProperties.getProperty("instance.ms.port")));
                task.setInstancePrefix(instanceName);
                this.tasksManager.addTask(task);
            }
        }
    }

    private void editLocalElementInfo(ConsoleMenuEvent event) throws IOException {
        ConsoleMenuItem clusterMenu = event.getCurrentMenu().getParent();
        String elemetMenuName = clusterMenu.getName();
        boolean server = elemetMenuName.startsWith("Server ");
        String elementName = server ? elemetMenuName.substring("Server ".length()) : elemetMenuName.substring("Dispatcher ".length());
        String instanceName = clusterMenu.getParent().getName().substring("Instance ".length());
        Instance instance = (Instance)this.clusterData.getInstances().get(instanceName);
        ClusterElement element = (ClusterElement)instance.getInstanceElements().get(elementName);
        Properties elementInfo = element.getElementInfo();
        Properties editProps = new Properties();
        if (server) {
            ((Hashtable)editProps).putAll(instance.getElementInfo());
        }
        ((Hashtable)editProps).putAll(elementInfo);
        ((Hashtable)elementInfo).putAll(this.editElementInfo(editProps, elementName));
    }

    private void editGlobalServersInfo(ConsoleMenuEvent event) throws IOException {
        String instanceName = event.getCurrentMenu().getParent().getName().substring("Instance ".length());
        Instance instance = (Instance)this.clusterData.getInstances().get(instanceName);
        Properties elementInfo = instance.getElementInfo();
        ((Hashtable)elementInfo).putAll(this.editElementInfo(elementInfo, "server." + instanceName));
    }

    private Properties editElementInfo(Properties elementInfo, String elementName) throws IOException {
        Properties changedProps = new Properties();
        System.out.println();
        System.out.println("Execute: " + elementInfo.getProperty("sf.execute"));
        System.out.println("Show console: " + elementInfo.getProperty("sf.execute"));
        System.out.println("Java home: " + elementInfo.getProperty("java.path"));
        System.out.println("Max heap size (in MB): " + elementInfo.getProperty("java.max.heap.size"));
        System.out.println("Java parameters: " + elementInfo.getProperty("java.parameters"));
        System.out.println("Classpath: " + elementInfo.getProperty("java.class.path"));
        System.out.println("Parameters: " + elementInfo.getProperty("java.main.class.parameters"));
        if (this.mainMenu.getUserConfirmation("Do you want to edit java settings?")) {
            String params;
            boolean changed = false;
            ElementInfoTask task = new ElementInfoTask();
            System.out.println();
            System.out.println("Execute: " + elementInfo.getProperty("sf.execute"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Execute'?")) {
                changed = true;
                Boolean execute = new Boolean(this.mainMenu.getUserConfirmation("Switch 'Execute' ON?"));
                task.setSFExecute(execute);
                changedProps.setProperty("sf.execute", execute != false ? "yes" : "no");
            }
            System.out.println();
            System.out.println("Show console: " + elementInfo.getProperty("sf.console"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Show console'?")) {
                changed = true;
                Boolean console = new Boolean(this.mainMenu.getUserConfirmation("Switch 'Show console' ON?"));
                task.setSFConsole(console);
                changedProps.setProperty("sf.console", console != false ? "yes" : "no");
            }
            System.out.println();
            System.out.println("Java home: " + elementInfo.getProperty("java.path"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Java home'?")) {
                changed = true;
                String javaHome = this.mainMenu.getUserResponce("New 'Java home': ");
                task.setJavaPath(javaHome);
                changedProps.setProperty("java.path", javaHome);
            }
            System.out.println();
            System.out.println("Max heap size (in MB): " + elementInfo.getProperty("java.max.heap.size"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Max heap size'?")) {
                changed = true;
                while (true) {
                    try {
                        Integer size = new Integer(this.mainMenu.getUserResponce("New 'Max heap size (in MB)' :"));
                        if (size <= 16) {
                            throw new NumberFormatException();
                        }
                        task.setJavaMaxHeapSize(size);
                        changedProps.setProperty("java.max.heap.size", size.toString());
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Wrong data! Max heap size must be number not less then 16.");
                        continue;
                    }
                    break;
                }
            }
            System.out.println();
            System.out.println("Java parameters: " + elementInfo.getProperty("java.parameters"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Java parameters'?")) {
                changed = true;
                params = this.mainMenu.getUserResponce("New 'Java parameters': ");
                task.setJavaParams(params);
                changedProps.setProperty("java.parameters", params);
            }
            System.out.println();
            System.out.println("Classpath: " + elementInfo.getProperty("java.class.path"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Classpath'?")) {
                changed = true;
                String classpath = this.mainMenu.getUserResponce("New 'Classpath': ");
                task.setJavaClassPath(classpath);
                changedProps.setProperty("java.class.path", classpath);
            }
            System.out.println();
            System.out.println("Parameters: " + elementInfo.getProperty("java.main.class.parameters"));
            if (this.mainMenu.getUserConfirmation("Do you want to edit 'Parameters'?")) {
                changed = true;
                params = this.mainMenu.getUserResponce("New 'Parameters': ");
                task.setJavaMainClassParams(params);
                changedProps.setProperty("java.main.class.parameters", params);
            }
            if (changed) {
                task.setInstallation(new Boolean(false));
                task.setElementName(elementName);
                this.tasksManager.addTask(task);
            }
        }
        return changedProps;
    }

    private void editLocalDebug(ConsoleMenuEvent event) throws IOException {
        ConsoleMenuItem clusterMenu = event.getCurrentMenu().getParent();
        String elemetMenuName = clusterMenu.getName();
        boolean server = elemetMenuName.startsWith("Server ");
        String elementName = server ? elemetMenuName.substring("Server ".length()) : elemetMenuName.substring("Dispatcher ".length());
        String instanceName = clusterMenu.getParent().getName().substring("Instance ".length());
        Instance instance = (Instance)this.clusterData.getInstances().get(instanceName);
        ClusterElement element = (ClusterElement)instance.getInstanceElements().get(elementName);
        Properties elementInfo = element.getElementInfo();
        Properties editProps = new Properties();
        if (server) {
            ((Hashtable)editProps).putAll(instance.getElementInfo());
        }
        ((Hashtable)editProps).putAll(elementInfo);
        ((Hashtable)elementInfo).putAll(this.editDebug(editProps, elementName));
    }

    private void editGlobalServersDebug(ConsoleMenuEvent event) throws IOException {
        String instanceName = event.getCurrentMenu().getParent().getName().substring("Instance ".length());
        Instance instance = (Instance)this.clusterData.getInstances().get(instanceName);
        Properties elementInfo = instance.getElementInfo();
        ((Hashtable)elementInfo).putAll(this.editDebug(elementInfo, "server." + instanceName));
    }

    private Properties editDebug(Properties elementInfo, String elementName) throws IOException {
        Properties changedProps = new Properties();
        System.out.println();
        String debuggable = elementInfo.getProperty("debuggable");
        System.out.println("Debuggable: " + debuggable);
        if (debuggable.equals("yes")) {
            String debugMode = elementInfo.getProperty("debug.enabled");
            System.out.println("Debug mode: " + debugMode);
            System.out.println("Restricted load balance: " + elementInfo.getProperty("sf.restricted.load.balance"));
            if (debugMode.equals("yes")) {
                System.out.println("Debug port: " + elementInfo.getProperty("debug.port"));
            }
        }
        if (this.mainMenu.getUserConfirmation("Do you want to edit debug settings?")) {
            boolean changed = false;
            ElementInfoTask task = new ElementInfoTask();
            System.out.println();
            boolean newDebuggable = this.mainMenu.getUserConfirmation("Switch 'Debuggable' ON?");
            if (newDebuggable != debuggable.equals("yes")) {
                task.setDebuggable(new Boolean(newDebuggable));
                changed = true;
                changedProps.setProperty("debuggable", newDebuggable ? "yes" : "no");
            }
            if (newDebuggable) {
                boolean loadBalance;
                boolean debugMode = this.mainMenu.getUserConfirmation("Switch 'Debug mode' ON?");
                if (debugMode != "yes".equals(elementInfo.getProperty("debug.enabled"))) {
                    task.setDebugEnabled(new Boolean(debugMode));
                    changed = true;
                    changedProps.setProperty("debug.enabled", debugMode ? "yes" : "no");
                }
                if ((loadBalance = this.mainMenu.getUserConfirmation("Switch 'Restricted load balance' ON?")) != "yes".equals(elementInfo.getProperty("sf.restricted.load.balance"))) {
                    task.setSFLoadBalance(new Boolean(loadBalance));
                    changed = true;
                    changedProps.setProperty("sf.restricted.load.balance", loadBalance ? "yes" : "no");
                }
                if (debugMode) {
                    while (true) {
                        try {
                            Integer port = new Integer(this.mainMenu.getUserResponce("Debug port: "));
                            if (port > 1024 && port < 65536) {
                                if (!port.toString().equals(elementInfo.getProperty("debug.port"))) {
                                    task.setDebugPort(port);
                                    changed = true;
                                    changedProps.setProperty("debug.port", port.toString());
                                }
                                break;
                            }
                            throw new NumberFormatException();
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Wrong data! Port must be number between 1024 and 65536.");
                            continue;
                        }
                        break;
                    }
                }
            }
            if (changed) {
                task.setInstallation(new Boolean(false));
                task.setElementName(elementName);
                this.tasksManager.addTask(task);
            }
        }
        return changedProps;
    }

    public static void main(String[] args) {
        new ConsoleConfigTool();
    }
}

