/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.xmlgenerator;

import com.sap.engine.configtool.ClusterData;
import com.sap.engine.configtool.Instance;
import com.sap.engine.configtool.batch.task.ChangeInstancePropsTask;
import com.sap.engine.configtool.batch.task.ElementInfoTask;
import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.batch.task.TaskUtil;
import com.sap.engine.configtool.batch.xmlgenerator.ConfigTaskXmlGenerationException;
import com.sap.engine.configtool.lib.PortsCalculator;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.core.configuration.bootstrap.ConfigurationManagerBootstrapImpl;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

final class ConfigXmlGeneratorUtils {
    private ConfigXmlGeneratorUtils() {
    }

    static String getRequiredString(Properties properties, String key) throws IllegalArgumentException {
        String result = PropertiesUtil.getProperty(properties, key);
        if (result == null) {
            throw new IllegalArgumentException("Error occurred while reading " + key);
        }
        return result;
    }

    static Integer getRequiredInteger(Properties properties, String key) throws IllegalArgumentException {
        Integer result = PropertiesUtil.getIntegerProperty(properties, key);
        if (result == null) {
            throw new IllegalArgumentException("Error occurred while reading " + key);
        }
        return result;
    }

    static Boolean getRequiredBoolean(Properties properties, String key) throws IllegalArgumentException {
        Boolean result = PropertiesUtil.getBooleanProperty(properties, key, "yes");
        if (result == null) {
            throw new IllegalArgumentException("Error occurred while reading " + key);
        }
        return result;
    }

    static String getCanonicalPath(String fileName) {
        try {
            fileName = new File(fileName).getCanonicalPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileName;
    }

    static void deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Properties getPropertiesFromFile(String propertiesFileName) throws FileNotFoundException, IOException {
        Properties properties;
        BufferedInputStream propertiesFileInputStream = null;
        try {
            propertiesFileInputStream = new BufferedInputStream(new FileInputStream(propertiesFileName));
            Properties properties2 = new Properties();
            properties2.load(propertiesFileInputStream);
            properties = properties2;
            Object var5_4 = null;
            if (propertiesFileInputStream == null) return properties;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (propertiesFileInputStream == null) throw throwable;
            ((InputStream)propertiesFileInputStream).close();
            throw throwable;
        }
        ((InputStream)propertiesFileInputStream).close();
        return properties;
    }

    static Properties getClusterElementProperties(String clusterElementName, Properties configurationProperties) throws ConfigurationException {
        ConfigurationHandler cfgHandler = new ConfigurationManagerBootstrapImpl(configurationProperties).getConfigurationHandler();
        String elementInfoPath = TaskUtil.getElementConfigurationPath(clusterElementName, cfgHandler) + "/" + "element-info";
        Configuration elementInfoConfig = cfgHandler.openConfiguration(elementInfoPath, 1);
        PropertySheet sheetProperties = null;
        if (elementInfoConfig != null) {
            sheetProperties = elementInfoConfig.getPropertySheetInterface();
        }
        Properties clusterElementProperties = sheetProperties.getProperties();
        cfgHandler.commit();
        cfgHandler.closeConfiguration(elementInfoConfig);
        return clusterElementProperties;
    }

    static Task createElementInfoTask(String elementName, Properties taskProperties) throws ConfigTaskXmlGenerationException {
        ElementInfoTask elementInfoTask = new ElementInfoTask();
        taskProperties.setProperty("element.name", elementName);
        try {
            elementInfoTask.setTaskProperties(taskProperties);
            elementInfoTask.setElementName(elementName);
            elementInfoTask.setInstallation(new Boolean(true));
        }
        catch (Exception e) {
            throw new ConfigTaskXmlGenerationException("An error occured while setting properties of the task for the cluster element " + elementName + ".\n" + e.getMessage());
        }
        return elementInfoTask;
    }

    static Task createChangeInstancePropsTask(String instancePrefix, Properties taskProperties) throws ConfigTaskXmlGenerationException {
        ChangeInstancePropsTask instanceTask = new ChangeInstancePropsTask();
        instanceTask.setInstancePrefix(instancePrefix);
        taskProperties.setProperty("instance.prefix", instancePrefix);
        try {
            instanceTask.setTaskProperties(taskProperties);
        }
        catch (Exception e) {
            throw new ConfigTaskXmlGenerationException("An error occured while setting properties of the task for the instance " + instancePrefix + ".\n" + e.getMessage());
        }
        return instanceTask;
    }

    static Properties prependProperties(Properties prepends, Properties original) {
        Properties result = new Properties();
        Iterator prependEntrySetIter = ((Hashtable)prepends).entrySet().iterator();
        while (prependEntrySetIter.hasNext()) {
            Map.Entry entry = prependEntrySetIter.next();
            String toPrependValue = (String)entry.getValue();
            String originalValue = (String)((Hashtable)original).get(entry.getKey());
            String prependedValue = toPrependValue;
            if (originalValue != null) {
                prependedValue = (originalValue + " ").indexOf(toPrependValue) == -1 ? toPrependValue + originalValue : originalValue;
            }
            ((Hashtable)result).put(entry.getKey(), prependedValue);
        }
        return result;
    }

    static Properties prependProperties(Properties prepends, PropertySheet original) {
        Properties result = new Properties();
        Iterator prependEntrySetIter = ((Hashtable)prepends).entrySet().iterator();
        while (prependEntrySetIter.hasNext()) {
            String toPrependValue;
            Map.Entry entry = prependEntrySetIter.next();
            String prependedValue = toPrependValue = (String)entry.getValue();
            String originalValue = null;
            try {
                originalValue = (String)original.getPropertyEntry((String)entry.getKey()).getDefault();
                prependedValue = (originalValue + " ").indexOf(toPrependValue) == -1 ? toPrependValue + originalValue : originalValue;
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
            ((Hashtable)result).put(entry.getKey(), prependedValue);
        }
        return result;
    }

    static void prepareBootstrapParamaters(Properties clusterElementProperties) {
        ConfigXmlGeneratorUtils.prepareBootstrapParamaters(null, clusterElementProperties);
    }

    static void prepareBootstrapParamaters(String clusterElementName, Properties elementProperties) {
        String bootstrapJavaParamsKey = null;
        bootstrapJavaParamsKey = clusterElementName != null ? "bootstrap_" + clusterElementName + "." + "JavaParameters" : "bootstrap.JavaParameters";
        String bootstrapJavaParams = (String)((Hashtable)elementProperties).get(bootstrapJavaParamsKey);
        if (bootstrapJavaParams != null) {
            ((Hashtable)elementProperties).put("bootstrap.java.parameters", bootstrapJavaParams);
        }
    }

    static String getInstancePrefix(Properties tasksProperties) {
        Integer systemId = ConfigXmlGeneratorUtils.getRequiredInteger(tasksProperties, "system.id");
        String boxNumber = ConfigXmlGeneratorUtils.getRequiredString(tasksProperties, "box.number");
        return new PortsCalculator(systemId, boxNumber, "server").getElementIdPrefix();
    }

    static Collection getInstanceElements(ClusterData clusterData, String instanceIdPrefix) throws ConfigTaskXmlGenerationException {
        Instance instance = (Instance)clusterData.getInstances().get(instanceIdPrefix);
        if (instance == null) {
            throw new ConfigTaskXmlGenerationException("The system could not find an instance with the specified prefix " + instanceIdPrefix + ".");
        }
        return instance.getInstanceElements().values();
    }
}

