/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.xmlgenerator;

import com.sap.engine.configtool.PropertyMap;
import com.sap.engine.configtool.batch.descriptor.BatchConfigDescriptor;
import com.sap.engine.configtool.batch.task.ChangeManagerPropsTask;
import com.sap.engine.configtool.batch.task.ChangeServicePropsTask;
import com.sap.engine.configtool.batch.task.CreateInstancePropsTask;
import com.sap.engine.configtool.batch.task.CreateNewElementTask;
import com.sap.engine.configtool.batch.task.ElementInfoTask;
import com.sap.engine.configtool.batch.task.FSTask;
import com.sap.engine.configtool.batch.task.GenerateBootstrapTask;
import com.sap.engine.configtool.batch.task.RemoveElementsTask;
import com.sap.engine.configtool.batch.xmlgenerator.ConfigXmlGeneratorUtils;
import com.sap.engine.configtool.lib.PropertiesUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;

public final class ConfigXmlGenerator {
    private static final String SHORT_XML_KEY = "-short";
    private boolean shortXML = false;
    private String outFileName;
    private String installedDir;
    private Integer serversCount;
    private Integer systemId;
    private String boxNumber;
    private Boolean r3;
    private String javaPath;
    private String dispJavaPath;
    private String serverJavaPath;
    private Integer dispHeapSize;
    private Integer serverHeapSize;
    private String bootstrapAdditionalParams;
    private String dispAdditionalParams;
    private String serverAdditionalParams;
    private Boolean debuggable;
    private String msHost;
    private Integer msPort;
    private String dbDriverLocation = null;
    private String dbUrl;
    private String dbUser;
    private String dbPassword;
    private Integer dbIC;
    private Integer dbMC;
    private String secstoreFSLib;
    private String secstoreFSSecfile;
    private String secstoreFSKeyfile;
    private String rdbmsConnection;
    private String sysName;
    private String enqProfileFileName;
    private String enqHost;
    private Integer enqPort;
    private String osName;
    private Integer osBitLength;
    private Boolean osUnicode;
    private String adminUserName;
    private String sysdsDSN;
    private String sysdsAliases;
    private Integer sysdsIC;
    private Integer sysdsMC;
    private Integer sysdsMaxTimeWC;
    private Integer sysdsCL;
    private String sysdsIL;
    private String sysdsRunCTI;
    private String sysdsSQLEngine;
    private Integer scsID;
    private Boolean isCentralInstance;
    private String umeTemplatesDir;
    private String sslStartupMode;
    private String umeUsermapping;
    private ArrayList tasks;
    private Properties properties;
    private Integer serverLoadTimeout;
    private Integer dispatcherLoadTimeout;

    public ConfigXmlGenerator(String propertiesFileName, boolean shortXML) {
        this.shortXML = shortXML;
        this.properties = new Properties();
        try {
            this.properties.load(new BufferedInputStream(new FileInputStream(propertiesFileName)));
        }
        catch (Exception e) {
            System.out.println("Error occurred while reading " + propertiesFileName + ".\n" + e.getMessage());
        }
    }

    public void generate() throws Exception {
        this.checkParameters();
        BatchConfigDescriptor descriptor = new BatchConfigDescriptor();
        descriptor.setDbProperties(PropertiesUtil.getDBProperties(this.secstoreFSSecfile, this.secstoreFSKeyfile, this.sysName, this.secstoreFSLib, this.rdbmsConnection, this.dbDriverLocation, this.dbIC, this.dbMC, this.dbUrl, this.dbUser, this.dbPassword));
        this.tasks = new ArrayList(11);
        if (!this.shortXML) {
            RemoveElementsTask removeElementsTask = new RemoveElementsTask();
            removeElementsTask.setSid(this.systemId);
            removeElementsTask.setBoxNumber(this.boxNumber);
            removeElementsTask.setInstallDir(this.installedDir);
            this.tasks.add(removeElementsTask);
        }
        FSTask fSTask = new FSTask();
        fSTask.setSid(this.systemId);
        fSTask.setBn(this.boxNumber);
        fSTask.setInstallDir(this.installedDir);
        fSTask.setdbURL(this.dbUrl);
        fSTask.setDriverLocation(this.dbDriverLocation);
        fSTask.setUser(this.dbUser);
        fSTask.setInitialConnections(this.dbIC);
        fSTask.setMaxConnections(this.dbMC);
        fSTask.setSecstoreFSLib(this.secstoreFSLib);
        fSTask.setSecstoreFSSecfile(this.secstoreFSSecfile);
        fSTask.setSecstoreFSKeyfile(this.secstoreFSKeyfile);
        fSTask.setRdbmsConnection(this.rdbmsConnection);
        fSTask.setSysName(this.sysName);
        fSTask.setScsID(this.scsID);
        fSTask.setMsHost(this.msHost);
        fSTask.setAdminUserName(this.adminUserName);
        this.tasks.add(fSTask);
        GenerateBootstrapTask generateBootstrapTask = new GenerateBootstrapTask();
        generateBootstrapTask.setDbDriverLocation(this.dbDriverLocation);
        generateBootstrapTask.setDbUrl(this.dbUrl);
        generateBootstrapTask.setDbUser(this.dbUser);
        generateBootstrapTask.setDbPassword(this.dbPassword);
        generateBootstrapTask.setDbIC(this.dbIC);
        generateBootstrapTask.setDbMC(this.dbMC);
        generateBootstrapTask.setSecstoreFSLib(this.secstoreFSLib);
        generateBootstrapTask.setSecstoreFSSecfile(this.secstoreFSSecfile);
        generateBootstrapTask.setSecstoreFSKeyfile(this.secstoreFSKeyfile);
        generateBootstrapTask.setRdbmsConnection(this.rdbmsConnection);
        generateBootstrapTask.setSysName(this.sysName);
        generateBootstrapTask.setSid(this.systemId);
        generateBootstrapTask.setBn(this.boxNumber);
        generateBootstrapTask.setInstallDir(this.installedDir);
        generateBootstrapTask.setAdditionalJavaParams(this.bootstrapAdditionalParams);
        this.tasks.add(generateBootstrapTask);
        CreateInstancePropsTask createInstancePropsTask = new CreateInstancePropsTask();
        createInstancePropsTask.setSid(this.systemId);
        createInstancePropsTask.setBn(this.boxNumber);
        createInstancePropsTask.setMsHost(this.msHost);
        createInstancePropsTask.setMsPort(this.msPort);
        createInstancePropsTask.setInstallDir(this.installedDir);
        createInstancePropsTask.setJavaPath(this.javaPath);
        this.tasks.add(createInstancePropsTask);
        if (!this.shortXML) {
            ChangeManagerPropsTask changeManagerPropTask;
            PropertyMap serveceManagerEntries;
            this.changeGlobalElementSettings("dispatcher", "dispatcher");
            this.changeGlobalElementSettings("server", "server");
            if (this.serverLoadTimeout != null) {
                serveceManagerEntries = new PropertyMap();
                serveceManagerEntries.put("LoadTimeout", this.serverLoadTimeout.toString());
                changeManagerPropTask = new ChangeManagerPropsTask();
                changeManagerPropTask.setElementName("server");
                changeManagerPropTask.setManagerName("ServiceManager");
                changeManagerPropTask.setManagerProperties(serveceManagerEntries);
                this.tasks.add(changeManagerPropTask);
            }
            if (this.dispatcherLoadTimeout != null) {
                serveceManagerEntries = new PropertyMap();
                serveceManagerEntries.put("LoadTimeout", this.dispatcherLoadTimeout.toString());
                changeManagerPropTask = new ChangeManagerPropsTask();
                changeManagerPropTask.setElementName("dispatcher");
                changeManagerPropTask.setManagerName("ServiceManager");
                changeManagerPropTask.setManagerProperties(serveceManagerEntries);
                this.tasks.add(changeManagerPropTask);
            }
            this.createNewElement("dispatcher");
            int i = 0;
            while (i < this.serversCount) {
                this.createNewElement("server");
                ++i;
            }
        }
        descriptor.setTasks(this.tasks);
        descriptor.saveToFile(this.outFileName);
        System.out.println("Batch Config Xml successfully generated to " + this.outFileName + "\n");
    }

    private void changeGlobalElementSettings(String elementName, String elementType) {
        if ("server".equals(elementType)) {
            ElementInfoTask elementInfoTask = new ElementInfoTask();
            elementInfoTask.setSid(this.systemId);
            elementInfoTask.setBoxNumber(this.boxNumber);
            elementInfoTask.setElementName(elementName);
            elementInfoTask.setJavaPath(this.serverJavaPath);
            elementInfoTask.setJavaMaxHeapSize(this.serverHeapSize);
            elementInfoTask.setAdditionalJavaParams(this.serverAdditionalParams);
            elementInfoTask.setDebuggable(this.debuggable);
            elementInfoTask.setOsName(this.osName);
            elementInfoTask.setOsBitLength(this.osBitLength);
            elementInfoTask.setOsUnicode(this.osUnicode);
            elementInfoTask.setInstallDir(this.installedDir);
            elementInfoTask.setInstallation(new Boolean(true));
            this.tasks.add(elementInfoTask);
            if (this.isCentralInstance.booleanValue()) {
                ChangeServicePropsTask changeDBPoolServiceTask = new ChangeServicePropsTask();
                changeDBPoolServiceTask.setElementName(elementName);
                changeDBPoolServiceTask.setServiceName("dbpool");
                PropertyMap dbpoolEntries = new PropertyMap();
                dbpoolEntries.putAsDefault("sysDS.DBConnectInfo", "jdbc/pool/" + this.sysName);
                dbpoolEntries.putAsDefault("sysDS.dataSourceName", this.sysdsDSN);
                dbpoolEntries.putAsDefault("sysDS.aliases", this.sysdsAliases);
                dbpoolEntries.putAsDefault("sysDS.initialConnections", this.sysdsIC.toString());
                dbpoolEntries.putAsDefault("sysDS.maximumConnections", this.sysdsMC.toString());
                dbpoolEntries.putAsDefault("sysDS.maxTimeToWaitConnection", this.sysdsMaxTimeWC.toString());
                dbpoolEntries.putAsDefault("sysDS.connectionLifetime", this.sysdsCL.toString());
                dbpoolEntries.putAsDefault("sysDS.isolationLevel", this.sysdsIL);
                dbpoolEntries.putAsDefault("sysDS.runCleanupThreadInterval", this.sysdsRunCTI);
                dbpoolEntries.putAsDefault("sysDS.SQLEngine", this.sysdsSQLEngine);
                changeDBPoolServiceTask.setServiceProperties(dbpoolEntries);
                this.tasks.add(changeDBPoolServiceTask);
            }
            ChangeServicePropsTask changeUMEServiceTask = new ChangeServicePropsTask();
            changeUMEServiceTask.setElementName(elementName);
            changeUMEServiceTask.setServiceName("com.sap.security.core.ume.service");
            PropertyMap umeEntries = new PropertyMap();
            umeEntries.putAsDefault("ume.usermapping.unsecure", this.umeUsermapping);
            changeUMEServiceTask.setServiceProperties(umeEntries);
            this.tasks.add(changeUMEServiceTask);
        } else if (this.sslStartupMode != null) {
            ChangeServicePropsTask changeSSLStartupMode = new ChangeServicePropsTask();
            changeSSLStartupMode.setElementName(elementName);
            changeSSLStartupMode.setServiceName("ssl");
            changeSSLStartupMode.setStartupMode(this.sslStartupMode);
            this.tasks.add(changeSSLStartupMode);
        }
        ChangeManagerPropsTask changeManagerPropsTask = new ChangeManagerPropsTask();
        changeManagerPropsTask.setElementName(elementName);
        changeManagerPropsTask.setManagerName("LockingManager");
        PropertyMap lockingManagerEntries = new PropertyMap();
        lockingManagerEntries.putAsDefault("enq.profile.filename", this.enqProfileFileName);
        lockingManagerEntries.putAsDefault("enqu.host", this.enqHost);
        lockingManagerEntries.putAsDefault("enqu.port", this.enqPort.toString());
        changeManagerPropsTask.setManagerProperties(lockingManagerEntries);
        this.tasks.add(changeManagerPropsTask);
        PropertyMap clusterManagerEntries = new PropertyMap();
        clusterManagerEntries.putAsDefault("ms.host", this.msHost);
        clusterManagerEntries.putAsDefault("ms.port", this.msPort.toString());
        ChangeManagerPropsTask changeManagerPropTask = new ChangeManagerPropsTask();
        changeManagerPropTask.setElementName(elementName);
        changeManagerPropTask.setManagerName("ClusterManager");
        changeManagerPropTask.setManagerProperties(clusterManagerEntries);
        this.tasks.add(changeManagerPropTask);
    }

    private void createNewElement(String elementType) {
        CreateNewElementTask createNewElementTask = new CreateNewElementTask();
        createNewElementTask.setType(elementType);
        createNewElementTask.setSid(this.systemId);
        createNewElementTask.setBn(this.boxNumber);
        createNewElementTask.setR3(this.r3);
        createNewElementTask.setDbDriverLocation(this.dbDriverLocation);
        createNewElementTask.setDbUrl(this.dbUrl);
        createNewElementTask.setDbUser(this.dbUser);
        createNewElementTask.setDbPassword(this.dbPassword);
        createNewElementTask.setDbIC(this.dbIC);
        createNewElementTask.setDbMC(this.dbMC);
        createNewElementTask.setSecstoreFSLib(this.secstoreFSLib);
        createNewElementTask.setSecstoreFSSecfile(this.secstoreFSSecfile);
        createNewElementTask.setSecstoreFSKeyfile(this.secstoreFSKeyfile);
        createNewElementTask.setRdbmsConnection(this.rdbmsConnection);
        createNewElementTask.setSysName(this.sysName);
        if (elementType.equals("dispatcher")) {
            createNewElementTask.setOsBitLength(this.osBitLength);
            createNewElementTask.setOsName(this.osName);
            createNewElementTask.setOsUnicode(this.osUnicode);
            createNewElementTask.setJavaPath(this.dispJavaPath);
            createNewElementTask.setMaxHeapSize(this.dispHeapSize);
            createNewElementTask.setAdditionalJavaParams(this.dispAdditionalParams);
        }
        this.tasks.add(createNewElementTask);
    }

    private void checkParameters() throws Exception {
        this.serversCount = ConfigXmlGeneratorUtils.getRequiredInteger(this.properties, "servers.count");
        if (this.serversCount < 1 || this.serversCount > 16) {
            throw new IllegalArgumentException("Error occurred while reading servers.count. Servers count should be between 1 to 16.");
        }
        this.outFileName = PropertiesUtil.getProperty(this.properties, "out.file.name", "BatchConfig.xml");
        File outFile = new File(this.outFileName);
        if (outFile.exists()) {
            outFile.delete();
        }
        this.installedDir = ConfigXmlGeneratorUtils.getRequiredString(this.properties, "install.dir");
        this.javaPath = ConfigXmlGeneratorUtils.getRequiredString(this.properties, "java.home");
        this.dispJavaPath = PropertiesUtil.getProperty(this.properties, "dispatcher.java.home", this.javaPath);
        this.serverJavaPath = PropertiesUtil.getProperty(this.properties, "server.java.home", this.javaPath);
        Integer javaHeapSize = PropertiesUtil.getIntegerProperty(this.properties, "java.heap.size", "64");
        this.dispHeapSize = PropertiesUtil.getIntegerProperty(this.properties, "dispatcher.heap.size", javaHeapSize.toString());
        this.serverHeapSize = PropertiesUtil.getIntegerProperty(this.properties, "server.heap.size", javaHeapSize.toString());
        String additionalJavaParams = PropertiesUtil.getProperty(this.properties, "java.additional.parameters", "");
        this.bootstrapAdditionalParams = PropertiesUtil.getProperty(this.properties, "bootstrap.additional.parameters", additionalJavaParams);
        this.dispAdditionalParams = PropertiesUtil.getProperty(this.properties, "dispatcher.additional.parameters", additionalJavaParams);
        this.serverAdditionalParams = PropertiesUtil.getProperty(this.properties, "server.additional.parameters", additionalJavaParams);
        this.debuggable = PropertiesUtil.getBooleanProperty(this.properties, "server.debuggable", "yes");
        this.systemId = ConfigXmlGeneratorUtils.getRequiredInteger(this.properties, "system.id");
        this.boxNumber = ConfigXmlGeneratorUtils.getRequiredString(this.properties, "box.number");
        this.msHost = ConfigXmlGeneratorUtils.getRequiredString(this.properties, "ms.host");
        this.msPort = ConfigXmlGeneratorUtils.getRequiredInteger(this.properties, "ms.port");
        this.r3 = PropertiesUtil.getBooleanProperty(this.properties, "r3.environment", "yes", "yes");
        this.isCentralInstance = PropertiesUtil.getBooleanProperty(this.properties, "system.isCentralInstance", "yes", "yes");
        this.dbDriverLocation = PropertiesUtil.getProperty(this.properties, "rdbms.driverLocation", "");
        this.dbUrl = PropertiesUtil.getProperty(this.properties, "rdbms.url");
        this.dbUser = PropertiesUtil.getProperty(this.properties, "rdbms.user");
        this.dbPassword = PropertiesUtil.getProperty(this.properties, "rdbms.password");
        this.dbIC = PropertiesUtil.getIntegerProperty(this.properties, "rdbms.initial_connections", "1");
        this.dbMC = PropertiesUtil.getIntegerProperty(this.properties, "rdbms.maximum_connections", "5");
        this.secstoreFSLib = ConfigXmlGeneratorUtils.getCanonicalPath(PropertiesUtil.getProperty(this.properties, "secstorefs.lib"));
        this.secstoreFSSecfile = ConfigXmlGeneratorUtils.getCanonicalPath(PropertiesUtil.getProperty(this.properties, "secstorefs.secfile"));
        this.secstoreFSKeyfile = ConfigXmlGeneratorUtils.getCanonicalPath(PropertiesUtil.getProperty(this.properties, "secstorefs.keyfile"));
        this.rdbmsConnection = PropertiesUtil.getProperty(this.properties, "rdbms.connection");
        this.sysName = PropertiesUtil.getProperty(this.properties, "system.name");
        this.enqProfileFileName = ConfigXmlGeneratorUtils.getRequiredString(this.properties, "enq.profile.filename");
        this.enqHost = ConfigXmlGeneratorUtils.getRequiredString(this.properties, "enq.host");
        this.enqPort = ConfigXmlGeneratorUtils.getRequiredInteger(this.properties, "enq.port");
        this.osName = ConfigXmlGeneratorUtils.getRequiredString(this.properties, "os.name");
        this.osBitLength = ConfigXmlGeneratorUtils.getRequiredInteger(this.properties, "os.bit.length");
        this.osUnicode = ConfigXmlGeneratorUtils.getRequiredBoolean(this.properties, "os.unicode");
        if (this.isCentralInstance.booleanValue()) {
            this.adminUserName = this.properties.getProperty("admin.user", "Administrator");
            this.sysdsDSN = ConfigXmlGeneratorUtils.getRequiredString(this.properties, "sysDS.dataSourceName");
            this.sysdsAliases = ConfigXmlGeneratorUtils.getRequiredString(this.properties, "sysDS.aliases");
            this.sysdsIC = ConfigXmlGeneratorUtils.getRequiredInteger(this.properties, "sysDS.initialConnections");
            this.sysdsMC = ConfigXmlGeneratorUtils.getRequiredInteger(this.properties, "sysDS.maximumConnections");
            this.sysdsMaxTimeWC = ConfigXmlGeneratorUtils.getRequiredInteger(this.properties, "sysDS.maxTimeToWaitConnection");
            this.sysdsCL = ConfigXmlGeneratorUtils.getRequiredInteger(this.properties, "sysDS.connectionLifetime");
            this.sysdsRunCTI = ConfigXmlGeneratorUtils.getRequiredString(this.properties, "sysDS.runCleanupThreadInterval");
            this.sysdsSQLEngine = ConfigXmlGeneratorUtils.getRequiredString(this.properties, "sysDS.SQLEngine");
            this.sysdsIL = PropertiesUtil.getProperty(this.properties, "sysDS.isolationLevel", "");
            this.umeTemplatesDir = PropertiesUtil.getProperty(this.properties, "ume.templates.dir", ".").replace('\\', File.separatorChar).replace('/', File.separatorChar);
            if (!this.umeTemplatesDir.endsWith(File.separator)) {
                this.umeTemplatesDir = this.umeTemplatesDir + File.separator;
            }
        }
        this.scsID = PropertiesUtil.getIntegerProperty(this.properties, "scs.id");
        this.serverLoadTimeout = PropertiesUtil.getIntegerProperty(this.properties, "server.LoadTimeout");
        this.dispatcherLoadTimeout = PropertiesUtil.getIntegerProperty(this.properties, "dispatcher.LoadTimeout");
        this.sslStartupMode = PropertiesUtil.getProperty(this.properties, "ssl.startup.mode");
        this.umeUsermapping = PropertiesUtil.getProperty(this.properties, "ume.usermapping.unsecure");
    }

    public static void main(String[] args) {
        System.out.println("\nSAP J2EE Engine Batch Config Xml Generator\n");
        if (args.length == 0) {
            System.out.println("Usage:\n  go properties_file_name\n\nThe format of the properties file is described in\nproperties.format.txt text file.");
        } else {
            String propertiesFileName = args[0];
            try {
                boolean shortXML = args.length > 1 && args[1].equalsIgnoreCase(SHORT_XML_KEY);
                new ConfigXmlGenerator(propertiesFileName, shortXML).generate();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.out.println("Error occurred while generating " + propertiesFileName);
                System.exit(31415);
            }
        }
    }
}

