/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.xmlgenerator;

import com.sap.engine.configtool.batch.xmlgenerator.ConfigTaskXmlGenerationException;
import com.sap.engine.configtool.batch.xmlgenerator.ConfigTasksXmlGenerator;
import com.sap.engine.frame.core.configuration.ConfigurationException;

public final class ConfigTasksXmlProcessor {
    private static final int RETURNED_ERROR_CODE = 31415;
    private static final int RETURNED_OK_CODE = 0;
    private String[] processArguments;

    public ConfigTasksXmlProcessor(String[] args) {
        this.processArguments = args;
    }

    public void process() throws ConfigTaskXmlGenerationException, ConfigurationException {
        this.processAllCommands(this.processArguments);
    }

    public void setProcessArguments(String[] processArguments) {
        this.cleanUp();
        this.processArguments = processArguments;
    }

    private void processAllCommands(String[] args) throws ConfigTaskXmlGenerationException, ConfigurationException {
        System.out.println("\nSAP J2EE Engine Batch Config Xml Generator\n");
        if (args.length == 0 || args.length % 2 != 0) {
            System.err.println("Usage:\nThe format of the arguments have to be: \"name value\" \nThe system supports only three commands in this version:\n- config  - There has to be only one config parameter.\n- update  - Multiple occurances are allowed.\n- prepend - Multiple occurances are allowed.\nAfter each command you have to specify the properties file related with the command.(Example: config configuration.properties update instance_one_update.properties \nupdate instance_two_update.properties prepend instance_one_prepend.properties)");
        } else {
            ConfigTasksXmlGenerator configTasksXmlGenerator = new ConfigTasksXmlGenerator();
            String command = null;
            String propertiesFileName = null;
            int i = 0;
            while (i < args.length) {
                if (i % 2 == 0) {
                    command = args[i].toLowerCase();
                } else {
                    propertiesFileName = args[i];
                    this.processCommand(configTasksXmlGenerator, command, propertiesFileName);
                }
                ++i;
            }
            configTasksXmlGenerator.generate();
        }
    }

    private void processCommand(ConfigTasksXmlGenerator configTasksXmlGenerator, String commandName, String commandValue) throws ConfigTaskXmlGenerationException {
        if ("update".equals(commandName)) {
            configTasksXmlGenerator.loadPropertyFileForUpdate(commandValue);
        } else if ("prepend".equals(commandName)) {
            configTasksXmlGenerator.loadPropertyFileForPrepend(commandValue);
        } else if ("config".equals(commandName)) {
            configTasksXmlGenerator.loadPropertyFileForConfig(commandValue);
        } else {
            throw new ConfigTaskXmlGenerationException("The command " + commandName + " is not supported!");
        }
    }

    private void cleanUp() {
        if (this.processArguments != null) {
            int i = 0;
            while (i < this.processArguments.length) {
                this.processArguments[i] = null;
                ++i;
            }
        }
    }

    public static void main(String[] args) {
        try {
            new ConfigTasksXmlProcessor(args).process();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error occured during tasks XML generation! \n" + e.getMessage());
            System.exit(31415);
        }
        System.exit(0);
    }
}

