/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.xmlgenerator;

import com.sap.engine.configtool.batch.descriptor.BatchConfigDescriptor;
import com.sap.engine.configtool.batch.task.TaskUtil;
import com.sap.engine.configtool.batch.xmlgenerator.ConfigTaskXmlGenerationException;
import com.sap.engine.configtool.batch.xmlgenerator.ConfigXmlGeneratorUtils;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.core.configuration.bootstrap.ConfigurationManagerBootstrapImpl;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public final class ConfigTasksXmlGenerator {
    public static final String UPDATE_COMMAND = "update";
    public static final String PREPEND_COMMAND = "prepend";
    public static final String CONFIG_COMMAND = "config";
    private Collection updatePropertyFiles = new ArrayList();
    private Collection prependPropertyFiles = new ArrayList();
    private Properties configProperties;
    private String outFileName;
    private ArrayList tasks;
    private String secstoreFSLib;
    private String secstoreFSSecfile;
    private String secstoreFSKeyfile;
    private String systemName;
    private String rdbmsConnection;
    private String dbDriverLocation;
    private Integer dbIC;
    private Integer dbMC;

    public void generate() throws ConfigTaskXmlGenerationException, ConfigurationException {
        this.checkConfigParameters();
        this.tasks = new ArrayList();
        BatchConfigDescriptor descriptor = this.getBatchConfigDescriptor();
        ConfigurationHandler cfgHandler = null;
        ConfigurationManagerBootstrapImpl cfgFactory = new ConfigurationManagerBootstrapImpl(this.configProperties);
        cfgHandler = cfgFactory.getConfigurationHandler();
        this.generatePrependTasks(cfgHandler);
        this.generateUpdateTasks();
        this.generateXmlFromTasks(descriptor);
        System.out.println("Batch Config Xml successfully generated to " + this.outFileName + "\n");
    }

    public void loadPropertyFileForUpdate(String propertyFileName) throws ConfigTaskXmlGenerationException {
        try {
            this.updatePropertyFiles.add(ConfigXmlGeneratorUtils.getPropertiesFromFile(propertyFileName));
        }
        catch (FileNotFoundException e) {
            throw new ConfigTaskXmlGenerationException("The system could not find the specified file " + propertyFileName + ".\n" + e.getMessage());
        }
        catch (IOException e) {
            throw new ConfigTaskXmlGenerationException("The system could not load the properties from the specified file " + propertyFileName + ".\n" + e.getMessage());
        }
    }

    public void loadPropertyFileForPrepend(String propertyFileName) throws ConfigTaskXmlGenerationException {
        try {
            this.prependPropertyFiles.add(ConfigXmlGeneratorUtils.getPropertiesFromFile(propertyFileName));
        }
        catch (FileNotFoundException e) {
            throw new ConfigTaskXmlGenerationException("The system could not find the specified file " + propertyFileName + ".\n" + e.getMessage());
        }
        catch (IOException e) {
            throw new ConfigTaskXmlGenerationException("The system could not load the properties from the specified file " + propertyFileName + ".\n" + e.getMessage());
        }
    }

    public void loadPropertyFileForConfig(String propertyFileName) throws ConfigTaskXmlGenerationException {
        try {
            if (this.configProperties != null && !((Hashtable)this.configProperties).isEmpty()) {
                throw new ConfigTaskXmlGenerationException("The system does not allow to set the configuration properties more that once.");
            }
            this.configProperties = ConfigXmlGeneratorUtils.getPropertiesFromFile(propertyFileName);
        }
        catch (FileNotFoundException e) {
            throw new ConfigTaskXmlGenerationException("The system could not find the specified file " + propertyFileName + ".\n" + e.getMessage());
        }
        catch (IOException e) {
            throw new ConfigTaskXmlGenerationException("The system could not load the properties from the specified file " + propertyFileName + ".\n" + e.getMessage());
        }
    }

    private void generateXmlFromTasks(BatchConfigDescriptor descriptor) throws ConfigTaskXmlGenerationException {
        descriptor.setTasks(this.tasks);
        try {
            descriptor.saveToFile(this.outFileName);
        }
        catch (IOException e) {
            throw new ConfigTaskXmlGenerationException("An error occured while tasks are stored as an xml data in the file system.");
        }
    }

    private BatchConfigDescriptor getBatchConfigDescriptor() {
        BatchConfigDescriptor descriptor = new BatchConfigDescriptor();
        descriptor.setDbProperties(PropertiesUtil.getDBProperties(this.secstoreFSSecfile, this.secstoreFSKeyfile, this.systemName, this.secstoreFSLib, this.rdbmsConnection, this.dbDriverLocation, this.dbIC, this.dbMC));
        return descriptor;
    }

    private void generateUpdateTasks() throws ConfigTaskXmlGenerationException {
        Iterator iter = this.updatePropertyFiles.iterator();
        while (iter.hasNext()) {
            Properties props = (Properties)iter.next();
            this.addInstanceElementsAsTasks(props);
        }
    }

    private void generatePrependTasks(ConfigurationHandler cfgHandler) throws ConfigurationException, ConfigTaskXmlGenerationException {
        Iterator iter = this.prependPropertyFiles.iterator();
        while (iter.hasNext()) {
            Properties props = (Properties)iter.next();
            this.prependAndAddInstanceElementsAsTasks(cfgHandler, props);
        }
    }

    private void prependAndAddInstanceElementsAsTasks(ConfigurationHandler cfgHandler, Properties propsForPrepending) throws ConfigurationException, ConfigTaskXmlGenerationException {
        String instancePrefix = ConfigXmlGeneratorUtils.getInstancePrefix(propsForPrepending);
        Properties instanceProperties = null;
        instanceProperties = TaskUtil.getInstanceProperties(cfgHandler, instancePrefix);
        ConfigXmlGeneratorUtils.prepareBootstrapParamaters(instanceProperties);
        Properties prependedInstanceProperties = ConfigXmlGeneratorUtils.prependProperties(propsForPrepending, instanceProperties);
        this.tasks.add(ConfigXmlGeneratorUtils.createChangeInstancePropsTask(instancePrefix, prependedInstanceProperties));
        String clusterName = instancePrefix + "00";
        Configuration dispCfg = cfgHandler.openConfiguration("cluster_data/dispatcher/" + clusterName + "/" + "element-info", 0);
        PropertySheet dispProps = dispCfg.getPropertySheetInterface();
        Properties prependProps = ConfigXmlGeneratorUtils.prependProperties(propsForPrepending, dispProps);
        this.tasks.add(ConfigXmlGeneratorUtils.createElementInfoTask(clusterName, prependProps));
        cfgHandler.closeConfiguration(dispCfg);
        Configuration serverCfg = cfgHandler.openConfiguration("cluster_data/server/cfg", 0);
        PropertySheet elementInfo = null;
        try {
            elementInfo = serverCfg.getSubConfiguration("element-info." + instancePrefix).getPropertySheetInterface();
        }
        catch (NameNotFoundException e) {
            elementInfo = serverCfg.getSubConfiguration("element-info").getPropertySheetInterface();
        }
        prependProps = ConfigXmlGeneratorUtils.prependProperties(propsForPrepending, elementInfo);
        this.tasks.add(ConfigXmlGeneratorUtils.createElementInfoTask("server." + instancePrefix, prependProps));
        cfgHandler.closeConfiguration(serverCfg);
    }

    private void addInstanceElementsAsTasks(Properties tasksProperties) throws ConfigTaskXmlGenerationException {
        String instancePrefix = ConfigXmlGeneratorUtils.getInstancePrefix(tasksProperties);
        this.tasks.add(ConfigXmlGeneratorUtils.createChangeInstancePropsTask(instancePrefix, tasksProperties));
        this.tasks.add(ConfigXmlGeneratorUtils.createElementInfoTask(instancePrefix + "00", tasksProperties));
        this.tasks.add(ConfigXmlGeneratorUtils.createElementInfoTask("server." + instancePrefix, tasksProperties));
    }

    private void checkConfigParameters() throws ConfigTaskXmlGenerationException {
        if (this.configProperties == null || ((Hashtable)this.configProperties).isEmpty()) {
            throw new ConfigTaskXmlGenerationException("No configuration properties are provided. The system could not generate the XML tasks.");
        }
        this.checkOutFileParam();
        this.checkDBParams();
        this.checkSecureStoreParams();
    }

    private void checkSecureStoreParams() {
        this.secstoreFSLib = ConfigXmlGeneratorUtils.getCanonicalPath(PropertiesUtil.getProperty(this.configProperties, "secstorefs.lib"));
        this.secstoreFSSecfile = ConfigXmlGeneratorUtils.getCanonicalPath(PropertiesUtil.getProperty(this.configProperties, "secstorefs.secfile"));
        this.secstoreFSKeyfile = ConfigXmlGeneratorUtils.getCanonicalPath(PropertiesUtil.getProperty(this.configProperties, "secstorefs.keyfile"));
        this.systemName = PropertiesUtil.getProperty(this.configProperties, "system.name");
    }

    private void checkDBParams() {
        this.dbDriverLocation = PropertiesUtil.getProperty(this.configProperties, "rdbms.driverLocation", "");
        this.dbIC = PropertiesUtil.getIntegerProperty(this.configProperties, "rdbms.initial_connections", "1");
        this.dbMC = PropertiesUtil.getIntegerProperty(this.configProperties, "rdbms.maximum_connections", "5");
        this.rdbmsConnection = PropertiesUtil.getProperty(this.configProperties, "rdbms.connection");
    }

    private void checkOutFileParam() {
        this.outFileName = PropertiesUtil.getProperty(this.configProperties, "out.file.name", "BatchConfig.xml");
        ConfigXmlGeneratorUtils.deleteFile(this.outFileName);
    }
}

