/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public final class UploadFileTask
extends Task {
    private static final String NAME = "upload.file";
    private static final String FILE_PATH_KEY = "file.path";
    private static final String CONFIGURATION_PATH_KEY = "configuration.path";
    private static final String CONFIGURATION_NAME_KEY = "configuration.name";
    private static final String ACTION_TYPE_KEY = "action.type";
    public static final String UPLOAD_FILE_ACTION = "file.upload";
    public static final String UPLOAD_FILE_PROPERTY_ACTION = "file.upload.property";
    public static final String UPLOAD_PROPERTIES_ACTION = "properties.upload";
    public static final String MERGE_PROPERTIES_ACTION = "properties.merge";
    private String filePath;
    private String configurationPath;
    private String configurationName;
    private String actionType;
    private String configurationKey;

    public UploadFileTask() {
        super(NAME);
    }

    public Task newInstance() {
        return new UploadFileTask();
    }

    public Properties getTaskProperties() {
        Properties props = new Properties();
        PropertiesUtil.setProperty(props, FILE_PATH_KEY, this.filePath);
        PropertiesUtil.setProperty(props, CONFIGURATION_PATH_KEY, this.configurationPath);
        PropertiesUtil.setProperty(props, CONFIGURATION_NAME_KEY, this.configurationName);
        PropertiesUtil.setProperty(props, ACTION_TYPE_KEY, this.actionType);
        PropertiesUtil.setProperty(props, UPLOAD_FILE_PROPERTY_ACTION, this.configurationKey);
        return props;
    }

    public void setTaskProperties(Properties taskProperties) throws Exception {
        this.setFilePath(PropertiesUtil.getProperty(taskProperties, FILE_PATH_KEY));
        this.setConfigurationPath(PropertiesUtil.getProperty(taskProperties, CONFIGURATION_PATH_KEY));
        this.setConfigurationName(PropertiesUtil.getProperty(taskProperties, CONFIGURATION_NAME_KEY));
        this.setActionType(PropertiesUtil.getProperty(taskProperties, ACTION_TYPE_KEY));
        this.setConfigurationKey(PropertiesUtil.getProperty(taskProperties, UPLOAD_FILE_PROPERTY_ACTION));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void go(ConfigurationHandler cfgHandler) {
        try {
            block19: {
                fileToUpload = new File(this.filePath);
                if (fileToUpload.exists()) break block19;
                this.fireWarningLog("UploadFileTask: Warning: File " + fileToUpload.getAbsolutePath() + " does not exist!");
                var5_4 = null;
                ** GOTO lbl47
            }
            if (this.configurationName == null) {
                this.configurationName = fileToUpload.getName();
            }
            if (this.configurationKey == null) {
                this.configurationKey = fileToUpload.getName();
            }
            fileCfg = this.obtainConfiguration(cfgHandler, this.configurationPath);
            if (this.actionType == null || this.actionType.equals("file.upload")) {
                this.uploadFile(fileCfg, fileToUpload);
            } else if (this.actionType.equals("properties.upload")) {
                this.uploadProperties(fileCfg, fileToUpload);
            } else if (this.actionType.equals("properties.merge")) {
                this.mergeProperties(fileCfg, fileToUpload);
            } else if (this.actionType.equals("file.upload.property")) {
                this.uploadFileToProperty(fileCfg, fileToUpload);
            }
            cfgHandler.commit();
            ** GOTO lbl53
        }
        catch (ConfigurationException ex) {
            this.fireCriticalLog("Error occured while connecting to database.", ex);
            var5_6 = null;
            try {
                cfgHandler.closeAllConfigurations();
                return;
            }
            catch (ConfigurationException ce) {
                this.fireWarningLog("Can't close configuration.", ce);
                return;
            }
        }
        {
            catch (Throwable var4_13) {
                var5_7 = null;
                ** try [egrp 2[TRYBLOCK] [2 : 218->227)] { 
lbl42:
                // 1 sources

                cfgHandler.closeAllConfigurations();
                throw var4_13;
lbl44:
                // 1 sources

                catch (ConfigurationException ce) {
                    this.fireWarningLog("Can't close configuration.", ce);
                }
                throw var4_13;
            }
lbl47:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [2 : 218->227)] { 
lbl48:
            // 1 sources

            cfgHandler.closeAllConfigurations();
            return;
lbl50:
            // 1 sources

            catch (ConfigurationException ce) {
                this.fireWarningLog("Can't close configuration.", ce);
            }
            return;
lbl53:
            // 1 sources

            var5_5 = null;
            try {}
            catch (ConfigurationException ce) {}
            this.fireWarningLog("Can't close configuration.", ce);
            return;
            cfgHandler.closeAllConfigurations();
            return;
        }
    }

    private Configuration obtainConfiguration(ConfigurationHandler cfgHandler, String configurationPath) throws ConfigurationException {
        Configuration fileCfg;
        try {
            fileCfg = cfgHandler.openConfiguration(configurationPath, 1);
        }
        catch (NameNotFoundException nnfe) {
            Configuration rootCfg;
            if (configurationPath.indexOf("/") == -1) {
                fileCfg = cfgHandler.createRootConfiguration(configurationPath);
            }
            String rootCfgName = configurationPath.substring(0, configurationPath.indexOf("/"));
            try {
                rootCfg = cfgHandler.openConfiguration(rootCfgName, 1);
            }
            catch (NameNotFoundException nnfe2) {
                rootCfg = cfgHandler.createRootConfiguration(rootCfgName);
            }
            fileCfg = rootCfg.createSubConfiguration(configurationPath.substring(configurationPath.indexOf("/") + 1));
        }
        return fileCfg;
    }

    private void uploadFile(Configuration fileCfg, File fileToUpload) throws ConfigurationException {
        try {
            fileCfg.addFileEntry(fileToUpload);
        }
        catch (NameAlreadyExistsException naee) {
            fileCfg.updateFile(fileToUpload);
        }
        this.fireInfoLog("File " + this.filePath + " successfully uploaded on " + this.configurationPath + ".");
    }

    private void uploadProperties(Configuration fileCfg, File fileToUpload) throws ConfigurationException {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(fileToUpload));
            if (fileCfg.existsSubConfiguration(this.configurationName)) {
                fileCfg.deleteSubConfigurations(new String[]{this.configurationName});
            }
            Configuration newCfg = fileCfg.createSubConfiguration(this.configurationName, 1);
            newCfg.getPropertySheetInterface().createPropertyEntries(props);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.fireInfoLog("Property sheet " + this.configurationName + " successfully uploaded on " + this.configurationPath + ".");
    }

    /*
     * Unable to fully structure code
     */
    private void mergeProperties(Configuration fileCfg, File fileToUpload) throws ConfigurationException {
        block7: {
            props = new Properties();
            try {
                props.load(new FileInputStream(fileToUpload));
                try {
                    newCfg = fileCfg.createSubConfiguration(this.configurationName, 1);
                    newCfg.addConfigEntries((Map)props);
                    break block7;
                }
                catch (NameAlreadyExistsException naae) {
                    newCfg = fileCfg.getSubConfiguration(this.configurationName);
                    propSheet = newCfg.getPropertySheetInterface();
                    keys = props.keys();
                    ** while (keys.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    key = (String)keys.nextElement();
                    newValue = props.getProperty(key);
                    try {
                        oldEntry = propSheet.getPropertyEntry(key);
                        oldValue = (String)oldEntry.getValue();
                        if (oldValue.equals(newValue)) continue;
                        oldEntry.setValue((Object)newValue);
                    }
                    catch (NameNotFoundException nnfe) {
                        propSheet.createPropertyEntry(key, (Object)newValue, newValue);
                    }
                    continue;
lbl25:
                    // 1 sources

                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.fireInfoLog("Property sheet " + this.configurationName + " successfully merged on " + this.configurationPath + ".");
    }

    /*
     * Loose catch block
     */
    private void uploadFileToProperty(Configuration fileCfg, File fileToUpload) throws ConfigurationException {
        block11: {
            String fileContent = null;
            try {
                FileReader inStream = new FileReader(fileToUpload);
                StringBuffer buffer = new StringBuffer();
                int ch = -1;
                while ((ch = inStream.read()) != -1) {
                    buffer.append((char)ch);
                }
                fileContent = buffer.toString();
            }
            catch (IOException e) {
                this.fireWarningLog("Error reading file '" + fileToUpload + "'", e);
                return;
            }
            Configuration newCfg = null;
            newCfg = fileCfg.createSubConfiguration(this.configurationName, 1);
            Object var8_9 = null;
            PropertySheet propSheet = newCfg.getPropertySheetInterface();
            try {
                propSheet.createSecurePropertyEntry(this.configurationKey, (Object)fileContent, "");
            }
            catch (NameAlreadyExistsException naae2) {
                propSheet.getPropertyEntry(this.configurationKey).setValue((Object)fileContent);
            }
            break block11;
            {
                catch (NameAlreadyExistsException naae) {
                    newCfg = fileCfg.getSubConfiguration(this.configurationName);
                    Object var8_10 = null;
                    propSheet = newCfg.getPropertySheetInterface();
                    try {
                        propSheet.createSecurePropertyEntry(this.configurationKey, (Object)fileContent, "");
                    }
                    catch (NameAlreadyExistsException naae2) {
                        propSheet.getPropertyEntry(this.configurationKey).setValue((Object)fileContent);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                propSheet = newCfg.getPropertySheetInterface();
                try {
                    propSheet.createSecurePropertyEntry(this.configurationKey, (Object)fileContent, "");
                }
                catch (NameAlreadyExistsException naae2) {
                    propSheet.getPropertyEntry(this.configurationKey).setValue((Object)fileContent);
                }
                throw throwable;
            }
        }
        this.fireInfoLog("Property sheet " + this.configurationName + " successfully secured on " + this.configurationPath + ".");
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String getConfigurationKey() {
        return this.configurationKey;
    }

    public void setConfigurationKey(String configurationKey) {
        this.configurationKey = configurationKey;
    }
}

