/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.batch.task.TasksThreadListener;
import com.sap.engine.configtool.log.LogListener;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import java.util.ArrayList;

public class TasksThread
extends Thread {
    private ArrayList tasks;
    private ConfigurationHandler cfgHandler;
    private TasksThreadListener threadListener;
    private ArrayList logListeners;

    public TasksThread(ArrayList tasks, ConfigurationHandler cfgHandler, TasksThreadListener threadListener) {
        this.tasks = tasks;
        this.cfgHandler = cfgHandler;
        this.threadListener = threadListener;
        this.logListeners = new ArrayList(11);
    }

    public void addLogListener(LogListener logListener) {
        this.logListeners.add(logListener);
    }

    public void run() {
        int i = 0;
        while (i < this.tasks.size()) {
            Task task = (Task)this.tasks.get(i);
            task.setLogListeners(this.logListeners);
            task.go(this.cfgHandler);
            ++i;
        }
        this.threadListener.finished();
    }

    public void interrupt() {
        super.interrupt();
        this.threadListener.finished();
    }
}

