/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.Manager;
import com.sap.engine.configtool.Property;
import com.sap.engine.configtool.PropertyMap;
import com.sap.engine.configtool.Service;
import com.sap.engine.configtool.lib.ConfigurationUtil;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;

public final class TaskUtil {
    public static Properties getInstanceProperties(ConfigurationHandler cfgHandler, String instancePrefix) throws ConfigurationException, IllegalArgumentException {
        if (instancePrefix == null) {
            throw new IllegalArgumentException("instancePrefix is null");
        }
        String instancePropsConfigPath = "cluster_data/instance.properties." + instancePrefix;
        Configuration instancePropsConfig = cfgHandler.openConfiguration(instancePropsConfigPath, 0);
        Properties result = instancePropsConfig.getPropertySheetInterface().getProperties();
        cfgHandler.closeConfiguration(instancePropsConfig);
        return result;
    }

    public static String getElementType(String elementName, ConfigurationHandler cfgHandler) throws ConfigurationException, IllegalArgumentException {
        String result;
        if (elementName == null) {
            throw new IllegalArgumentException("elementName is null");
        }
        if (elementName.equals("dispatcher")) {
            result = "dispatcher";
        } else if (elementName.startsWith("server")) {
            result = "server";
        } else {
            Configuration rootCfg = cfgHandler.openConfiguration("cluster_data", 0);
            if (rootCfg.getSubConfiguration("dispatcher").existsSubConfiguration(elementName)) {
                result = "dispatcher";
            } else if (rootCfg.getSubConfiguration("server").existsSubConfiguration(elementName)) {
                result = "server";
            } else {
                throw new ConfigurationException("elementName: " + elementName + " not found");
            }
            cfgHandler.closeConfiguration(rootCfg);
        }
        return result;
    }

    public static Properties getElementInfo(String elementName, ConfigurationHandler cfgHandler) throws IllegalArgumentException, ConfigurationException {
        Properties localElementInfo = TaskUtil.getLocalElementInfo(elementName, TaskUtil.getElementType(elementName, cfgHandler), cfgHandler);
        if ("server".equals(elementName)) {
            Properties instanceElementInfo = TaskUtil.getInstanceElementInfo(TaskUtil.getInstanceName(elementName), cfgHandler);
            return PropertiesUtil.mergeProperties(instanceElementInfo, localElementInfo);
        }
        return localElementInfo;
    }

    public static String getInstanceName(String elementName) {
        return elementName.substring(0, elementName.length() - 2);
    }

    public static Properties getInstanceElementInfo(String instanceName, ConfigurationHandler cfgHandler) throws ConfigurationException, ConfigurationLockedException {
        String globalElementInfoPath = TaskUtil.getGlobalElementConfigurationPath("server") + "/" + "element-info" + '.' + instanceName;
        Configuration globalElementInfoCfg = cfgHandler.openConfiguration(globalElementInfoPath, 0);
        Properties elementInfo = ConfigurationUtil.getProperties(globalElementInfoCfg);
        cfgHandler.closeConfiguration(globalElementInfoCfg);
        return elementInfo;
    }

    public static Properties getLocalElementInfo(String elementName, String elementType, ConfigurationHandler cfgHandler) throws ConfigurationException, ConfigurationLockedException {
        String elementInfoPath = TaskUtil.getElementConfigurationPath(elementName, elementType) + "/" + "element-info";
        Configuration elementInfoCfg = cfgHandler.openConfiguration(elementInfoPath, 0);
        Properties elementInfo = ConfigurationUtil.getProperties(elementInfoCfg);
        cfgHandler.closeConfiguration(elementInfoCfg);
        return elementInfo;
    }

    public static String getGlobalElementConfigurationPath(String elementType) throws IllegalArgumentException {
        String result;
        if (elementType.equals("dispatcher")) {
            result = TaskUtil.getElementConfigurationPath("dispatcher", elementType);
        } else if (elementType.equals("server")) {
            result = TaskUtil.getElementConfigurationPath("server", elementType);
        } else {
            throw new IllegalArgumentException("elementType: " + elementType + " unknown.");
        }
        return result;
    }

    public static String getElementConfigurationPath(String elementName, ConfigurationHandler cfgHandler) throws IllegalArgumentException, ConfigurationException {
        return TaskUtil.getElementConfigurationPath(elementName, TaskUtil.getElementType(elementName, cfgHandler));
    }

    public static String getElementConfigurationPath(String elementName, String elementType) throws IllegalArgumentException {
        String result;
        if (elementName == null) {
            throw new IllegalArgumentException("elementName is null");
        }
        if (elementName.equals("dispatcher")) {
            result = "cluster_data/dispatcher/cfg";
        } else if (elementName.startsWith("server")) {
            result = "cluster_data/server/cfg";
        } else {
            if (elementType == null) {
                throw new IllegalArgumentException("elementType is null");
            }
            if (elementType.equals("dispatcher")) {
                result = "cluster_data/dispatcher/" + elementName;
            } else if (elementType.equals("server")) {
                result = "cluster_data/server/" + elementName;
            } else {
                throw new IllegalArgumentException("elementType: " + elementName + " undefined");
            }
        }
        return result;
    }

    public static void setPropertyEntryValue(PropertySheet sheet, String key, String value) throws ConfigurationException {
        if (value != null) {
            TaskUtil.setPropertyEntry(sheet, new Property(key, value));
        }
    }

    public static void setPropertyEntryValue(PropertySheet sheet, String key, String value, String description) throws ConfigurationException {
        if (value != null) {
            TaskUtil.setPropertyEntry(sheet, new Property(key, value, value, description, false));
        }
    }

    private static void setPropertyEntry(PropertySheet sheet, Property property) throws ConfigurationException {
        String key = property.getName();
        String customValue = property.getCustomValue();
        String defaultValue = property.getDefaultValue();
        boolean isSecure = property.isSecure();
        String description = property.getDescription();
        if (description == null) {
            description = "";
        }
        if (property.isActionDelete()) {
            try {
                sheet.deletePropertyEntry(key);
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        if (defaultValue == null) {
            return;
        }
        PropertyEntry entry = null;
        try {
            entry = sheet.getPropertyEntry(key);
        }
        catch (NameNotFoundException nnfe) {
            entry = ConfigurationUtil.createPropertyEntry(sheet, key, defaultValue, description, isSecure);
        }
        if (property.isActionRestoreDefault()) {
            entry.restoreDefault();
        } else if (customValue != null) {
            entry.setValue((Object)customValue);
        } else if (defaultValue != null) {
            entry.setDefault((Object)defaultValue);
        }
    }

    public static void setPropertyBooleanValue(PropertySheet sheet, String key, Boolean value, String yesValue, boolean isDefault) throws ConfigurationException {
        if (value != null) {
            if (isDefault) {
                TaskUtil.setPropertyDefaultValue(sheet, key, value != false ? yesValue : "no");
            } else {
                TaskUtil.setPropertyCustomValues(sheet, key, value != false ? yesValue : "no");
            }
        }
    }

    public static void setPropertyIntegerValue(PropertySheet sheet, String key, Integer value, boolean isDefault) throws ConfigurationException {
        if (value != null) {
            if (isDefault) {
                TaskUtil.setPropertyDefaultValue(sheet, key, value.toString());
            } else {
                TaskUtil.setPropertyCustomValues(sheet, key, value.toString());
            }
        }
    }

    public static void setPropertyValue(PropertySheet sheet, String key, String value, boolean isDefault) throws ConfigurationException {
        if (value != null) {
            if (isDefault) {
                TaskUtil.setPropertyDefaultValue(sheet, key, value);
            } else {
                TaskUtil.setPropertyCustomValues(sheet, key, value);
            }
        }
    }

    public static void setPropertyDefaultValue(PropertySheet sheet, String key, String value) throws ConfigurationException {
        TaskUtil.setPropertyValues(sheet, key, true, value, false, null);
    }

    public static void setPropertyCustomValues(PropertySheet sheet, String key, String value) throws ConfigurationException {
        TaskUtil.setPropertyValues(sheet, key, false, null, true, value);
    }

    private static void setPropertyValues(PropertySheet sheet, String key, boolean isDefault, String defaultValue, boolean isCustom, String customValue) throws ConfigurationException {
        PropertyEntry entry = null;
        try {
            entry = sheet.getPropertyEntry(key);
            if (isDefault) {
                entry.setDefault((Object)defaultValue);
            }
        }
        catch (NameNotFoundException e) {
            String value = isDefault ? defaultValue : customValue;
            entry = sheet.createPropertyEntry(key, (Object)value, "");
        }
        if (isCustom) {
            entry.setValue((Object)customValue);
        }
    }

    public static void setPropertyEntryIntegerValue(PropertySheet sheet, String key, Integer value) throws ConfigurationException {
        TaskUtil.setPropertyEntryIntegerValue(sheet, key, value, "");
    }

    public static void setPropertyEntryIntegerValue(PropertySheet sheet, String key, Integer value, String description) throws ConfigurationException {
        if (value != null) {
            TaskUtil.setPropertyEntryValue(sheet, key, value.toString(), description);
        }
    }

    public static void setPropertyEntryBooleanValue(PropertySheet sheet, String key, Boolean value, String cfgYesValue) throws ConfigurationException {
        TaskUtil.setPropertyEntryBooleanValue(sheet, key, value, cfgYesValue, "");
    }

    public static void setPropertyEntryBooleanValue(PropertySheet sheet, String key, Boolean value, String cfgYesValue, String description) throws ConfigurationException {
        if (value != null) {
            TaskUtil.setPropertyEntryBooleanValue(sheet, key, (boolean)value, cfgYesValue, description);
        }
    }

    public static void setPropertyEntryBooleanValue(PropertySheet sheet, String key, boolean value, String cfgYesValue, String description) throws ConfigurationException {
        TaskUtil.setPropertyEntryValue(sheet, key, value ? cfgYesValue : "no", description);
    }

    public static void changeProperties(ConfigurationHandler cfgHandler, String elementPath, String sheetPath, String sheetName, PropertyMap entries) throws ConfigurationException {
        if (entries != null && entries.size() != 0) {
            Configuration elementCfg = cfgHandler.openConfiguration(elementPath, 1);
            Configuration sheetPathCfg = elementCfg.existsSubConfiguration(sheetPath) ? elementCfg.getSubConfiguration(sheetPath) : elementCfg.createSubConfiguration(sheetPath);
            Configuration sheetCfg = sheetPathCfg.existsSubConfiguration(sheetName) ? sheetPathCfg.getSubConfiguration(sheetName) : sheetPathCfg.createSubConfiguration(sheetName, 1);
            PropertySheet sheet = sheetCfg.getPropertySheetInterface();
            Iterator keys = entries.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Property entry = (Property)entries.get(key);
                TaskUtil.setPropertyEntry(sheet, entry);
            }
            if (sheet.getAllPropertyEntries().length == 0) {
                sheetCfg.deleteConfiguration();
            }
            cfgHandler.commit();
            cfgHandler.closeConfiguration(elementCfg);
        }
    }

    public static void setManagerDefaultPropertyEntry(ConfigurationHandler cfgHandler, PropertySheet sheet, String elementType, Manager manager, String propertyName, String propertyValue) throws ConfigurationException {
        if (propertyValue != null) {
            boolean isSecure = TaskUtil.isSecureGlobalManagerProperty(cfgHandler, elementType, manager.getName(), propertyName);
            try {
                PropertyEntry entry = sheet.getPropertyEntry(propertyName);
                entry.setDefault((Object)propertyValue);
            }
            catch (NameNotFoundException nnfe) {
                ConfigurationUtil.createPropertyEntry(sheet, propertyName, propertyValue, "", isSecure);
            }
            manager.getProperties().put(new Property(propertyName, propertyValue, isSecure));
        }
    }

    public static void setServiceDefaultPropertyEntry(ConfigurationHandler cfgHandler, PropertySheet sheet, String elementType, Service service, String propertyName, String propertyValue) throws ConfigurationException {
        if (propertyValue != null) {
            boolean isSecure = TaskUtil.isSecureGlobalServiceProperty(cfgHandler, elementType, service.getName(), propertyName);
            try {
                PropertyEntry entry = sheet.getPropertyEntry(propertyName);
                entry.setDefault((Object)propertyValue);
            }
            catch (NameNotFoundException nnfe) {
                ConfigurationUtil.createPropertyEntry(sheet, propertyName, propertyValue, "", isSecure);
            }
            service.getProperties().put(new Property(propertyName, propertyValue, isSecure));
        }
    }

    public static boolean isSecureGlobalManagerProperty(ConfigurationHandler cfgHandler, String elementType, String managerName, String propertyEntryName) throws ConfigurationException {
        String globalElementPath = TaskUtil.getGlobalElementConfigurationPath(elementType);
        String path = globalElementPath + "/" + "kernel" + "/" + managerName;
        return ConfigurationUtil.isSecureProperty(cfgHandler, path, propertyEntryName);
    }

    public static boolean isSecureGlobalServiceProperty(ConfigurationHandler cfgHandler, String elementType, String serviceName, String propertyEntryName) throws ConfigurationException {
        String globalElementPath = TaskUtil.getGlobalElementConfigurationPath(elementType);
        String path = globalElementPath + "/" + "services" + "/" + serviceName;
        return ConfigurationUtil.isSecureProperty(cfgHandler, path, propertyEntryName);
    }

    public static void deleteFile(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    TaskUtil.deleteFile(files[i]);
                    ++i;
                }
            }
            file.delete();
        }
    }
}

