/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.batch.task.TaskUtil;
import com.sap.engine.configtool.lib.PortsCalculator;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public final class RemoveElementsTask
extends Task {
    public static final String NAME = "remove.elements";
    private static final String SID_KEY = "system.id";
    private static final String BN_KEY = "box.number";
    private static final String INSTALL_DIR_KEY = "install.dir";
    private Integer sid;
    private String boxNumber;
    private String installDir;

    public RemoveElementsTask() {
        super(NAME);
    }

    public Task newInstance() {
        return new RemoveElementsTask();
    }

    public Properties getTaskProperties() {
        Properties props = new Properties();
        PropertiesUtil.setIntegerProperty(props, SID_KEY, this.sid);
        PropertiesUtil.setProperty(props, BN_KEY, this.boxNumber);
        PropertiesUtil.setProperty(props, INSTALL_DIR_KEY, this.installDir);
        return props;
    }

    public void setTaskProperties(Properties taskProperties) throws Exception {
        this.setSid(PropertiesUtil.getIntegerProperty(taskProperties, SID_KEY));
        this.setBoxNumber(PropertiesUtil.getProperty(taskProperties, BN_KEY));
        this.setInstallDir(PropertiesUtil.getProperty(taskProperties, INSTALL_DIR_KEY));
    }

    public void go(ConfigurationHandler cfgHandler) {
        try {
            String prefix = new PortsCalculator(this.sid, this.boxNumber, "dispatcher").getElementIdPrefix();
            this.removeElements(cfgHandler, prefix);
        }
        catch (ConfigurationException ce) {
            this.fireCriticalLog("Error occurred while working with Configuraition.", ce);
        }
    }

    private void removeElements(ConfigurationHandler cfgHandler, String prefix) throws ConfigurationException {
        Configuration rootCfg = cfgHandler.openConfiguration("cluster_data", 1);
        Configuration dispatchers = rootCfg.getSubConfiguration("dispatcher");
        String[] allDisps = dispatchers.getAllSubConfigurationNames();
        int i = 0;
        while (i < allDisps.length) {
            if (allDisps[i].startsWith(prefix)) {
                dispatchers.deleteConfiguration(allDisps[i]);
                try {
                    this.removeFromFileSystem("dispatcher", allDisps[i]);
                }
                catch (IOException ioe) {
                    this.fireWarningLog("Error occurred while removing dispatcher from FS.", ioe);
                }
            }
            ++i;
        }
        Configuration servers = rootCfg.getSubConfiguration("server");
        String[] allServers = servers.getAllSubConfigurationNames();
        int i2 = 0;
        while (i2 < allServers.length) {
            if (allServers[i2].startsWith(prefix)) {
                servers.deleteConfiguration(allServers[i2]);
                try {
                    this.removeFromFileSystem("server", allServers[i2]);
                }
                catch (IOException ioe) {
                    this.fireWarningLog("Error occurred while removing server from FS.", ioe);
                }
            }
            ++i2;
        }
        String instancePropsName = "instance.properties." + prefix;
        if (rootCfg.existsSubConfiguration(instancePropsName)) {
            rootCfg.deleteConfiguration(instancePropsName);
        }
        cfgHandler.commit();
        cfgHandler.closeConfiguration(rootCfg);
    }

    private void removeFromFileSystem(String elementType, String elementId) throws IOException {
        String elementDir = this.installDir + "cluster" + File.separator;
        elementDir = elementType.equals("dispatcher") ? elementDir + "dispatcher" : elementDir + "server" + (Integer.parseInt(elementId.substring(elementId.length() - 2)) - 50);
        TaskUtil.deleteFile(new File(elementDir));
    }

    public Integer getSid() {
        return this.sid;
    }

    public void setSid(Integer sid) {
        if (sid == null) {
            throw new IllegalArgumentException("Error occurred while reading system.id");
        }
        this.sid = sid;
    }

    public String getBoxNumber() {
        return this.boxNumber;
    }

    public void setBoxNumber(String boxNumber) {
        if (boxNumber == null) {
            throw new IllegalArgumentException("Error occurred while reading box.number");
        }
        this.boxNumber = boxNumber;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(String installDir) {
        if (installDir == null) {
            throw new IllegalArgumentException("Error occurred while reading install.dir");
        }
        installDir = installDir.replace('\\', File.separatorChar);
        if (!(installDir = installDir.replace('/', File.separatorChar)).endsWith(File.separator)) {
            installDir = installDir + File.separator;
        }
        this.installDir = installDir;
    }
}

