/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.batch.task.TaskUtil;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import java.util.Properties;

public final class RemoveElementTask
extends Task {
    public static final String NAME = "remove.element";
    private static final String ELEMENT_ID_KEY = "element.id";
    private static final String ELEMENT_TYPE_KEY = "element.type";
    private String elementId;
    private String elementType;

    public RemoveElementTask() {
        super(NAME);
    }

    public Task newInstance() {
        return new RemoveElementTask();
    }

    public Properties getTaskProperties() {
        Properties props = new Properties();
        PropertiesUtil.setProperty(props, ELEMENT_ID_KEY, this.elementId);
        PropertiesUtil.setProperty(props, ELEMENT_TYPE_KEY, this.elementType);
        return props;
    }

    public void setTaskProperties(Properties taskProperties) throws Exception {
        this.setElementId(PropertiesUtil.getProperty(taskProperties, ELEMENT_ID_KEY));
        this.setElementType(PropertiesUtil.getProperty(taskProperties, ELEMENT_TYPE_KEY));
    }

    public void go(ConfigurationHandler cfgHandler) {
        try {
            String cfgName = "cluster_data/" + this.elementType + "/" + this.elementId;
            Configuration elementCfg = cfgHandler.openConfiguration(cfgName, 1);
            elementCfg.deleteConfiguration();
            cfgName = "cluster_data/instance.properties." + this.elementId.substring(0, this.elementId.length() - 2);
            Configuration instancePropsCfg = cfgHandler.openConfiguration(cfgName, 1);
            PropertySheet instanceProps = instancePropsCfg.getPropertySheetInterface();
            PropertyEntry[] entries = instanceProps.getAllPropertyEntries();
            int i = 0;
            while (i < entries.length) {
                String key = entries[i].getName();
                if (key.indexOf(this.elementId) != -1) {
                    instanceProps.deletePropertyEntry(key);
                }
                ++i;
            }
            cfgHandler.commit();
            cfgHandler.closeAllConfigurations();
            if (this.elementType.equals("server")) {
                try {
                    int fullId = Integer.parseInt(this.elementId.substring(2));
                    this.changeDispatcherR3Startup(cfgHandler, fullId);
                }
                catch (Exception exc) {
                    this.fireWarningLog("Error occurred while updating r3startup service properties.", exc);
                }
            }
            this.fireInfoLog("RemoveElementTask has finished successfully on " + this.elementId);
        }
        catch (ConfigurationException ce) {
            this.fireCriticalLog("Error occurred while working with Configuraition.", ce);
        }
    }

    private void changeDispatcherR3Startup(ConfigurationHandler cfgHandler, int fullId) {
        int dispatcherId = fullId / 100 * 100;
        Configuration dispR3StartupCfg = null;
        try {
            dispR3StartupCfg = cfgHandler.openConfiguration("cluster_data/dispatcher/ID" + String.valueOf(dispatcherId) + "/" + "services" + "/" + "r3startup", 1);
        }
        catch (ConfigurationException ce) {
            this.fireWarningLog("Error occurred while working with Configuration.", ce);
        }
        if (dispR3StartupCfg != null) {
            try {
                PropertySheet props = dispR3StartupCfg.getPropertySheetInterface();
                PropertyEntry[] entries = props.getAllPropertyEntries();
                int i = 0;
                while (i < entries.length) {
                    String value = (String)entries[i].getValue();
                    if (value.equals(String.valueOf(fullId))) {
                        int elements = Integer.parseInt((String)props.getPropertyEntry("elements").getValue());
                        TaskUtil.setPropertyEntryValue(props, "elements", "" + --elements);
                        String key = entries[i].getName();
                        String r3PropertyIndex = key.substring(8, key.lastIndexOf("_"));
                        props.deletePropertyEntry(key);
                        props.deletePropertyEntry("element_" + r3PropertyIndex + "_dir");
                        int r3PropertyIndexNumber = Integer.parseInt(r3PropertyIndex);
                        PropertyEntry oldEntry = null;
                        Object oldValue = null;
                        String oldKey = null;
                        int t = r3PropertyIndexNumber;
                        while (t < elements) {
                            oldEntry = props.getPropertyEntry("element_" + (t + 1) + "_id");
                            oldValue = oldEntry.getValue();
                            oldKey = oldEntry.getName();
                            TaskUtil.setPropertyEntryValue(props, "element_" + t + "_id", (String)oldValue);
                            props.deletePropertyEntry(oldKey);
                            oldEntry = props.getPropertyEntry("element_" + (t + 1) + "_dir");
                            oldValue = oldEntry.getValue();
                            oldKey = oldEntry.getName();
                            TaskUtil.setPropertyEntryValue(props, "element_" + t + "_dir", (String)oldValue);
                            props.deletePropertyEntry(oldKey);
                            ++t;
                        }
                        break;
                    }
                    ++i;
                }
                cfgHandler.commit();
                cfgHandler.closeConfiguration(dispR3StartupCfg);
            }
            catch (ConfigurationException ce) {
                this.fireCriticalLog("Error occurred while working with Configuration.", ce);
            }
        }
    }

    public String getElementId() {
        return this.elementId;
    }

    public void setElementId(String elementId) {
        if (!elementId.startsWith("ID")) {
            elementId = "ID" + elementId;
        }
        this.elementId = elementId;
    }

    public String getElementType() {
        return this.elementType;
    }

    public void setElementType(String elementType) {
        this.elementType = elementType;
    }
}

