/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.security.core.server.secstorefs.SecStoreFS;
import java.util.Properties;

public final class MigrateKeyPhraseTask
extends Task {
    private static final String NAME = "NewKeyPhrase.secstore";
    private static final String SAPSECFILE = "SAPSECFILE";
    private static final String SAPKEYFILE = "SAPKEYFILE";
    private static final String SAPSYSTEMNAME = "SAPSYSTEMNAME";
    private static final String KEYPHRASE = "KEYPHRASE";
    private String secStoreFilename;
    private String secStoreKeyFilename;
    private String secStoreSystemName;
    private String secStoreKeyPhrase;

    public MigrateKeyPhraseTask() {
        super(NAME);
    }

    public Task newInstance() {
        return new MigrateKeyPhraseTask();
    }

    public Properties getTaskProperties() {
        Properties taskProperties = new Properties();
        PropertiesUtil.setProperty(taskProperties, SAPSECFILE, this.secStoreFilename);
        PropertiesUtil.setProperty(taskProperties, SAPKEYFILE, this.secStoreKeyFilename);
        PropertiesUtil.setProperty(taskProperties, SAPSYSTEMNAME, this.secStoreSystemName);
        PropertiesUtil.setProperty(taskProperties, KEYPHRASE, this.secStoreKeyPhrase);
        return taskProperties;
    }

    public void setTaskProperties(Properties taskProperties) throws Exception {
        this.setSecStoreFilename(PropertiesUtil.getProperty(taskProperties, SAPSECFILE));
        this.setSecStoreKeyFilename(PropertiesUtil.getProperty(taskProperties, SAPKEYFILE));
        this.setSecStoreSystemFilename(PropertiesUtil.getProperty(taskProperties, SAPSYSTEMNAME));
        this.setSecStoreKeyPhrase(PropertiesUtil.getProperty(taskProperties, KEYPHRASE));
    }

    public void go(ConfigurationHandler cfgHandler) {
        try {
            boolean storeKeyPhraseInFile = true;
            SecStoreFS store = new SecStoreFS();
            SecStoreFS.setSID((String)this.secStoreSystemName);
            store.setFilenames(this.secStoreFilename, this.secStoreKeyFilename);
            if (!store.isEncryptionPossible()) {
                return;
            }
            store.openExistingStore();
            if (store.isEncrypted()) {
                if (!store.isKeyRequired()) {
                    return;
                }
            } else {
                return;
            }
            store.migrateEncryptionKey(this.secStoreKeyPhrase, storeKeyPhraseInFile);
            this.fireInfoLog("The migration of the key phrase of the Secure Store is performed successfully");
        }
        catch (Exception e) {
            this.fireWarningLog("An error has occurred.", e);
        }
    }

    public String getSecStoreFilename() {
        return this.secStoreFilename;
    }

    public String getSecStoreKeyFilename() {
        return this.secStoreKeyFilename;
    }

    public String getSecStoreSystemFilename() {
        return this.secStoreSystemName;
    }

    public void setSecStoreFilename(String secStoreFilename) {
        this.secStoreFilename = secStoreFilename;
    }

    public void setSecStoreKeyFilename(String secStoreKeyFilename) {
        this.secStoreKeyFilename = secStoreKeyFilename;
    }

    public void setSecStoreSystemFilename(String secStoreSystemFilename) {
        this.secStoreSystemName = secStoreSystemFilename;
    }

    public String getSecStoreKeyPhrase() {
        return this.secStoreKeyPhrase;
    }

    public void setSecStoreKeyPhrase(String secStoreKeyPhrase) {
        this.secStoreKeyPhrase = secStoreKeyPhrase;
    }
}

