/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.batch.OfflinePersistenceAdapter;
import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.PersistenceAdapter;
import com.sap.engine.services.log_configurator.admin.LogXMLParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;

public class LogConfigurationTask
extends Task {
    private static final String NAME = "change.log.configuration";
    private LogConfiguration addEditElements;
    private LogConfiguration removedElements;
    private OfflinePersistenceAdapter opa;
    private String prefix = "";

    public LogConfigurationTask() {
        super(NAME);
    }

    public LogConfigurationTask(OfflinePersistenceAdapter opa, String prefix, LogConfiguration addEditElements, LogConfiguration removedElements) {
        super(NAME);
        this.setConfigurations(opa, prefix, addEditElements, removedElements);
    }

    public Task newInstance() {
        return new LogConfigurationTask();
    }

    public Properties getTaskProperties() {
        Properties result = new Properties();
        ((Hashtable)result).put("prefix", this.prefix);
        ((Hashtable)result).put("adapter.global.path", this.opa.getGlobalPath());
        ((Hashtable)result).put("adapter.global.name", this.opa.getGlobalName());
        String path = this.opa.getLocalPath();
        if (path != null) {
            ((Hashtable)result).put("adapter.local.path", path);
        }
        if (this.isNotEmpty(this.addEditElements)) {
            ((Hashtable)result).put("add.edit.configuration", LogConfigurationTask.toString(this.addEditElements));
        }
        if (this.isNotEmpty(this.removedElements)) {
            ((Hashtable)result).put("remove.configuration", LogConfigurationTask.toString(this.removedElements));
        }
        return result;
    }

    private boolean isNotEmpty(LogConfiguration cfg) {
        return cfg.getLogControllers().length != 0 || cfg.getLogDestinations().length != 0 || cfg.getLogFormatters().length != 0;
    }

    public void setTaskProperties(Properties taskProperties) throws Exception {
        this.opa = new OfflinePersistenceAdapter(taskProperties.getProperty("adapter.global.path"), taskProperties.getProperty("adapter.global.name"), taskProperties.getProperty("adapter.local.path"));
        String prefix = taskProperties.getProperty("prefix");
        this.prefix = prefix == null ? "" : prefix;
        String addEditXML = taskProperties.getProperty("add.edit.configuration");
        this.addEditElements = addEditXML == null ? new LogConfiguration() : this.parse(addEditXML);
        String removeXML = taskProperties.getProperty("remove.configuration");
        this.removedElements = removeXML == null ? new LogConfiguration() : this.parse(removeXML);
    }

    public void addTaskProperties(Properties taskProperties) throws Exception {
        String removeXML;
        String addEditXML = taskProperties.getProperty("add.edit.configuration");
        if (addEditXML != null) {
            this.addEditElements.addLogConfiguration(this.parse(addEditXML));
        }
        if ((removeXML = taskProperties.getProperty("remove.configuration")) != null) {
            this.removedElements.addLogConfiguration(this.parse(removeXML));
        }
    }

    public void setConfigurations(OfflinePersistenceAdapter opa, String prefix, LogConfiguration addEditElements, LogConfiguration removedElements) {
        this.opa = opa;
        this.prefix = prefix == null ? "" : prefix;
        this.addEditElements = addEditElements;
        this.removedElements = removedElements;
    }

    public void go(ConfigurationHandler cfgHandler) {
        try {
            this.opa.saveConfiguration(cfgHandler, this.addEditElements, this.removedElements);
        }
        catch (ConfigurationException e) {
            this.fireWarningLog("DB error has occured when saving log configuration.", e);
        }
        catch (IOException e) {
            this.fireWarningLog("I/O error has occured when saving log configuration.", e);
        }
        this.fireInfoLog("LogConfigurationTask has finished successfully.");
    }

    public String getUniqueName() {
        return this.opa.toString();
    }

    private static String toString(LogConfiguration cfg) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LogXMLParser.writeToXml((OutputStream)out, (LogConfiguration)cfg);
        return out.toString();
    }

    private LogConfiguration parse(String str) {
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
        return new LogXMLParser().parse((InputStream)in, (PersistenceAdapter)this.opa, this.prefix);
    }
}

