/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.ClusterData;
import com.sap.engine.configtool.ClusterElement;
import com.sap.engine.configtool.Instance;
import com.sap.engine.configtool.Manager;
import com.sap.engine.configtool.Property;
import com.sap.engine.configtool.PropertyMap;
import com.sap.engine.configtool.Service;
import com.sap.engine.configtool.batch.Scanner;
import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.batch.task.TaskUtil;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class InformationTask
extends Task {
    private static final String NAME = "information";
    public static final String DEFAULT_SUFFIX = ".default";
    public static final String CUSTOM_SUFFIX = ".custom";
    public static final String LOCAL_SUFFIX = ".local";
    public static final String GLOBAL_SUFFIX = ".global";
    public static final String STARTUP_MODE = "startup.mode";
    public static final String ELEMENT_NAME = "element.name";
    private static final String INFO_TYPE = "info.type";
    private static final String IT_SERVICE = "service";
    private static final String IT_MANAGER = "manager";
    private static final String IT_JVM = "jvm";
    private static final String IT_INSTANCE = "instance";
    public static final String SERVICE_NAME = "service.name";
    public static final String MANAGER_NAME = "manager.name";
    private static final String FILE_NAME = "file.name";
    private String elementName;
    private String infoType;
    private String fileName;
    private String name;

    public InformationTask() {
        super(NAME);
    }

    public Task newInstance() {
        return new InformationTask();
    }

    public Properties getTaskProperties() {
        Properties taskProperties = new Properties();
        PropertiesUtil.setProperty(taskProperties, ELEMENT_NAME, this.elementName);
        PropertiesUtil.setProperty(taskProperties, INFO_TYPE, this.infoType);
        PropertiesUtil.setProperty(taskProperties, FILE_NAME, this.fileName);
        if (IT_SERVICE.equalsIgnoreCase(this.infoType)) {
            PropertiesUtil.setProperty(taskProperties, SERVICE_NAME, this.name);
        } else if (IT_MANAGER.equalsIgnoreCase(this.infoType)) {
            PropertiesUtil.setProperty(taskProperties, MANAGER_NAME, this.name);
        }
        return taskProperties;
    }

    public void setTaskProperties(Properties taskProperties) throws Exception {
        this.elementName = PropertiesUtil.getProperty(taskProperties, ELEMENT_NAME);
        this.infoType = PropertiesUtil.getProperty(taskProperties, INFO_TYPE);
        this.fileName = PropertiesUtil.getProperty(taskProperties, FILE_NAME);
        if (IT_SERVICE.equalsIgnoreCase(this.infoType)) {
            this.name = PropertiesUtil.getProperty(taskProperties, SERVICE_NAME);
        } else if (IT_MANAGER.equalsIgnoreCase(this.infoType)) {
            this.name = PropertiesUtil.getProperty(taskProperties, MANAGER_NAME);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void go(ConfigurationHandler cfgHandler) {
        block17: {
            out /* !! */  = null;
            try {
                block16: {
                    if (this.fileName != null) {
                        this.fileName = this.fileName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
                        pos = this.fileName.lastIndexOf(File.separatorChar);
                        path = pos != -1 ? this.fileName.substring(0, this.fileName.lastIndexOf(File.separatorChar)) : this.fileName;
                        new File(path).mkdirs();
                        out /* !! */  = new FileOutputStream(this.fileName);
                    } else {
                        out /* !! */  = System.out;
                    }
                    clusterData = new Scanner(cfgHandler).scan();
                    if ("service".equalsIgnoreCase(this.infoType)) {
                        this.getServiceInfo(clusterData, out /* !! */ );
                        break block16;
                    }
                    if ("manager".equalsIgnoreCase(this.infoType)) {
                        this.getManagerInfo(clusterData, out /* !! */ );
                        break block16;
                    }
                    if ("jvm".equalsIgnoreCase(this.infoType)) {
                        this.getElementInfo(clusterData, out /* !! */ );
                        break block16;
                    }
                    if (!"instance".equalsIgnoreCase(this.infoType)) break block16;
                    this.getInstanceProperties(clusterData, out /* !! */ );
                }
                var6_7 = null;
                ** if (this.fileName == null) goto lbl-1000
            }
            catch (Throwable var5_13) {
                var6_9 = null;
                if (this.fileName != null) {
                    try {
                        out /* !! */ .close();
                    }
                    catch (IOException e) {
                        this.fireWarningLog("I/O Error occurred while closing the output file.", e);
                    }
                }
                throw var5_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    out /* !! */ .close();
                }
                catch (IOException e) {
                    this.fireWarningLog("I/O Error occurred while closing the output file.", e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block17;
                catch (IOException e) {
                    this.fireCriticalLog("I/O Error occurred.", e);
                    var6_8 = null;
                    if (this.fileName != null) {
                        try {
                            out /* !! */ .close();
                        }
                        catch (IOException e) {
                            this.fireWarningLog("I/O Error occurred while closing the output file.", e);
                        }
                    }
                }
            }
        }
        this.fireInfoLog("InformationTask has finished successfully on " + this.elementName);
    }

    private void getServiceInfo(ClusterData clusterData, OutputStream out) throws IOException {
        Properties result = new Properties();
        Service globalService = null;
        if ("server".equalsIgnoreCase(this.elementName)) {
            globalService = (Service)clusterData.getGlobalServer().getServices().get(this.name);
        } else if ("dispatcher".equalsIgnoreCase(this.elementName)) {
            globalService = (Service)clusterData.getGlobalDispatcher().getServices().get(this.name);
        } else {
            ClusterElement clusterElement;
            Instance instance = (Instance)clusterData.getInstances().get(TaskUtil.getInstanceName(this.elementName));
            if (instance == null) {
                this.fireCriticalLog("No such cluster element.");
            }
            if ((clusterElement = (ClusterElement)instance.getInstanceElements().get(this.elementName)) == null) {
                this.fireCriticalLog("No such cluster element.");
            }
            globalService = clusterElement.getType().equals("server") ? (Service)clusterData.getGlobalServer().getServices().get(this.name) : (Service)clusterData.getGlobalDispatcher().getServices().get(this.name);
            Service localService = (Service)clusterElement.getServices().get(this.name);
            if (globalService == null) {
                this.fireCriticalLog("No such service.");
            }
            PropertyMap localProps = localService.getProperties();
            this.addPropertiesFromMap(localProps, result, LOCAL_SUFFIX);
            result.setProperty("startup.mode.local", localService.getStartupMode());
        }
        if (globalService == null) {
            this.fireCriticalLog("No such service.");
        }
        PropertyMap globalProps = globalService.getProperties();
        this.addPropertiesFromMap(globalProps, result, GLOBAL_SUFFIX);
        result.setProperty("startup.mode.global", globalService.getStartupMode());
        result.setProperty(ELEMENT_NAME, this.elementName);
        result.setProperty(SERVICE_NAME, this.name);
        result.store(out, "These are properties for '" + this.name + "' service on cluster element '" + this.elementName + "' loaded via InformationTask");
    }

    private void getManagerInfo(ClusterData clusterData, OutputStream out) throws IOException {
        Properties result = new Properties();
        Manager globalManager = null;
        if ("server".equalsIgnoreCase(this.elementName)) {
            globalManager = (Manager)clusterData.getGlobalServer().getManagers().get(this.name);
        } else if ("dispatcher".equalsIgnoreCase(this.elementName)) {
            globalManager = (Manager)clusterData.getGlobalDispatcher().getManagers().get(this.name);
        } else {
            ClusterElement clusterElement;
            Instance instance = (Instance)clusterData.getInstances().get(TaskUtil.getInstanceName(this.elementName));
            if (instance == null) {
                this.fireCriticalLog("No such cluster element.");
            }
            if ((clusterElement = (ClusterElement)instance.getInstanceElements().get(this.elementName)) == null) {
                this.fireCriticalLog("No such cluster element.");
            }
            globalManager = clusterElement.getType().equals("server") ? (Manager)clusterData.getGlobalServer().getManagers().get(this.name) : (Manager)clusterData.getGlobalDispatcher().getManagers().get(this.name);
            Manager localManager = (Manager)clusterElement.getManagers().get(this.name);
            if (localManager == null) {
                this.fireCriticalLog("No such manager.");
            }
            PropertyMap localProps = localManager.getProperties();
            this.addPropertiesFromMap(localProps, result, LOCAL_SUFFIX);
        }
        if (globalManager == null) {
            this.fireCriticalLog("No such manager.");
        }
        PropertyMap globalProps = globalManager.getProperties();
        this.addPropertiesFromMap(globalProps, result, GLOBAL_SUFFIX);
        result.setProperty(ELEMENT_NAME, this.elementName);
        result.setProperty(MANAGER_NAME, this.name);
        result.store(out, "These are properties for '" + this.name + "' manager on cluster element '" + this.elementName + "' loaded via InformationTask");
    }

    private void addPropertiesFromMap(PropertyMap source, Properties destination, String suffix) {
        Iterator keys = source.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Property value = (Property)source.get(key);
            String customValue = value.getCustomValue();
            String defaultValue = value.getDefaultValue();
            if (customValue != null) {
                destination.setProperty(key + suffix + CUSTOM_SUFFIX, customValue);
            }
            if (defaultValue == null) continue;
            destination.setProperty(key + suffix + DEFAULT_SUFFIX, defaultValue);
        }
    }

    private void getElementInfo(ClusterData clusterData, OutputStream out) throws IOException {
        Properties result = new Properties();
        Instance instance = (Instance)clusterData.getInstances().get(this.elementName);
        if (instance != null) {
            Properties elementInfo = instance.getElementInfo();
            this.addPropertiesFromProperties(elementInfo, result, GLOBAL_SUFFIX);
        } else {
            ClusterElement clusterElement;
            instance = (Instance)clusterData.getInstances().get(TaskUtil.getInstanceName(this.elementName));
            if (instance == null) {
                this.fireCriticalLog("No such element.");
            }
            if ((clusterElement = (ClusterElement)instance.getInstanceElements().get(this.elementName)) == null) {
                this.fireCriticalLog("No such element.");
            }
            if (clusterElement.getType().equals("server")) {
                Properties globalElementInfo = instance.getElementInfo();
                this.addPropertiesFromProperties(globalElementInfo, result, GLOBAL_SUFFIX);
            }
            Properties localElementInfo = clusterElement.getElementInfo();
            this.addPropertiesFromProperties(localElementInfo, result, LOCAL_SUFFIX);
        }
        result.setProperty(ELEMENT_NAME, this.elementName);
        result.store(out, "These are element info properties for '" + this.elementName + "' loaded via InformationTask");
    }

    private void addPropertiesFromProperties(Properties source, Properties destination, String suffix) {
        Iterator keys = ((Hashtable)source).keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            destination.setProperty(key + suffix, source.getProperty(key));
        }
    }

    private void getInstanceProperties(ClusterData clusterData, OutputStream out) throws IOException {
        Instance instance = (Instance)clusterData.getInstances().get(this.elementName);
        if (instance == null) {
            this.fireCriticalLog("No such instance.");
        }
        Properties instanceProperties = instance.getInstanceProperties();
        instanceProperties.store(out, "These are instance properties for instance '" + this.elementName + "' loaded via InformationTask");
    }
}

