/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.batch.task.TaskUtil;
import com.sap.engine.configtool.lib.ConfigurationUtil;
import com.sap.engine.configtool.lib.PortsCalculator;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class GenerateBootstrapTask
extends Task {
    private static final String DIR_BOOTSTRAP = "bootstrap";
    private static final String FILE_BOOTSTRAP = "bootstrap.properties";
    private static final String BS_INSTALL_DIR = "install.dir";
    private static final String BS_RESYNCH = "element.resynch";
    private static final String BS_RESYNCH_VALUE = "detect";
    private static final String BS_INSTANCE_PREFIX = "instance.prefix";
    private static final String NAME = "generate.bootstrap";
    private static final String SID_KEY = "system.id";
    private static final String BN_KEY = "box.number";
    private static final String INSTALL_DIR_KEY = "install.dir";
    private static final String DB_DRIVER_LOCATION = "rdbms.driverLocation";
    private static final String DB_URL = "rdbms.url";
    private static final String DB_USER = "rdbms.user";
    private static final String DB_PASSWORD = "rdbms.password";
    private static final String DB_IC = "rdbms.initial_connections";
    private static final String DB_MC = "rdbms.maximum_connections";
    private static final String SECSTORE_FS_LIB = "secstorefs.lib";
    private static final String SECSTORE_FS_SEC_FILE = "secstorefs.secfile";
    private static final String SECSTORE_FS_KEY_FILE = "secstorefs.keyfile";
    private static final String RDBMS_CONNECTION = "rdbms.connection";
    private static final String SYSTEM_NAME = "system.name";
    private static final String JAVA_PARAMS_KEY = "java.params";
    private Integer sid;
    private String bn;
    private String installDir;
    private String dbDriverLocation;
    private String dbUrl;
    private String dbUser;
    private String dbPassword;
    private Integer dbIC;
    private Integer dbMC;
    private String secstoreFSLib;
    private String secstoreFSSecfile;
    private String secstoreFSKeyfile;
    private String rdbmsConnection;
    private String sysName;
    private String javaParams;

    public GenerateBootstrapTask() {
        super(NAME);
    }

    public Task newInstance() {
        return new GenerateBootstrapTask();
    }

    public Properties getTaskProperties() {
        Properties taskProperties = new Properties();
        PropertiesUtil.setIntegerProperty(taskProperties, SID_KEY, this.sid);
        PropertiesUtil.setProperty(taskProperties, BN_KEY, this.bn);
        PropertiesUtil.setProperty(taskProperties, "install.dir", this.installDir);
        PropertiesUtil.setProperty(taskProperties, DB_DRIVER_LOCATION, this.dbDriverLocation);
        PropertiesUtil.setProperty(taskProperties, DB_URL, this.dbUrl);
        PropertiesUtil.setProperty(taskProperties, DB_USER, this.dbUser);
        PropertiesUtil.setProperty(taskProperties, DB_PASSWORD, this.dbPassword);
        PropertiesUtil.setIntegerProperty(taskProperties, DB_IC, this.dbIC);
        PropertiesUtil.setIntegerProperty(taskProperties, DB_MC, this.dbMC);
        PropertiesUtil.setProperty(taskProperties, SECSTORE_FS_LIB, this.secstoreFSLib);
        PropertiesUtil.setProperty(taskProperties, SECSTORE_FS_SEC_FILE, this.secstoreFSSecfile);
        PropertiesUtil.setProperty(taskProperties, SECSTORE_FS_KEY_FILE, this.secstoreFSKeyfile);
        PropertiesUtil.setProperty(taskProperties, RDBMS_CONNECTION, this.rdbmsConnection);
        PropertiesUtil.setProperty(taskProperties, SYSTEM_NAME, this.sysName);
        PropertiesUtil.setProperty(taskProperties, JAVA_PARAMS_KEY, this.javaParams);
        return taskProperties;
    }

    public void setTaskProperties(Properties taskProperties) throws Exception {
        this.setSid(PropertiesUtil.getIntegerProperty(taskProperties, SID_KEY));
        this.setBn(PropertiesUtil.getProperty(taskProperties, BN_KEY));
        this.setInstallDir(PropertiesUtil.getProperty(taskProperties, "install.dir"));
        this.setDbDriverLocation(PropertiesUtil.getProperty(taskProperties, DB_DRIVER_LOCATION));
        this.setDbUrl(PropertiesUtil.getProperty(taskProperties, DB_URL));
        this.setDbUser(PropertiesUtil.getProperty(taskProperties, DB_USER));
        this.setDbPassword(PropertiesUtil.getProperty(taskProperties, DB_PASSWORD));
        this.setDbIC(PropertiesUtil.getIntegerProperty(taskProperties, DB_IC));
        this.setDbMC(PropertiesUtil.getIntegerProperty(taskProperties, DB_MC));
        this.setSecstoreFSLib(PropertiesUtil.getProperty(taskProperties, SECSTORE_FS_LIB));
        this.setSecstoreFSSecfile(PropertiesUtil.getProperty(taskProperties, SECSTORE_FS_SEC_FILE));
        this.setSecstoreFSKeyfile(PropertiesUtil.getProperty(taskProperties, SECSTORE_FS_KEY_FILE));
        this.setRdbmsConnection(PropertiesUtil.getProperty(taskProperties, RDBMS_CONNECTION));
        this.setSysName(PropertiesUtil.getProperty(taskProperties, SYSTEM_NAME));
        this.setJavaParams(PropertiesUtil.getProperty(taskProperties, JAVA_PARAMS_KEY));
    }

    public void go(ConfigurationHandler cfgHandler) {
        try {
            String clusterDir = new File(this.installDir + File.separator + "cluster").getCanonicalPath();
            String bootstrapDir = clusterDir + File.separator + DIR_BOOTSTRAP;
            new File(bootstrapDir).mkdirs();
            Configuration clusterData = cfgHandler.openConfiguration("cluster_data", 0);
            try {
                ConfigurationUtil.getFile(clusterData, ".hotspot_compiler", clusterDir);
            }
            catch (NameNotFoundException e) {
                this.fireWarningLog(".hotspot_compiler is missing in cluster_data.");
            }
            Configuration bootstrapConfig = clusterData.getSubConfiguration(DIR_BOOTSTRAP);
            Map bootstrapFiles = bootstrapConfig.getAllFileEntries();
            Iterator fileNames = bootstrapFiles.keySet().iterator();
            while (fileNames.hasNext()) {
                String fileName = (String)fileNames.next();
                ConfigurationUtil.getFile(bootstrapConfig, fileName, bootstrapDir);
            }
            PortsCalculator calculator = new PortsCalculator(this.sid, this.bn, "dispatcher");
            Properties bootStrapProperties = PropertiesUtil.getDBProperties(this.secstoreFSSecfile, this.secstoreFSKeyfile, this.sysName, this.secstoreFSLib, this.rdbmsConnection, this.dbDriverLocation, this.dbIC, this.dbMC, this.dbUrl, this.dbUser, this.dbPassword);
            bootStrapProperties.setProperty("install.dir", this.installDir);
            bootStrapProperties.setProperty(BS_INSTANCE_PREFIX, calculator.getElementIdPrefix());
            bootStrapProperties.store(new FileOutputStream(bootstrapDir + File.separator + FILE_BOOTSTRAP), "");
            cfgHandler.closeConfiguration(clusterData);
            this.changeBootstrapJVMProps(cfgHandler);
        }
        catch (IOException ioe) {
            this.fireWarningLog("Error occurred while creating bootstrap.", ioe);
        }
        catch (ConfigurationException ce) {
            this.fireCriticalLog("Error occurred while working with Configuration.", ce);
        }
    }

    private void changeBootstrapJVMProps(ConfigurationHandler cfgHandler) throws ConfigurationException {
        Configuration bootStrapJvmCfg = cfgHandler.openConfiguration("cluster_data/bootstrap/jvm", 1);
        if (bootStrapJvmCfg != null) {
            PropertySheet sheetProperties = bootStrapJvmCfg.getPropertySheetInterface();
            if (this.javaParams != null && this.javaParams.startsWith("prefix.please.ivkrasfam.")) {
                String oldJavaParams;
                this.javaParams = this.javaParams.substring("prefix.please.ivkrasfam.".length());
                Properties bootstrapJVMProps = sheetProperties.getProperties();
                if (bootstrapJVMProps != null && (oldJavaParams = bootstrapJVMProps.getProperty("java.parameters")) != null) {
                    this.javaParams = (oldJavaParams + " " + this.javaParams).trim();
                }
            }
            TaskUtil.setPropertyEntryValue(sheetProperties, "java.parameters", this.javaParams);
        }
        cfgHandler.commit();
        cfgHandler.closeConfiguration(bootStrapJvmCfg);
    }

    public Integer getSid() {
        return this.sid;
    }

    public void setSid(Integer sid) {
        if (sid == null) {
            throw new IllegalArgumentException("Error occurred while reading system.id");
        }
        this.sid = sid;
    }

    public String getBn() {
        return this.bn;
    }

    public void setBn(String bn) {
        this.bn = bn;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(String installDir) {
        if (installDir == null) {
            throw new IllegalArgumentException("Error occurred while reading install.dir");
        }
        this.installDir = installDir;
    }

    public String getDbDriverLocation() {
        return this.dbDriverLocation;
    }

    public void setDbDriverLocation(String dbDriverLocation) {
        this.dbDriverLocation = dbDriverLocation;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public Integer getDbIC() {
        return this.dbIC;
    }

    public void setDbIC(Integer dbIC) {
        this.dbIC = dbIC;
    }

    public Integer getDbMC() {
        return this.dbMC;
    }

    public void setDbMC(Integer dbMC) {
        this.dbMC = dbMC;
    }

    public void setSecstoreFSLib(String secstoreFSLib) {
        this.secstoreFSLib = secstoreFSLib;
    }

    public String getSecstoreFSLib() {
        return this.secstoreFSLib;
    }

    public void setSecstoreFSSecfile(String secstoreFSSecfile) {
        this.secstoreFSSecfile = secstoreFSSecfile;
    }

    public String getSecstoreFSSecfile() {
        return this.secstoreFSSecfile;
    }

    public void setSecstoreFSKeyfile(String secstoreFSKeyfile) {
        this.secstoreFSKeyfile = secstoreFSKeyfile;
    }

    public String getSecstoreFSKeyfile() {
        return this.secstoreFSKeyfile;
    }

    public void setRdbmsConnection(String rdbmsConnection) {
        this.rdbmsConnection = rdbmsConnection;
    }

    public String getRdbmsConnection() {
        return this.rdbmsConnection;
    }

    public void setSysName(String sysName) {
        this.sysName = sysName;
    }

    public String getSysName() {
        return this.sysName;
    }

    public String getJavaParams() {
        return this.javaParams;
    }

    public void setJavaParams(String javaParams) {
        this.javaParams = javaParams;
    }

    public void setAdditionalJavaParams(String additionalJavaParams) {
        if (additionalJavaParams != null && additionalJavaParams.trim().length() != 0) {
            this.javaParams = "prefix.please.ivkrasfam." + additionalJavaParams;
        }
    }
}

