/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.lib.PortsCalculator;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class FSTask
extends Task {
    private static final String DIR_OSLIBS = "os_libs";
    private static final String DIR_ADMIN = "admin";
    private static final String ADMIN_CFG_FILENAME = "adminCFG.properties";
    private static final String ADMIN_CFG_USER = "admin.user";
    private static final String ADMIN_CFG_LOGIN_PORT = "LOGIN_PORT";
    private static final String ADMIN_CFG_HTTP_LOGIN_PORT = "LOGIN_HTTP_PORT";
    private static final String ADMIN_CFG_SSL_LOGIN_PORT = "LOGIN_SSL_PORT";
    private static final String ADMIN_CFG_CONNECTION_PORT = "connection.0.Port";
    private static final String ADMIN_CFG_CONNECTION_HOSTNAME = "connection.0.HostName";
    private static final String ADMIN_CFG_CONNECTION_LOAD_BALANCING = "connection.0.LoadBalancing";
    private static final String ADMIN_CFG_CONNECTION_USER_NAME = "connection.0.UserName";
    private static final String ADMIN_CFG_CONNECTION_LOOKUP_METHOD = "connection.0.LookupMethod";
    private static final String ADMIN_CFG_CONNECTION_DISPLAY_INDEX = "connection.0.DisplayIndex";
    private static final String ADMIN_CFG_CONNECTION_TRANSPORT_LAYER = "connection.0.TransportLayer";
    private static final String ADMIN_CFG_CONNECTION_DISPLAY_NAME = "connection.0.DisplayName";
    private static final String CFG_PATH = "cfg";
    private static final String CONFIG_TOOL_DIR = "configtool";
    private static final String CONFIG_PROPERTIES_FILENAME = "config.properties";
    private static final String NAME = "fs";
    private static final String DEPLOYING_DIRECTORY = "deploying";
    private static final String DPLOPTIONS_FILENAME = "dplOptions.options";
    private static final String REMOTE_PORT = "RemotePort";
    private static final String HTTP_TUNNELING_PORT = "Http_tunneling_port";
    private static final String SSL_PORT = "Ssl_port";
    private static final String HTTPS_PORT = "Https_port";
    private static final String RDB_FILENAME = "rdb.properties";
    private static final String DIR_TO_CLUSTER = "DIR_TO_CLUSTER";
    private static final String INSTALL_DIR_KEY = "install.dir";
    private static final String SID_KEY = "system.id";
    private static final String BN_KEY = "box.number";
    private static final String RDBMS_URL = "rdbms.url";
    private static final String RDBMS_DRIVERLOCATION = "rdbms.driverLocation";
    private static final String RDBMS_USER = "rdbms.user";
    private static final String RDBMS_INITIAL_CONNECTIONS = "rdbms.initial_connections";
    private static final String RDBMS_MAXIMUM_CONNECTIONS = "rdbms.maximum_connections";
    private static final String SECSTORE_FS_LIB = "secstorefs.lib";
    private static final String SECSTORE_FS_SEC_FILE = "secstorefs.secfile";
    private static final String SECSTORE_FS_KEY_FILE = "secstorefs.keyfile";
    private static final String RDBMS_CONNECTION = "rdbms.connection";
    private static final String SYSTEM_NAME = "system.name";
    private static final String SCS_ID = "scs.id";
    private static final String MS_HOST = "ms.host";
    private String installDir;
    private Integer sid;
    private String bn;
    private String dbURL;
    private String driverLocation;
    private String user;
    private Integer initialConnections;
    private Integer maximumConnections;
    private String secstoreFSLib;
    private String secstoreFSSecfile;
    private String secstoreFSKeyfile;
    private String rdbmsConnection;
    private String sysName;
    private Integer scsID;
    private String msHost;
    private String adminUserName;

    public FSTask() {
        super(NAME);
    }

    public Task newInstance() {
        return new FSTask();
    }

    public Properties getTaskProperties() {
        Properties taskProperties = new Properties();
        PropertiesUtil.setIntegerProperty(taskProperties, SID_KEY, this.sid);
        PropertiesUtil.setProperty(taskProperties, BN_KEY, this.bn);
        PropertiesUtil.setProperty(taskProperties, INSTALL_DIR_KEY, this.installDir);
        PropertiesUtil.setProperty(taskProperties, RDBMS_URL, this.dbURL);
        PropertiesUtil.setProperty(taskProperties, RDBMS_DRIVERLOCATION, this.driverLocation);
        PropertiesUtil.setProperty(taskProperties, RDBMS_USER, this.user);
        PropertiesUtil.setIntegerProperty(taskProperties, RDBMS_INITIAL_CONNECTIONS, this.initialConnections);
        PropertiesUtil.setIntegerProperty(taskProperties, RDBMS_MAXIMUM_CONNECTIONS, this.maximumConnections);
        PropertiesUtil.setProperty(taskProperties, SECSTORE_FS_LIB, this.secstoreFSLib);
        PropertiesUtil.setProperty(taskProperties, SECSTORE_FS_SEC_FILE, this.secstoreFSSecfile);
        PropertiesUtil.setProperty(taskProperties, SECSTORE_FS_KEY_FILE, this.secstoreFSKeyfile);
        PropertiesUtil.setProperty(taskProperties, RDBMS_CONNECTION, this.rdbmsConnection);
        PropertiesUtil.setProperty(taskProperties, SYSTEM_NAME, this.sysName);
        PropertiesUtil.setIntegerProperty(taskProperties, SCS_ID, this.scsID);
        PropertiesUtil.setProperty(taskProperties, MS_HOST, this.msHost);
        PropertiesUtil.setProperty(taskProperties, ADMIN_CFG_USER, this.adminUserName);
        return taskProperties;
    }

    public void setTaskProperties(Properties taskProperties) throws Exception {
        this.setSid(PropertiesUtil.getIntegerProperty(taskProperties, SID_KEY));
        this.setBn(PropertiesUtil.getProperty(taskProperties, BN_KEY));
        this.setInstallDir(PropertiesUtil.getProperty(taskProperties, INSTALL_DIR_KEY));
        this.setdbURL(PropertiesUtil.getProperty(taskProperties, RDBMS_URL));
        this.setDriverLocation(PropertiesUtil.getProperty(taskProperties, RDBMS_DRIVERLOCATION));
        this.setUser(PropertiesUtil.getProperty(taskProperties, RDBMS_USER));
        this.setInitialConnections(PropertiesUtil.getIntegerProperty(taskProperties, RDBMS_INITIAL_CONNECTIONS));
        this.setMaxConnections(PropertiesUtil.getIntegerProperty(taskProperties, RDBMS_MAXIMUM_CONNECTIONS));
        this.setSecstoreFSLib(PropertiesUtil.getProperty(taskProperties, SECSTORE_FS_LIB));
        this.setSecstoreFSSecfile(PropertiesUtil.getProperty(taskProperties, SECSTORE_FS_SEC_FILE));
        this.setSecstoreFSKeyfile(PropertiesUtil.getProperty(taskProperties, SECSTORE_FS_KEY_FILE));
        this.setRdbmsConnection(PropertiesUtil.getProperty(taskProperties, RDBMS_CONNECTION));
        this.setSysName(PropertiesUtil.getProperty(taskProperties, SYSTEM_NAME));
        this.setScsID(PropertiesUtil.getIntegerProperty(taskProperties, SCS_ID));
        this.setMsHost(PropertiesUtil.getProperty(taskProperties, MS_HOST));
        this.setAdminUserName(PropertiesUtil.getProperty(taskProperties, ADMIN_CFG_USER, "Administrator"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void go(ConfigurationHandler cfgHandler) {
        PortsCalculator calculator = new PortsCalculator(this.sid, this.bn, "dispatcher");
        Properties configData = null;
        Configuration dispCfg = null;
        try {
            try {
                try {
                    dispCfg = cfgHandler.openConfiguration("cluster_data/dispatcher", 0);
                    configData = calculator.getNewDispatcherConfiguration(FSTask.getAllocatedIds(dispCfg, calculator.getElementIdPrefix()));
                }
                catch (IndexOutOfBoundsException ioobe) {
                    this.fireWarningLog(ioobe.getMessage(), ioobe);
                    Object var7_6 = null;
                    cfgHandler.closeConfiguration(dispCfg);
                    return;
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                cfgHandler.closeConfiguration(dispCfg);
                throw throwable;
            }
            cfgHandler.closeConfiguration(dispCfg);
        }
        catch (ConfigurationException ce) {
            this.fireCriticalLog("Error occurred while working with Configuration.", ce);
        }
        this.writeAdminCfgProperties(configData);
        this.writeCfgAdminCfgProperties();
        this.writeDplOptions(configData);
        this.writeConfigToolProperties();
        this.writeRdbProperties();
        this.installOSLibs(this.installDir);
    }

    private void writeAdminCfgProperties(Properties configData) {
        String dispDerviceP4Port = configData.getProperty("disp.service.p4.port");
        String dispServiceP4Ssl = configData.getProperty("disp.service.p4.ssl");
        String dispServiceP4HttpTunneling = configData.getProperty("disp.service.p4.httptunneling");
        String adminCfgPath = this.installDir + File.separator + DIR_ADMIN + File.separator;
        new File(adminCfgPath).mkdirs();
        String adminCfgFileName = adminCfgPath + ADMIN_CFG_FILENAME;
        Properties adminCfgProps = new Properties();
        try {
            adminCfgProps.load(new BufferedInputStream(new FileInputStream(adminCfgFileName)));
        }
        catch (IOException ioe) {
            this.fireInfoLog(adminCfgFileName + " doesn't exist and will be created by batchconfig.");
        }
        ((Hashtable)adminCfgProps).put(ADMIN_CFG_LOGIN_PORT, dispDerviceP4Port);
        ((Hashtable)adminCfgProps).put(ADMIN_CFG_SSL_LOGIN_PORT, dispServiceP4Ssl);
        ((Hashtable)adminCfgProps).put(ADMIN_CFG_HTTP_LOGIN_PORT, dispServiceP4HttpTunneling);
        try {
            adminCfgProps.store(new BufferedOutputStream(new FileOutputStream(adminCfgFileName)), "");
        }
        catch (IOException ioe) {
            this.fireWarningLog("The adminCFG.properties could not be written.", ioe);
        }
    }

    private void writeCfgAdminCfgProperties() {
        if (this.scsID == null) {
            return;
        }
        String adminCfgPath = this.installDir + File.separator + DIR_ADMIN + File.separator + CFG_PATH + File.separator;
        new File(adminCfgPath).mkdirs();
        String adminCfgFileName = adminCfgPath + ADMIN_CFG_FILENAME;
        Properties adminCfgProps = new Properties();
        try {
            adminCfgProps.load(new BufferedInputStream(new FileInputStream(adminCfgFileName)));
        }
        catch (IOException ioe) {
            this.fireInfoLog(adminCfgFileName + " doesn't exist and will be created by batchconfig.");
        }
        PropertiesUtil.setIntegerProperty(adminCfgProps, ADMIN_CFG_CONNECTION_PORT, new Integer(8100 + this.scsID));
        PropertiesUtil.setIntegerProperty(adminCfgProps, ADMIN_CFG_CONNECTION_DISPLAY_INDEX, new Integer(0));
        PropertiesUtil.setProperty(adminCfgProps, ADMIN_CFG_CONNECTION_HOSTNAME, this.msHost);
        PropertiesUtil.setProperty(adminCfgProps, ADMIN_CFG_CONNECTION_LOAD_BALANCING, "manual");
        PropertiesUtil.setProperty(adminCfgProps, ADMIN_CFG_CONNECTION_USER_NAME, this.adminUserName);
        PropertiesUtil.setProperty(adminCfgProps, ADMIN_CFG_CONNECTION_LOOKUP_METHOD, "message_server");
        PropertiesUtil.setProperty(adminCfgProps, ADMIN_CFG_CONNECTION_TRANSPORT_LAYER, "Default");
        PropertiesUtil.setProperty(adminCfgProps, ADMIN_CFG_CONNECTION_DISPLAY_NAME, "Default");
        try {
            adminCfgProps.store(new BufferedOutputStream(new FileOutputStream(adminCfgFileName)), "");
        }
        catch (IOException ioe) {
            this.fireWarningLog("The adminCfg.properties could not be written.", ioe);
        }
    }

    private void writeDplOptions(Properties configData) {
        String remotePort = configData.getProperty("disp.service.p4.port");
        String httpTunneling = configData.getProperty("disp.service.p4.httptunneling");
        String sslPort = configData.getProperty("disp.service.p4.ssl");
        String httpsPort = configData.getProperty("disp.service.http.SslPort");
        String installDirectory = this.installDir.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        String dplOptionsPath = installDirectory + File.separator + DEPLOYING_DIRECTORY + File.separator;
        new File(dplOptionsPath).mkdirs();
        String dplOptionsFileName = dplOptionsPath + DPLOPTIONS_FILENAME;
        Properties dplOptionsProps = new Properties();
        try {
            dplOptionsProps.load(new BufferedInputStream(new FileInputStream(dplOptionsFileName)));
        }
        catch (IOException ioe) {
            this.fireInfoLog(dplOptionsFileName + " doesn't exist and will be created by batchconfig.");
        }
        ((Hashtable)dplOptionsProps).put(REMOTE_PORT, remotePort);
        ((Hashtable)dplOptionsProps).put(HTTP_TUNNELING_PORT, httpTunneling);
        ((Hashtable)dplOptionsProps).put(SSL_PORT, sslPort);
        ((Hashtable)dplOptionsProps).put(HTTPS_PORT, httpsPort);
        try {
            dplOptionsProps.store(new BufferedOutputStream(new FileOutputStream(dplOptionsFileName)), "Generated by FIJK");
        }
        catch (IOException ioe) {
            this.fireWarningLog("The dplOptions.options file could not be written.", ioe);
        }
    }

    private void writeRdbProperties() {
        String installDirectory = this.installDir.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        if (!this.installDir.endsWith(File.separator)) {
            installDirectory = this.installDir + File.separator;
        }
        String rdbPath = installDirectory + DEPLOYING_DIRECTORY + File.separator;
        String rdbFileName = rdbPath + RDB_FILENAME;
        if (!new File(rdbPath).exists()) {
            new File(rdbPath).mkdirs();
        }
        Properties rdbProps = new Properties();
        try {
            rdbProps.load(new BufferedInputStream(new FileInputStream(rdbFileName)));
        }
        catch (IOException ioe) {
            this.fireInfoLog(rdbFileName + " doesn't exist and will be created by batchconfig.");
        }
        PropertiesUtil.setProperty(rdbProps, DIR_TO_CLUSTER, installDirectory + "cluster" + File.separator);
        PropertiesUtil.setProperty(rdbProps, RDBMS_URL, this.dbURL);
        PropertiesUtil.setProperty(rdbProps, RDBMS_DRIVERLOCATION, this.driverLocation);
        PropertiesUtil.setProperty(rdbProps, RDBMS_USER, this.user);
        PropertiesUtil.setIntegerProperty(rdbProps, RDBMS_INITIAL_CONNECTIONS, this.initialConnections);
        PropertiesUtil.setIntegerProperty(rdbProps, RDBMS_MAXIMUM_CONNECTIONS, this.maximumConnections);
        PropertiesUtil.setProperty(rdbProps, SECSTORE_FS_LIB, this.secstoreFSLib);
        PropertiesUtil.setProperty(rdbProps, SECSTORE_FS_SEC_FILE, this.secstoreFSSecfile);
        PropertiesUtil.setProperty(rdbProps, SECSTORE_FS_KEY_FILE, this.secstoreFSKeyfile);
        PropertiesUtil.setProperty(rdbProps, RDBMS_CONNECTION, this.rdbmsConnection);
        PropertiesUtil.setProperty(rdbProps, SYSTEM_NAME, this.sysName);
        try {
            rdbProps.store(new BufferedOutputStream(new FileOutputStream(rdbFileName)), "Generated by KIJF");
        }
        catch (IOException ioe) {
            this.fireWarningLog("The rdb.properties could not be properly saved.", ioe);
        }
    }

    private void installOSLibs(String installDir) {
        try {
            new File(installDir + File.separator + DIR_OSLIBS).mkdirs();
        }
        catch (Exception e) {
            this.fireWarningLog("Error occurred while creating oslibs directory.", e);
        }
    }

    private void writeConfigToolProperties() {
        String installDirectory = this.installDir.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        String configPropertiesDir = installDirectory + File.separator + CONFIG_TOOL_DIR + File.separator;
        new File(configPropertiesDir).mkdirs();
        String configPropsFile = configPropertiesDir + CONFIG_PROPERTIES_FILENAME;
        Properties props = new Properties();
        try {
            props.load(new BufferedInputStream(new FileInputStream(configPropsFile)));
        }
        catch (IOException ioe) {
            this.fireInfoLog(configPropsFile + " doesn't exist and will be created by batchconfig.");
        }
        PropertiesUtil.setProperty(props, RDBMS_URL, this.dbURL);
        PropertiesUtil.setProperty(props, RDBMS_DRIVERLOCATION, this.driverLocation);
        PropertiesUtil.setProperty(props, RDBMS_USER, this.user);
        PropertiesUtil.setIntegerProperty(props, RDBMS_INITIAL_CONNECTIONS, this.initialConnections);
        PropertiesUtil.setIntegerProperty(props, RDBMS_MAXIMUM_CONNECTIONS, this.maximumConnections);
        PropertiesUtil.setProperty(props, SECSTORE_FS_LIB, this.secstoreFSLib);
        PropertiesUtil.setProperty(props, SECSTORE_FS_SEC_FILE, this.secstoreFSSecfile);
        PropertiesUtil.setProperty(props, SECSTORE_FS_KEY_FILE, this.secstoreFSKeyfile);
        PropertiesUtil.setProperty(props, RDBMS_CONNECTION, this.rdbmsConnection);
        PropertiesUtil.setProperty(props, SYSTEM_NAME, this.sysName);
        try {
            props.store(new BufferedOutputStream(new FileOutputStream(configPropsFile)), "Generated by KIJF");
        }
        catch (IOException ioe) {
            this.fireWarningLog("The config.properties could not be properly saved.", ioe);
        }
    }

    private static int[] getAllocatedIds(Configuration cfg, String prefix) throws ConfigurationException {
        ArrayList<Integer> allocatedIds = new ArrayList<Integer>(11);
        Map allCfgs = cfg.getAllSubConfigurations();
        Iterator cfgNames = allCfgs.keySet().iterator();
        while (cfgNames.hasNext()) {
            String cfgName = (String)cfgNames.next();
            if (!cfgName.startsWith(prefix)) continue;
            allocatedIds.add(Integer.valueOf(cfgName.substring("ID".length())));
        }
        int[] result = new int[allocatedIds.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (Integer)allocatedIds.get(i);
            ++i;
        }
        return result;
    }

    public Integer getSid() {
        return this.sid;
    }

    public void setSid(Integer sid) {
        if (sid == null) {
            throw new IllegalArgumentException("Error occurred while reading system.id");
        }
        this.sid = sid;
    }

    public String getBn() {
        return this.bn;
    }

    public void setBn(String bn) {
        this.bn = bn;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(String installDir) {
        if (installDir == null) {
            throw new IllegalArgumentException("Error occurred while reading install.dir");
        }
        this.installDir = installDir;
    }

    public void setdbURL(String dbURL) {
        this.dbURL = dbURL;
    }

    public String getdbUrl() {
        return this.dbURL;
    }

    public void setDriverLocation(String driverLocation) {
        this.driverLocation = driverLocation;
    }

    public String getDriverLocation() {
        return this.driverLocation;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setInitialConnections(Integer initialConnections) {
        this.initialConnections = initialConnections;
    }

    public Integer getInitialConnections() {
        return this.initialConnections;
    }

    public void setMaxConnections(Integer maximumConnections) {
        this.maximumConnections = maximumConnections;
    }

    public Integer getMaxConnections() {
        return this.maximumConnections;
    }

    public void setSecstoreFSLib(String secstoreFSLib) {
        this.secstoreFSLib = secstoreFSLib;
    }

    public String getSecstoreFSLib() {
        return this.secstoreFSLib;
    }

    public void setSecstoreFSSecfile(String secstoreFSSecfile) {
        this.secstoreFSSecfile = secstoreFSSecfile;
    }

    public String getSecstoreFSSecfile() {
        return this.secstoreFSSecfile;
    }

    public void setSecstoreFSKeyfile(String secstoreFSKeyfile) {
        this.secstoreFSKeyfile = secstoreFSKeyfile;
    }

    public String getSecstoreFSKeyfile() {
        return this.secstoreFSKeyfile;
    }

    public void setRdbmsConnection(String rdbmsConnection) {
        this.rdbmsConnection = rdbmsConnection;
    }

    public String getRdbmsConnection() {
        return this.rdbmsConnection;
    }

    public void setSysName(String sysName) {
        this.sysName = sysName;
    }

    public String getSysName() {
        return this.sysName;
    }

    public Integer getScsID() {
        return this.scsID;
    }

    public void setScsID(Integer scsID) {
        this.scsID = scsID;
    }

    public String getMsHost() {
        return this.msHost;
    }

    public void setMsHost(String msHost) {
        this.msHost = msHost;
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public void setAdminUserName(String adminUserName) {
        this.adminUserName = adminUserName;
    }
}

