/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.batch.task.TaskUtil;
import com.sap.engine.configtool.lib.PortsCalculator;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import java.util.Properties;

public final class ElementInfoTask
extends Task {
    private static final String NAME = "change.element.info";
    public static final String ELEMENT_NAME_KEY = "element.name";
    public static final String SYSTEM_ID = "system.id";
    public static final String BOX_NUMBER = "box.number";
    private static final String JAVA_PATH_KEY = "java.path";
    private static final String JAVA_CLASSPATH_KEY = "java.classpath";
    private static final String JAVA_PARAMS_KEY = "java.parameters";
    private static final String JAVA_MAX_HEAP_SIZE_KEY = "java.max.heap.size";
    private static final String JAVA_MAIN_CLASS_KEY = "java.main.class";
    private static final String JAVA_MAIN_CLASS_PARAMETERS_KEY = "java.main.class.parameters";
    private static final String OS_BIT_LENGTH = "os.bit.length";
    private static final String OS_NAME = "os.name";
    private static final String OS_UNICODE = "os.unicode";
    private static final String DEBUGGABLE_KEY = "debuggable";
    private static final String DEBUG_ENABLED_KEY = "debug.enabled";
    private static final String DEBUG_PORT_KEY = "debug.port";
    private static final String INSTALL_DIR_KEY = "install.dir";
    private static final String SF_EXECUTE_KEY = "sf.execute ";
    private static final String SF_CONSOLE_KEY = "sf.console";
    private static final String SF_RESTRICTED_LOAD_BALANCE_KEY = "sf.restricted.load.balance";
    private static final String BOOTSTRAP_JAVA_PATH_KEY = "bootstrap.java.path";
    private static final String BOOTSTRAP_JAVA_CLASSPATH_KEY = "bootstrap.java.classpath";
    private static final String BOOTSTRAP_JAVA_PARAMS_KEY = "bootstrap.java.parameters";
    private static final String BOOTSTRAP_JAVA_MAX_HEAP_SIZE_KEY = "bootstrap.java.max.heap.size";
    private static final String BOOTSTRAP_JAVA_MAIN_CLASS_KEY = "bootstrap.java.main.class";
    private static final String BOOTSTRAP_JAVA_MAIN_CLASS_PARAMETERS_KEY = "bootstrap.java.main.class.parameters";
    private static final String INSTALLATION_KEY = "installation";
    private String elementName;
    private String javaPath;
    private String javaClassPath;
    private String javaParams;
    private Integer javaMaxHeapSize;
    private String javaMainClass;
    private String javaMainClassParams;
    private Integer osBitLength;
    private String osName;
    private Boolean osUnicode;
    private Boolean isDebuggable;
    private Boolean debugEnabled;
    private Integer debugPort;
    private String installDir;
    private Boolean sfExecute;
    private Boolean sfConsole;
    private Boolean sfLoadBalance;
    private Integer systemId;
    private String boxNumber;
    private String bootstrapJavaPath;
    private String bootstrapJavaClassPath;
    private String bootstrapJavaParams;
    private Integer bootstrapJavaMaxHeapSize;
    private String bootstrapJavaMainClass;
    private String bootstrapJavaMainClassParams;
    private Boolean installation;

    public ElementInfoTask() {
        super(NAME);
    }

    public Task newInstance() {
        return new ElementInfoTask();
    }

    public String getUniqueName() {
        return this.elementName;
    }

    /*
     * Unable to fully structure code
     */
    public void go(ConfigurationHandler cfgHandler) {
        try {
            elementInfoPath = TaskUtil.getElementConfigurationPath(this.elementName, cfgHandler);
            elementInfoFile = elementInfoPath + "/" + "element-info";
            if (this.elementName.startsWith("server")) {
                block18: {
                    calculator = null;
                    prefix = null;
                    if (this.elementName.equals("server")) {
                        calculator = new PortsCalculator(this.systemId, this.boxNumber, "server");
                        prefix = calculator.getElementIdPrefix();
                    } else {
                        prefix = this.elementName.substring("server".length() + 1);
                    }
                    instanceGlobalEIPath = elementInfoFile + '.' + prefix;
                    try {
                        elementInfoConfig = cfgHandler.openConfiguration(instanceGlobalEIPath, 1);
                        if (elementInfoConfig != null) {
                            sheetProperties = elementInfoConfig.getPropertySheetInterface();
                            this.setElementInfoProperties(sheetProperties, cfgHandler, this.installation);
                            break block18;
                        }
                        throw new NameNotFoundException(instanceGlobalEIPath);
                    }
                    catch (NameNotFoundException nnfe) {
                        elementInfoConfig = cfgHandler.openConfiguration(elementInfoFile, 0);
                        globalProps = elementInfoConfig.getPropertySheetInterface().getProperties();
                        elementInfoConfig.close();
                        elementInfoConfig = cfgHandler.openConfiguration(elementInfoPath, 1);
                        elementInfo = elementInfoConfig.createSubConfiguration("element-info." + prefix, 1);
                        sheetProperties = elementInfo.getPropertySheetInterface();
                        keys = globalProps.keys();
                        ** while (keys.hasMoreElements())
                    }
lbl-1000:
                    // 1 sources

                    {
                        key = (String)keys.nextElement();
                        sheetProperties.createPropertyEntry(key, (Object)globalProps.getProperty(key), "");
                        continue;
                    }
lbl33:
                    // 1 sources

                    if (this.osName != null && this.osBitLength != null && this.osUnicode != null) {
                        sheetProperties.createPropertyEntry("os.name", (Object)this.osName, "");
                        sheetProperties.createPropertyEntry("os.bit.length", (Object)this.osBitLength.toString(), "");
                        sheetProperties.createPropertyEntry("os.unicode", (Object)(this.osUnicode != false ? "yes" : "no"), "");
                    } else {
                        try {
                            localElementInfo = TaskUtil.getElementInfo(this.elementName.substring(this.elementName.indexOf(46) + 1) + "50", cfgHandler);
                            sheetProperties.createPropertyEntry("os.name", (Object)localElementInfo.getProperty("os.name"), "");
                            sheetProperties.createPropertyEntry("os.bit.length", (Object)localElementInfo.getProperty("os.bit.length"), "");
                            sheetProperties.createPropertyEntry("os.unicode", (Object)localElementInfo.getProperty("os.unicode"), "");
                        }
                        catch (Exception e) {
                            this.fireCriticalLog("Can't find os parameters.", e);
                        }
                    }
                    this.setElementInfoProperties(sheetProperties, cfgHandler, true);
                }
                cfgHandler.commit();
                cfgHandler.closeConfiguration(elementInfoConfig);
                serverCfg = cfgHandler.openConfiguration("cluster_data/server", 0);
                serversCfg = serverCfg.getAllSubConfigurations();
                serversKeys = serversCfg.keySet().iterator();
                while (serversKeys.hasNext()) {
                    key = (String)serversKeys.next();
                    if (!key.startsWith(prefix)) continue;
                    try {
                        elementInfo = ((Configuration)serversCfg.get(key)).getSubConfiguration("element-info");
                        this.updateInstanceProperties(cfgHandler, key, elementInfo.getPropertySheetInterface().getProperties());
                    }
                    catch (NameNotFoundException e) {
                        this.fireWarningLog("Element '" + key + "' is corrupted!", e);
                    }
                }
                cfgHandler.closeConfiguration(serverCfg);
            } else {
                elementInfoConfig = cfgHandler.openConfiguration(elementInfoFile, 1);
                if (elementInfoConfig != null) {
                    sheetProperties = elementInfoConfig.getPropertySheetInterface();
                    this.setElementInfoProperties(sheetProperties, cfgHandler, this.installation);
                }
                cfgHandler.commit();
                cfgHandler.closeConfiguration(elementInfoConfig);
                this.updateInstanceProperties(cfgHandler, this.elementName, new Properties());
            }
            this.fireInfoLog("ElementInfoTask has finished successfully on " + this.elementName);
        }
        catch (ConfigurationException ce) {
            this.fireCriticalLog("Error occurred while working with Configuration.", ce);
        }
    }

    private void setElementInfoProperties(PropertySheet sheetProperties, ConfigurationHandler cfgHandler, boolean installation) throws ConfigurationException {
        TaskUtil.setPropertyValue(sheetProperties, JAVA_PATH_KEY, this.javaPath, installation);
        TaskUtil.setPropertyValue(sheetProperties, "java.class.path", this.javaClassPath, installation);
        if (this.javaParams != null && this.javaParams.startsWith("prefix.please.ivkrasfam.")) {
            this.javaParams = this.javaParams.substring("prefix.please.ivkrasfam.".length());
            String oldJavaParams = null;
            if (this.elementName.equals("dispatcher") || this.elementName.equals("server")) {
                PropertyEntry javaParamsEntry = sheetProperties.getPropertyEntry(JAVA_PARAMS_KEY);
                if (javaParamsEntry != null) {
                    oldJavaParams = (String)javaParamsEntry.getDefault();
                }
            } else {
                Properties elementInfo = TaskUtil.getElementInfo(this.elementName, cfgHandler);
                if (elementInfo != null) {
                    oldJavaParams = elementInfo.getProperty(JAVA_PARAMS_KEY);
                }
            }
            if (oldJavaParams != null) {
                this.javaParams = (oldJavaParams + " " + this.javaParams).trim();
            }
        }
        TaskUtil.setPropertyValue(sheetProperties, JAVA_PARAMS_KEY, this.javaParams, installation);
        TaskUtil.setPropertyIntegerValue(sheetProperties, JAVA_MAX_HEAP_SIZE_KEY, this.javaMaxHeapSize, installation);
        TaskUtil.setPropertyValue(sheetProperties, JAVA_MAIN_CLASS_KEY, this.javaMainClass, installation);
        TaskUtil.setPropertyValue(sheetProperties, JAVA_MAIN_CLASS_PARAMETERS_KEY, this.javaMainClassParams, installation);
        TaskUtil.setPropertyIntegerValue(sheetProperties, OS_BIT_LENGTH, this.getOsBitLength(), installation);
        TaskUtil.setPropertyValue(sheetProperties, OS_NAME, this.getOsName(), installation);
        TaskUtil.setPropertyBooleanValue(sheetProperties, OS_UNICODE, this.getOsUnicode(), "yes", installation);
        TaskUtil.setPropertyBooleanValue(sheetProperties, DEBUGGABLE_KEY, this.isDebuggable, "yes", installation);
        TaskUtil.setPropertyBooleanValue(sheetProperties, DEBUG_ENABLED_KEY, this.debugEnabled, "yes", installation);
        TaskUtil.setPropertyIntegerValue(sheetProperties, DEBUG_PORT_KEY, this.debugPort, installation);
        TaskUtil.setPropertyBooleanValue(sheetProperties, "sf.execute", this.sfExecute, "yes", installation);
        TaskUtil.setPropertyBooleanValue(sheetProperties, SF_CONSOLE_KEY, this.sfConsole, "yes", installation);
        TaskUtil.setPropertyBooleanValue(sheetProperties, SF_RESTRICTED_LOAD_BALANCE_KEY, this.sfLoadBalance, "yes", installation);
    }

    private void updateInstanceProperties(ConfigurationHandler cfgHandler, String elementName, Properties local) throws ConfigurationException {
        String prefix = elementName.substring(0, elementName.length() - 2);
        Configuration rootCfg = cfgHandler.openConfiguration("cluster_data", 1);
        Configuration instancePropsCfg = rootCfg.getSubConfiguration("instance.properties." + prefix);
        PropertySheet sheetProperties = instancePropsCfg.getPropertySheetInterface();
        String elementNameKey = elementName + ".";
        if (local.getProperty(JAVA_PATH_KEY) == null) {
            TaskUtil.setPropertyEntryValue(sheetProperties, elementNameKey + "JavaPath", this.javaPath);
        }
        if (local.getProperty("java.class.path") == null) {
            TaskUtil.setPropertyEntryValue(sheetProperties, elementNameKey + "ClassPath", this.javaClassPath);
        }
        if (local.getProperty(JAVA_PARAMS_KEY) == null) {
            int pos;
            String oldJavaParams;
            String javaParamsKey = elementNameKey + "JavaParameters";
            if (this.javaParams != null && (oldJavaParams = sheetProperties.getProperties().getProperty(javaParamsKey)) != null && (pos = oldJavaParams.indexOf(" -Drdbms.driverLocation")) != -1) {
                this.javaParams = this.javaParams + oldJavaParams.substring(pos);
            }
            TaskUtil.setPropertyEntryValue(sheetProperties, javaParamsKey, this.javaParams);
        }
        if (local.getProperty(JAVA_PARAMS_KEY) == null) {
            TaskUtil.setPropertyEntryIntegerValue(sheetProperties, elementNameKey + "MaxHeapSize", this.javaMaxHeapSize);
        }
        if (local.getProperty(JAVA_MAIN_CLASS_KEY) == null) {
            TaskUtil.setPropertyEntryValue(sheetProperties, elementNameKey + "MainClass", this.javaMainClass);
        }
        if (local.getProperty(JAVA_MAIN_CLASS_PARAMETERS_KEY) == null) {
            TaskUtil.setPropertyEntryValue(sheetProperties, elementNameKey + "Parameters", this.javaMainClassParams);
        }
        if (local.getProperty(DEBUGGABLE_KEY) == null) {
            TaskUtil.setPropertyEntryBooleanValue(sheetProperties, elementNameKey + "Debuggable", this.isDebuggable, "yes");
        }
        if (local.getProperty(DEBUG_ENABLED_KEY) == null) {
            TaskUtil.setPropertyEntryBooleanValue(sheetProperties, elementNameKey + "DebugMode", this.debugEnabled, "yes");
        }
        if (local.getProperty(DEBUG_PORT_KEY) == null) {
            TaskUtil.setPropertyEntryIntegerValue(sheetProperties, elementNameKey + "DebugPort", this.debugPort);
        }
        if (local.getProperty("sf.execute") == null) {
            TaskUtil.setPropertyEntryBooleanValue(sheetProperties, elementNameKey + "Execute", this.sfExecute, "yes");
        }
        if (local.getProperty(SF_CONSOLE_KEY) == null) {
            TaskUtil.setPropertyEntryBooleanValue(sheetProperties, elementNameKey + "Console", this.sfConsole, "yes");
        }
        if (local.getProperty(SF_RESTRICTED_LOAD_BALANCE_KEY) == null) {
            TaskUtil.setPropertyEntryBooleanValue(sheetProperties, elementNameKey + "LoadBalanceRestricted", this.sfLoadBalance, "yes");
        }
        String bootstrapPrefix = "bootstrap_" + elementName + ".";
        this.setPropertyEntryValue(sheetProperties, bootstrapPrefix + "JavaPath", this.bootstrapJavaPath);
        this.setPropertyEntryValue(sheetProperties, bootstrapPrefix + "ClassPath", this.bootstrapJavaClassPath);
        if (this.bootstrapJavaParams != null && this.bootstrapJavaParams.startsWith("prefix.please.ivkrasfam.")) {
            String oldBootstrapJavaParams;
            this.bootstrapJavaParams = this.bootstrapJavaParams.substring("prefix.please.ivkrasfam.".length());
            Properties instanceProperties = TaskUtil.getInstanceProperties(cfgHandler, prefix);
            if (instanceProperties != null && (oldBootstrapJavaParams = instanceProperties.getProperty(bootstrapPrefix + "JavaParameters")) != null) {
                this.bootstrapJavaParams = (oldBootstrapJavaParams + " " + this.bootstrapJavaParams).trim();
            }
        }
        this.setPropertyEntryValue(sheetProperties, bootstrapPrefix + "JavaParameters", this.bootstrapJavaParams);
        TaskUtil.setPropertyEntryIntegerValue(sheetProperties, bootstrapPrefix + "MaxHeapSize", this.bootstrapJavaMaxHeapSize);
        TaskUtil.setPropertyEntryValue(sheetProperties, bootstrapPrefix + "MainClass", this.bootstrapJavaMainClass);
        this.setPropertyEntryValue(sheetProperties, bootstrapPrefix + "Parameters", this.bootstrapJavaMainClassParams);
        cfgHandler.commit();
        cfgHandler.closeConfiguration(rootCfg);
    }

    public Properties getTaskProperties() {
        Properties taskProperties = new Properties();
        PropertiesUtil.setProperty(taskProperties, ELEMENT_NAME_KEY, this.elementName);
        PropertiesUtil.setIntegerProperty(taskProperties, SYSTEM_ID, this.systemId);
        PropertiesUtil.setProperty(taskProperties, BOX_NUMBER, this.boxNumber);
        PropertiesUtil.setProperty(taskProperties, JAVA_PATH_KEY, this.javaPath);
        PropertiesUtil.setProperty(taskProperties, JAVA_CLASSPATH_KEY, this.javaClassPath);
        PropertiesUtil.setProperty(taskProperties, JAVA_PARAMS_KEY, this.javaParams);
        PropertiesUtil.setIntegerProperty(taskProperties, JAVA_MAX_HEAP_SIZE_KEY, this.javaMaxHeapSize);
        PropertiesUtil.setProperty(taskProperties, JAVA_MAIN_CLASS_KEY, this.javaMainClass);
        PropertiesUtil.setProperty(taskProperties, JAVA_MAIN_CLASS_PARAMETERS_KEY, this.javaMainClassParams);
        PropertiesUtil.setIntegerProperty(taskProperties, OS_BIT_LENGTH, this.getOsBitLength());
        PropertiesUtil.setProperty(taskProperties, OS_NAME, this.getOsName());
        PropertiesUtil.setBooleanProperty(taskProperties, OS_UNICODE, this.getOsUnicode(), "yes");
        PropertiesUtil.setBooleanProperty(taskProperties, DEBUGGABLE_KEY, this.isDebuggable, "yes");
        PropertiesUtil.setBooleanProperty(taskProperties, DEBUG_ENABLED_KEY, this.debugEnabled, "yes");
        PropertiesUtil.setIntegerProperty(taskProperties, DEBUG_PORT_KEY, this.debugPort);
        PropertiesUtil.setProperty(taskProperties, INSTALL_DIR_KEY, this.installDir);
        PropertiesUtil.setBooleanProperty(taskProperties, "sf.execute", this.sfExecute, "yes");
        PropertiesUtil.setBooleanProperty(taskProperties, SF_CONSOLE_KEY, this.sfConsole, "yes");
        PropertiesUtil.setBooleanProperty(taskProperties, SF_RESTRICTED_LOAD_BALANCE_KEY, this.sfLoadBalance, "yes");
        PropertiesUtil.setProperty(taskProperties, BOOTSTRAP_JAVA_PATH_KEY, this.bootstrapJavaPath);
        PropertiesUtil.setProperty(taskProperties, BOOTSTRAP_JAVA_CLASSPATH_KEY, this.bootstrapJavaClassPath);
        PropertiesUtil.setProperty(taskProperties, BOOTSTRAP_JAVA_PARAMS_KEY, this.bootstrapJavaParams);
        PropertiesUtil.setIntegerProperty(taskProperties, BOOTSTRAP_JAVA_MAX_HEAP_SIZE_KEY, this.bootstrapJavaMaxHeapSize);
        PropertiesUtil.setProperty(taskProperties, BOOTSTRAP_JAVA_MAIN_CLASS_KEY, this.bootstrapJavaMainClass);
        PropertiesUtil.setProperty(taskProperties, BOOTSTRAP_JAVA_MAIN_CLASS_PARAMETERS_KEY, this.bootstrapJavaMainClassParams);
        PropertiesUtil.setBooleanProperty(taskProperties, INSTALLATION_KEY, this.installation, "yes");
        return taskProperties;
    }

    public void setTaskProperties(Properties taskProperties) throws Exception {
        this.setElementName(PropertiesUtil.getProperty(taskProperties, ELEMENT_NAME_KEY));
        this.setSid(PropertiesUtil.getIntegerProperty(taskProperties, SYSTEM_ID));
        this.setBoxNumber(PropertiesUtil.getProperty(taskProperties, BOX_NUMBER));
        this.setJavaPath(PropertiesUtil.getProperty(taskProperties, JAVA_PATH_KEY));
        this.setJavaClassPath(PropertiesUtil.getProperty(taskProperties, JAVA_CLASSPATH_KEY));
        this.setJavaParams(PropertiesUtil.getProperty(taskProperties, JAVA_PARAMS_KEY));
        this.setJavaMaxHeapSize(PropertiesUtil.getIntegerProperty(taskProperties, JAVA_MAX_HEAP_SIZE_KEY));
        this.setJavaMainClass(PropertiesUtil.getProperty(taskProperties, JAVA_MAIN_CLASS_KEY));
        this.setJavaMainClassParams(PropertiesUtil.getProperty(taskProperties, JAVA_MAIN_CLASS_PARAMETERS_KEY));
        this.setOsBitLength(PropertiesUtil.getIntegerProperty(taskProperties, OS_BIT_LENGTH));
        this.setOsName(PropertiesUtil.getProperty(taskProperties, OS_NAME));
        this.setOsUnicode(PropertiesUtil.getBooleanProperty(taskProperties, OS_UNICODE, "yes"));
        this.setDebuggable(PropertiesUtil.getBooleanProperty(taskProperties, DEBUGGABLE_KEY, "yes"));
        this.setDebugEnabled(PropertiesUtil.getBooleanProperty(taskProperties, DEBUG_ENABLED_KEY, "yes"));
        this.setDebugPort(PropertiesUtil.getIntegerProperty(taskProperties, DEBUG_PORT_KEY));
        this.setInstallDir(PropertiesUtil.getProperty(taskProperties, INSTALL_DIR_KEY));
        Boolean execute = PropertiesUtil.getBooleanProperty(taskProperties, SF_EXECUTE_KEY, "yes");
        execute = PropertiesUtil.getBooleanProperty(taskProperties, "sf.execute", "yes");
        this.setSFExecute(execute);
        this.setSFConsole(PropertiesUtil.getBooleanProperty(taskProperties, SF_CONSOLE_KEY, "yes"));
        this.setSFLoadBalance(PropertiesUtil.getBooleanProperty(taskProperties, SF_RESTRICTED_LOAD_BALANCE_KEY, "yes"));
        this.setBootstrapJavaPath(PropertiesUtil.getProperty(taskProperties, BOOTSTRAP_JAVA_PATH_KEY));
        this.setBootstrapJavaClassPath(PropertiesUtil.getProperty(taskProperties, BOOTSTRAP_JAVA_CLASSPATH_KEY));
        this.setBootstrapJavaParams(PropertiesUtil.getProperty(taskProperties, BOOTSTRAP_JAVA_PARAMS_KEY));
        this.setBootstrapJavaMaxHeapSize(PropertiesUtil.getIntegerProperty(taskProperties, BOOTSTRAP_JAVA_MAX_HEAP_SIZE_KEY));
        this.setBootstrapJavaMainClass(PropertiesUtil.getProperty(taskProperties, BOOTSTRAP_JAVA_MAIN_CLASS_KEY));
        this.setBootstrapJavaMainClassParams(PropertiesUtil.getProperty(taskProperties, BOOTSTRAP_JAVA_MAIN_CLASS_PARAMETERS_KEY));
        this.setInstallation(PropertiesUtil.getBooleanProperty(taskProperties, INSTALLATION_KEY, "yes"));
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Error occurred while reading element.name");
        }
        this.elementName = elementName;
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    public void setJavaPath(String javaPath) {
        this.javaPath = javaPath;
    }

    public String getJavaClassPath() {
        return this.javaClassPath;
    }

    public void setJavaClassPath(String javaClassPath) {
        this.javaClassPath = javaClassPath;
    }

    public String getJavaParams() {
        return this.javaParams;
    }

    public void setJavaParams(String javaParams) {
        if (javaParams != null && javaParams.trim().length() != 0) {
            this.javaParams = javaParams.replace('\u2013', '-');
        }
    }

    public void setAdditionalJavaParams(String additionalJavaParams) {
        if (additionalJavaParams != null && additionalJavaParams.trim().length() != 0) {
            this.javaParams = "prefix.please.ivkrasfam." + additionalJavaParams.replace('\u2013', '-');
        }
    }

    public Integer getJavaMaxHeapSize() {
        return this.javaMaxHeapSize;
    }

    public void setJavaMaxHeapSize(Integer javaMaxHeapSize) {
        this.javaMaxHeapSize = javaMaxHeapSize;
    }

    public String getJavaMainClass() {
        return this.javaMainClass;
    }

    public void setJavaMainClass(String javaMainClass) {
        this.javaMainClass = javaMainClass;
    }

    public String getJavaMainClassParams() {
        return this.javaMainClassParams;
    }

    public void setJavaMainClassParams(String javaMainClassParams) {
        this.javaMainClassParams = javaMainClassParams;
    }

    public Boolean getDebuggable() {
        return this.isDebuggable;
    }

    public void setDebuggable(Boolean isDebuggable) {
        this.isDebuggable = isDebuggable;
    }

    public Boolean getDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(Boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public Integer getDebugPort() {
        return this.debugPort;
    }

    public void setDebugPort(Integer debugPort) {
        this.debugPort = debugPort;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(String installDir) {
        this.installDir = installDir;
    }

    public Boolean getSFExecute() {
        return this.sfExecute;
    }

    public void setSFExecute(Boolean sfExecute) {
        this.sfExecute = sfExecute;
    }

    public Boolean getSFConsole() {
        return this.sfConsole;
    }

    public void setSFConsole(Boolean sfConsole) {
        this.sfConsole = sfConsole;
    }

    public Boolean getSFLoadBalance() {
        return this.sfLoadBalance;
    }

    public void setSFLoadBalance(Boolean sfLoadBalance) {
        this.sfLoadBalance = sfLoadBalance;
    }

    public String getBootstrapJavaPath() {
        return this.bootstrapJavaPath;
    }

    public void setBootstrapJavaPath(String bootstrapJavaPath) {
        this.bootstrapJavaPath = bootstrapJavaPath;
    }

    public String getBootstrapJavaClassPath() {
        return this.bootstrapJavaClassPath;
    }

    public void setBootstrapJavaClassPath(String bootstrapJavaClassPath) {
        this.bootstrapJavaClassPath = bootstrapJavaClassPath;
    }

    public String getBootstrapJavaParams() {
        return this.bootstrapJavaParams;
    }

    public void setBootstrapJavaParams(String bootstrapJavaParams) {
        this.bootstrapJavaParams = bootstrapJavaParams;
    }

    public void setBootstrapAdditionalJavaParams(String additionalJavaParams) {
        if (additionalJavaParams != null && additionalJavaParams.trim().length() != 0) {
            this.bootstrapJavaParams = "prefix.please.ivkrasfam." + additionalJavaParams;
        }
    }

    public Integer getBootstrapJavaMaxHeapSize() {
        return this.bootstrapJavaMaxHeapSize;
    }

    public void setBootstrapJavaMaxHeapSize(Integer bootstrapJavaMaxHeapSize) {
        this.bootstrapJavaMaxHeapSize = bootstrapJavaMaxHeapSize;
    }

    public String getBootstrapJavaMainClass() {
        return this.bootstrapJavaMainClass;
    }

    public void setBootstrapJavaMainClass(String bootstrapJavaMainClass) {
        this.bootstrapJavaMainClass = bootstrapJavaMainClass;
    }

    public String getBootstrapJavaMainClassParams() {
        return this.bootstrapJavaMainClassParams;
    }

    public void setBootstrapJavaMainClassParams(String bootstrapJavaMainClassParams) {
        this.bootstrapJavaMainClassParams = bootstrapJavaMainClassParams;
    }

    private void setPropertyEntryValue(PropertySheet sheetProperties, String key, String value) throws ConfigurationException {
        if (value != null) {
            TaskUtil.setPropertyEntryValue(sheetProperties, key, value.replace('\\', '/').replace(';', ':'));
        }
    }

    public void setOsBitLength(Integer osBitLength) {
        this.osBitLength = osBitLength;
    }

    public Integer getOsBitLength() {
        return this.osBitLength;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsUnicode(Boolean osUnicode) {
        this.osUnicode = osUnicode;
    }

    public Boolean getOsUnicode() {
        return this.osUnicode;
    }

    public Integer getSid() {
        return this.systemId;
    }

    public void setSid(Integer systemId) {
        this.systemId = systemId;
    }

    public String getBoxNumber() {
        return this.boxNumber;
    }

    public void setBoxNumber(String boxNumber) {
        this.boxNumber = boxNumber;
    }

    public void setInstallation(Boolean installation) {
        this.installation = installation;
    }
}

