/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.ClusterElement;
import com.sap.engine.configtool.Constants;
import com.sap.engine.configtool.Manager;
import com.sap.engine.configtool.Service;
import com.sap.engine.configtool.batch.Scanner;
import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.batch.task.TaskUtil;
import com.sap.engine.configtool.lib.PortsCalculator;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public final class CreateNewElementTask
extends Task {
    public static final String NAME = "create.new.element";
    private static final String DEFAULT_JAVA_PARAMS = "-Djava.security.policy=.\\java.policy -Djava.security.egd=file:/dev/urandom ";
    private static final String DEFAULT_JAVA_MAIN_CLASS = "com.sap.engine.boot.Start";
    private static final String DEFAULT_JAVA_MAIN_CLASS_PARAMS = "";
    private static final String DEFAULT_DEBUGGABLE = "no";
    private static final String DEFAULT_JAVA_CLASSPATH = "./bin/boot/boot.jar;./bin/system/bytecode.jar;.";
    private static final String DEFAULT_SF_CONSOLE = "yes";
    private static final String DEFAULT_SF_EXECUTE = "yes";
    private static final String DEFAULT_SF_LOAD_BALANCE = "no";
    private static final String SID_KEY = "system.id";
    private static final String BN_KEY = "box.number";
    private static final String TYPE_KEY = "type";
    private static final String R3_KEY = "r3.environment";
    private static final String OS_NAME_KEY = "os.name";
    private static final String OS_BIT_LENGTH_KEY = "os.bit.length";
    private static final String OS_UNICODE_KEY = "os.unicode";
    private static final String DB_DRIVER_LOCATION = "rdbms.driverLocation";
    private static final String DB_URL = "rdbms.url";
    private static final String DB_USER = "rdbms.user";
    private static final String DB_PASSWORD = "rdbms.password";
    private static final String DB_IC = "rdbms.initial_connections";
    private static final String DB_MC = "rdbms.maximum_connections";
    private static final String SECSTORE_FS_LIB = "secstorefs.lib";
    private static final String SECSTORE_FS_SEC_FILE = "secstorefs.secfile";
    private static final String SECSTORE_FS_KEY_FILE = "secstorefs.keyfile";
    private static final String RDBMS_CONNECTION = "rdbms.connection";
    private static final String SYSTEM_NAME = "system.name";
    private static final String DISPATCHER_DIR_PREFIX = "dispatcher";
    private static final String SERVER_DIR_PREFIX = "server";
    private static final String JAVA_PATH_KEY = "java.path";
    private static final String JAVA_PARAMS_KEY = "java.parameters";
    private static final String JAVA_MAX_HEAP_SIZE_KEY = "java.max.heap.size";
    private Integer sid;
    private String bn;
    private String type;
    private Boolean r3;
    private String osName;
    private Integer osBitLength;
    private Boolean osUnicode;
    private String dbDriverLocation;
    private String dbUrl;
    private String dbUser;
    private String dbPassword;
    private Integer dbIC;
    private Integer dbMC;
    private String secstoreFSLib;
    private String secstoreFSSecfile;
    private String secstoreFSKeyfile;
    private String rdbmsConnection;
    private String sysName;
    private String javaPath;
    private Integer maxHeapSize;
    private String additionalJavaParams;
    private String installDir;
    private ClusterElement newClusterElement;
    private boolean loadLogConfiguration = false;

    public CreateNewElementTask() {
        super(NAME);
    }

    public Task newInstance() {
        return new CreateNewElementTask();
    }

    public Properties getTaskProperties() {
        Properties taskProperties = new Properties();
        PropertiesUtil.setIntegerProperty(taskProperties, SID_KEY, this.sid);
        PropertiesUtil.setProperty(taskProperties, BN_KEY, this.bn);
        PropertiesUtil.setProperty(taskProperties, TYPE_KEY, this.type);
        PropertiesUtil.setBooleanProperty(taskProperties, R3_KEY, this.r3, "yes");
        PropertiesUtil.setProperty(taskProperties, OS_NAME_KEY, this.osName);
        PropertiesUtil.setIntegerProperty(taskProperties, OS_BIT_LENGTH_KEY, this.osBitLength);
        PropertiesUtil.setBooleanProperty(taskProperties, OS_UNICODE_KEY, this.osUnicode, "yes");
        PropertiesUtil.setProperty(taskProperties, DB_DRIVER_LOCATION, this.dbDriverLocation);
        PropertiesUtil.setProperty(taskProperties, DB_URL, this.dbUrl);
        PropertiesUtil.setProperty(taskProperties, DB_USER, this.dbUser);
        PropertiesUtil.setProperty(taskProperties, DB_PASSWORD, this.dbPassword);
        PropertiesUtil.setIntegerProperty(taskProperties, DB_IC, this.dbIC);
        PropertiesUtil.setIntegerProperty(taskProperties, DB_MC, this.dbMC);
        PropertiesUtil.setProperty(taskProperties, SECSTORE_FS_LIB, this.secstoreFSLib);
        PropertiesUtil.setProperty(taskProperties, SECSTORE_FS_SEC_FILE, this.secstoreFSSecfile);
        PropertiesUtil.setProperty(taskProperties, SECSTORE_FS_KEY_FILE, this.secstoreFSKeyfile);
        PropertiesUtil.setProperty(taskProperties, RDBMS_CONNECTION, this.rdbmsConnection);
        PropertiesUtil.setProperty(taskProperties, SYSTEM_NAME, this.sysName);
        PropertiesUtil.setProperty(taskProperties, JAVA_PATH_KEY, this.javaPath);
        PropertiesUtil.setIntegerProperty(taskProperties, JAVA_MAX_HEAP_SIZE_KEY, this.maxHeapSize);
        PropertiesUtil.setProperty(taskProperties, JAVA_PARAMS_KEY, this.additionalJavaParams);
        return taskProperties;
    }

    public void setTaskProperties(Properties taskProperties) throws Exception {
        this.setSid(PropertiesUtil.getIntegerProperty(taskProperties, SID_KEY));
        this.setBn(PropertiesUtil.getProperty(taskProperties, BN_KEY));
        this.setType(PropertiesUtil.getProperty(taskProperties, TYPE_KEY));
        this.setR3(PropertiesUtil.getBooleanProperty(taskProperties, R3_KEY, "yes"));
        this.setOsName(PropertiesUtil.getProperty(taskProperties, OS_NAME_KEY));
        this.setOsBitLength(PropertiesUtil.getIntegerProperty(taskProperties, OS_BIT_LENGTH_KEY));
        this.setOsUnicode(PropertiesUtil.getBooleanProperty(taskProperties, OS_UNICODE_KEY, "yes"));
        this.setDbDriverLocation(PropertiesUtil.getProperty(taskProperties, DB_DRIVER_LOCATION));
        this.setDbUrl(PropertiesUtil.getProperty(taskProperties, DB_URL));
        this.setDbUser(PropertiesUtil.getProperty(taskProperties, DB_USER));
        this.setDbPassword(PropertiesUtil.getProperty(taskProperties, DB_PASSWORD));
        this.setDbIC(PropertiesUtil.getIntegerProperty(taskProperties, DB_IC));
        this.setDbMC(PropertiesUtil.getIntegerProperty(taskProperties, DB_MC));
        this.setSecstoreFSLib(PropertiesUtil.getProperty(taskProperties, SECSTORE_FS_LIB));
        this.setSecstoreFSSecfile(PropertiesUtil.getProperty(taskProperties, SECSTORE_FS_SEC_FILE));
        this.setSecstoreFSKeyfile(PropertiesUtil.getProperty(taskProperties, SECSTORE_FS_KEY_FILE));
        this.setRdbmsConnection(PropertiesUtil.getProperty(taskProperties, RDBMS_CONNECTION));
        this.setSysName(PropertiesUtil.getProperty(taskProperties, SYSTEM_NAME));
        this.setJavaPath(PropertiesUtil.getProperty(taskProperties, JAVA_PATH_KEY));
        this.setMaxHeapSize(PropertiesUtil.getIntegerProperty(taskProperties, JAVA_MAX_HEAP_SIZE_KEY));
        this.setAdditionalJavaParams(PropertiesUtil.getProperty(taskProperties, JAVA_PARAMS_KEY));
    }

    public void go(ConfigurationHandler cfgHandler) {
        PropertySheet instancePropsSheet;
        Configuration instancePropsCfg;
        this.fireInfoLog("\n");
        if (this.osName != null && this.osBitLength != null && this.osUnicode != null) {
            this.fireInfoLog("  os.name: " + this.osName);
            this.fireInfoLog("  os.bit.length: " + this.osBitLength.toString());
            this.fireInfoLog("  os.unicode: " + this.osUnicode.toString());
            this.fireInfoLog("---------------------------------------");
        }
        PortsCalculator calculator = new PortsCalculator(this.sid, this.bn, DISPATCHER_DIR_PREFIX);
        try {
            instancePropsCfg = cfgHandler.openConfiguration("cluster_data/instance.properties." + calculator.getElementIdPrefix(), 0);
            instancePropsSheet = instancePropsCfg.getPropertySheetInterface();
        }
        catch (ConfigurationException ce) {
            instancePropsCfg = null;
            instancePropsSheet = null;
        }
        if (instancePropsSheet == null) {
            this.fireWarningLog("Error occurred while working with Configuration. instance.properties for instance " + calculator.getElementIdPrefix() + " not found.");
            return;
        }
        try {
            this.installDir = (String)instancePropsSheet.getPropertyEntry("instance.install.dir").getValue();
            cfgHandler.closeConfiguration(instancePropsCfg);
        }
        catch (ConfigurationException ce) {
            this.fireCriticalLog("Error occurred while working with Configuration.", ce);
        }
        if (this.type.equals(DISPATCHER_DIR_PREFIX)) {
            this.makeDispatcher(cfgHandler);
        } else if (this.type.equals(SERVER_DIR_PREFIX)) {
            this.makeServer(cfgHandler);
        } else {
            this.fireWarningLog("Unknown element type: " + this.type);
        }
    }

    public ClusterElement getNewClusterElement() {
        return this.newClusterElement;
    }

    private void makeDispatcher(ConfigurationHandler cfgHandler) {
        PortsCalculator calculator = new PortsCalculator(this.sid, this.bn, this.type);
        Properties configData = null;
        try {
            Configuration dispCfg = cfgHandler.openConfiguration("cluster_data/dispatcher", 0);
            configData = calculator.getNewDispatcherConfiguration(CreateNewElementTask.getAllocatedIds(dispCfg, calculator.getElementIdPrefix()));
            cfgHandler.closeConfiguration(dispCfg);
        }
        catch (ConfigurationException ce) {
            this.fireCriticalLog("Error occurred while working with Configuration.", ce);
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.fireWarningLog(ioobe.getMessage(), ioobe);
            return;
        }
        int fullId = Integer.parseInt(configData.getProperty("give me my full ID please"));
        this.newClusterElement = new ClusterElement();
        this.newClusterElement.setName("ID" + String.valueOf(fullId));
        this.newClusterElement.setType(DISPATCHER_DIR_PREFIX);
        this.createDispatcherDb(cfgHandler, fullId, configData);
        this.addInfoToInstanceProps(cfgHandler, DISPATCHER_DIR_PREFIX, "ID" + String.valueOf(fullId));
    }

    private void createDispatcherDb(ConfigurationHandler cfgHandler, int fullId, Properties configData) {
        try {
            Configuration dispCfg = cfgHandler.openConfiguration("cluster_data/dispatcher", 1);
            Configuration newDispCfg = dispCfg.createSubConfiguration("ID" + fullId);
            Configuration elementInfo = newDispCfg.createSubConfiguration("element-info", 1);
            PropertySheet sheet = elementInfo.getPropertySheetInterface();
            sheet.createPropertyEntry(OS_NAME_KEY, (Object)this.osName, DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            sheet.createPropertyEntry(OS_BIT_LENGTH_KEY, (Object)this.osBitLength.toString(), DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            sheet.createPropertyEntry(OS_UNICODE_KEY, (Object)(this.osUnicode != false ? "yes" : "no"), DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            sheet.createPropertyEntry("directory", (Object)DISPATCHER_DIR_PREFIX, DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            sheet.createPropertyEntry(JAVA_PATH_KEY, (Object)this.javaPath, DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            sheet.createPropertyEntry(JAVA_MAX_HEAP_SIZE_KEY, (Object)this.maxHeapSize.toString(), DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            sheet.createPropertyEntry(JAVA_PARAMS_KEY, (Object)(DEFAULT_JAVA_PARAMS + this.additionalJavaParams), DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            sheet.createPropertyEntry("java.main.class", (Object)DEFAULT_JAVA_MAIN_CLASS, DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            sheet.createPropertyEntry("java.main.class.parameters", (Object)DEFAULT_JAVA_MAIN_CLASS_PARAMS, DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            sheet.createPropertyEntry("debuggable", (Object)"no", DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            sheet.createPropertyEntry("java.class.path", (Object)DEFAULT_JAVA_CLASSPATH, DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            sheet.createPropertyEntry("sf.console", (Object)"yes", DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            sheet.createPropertyEntry("sf.execute", (Object)"yes", DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            sheet.createPropertyEntry("sf.restricted.load.balance", (Object)"no", DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            Configuration kernelCfg = newDispCfg.createSubConfiguration("kernel");
            String dispManagerClusterClusterName = configData.getProperty("disp.manager.cluster.cluster.name");
            String dispManagerClusterElementName = configData.getProperty("disp.manager.cluster.element.name");
            String dispManagerClusterElementClusterId = configData.getProperty("disp.manager.cluster.element.clusterId");
            String dispManagerClusterElementGroupId = configData.getProperty("disp.manager.cluster.element.groupId");
            Configuration cmCfg = kernelCfg.createSubConfiguration("ClusterManager", 1);
            sheet = cmCfg.getPropertySheetInterface();
            Manager manager = new Manager("ClusterManager");
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, manager, "cluster.name", dispManagerClusterClusterName);
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, manager, "element.name", dispManagerClusterElementName);
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, manager, "element.clusterId", dispManagerClusterElementClusterId);
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, manager, "element.groupId", dispManagerClusterElementGroupId);
            Configuration cfgmCfg = kernelCfg.createSubConfiguration("ConfigurationManager", 1);
            sheet = cfgmCfg.getPropertySheetInterface();
            manager = new Manager("ConfigurationManager");
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, manager, DB_DRIVER_LOCATION, this.dbDriverLocation);
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, manager, DB_URL, this.dbUrl);
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, manager, DB_USER, this.dbUser);
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, manager, DB_PASSWORD, this.dbPassword);
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, manager, DB_IC, this.dbIC.toString());
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, manager, DB_MC, this.dbMC.toString());
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, manager, SECSTORE_FS_LIB, this.secstoreFSLib);
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, manager, SECSTORE_FS_SEC_FILE, this.secstoreFSSecfile);
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, manager, SECSTORE_FS_KEY_FILE, this.secstoreFSKeyfile);
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, manager, RDBMS_CONNECTION, this.rdbmsConnection);
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, manager, SYSTEM_NAME, this.sysName);
            Configuration smCfg = kernelCfg.createSubConfiguration("ServiceManager", 1);
            sheet = smCfg.getPropertySheetInterface();
            manager = new Manager("ServiceManager");
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, manager, "FileMode", "false");
            Configuration servicesCfg = newDispCfg.createSubConfiguration("services");
            String dispServiceHttpPort = configData.getProperty("disp.service.http.Port");
            String dispServiceHttpSslPort = configData.getProperty("disp.service.http.SslPort");
            Configuration httpCfg = servicesCfg.createSubConfiguration("http", 1);
            sheet = httpCfg.getPropertySheetInterface();
            Service service = new Service("http");
            TaskUtil.setServiceDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, service, "Ports", "(Port:" + dispServiceHttpPort + "," + "Type:" + "http" + ")" + "(" + "Port:" + dispServiceHttpSslPort + "," + "Type:" + "ssl" + ")");
            String dispServiceIiopPort = configData.getProperty("disp.service.iiop.port");
            String dispServiceIiopICPort = configData.getProperty("disp.service.iiop.initialContextPort");
            String dispServiceIiopSslSocketPort = configData.getProperty("disp.service.iiop.ssl_socket");
            Configuration iiopCfg = servicesCfg.createSubConfiguration("iiop", 1);
            sheet = iiopCfg.getPropertySheetInterface();
            service = new Service("iiop");
            TaskUtil.setServiceDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, service, "port", dispServiceIiopPort);
            TaskUtil.setServiceDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, service, "initialContextPort", dispServiceIiopICPort);
            TaskUtil.setServiceDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, service, "ssl_socket", dispServiceIiopSslSocketPort);
            String dispServiceLogViewerPort = configData.getProperty("disp.service.log.viewer.port");
            Configuration logViewerCfg = servicesCfg.createSubConfiguration("tc.monitoring.logviewer", 1);
            sheet = logViewerCfg.getPropertySheetInterface();
            service = new Service("tc.monitoring.logviewer");
            TaskUtil.setServiceDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, service, "Logviewer_socketPort", dispServiceLogViewerPort);
            String dispDerviceP4Port = configData.getProperty("disp.service.p4.port");
            String dispServiceP4Ssl = configData.getProperty("disp.service.p4.ssl");
            String dispServiceP4HttpTunneling = configData.getProperty("disp.service.p4.httptunneling");
            Configuration p4Cfg = servicesCfg.createSubConfiguration("p4", 1);
            sheet = p4Cfg.getPropertySheetInterface();
            service = new Service("p4");
            TaskUtil.setServiceDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, service, "port", dispDerviceP4Port);
            TaskUtil.setServiceDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, service, "ssl", dispServiceP4Ssl);
            TaskUtil.setServiceDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, service, "httptunneling", dispServiceP4HttpTunneling);
            String dispServiceTelnetPort = configData.getProperty("disp.service.telnet.port");
            Configuration telnetCfg = servicesCfg.createSubConfiguration("telnet", 1);
            sheet = telnetCfg.getPropertySheetInterface();
            service = new Service("telnet");
            TaskUtil.setServiceDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, service, "port", dispServiceTelnetPort);
            String dispServiceJmsTcpPort = configData.getProperty("disp.service.jms.port");
            Configuration jmsCfg = servicesCfg.createSubConfiguration("jms_provider", 1);
            sheet = jmsCfg.getPropertySheetInterface();
            service = new Service("jms_provider");
            TaskUtil.setServiceDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, service, "/tcp", dispServiceJmsTcpPort);
            Configuration r3StartupCfg = servicesCfg.createSubConfiguration("r3startup", 1);
            sheet = r3StartupCfg.getPropertySheetInterface();
            service = new Service("r3startup");
            TaskUtil.setServiceDefaultPropertyEntry(cfgHandler, sheet, DISPATCHER_DIR_PREFIX, service, "elements", String.valueOf(0));
            String startupMode = this.r3 != false ? "always" : "manual";
            Configuration r3StartupRuntime = servicesCfg.createSubConfiguration("r3startup-runtime", 1);
            sheet = r3StartupRuntime.getPropertySheetInterface();
            sheet.createPropertyEntry("startup-mode", (Object)startupMode, DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            service.setStartupMode(startupMode);
            this.fireInfoLog("  Port Offset (by system number)= " + this.sid * 100);
            this.fireInfoLog("---------------------------------------");
            this.fireInfoLog("  disp cluster id = " + dispManagerClusterElementClusterId);
            this.fireInfoLog("  disp group id = " + dispManagerClusterElementGroupId);
            this.fireInfoLog("  disp cluster name = " + dispManagerClusterClusterName);
            this.fireInfoLog("  disp element name = " + dispManagerClusterElementName);
            this.fireInfoLog("---------------------------------------");
            this.fireInfoLog("  http port = " + dispServiceHttpPort);
            this.fireInfoLog("  http over ssl port = " + dispServiceHttpSslPort);
            this.fireInfoLog("  p4 port = " + dispDerviceP4Port);
            this.fireInfoLog("  p4 over http port = " + dispServiceP4HttpTunneling);
            this.fireInfoLog("  p4 over ssl port = " + dispServiceP4Ssl);
            this.fireInfoLog("  iiop port = " + dispServiceIiopPort);
            this.fireInfoLog("  telnet port = " + dispServiceTelnetPort);
            this.fireInfoLog("  iiop initial context port = " + dispServiceIiopICPort);
            this.fireInfoLog("  iiop ssl socket = " + dispServiceIiopSslSocketPort);
            this.fireInfoLog("  jms port = " + dispServiceJmsTcpPort);
            this.fireInfoLog("---------------------------------------");
            cfgHandler.commit();
            cfgHandler.closeConfiguration(dispCfg);
        }
        catch (ConfigurationException ce) {
            this.fireCriticalLog("Error occurred while working with Configuration.", ce);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void makeServer(ConfigurationHandler cfgHandler) {
        block16: {
            calculator = new PortsCalculator(this.sid, this.bn, this.type);
            configData = null;
            servCfg = null;
            try {
                servCfg = cfgHandler.openConfiguration("cluster_data/server", 0);
                configData = calculator.getNewServerConfiguration(CreateNewElementTask.getAllocatedIds(servCfg, calculator.getElementIdPrefix()));
                var8_5 = null;
                ** if (servCfg == null) goto lbl-1000
            }
            catch (Throwable var7_17) {
                var8_7 = null;
                if (servCfg != null) {
                    try {
                        cfgHandler.closeConfiguration(servCfg);
                    }
                    catch (ConfigurationException e) {
                        this.fireWarningLog("Can't close configuration 'cluster_data/server'", e);
                    }
                }
                throw var7_17;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    cfgHandler.closeConfiguration(servCfg);
                }
                catch (ConfigurationException e) {
                    this.fireWarningLog("Can't close configuration 'cluster_data/server'", e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block16;
                catch (ConfigurationException ce) {
                    this.fireCriticalLog("Error occurred while working with Configuration.", ce);
                    var8_5 = null;
                    if (servCfg != null) {
                        try {
                            cfgHandler.closeConfiguration(servCfg);
                        }
                        catch (ConfigurationException e) {
                            this.fireWarningLog("Can't close configuration 'cluster_data/server'", e);
                        }
                    }
                    break block16;
                }
                catch (IndexOutOfBoundsException ioobe) {
                    this.fireWarningLog(ioobe.getMessage(), ioobe);
                    var8_6 = null;
                    if (servCfg != null) {
                        try {
                            cfgHandler.closeConfiguration(servCfg);
                        }
                        catch (ConfigurationException e) {
                            this.fireWarningLog("Can't close configuration 'cluster_data/server'", e);
                        }
                    }
                    return;
                }
            }
        }
        id = Integer.parseInt(configData.getProperty("give me my ID please"));
        fullId = Integer.parseInt(configData.getProperty("give me my full ID please"));
        this.newClusterElement = new ClusterElement();
        this.newClusterElement.setName("ID" + fullId);
        this.newClusterElement.setType("server");
        this.createServerDb(cfgHandler, id, fullId, configData);
        fullInstallDir = null;
        try {
            fullInstallDir = new File(this.installDir + File.separator + "cluster" + File.separator + "server" + String.valueOf(id)).getCanonicalPath();
        }
        catch (IOException ioe) {
            this.fireCriticalLog("Error occurred while setting up FS items.", ioe);
        }
        this.changeDispatcherR3Startup(cfgHandler, fullId, fullInstallDir);
        this.addInfoToInstanceProps(cfgHandler, "server" + String.valueOf(id), "ID" + String.valueOf(fullId));
    }

    private void createServerDb(ConfigurationHandler cfgHandler, int id, int fullId, Properties configData) {
        try {
            Configuration servCfg = cfgHandler.openConfiguration("cluster_data/server", 1);
            Configuration newServerCfg = servCfg.createSubConfiguration("ID" + String.valueOf(fullId));
            String servElementInfoDebugPort = configData.getProperty("serv.debug.port");
            Configuration elementInfo = newServerCfg.createSubConfiguration("element-info", 1);
            PropertySheet sheet = elementInfo.getPropertySheetInterface();
            sheet.createPropertyEntry("debug.port", (Object)servElementInfoDebugPort, DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            sheet.createPropertyEntry("directory", (Object)(SERVER_DIR_PREFIX + id), DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            Properties elementInfoProps = new Properties();
            ((Hashtable)elementInfoProps).put("debug.port", servElementInfoDebugPort);
            this.newClusterElement.setElementInfo(new Properties(), elementInfoProps);
            TreeMap<String, Manager> managers = new TreeMap<String, Manager>();
            Configuration kernelCfg = newServerCfg.createSubConfiguration("kernel");
            String servManagerClusterClusterName = configData.getProperty("serv.manager.cluster.cluster.name");
            String servManagerClusterElementName = configData.getProperty("serv.manager.cluster.element.name");
            String servManagerClusterElementClusterId = configData.getProperty("serv.manager.cluster.element.clusterId");
            String servManagerClusterElementGroupId = configData.getProperty("serv.manager.cluster.element.groupId");
            String servManagerClusterElementJoinPort = configData.getProperty("serv.manager.cluster.element.joinPort");
            Configuration cmCfg = kernelCfg.createSubConfiguration("ClusterManager", 1);
            sheet = cmCfg.getPropertySheetInterface();
            Manager manager = new Manager("ClusterManager");
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, "cluster.name", servManagerClusterClusterName);
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, "element.name", servManagerClusterElementName);
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, "element.clusterId", servManagerClusterElementClusterId);
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, "element.groupId", servManagerClusterElementGroupId);
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, "element.joinPort", servManagerClusterElementJoinPort);
            managers.put("ClusterManager", manager);
            Configuration cfgmCfg = kernelCfg.createSubConfiguration("ConfigurationManager", 1);
            sheet = cfgmCfg.getPropertySheetInterface();
            manager = new Manager("ConfigurationManager");
            if (fullId % 100 == 50) {
                TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, DB_DRIVER_LOCATION, this.dbDriverLocation);
                TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, DB_URL, this.dbUrl);
                TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, DB_USER, this.dbUser);
                TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, DB_PASSWORD, this.dbPassword);
                TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, DB_IC, this.dbIC.toString());
                TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, DB_MC, this.dbMC.toString());
                TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, SECSTORE_FS_LIB, this.secstoreFSLib);
                TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, SECSTORE_FS_SEC_FILE, this.secstoreFSSecfile);
                TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, SECSTORE_FS_KEY_FILE, this.secstoreFSKeyfile);
                TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, RDBMS_CONNECTION, this.rdbmsConnection);
                TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, SYSTEM_NAME, this.sysName);
            } else {
                Configuration firstServerCfg = servCfg.getSubConfiguration("ID" + String.valueOf(fullId / 100) + "50");
                Configuration managerCfg = firstServerCfg.getSubConfiguration("kernel").getSubConfiguration("ConfigurationManager");
                PropertyEntry[] properties = managerCfg.getPropertySheetInterface().getAllPropertyEntries();
                int i = 0;
                while (i < properties.length) {
                    TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, properties[i].getName(), (String)properties[i].getDefault());
                    ++i;
                }
            }
            managers.put("ConfigurationManager", manager);
            Configuration smCfg = kernelCfg.createSubConfiguration("ServiceManager", 1);
            sheet = smCfg.getPropertySheetInterface();
            manager = new Manager("ServiceManager");
            TaskUtil.setManagerDefaultPropertyEntry(cfgHandler, sheet, SERVER_DIR_PREFIX, manager, "FileMode", "false");
            managers.put("ServiceManager", manager);
            this.newClusterElement.setManagers(managers);
            this.fireInfoLog("  serv " + id + " cluster id = " + servManagerClusterElementClusterId);
            this.fireInfoLog("  serv " + id + " group id = " + servManagerClusterElementGroupId);
            this.fireInfoLog("  serv " + id + " cluster name = " + servManagerClusterClusterName);
            this.fireInfoLog("  serv " + id + " element name = " + servManagerClusterElementName);
            this.fireInfoLog("---------------------------------------");
            this.fireInfoLog("  serv " + id + " join port = " + servManagerClusterElementJoinPort);
            this.fireInfoLog("  serv " + id + " debug port = " + servElementInfoDebugPort);
            this.fireInfoLog("---------------------------------------");
            if (this.loadLogConfiguration) {
                new Scanner(cfgHandler).scanElementLogConfiguration(this.newClusterElement, servCfg, newServerCfg);
            }
            cfgHandler.commit();
            cfgHandler.closeConfiguration(servCfg);
        }
        catch (ConfigurationException ce) {
            this.fireCriticalLog("Error occurred while working with Configuration.", ce);
        }
    }

    private void changeDispatcherR3Startup(ConfigurationHandler cfgHandler, int fullId, String installDir) {
        int dispatcherId = fullId / 100 * 100;
        Configuration dispR3StartupCfg = null;
        try {
            dispR3StartupCfg = cfgHandler.openConfiguration("cluster_data/dispatcher/ID" + String.valueOf(dispatcherId) + "/" + "services" + "/" + "r3startup", 1);
        }
        catch (ConfigurationException ce) {
            this.fireWarningLog("Error occurred while working with Configuration.", ce);
        }
        if (dispR3StartupCfg != null) {
            try {
                PropertySheet props = dispR3StartupCfg.getPropertySheetInterface();
                int elements = Integer.parseInt((String)props.getPropertyEntry("elements").getValue());
                TaskUtil.setPropertyDefaultValue(props, "elements", DEFAULT_JAVA_MAIN_CLASS_PARAMS + (elements + 1));
                TaskUtil.setPropertyDefaultValue(props, "element_" + elements + "_id", fullId + DEFAULT_JAVA_MAIN_CLASS_PARAMS);
                TaskUtil.setPropertyDefaultValue(props, "element_" + elements + "_dir", installDir);
                this.fireInfoLog("  r3startup elements = " + elements);
                this.fireInfoLog("  r3startup element_" + elements + "_id  = " + fullId);
                this.fireInfoLog("  r3startup element_" + elements + "_dir = " + installDir);
                this.fireInfoLog("---------------------------------------");
                cfgHandler.commit();
                cfgHandler.closeConfiguration(dispR3StartupCfg);
            }
            catch (ConfigurationException ce) {
                this.fireCriticalLog("Error occurred while working with Configuration." + (Object)((Object)ce));
            }
        }
    }

    private void addInfoToInstanceProps(ConfigurationHandler cfgHandler, String elementName, String elementIDName) {
        String installParentPath = new File(this.installDir).getParent();
        String globalPath = null;
        if (installParentPath != null && (globalPath = new File(installParentPath).getParent()) != null) {
            globalPath = globalPath.endsWith(File.separator) ? globalPath + Constants.PATH_SYS_GLOBAL : globalPath + File.separator + Constants.PATH_SYS_GLOBAL;
        }
        Map bootStrapProps = null;
        Properties globalElementInfo = null;
        Properties localElementInfo = new Properties();
        Properties elementProps = null;
        try {
            Configuration bootStrapJvmCfg = cfgHandler.openConfiguration("cluster_data/bootstrap/jvm", 0);
            bootStrapProps = bootStrapJvmCfg.getPropertySheetInterface().getPropertyMap();
            cfgHandler.closeConfiguration(bootStrapJvmCfg);
            if (this.newClusterElement.getType().equals(SERVER_DIR_PREFIX)) {
                globalElementInfo = TaskUtil.getInstanceElementInfo(TaskUtil.getInstanceName(elementIDName), cfgHandler);
                localElementInfo = TaskUtil.getLocalElementInfo(elementIDName, this.type, cfgHandler);
                elementProps = PropertiesUtil.mergeProperties(globalElementInfo, localElementInfo);
            } else {
                elementProps = localElementInfo = TaskUtil.getLocalElementInfo(elementIDName, this.type, cfgHandler);
            }
        }
        catch (ConfigurationException ce) {
            this.fireCriticalLog("Error occurred while working with Configuration.", ce);
        }
        try {
            String debugPort;
            PortsCalculator calculator = new PortsCalculator(this.sid, this.bn, DISPATCHER_DIR_PREFIX);
            Configuration instancePropsCfg = cfgHandler.openConfiguration("cluster_data/instance.properties." + calculator.getElementIdPrefix(), 1);
            String bootStrapKeysPrefix = "bootstrap_" + elementIDName + ".";
            PropertySheet sheetProperties = instancePropsCfg.getPropertySheetInterface();
            TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeysPrefix + "Name", elementName + " bootstrap");
            TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeysPrefix + "Type", "bootstrap");
            String javaPath = (String)((Hashtable)elementProps).get(JAVA_PATH_KEY);
            if (javaPath != null) {
                TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeysPrefix + "JavaPath", javaPath.replace('\\', '/'));
            }
            TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeysPrefix + "MaxHeapSize", (String)((Hashtable)elementProps).get(JAVA_MAX_HEAP_SIZE_KEY));
            String bsClassPath = (String)bootStrapProps.get("java.class.path");
            TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeysPrefix + "ClassPath", bsClassPath.replace('\\', '/').replace(';', ':'));
            TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeysPrefix + "JavaParameters", ((String)bootStrapProps.get(JAVA_PARAMS_KEY)).replace('\\', '/'));
            TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeysPrefix + "MainClass", (String)bootStrapProps.get("java.main.class"));
            String realId = elementIDName.substring(2);
            realId = "ID" + PortsCalculator.appendIntToString(realId, 9);
            TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeysPrefix + "Parameters", bootStrapProps.get("java.main.class.parameters") + " " + realId);
            TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeysPrefix + "RootPath", (this.installDir + File.separator + "cluster").replace('\\', '/'));
            TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeysPrefix + "JLaunchParameters", DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            String elementKeysPrefix = elementIDName + ".";
            TaskUtil.setPropertyEntryValue(sheetProperties, elementKeysPrefix + "Name", elementName);
            TaskUtil.setPropertyEntryValue(sheetProperties, elementKeysPrefix + "Type", this.type);
            if (javaPath != null) {
                TaskUtil.setPropertyEntryValue(sheetProperties, elementKeysPrefix + "JavaPath", ((String)((Hashtable)elementProps).get(JAVA_PATH_KEY)).replace('\\', '/'));
            }
            TaskUtil.setPropertyEntryValue(sheetProperties, elementKeysPrefix + "MaxHeapSize", (String)((Hashtable)elementProps).get(JAVA_MAX_HEAP_SIZE_KEY));
            TaskUtil.setPropertyEntryValue(sheetProperties, elementKeysPrefix + "ClassPath", ((String)((Hashtable)elementProps).get("java.class.path")).replace('\\', '/').replace(';', ':'));
            TaskUtil.setPropertyEntryValue(sheetProperties, elementKeysPrefix + "JavaParameters", ((String)((Hashtable)elementProps).get(JAVA_PARAMS_KEY)).replace('\\', '/').replace(';', ':'));
            TaskUtil.setPropertyEntryValue(sheetProperties, elementKeysPrefix + "MainClass", (String)((Hashtable)elementProps).get("java.main.class"));
            TaskUtil.setPropertyEntryValue(sheetProperties, elementKeysPrefix + "Parameters", ((String)((Hashtable)elementProps).get("java.main.class.parameters")).replace('\\', '/'));
            TaskUtil.setPropertyEntryValue(sheetProperties, elementKeysPrefix + "JLaunchParameters", DEFAULT_JAVA_MAIN_CLASS_PARAMS);
            String javaParams = (String)((Hashtable)elementProps).get(JAVA_PARAMS_KEY);
            String driverLocation = this.dbDriverLocation;
            if (driverLocation.indexOf(" ") != -1) {
                driverLocation = "\"" + driverLocation + "\"";
            }
            if (globalPath != null) {
                javaParams = javaParams + " -Drdbms.driverLocation=" + driverLocation + " -D" + "sys.global.dir" + "=" + globalPath;
            }
            TaskUtil.setPropertyEntryValue(sheetProperties, elementKeysPrefix + "JavaParameters", javaParams.replace('\\', '/').replace(';', ':'));
            TaskUtil.setPropertyEntryValue(sheetProperties, elementKeysPrefix + "RootPath", (this.installDir + File.separator + "cluster" + File.separator + elementName).replace('\\', '/'));
            TaskUtil.setPropertyEntryValue(sheetProperties, elementKeysPrefix + "Debuggable", (String)((Hashtable)elementProps).get("debuggable"));
            String debugMode = (String)((Hashtable)elementProps).get("debug.enabled");
            if (debugMode != null) {
                TaskUtil.setPropertyEntryValue(sheetProperties, elementKeysPrefix + "DebugMode", debugMode);
            }
            if ((debugPort = (String)((Hashtable)elementProps).get("debug.port")) != null) {
                TaskUtil.setPropertyEntryValue(sheetProperties, elementKeysPrefix + "DebugPort", debugPort);
            }
            TaskUtil.setPropertyEntryValue(sheetProperties, elementKeysPrefix + "LogName", elementName);
            if (this.newClusterElement.getType().equals(SERVER_DIR_PREFIX)) {
                if (javaPath != null) {
                    localElementInfo.setProperty(bootStrapKeysPrefix + "JavaPath", javaPath.replace('\\', '/'));
                }
                localElementInfo.setProperty(bootStrapKeysPrefix + "MaxHeapSize", (String)((Hashtable)elementProps).get(JAVA_MAX_HEAP_SIZE_KEY));
                localElementInfo.setProperty(bootStrapKeysPrefix + "ClassPath", bsClassPath.replace('\\', '/').replace(';', ':'));
                localElementInfo.setProperty(bootStrapKeysPrefix + "JavaParameters", ((String)bootStrapProps.get(JAVA_PARAMS_KEY)).replace('\\', '/'));
                localElementInfo.setProperty(bootStrapKeysPrefix + "Parameters", bootStrapProps.get("java.main.class.parameters") + " " + realId);
                this.newClusterElement.setElementInfo(globalElementInfo, localElementInfo);
            }
            cfgHandler.commit();
            cfgHandler.closeConfiguration(instancePropsCfg);
        }
        catch (ConfigurationException ce) {
            this.fireCriticalLog("Error occurred while working with Configuration.", ce);
        }
    }

    private static int[] getAllocatedIds(Configuration cfg, String prefix) throws ConfigurationException {
        ArrayList<Integer> allocatedIds = new ArrayList<Integer>(11);
        Map allCfgs = cfg.getAllSubConfigurations();
        Iterator cfgNames = allCfgs.keySet().iterator();
        while (cfgNames.hasNext()) {
            String cfgName = (String)cfgNames.next();
            if (!cfgName.startsWith(prefix)) continue;
            allocatedIds.add(Integer.valueOf(cfgName.substring("ID".length())));
        }
        int[] result = new int[allocatedIds.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (Integer)allocatedIds.get(i);
            ++i;
        }
        return result;
    }

    public Integer getSid() {
        return this.sid;
    }

    public void setSid(Integer sid) {
        if (sid == null) {
            throw new IllegalArgumentException("Error occurred while reading system.id");
        }
        this.sid = sid;
    }

    public String getBn() {
        return this.bn;
    }

    public void setBn(String bn) {
        this.bn = bn;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Error occurred while reading type");
        }
        this.type = type;
    }

    public Boolean getR3() {
        return this.r3;
    }

    public void setR3(Boolean r3) {
        if (r3 == null) {
            throw new IllegalArgumentException("Error occurred while reading r3.environment");
        }
        this.r3 = r3;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public Integer getOsBitLength() {
        return this.osBitLength;
    }

    public void setOsBitLength(Integer osBitLength) {
        this.osBitLength = osBitLength;
    }

    public Boolean getOsUnicode() {
        return this.osUnicode;
    }

    public void setOsUnicode(Boolean osUnicode) {
        this.osUnicode = osUnicode;
    }

    public String getDbDriverLocation() {
        return this.dbDriverLocation;
    }

    public void setDbDriverLocation(String dbDriverLocation) {
        this.dbDriverLocation = dbDriverLocation;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public Integer getDbIC() {
        return this.dbIC;
    }

    public void setDbIC(Integer dbIC) {
        this.dbIC = dbIC;
    }

    public Integer getDbMC() {
        return this.dbMC;
    }

    public void setDbMC(Integer dbMC) {
        this.dbMC = dbMC;
    }

    public void setSecstoreFSLib(String secstoreFSLib) {
        this.secstoreFSLib = secstoreFSLib;
    }

    public String getSecstoreFSLib() {
        return this.secstoreFSLib;
    }

    public void setSecstoreFSSecfile(String secstoreFSSecfile) {
        this.secstoreFSSecfile = secstoreFSSecfile;
    }

    public String getSecstoreFSSecfile() {
        return this.secstoreFSSecfile;
    }

    public void setSecstoreFSKeyfile(String secstoreFSKeyfile) {
        this.secstoreFSKeyfile = secstoreFSKeyfile;
    }

    public String getSecstoreFSKeyfile() {
        return this.secstoreFSKeyfile;
    }

    public void setRdbmsConnection(String rdbmsConnection) {
        this.rdbmsConnection = rdbmsConnection;
    }

    public String getRdbmsConnection() {
        return this.rdbmsConnection;
    }

    public void setSysName(String sysName) {
        this.sysName = sysName;
    }

    public String getSysName() {
        return this.sysName;
    }

    public void loadLogConfiguration(boolean loadLogConfiguration) {
        this.loadLogConfiguration = loadLogConfiguration;
    }

    public void setJavaPath(String javaPath) {
        this.javaPath = javaPath;
    }

    public void setMaxHeapSize(Integer maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    public void setAdditionalJavaParams(String additionalJavaParams) {
        this.additionalJavaParams = additionalJavaParams;
    }
}

