/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.batch.task.TaskUtil;
import com.sap.engine.configtool.lib.PortsCalculator;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public final class CreateInstancePropsTask
extends Task {
    public static final String NAME = "create.instance.props";
    private static final String SID_KEY = "system.id";
    private static final String BN_KEY = "box.number";
    private static final String MS_HOST_KEY = "ms.host";
    private static final String MS_PORT_KEY = "ms.port";
    private static final String INSTALL_DIR_KEY = "install.dir";
    private static final String DB_DRIVER_LOCATION = "rdbms.driverLocation";
    private static final String JAVA_PATH_KEY = "java.path";
    private Integer sid;
    private String bn;
    private String msHost;
    private Integer msPort;
    private String installDir;
    private String dbDriverLocation;
    private String javaPath;

    public CreateInstancePropsTask() {
        super(NAME);
    }

    public Task newInstance() {
        return new CreateInstancePropsTask();
    }

    public Properties getTaskProperties() {
        Properties props = new Properties();
        PropertiesUtil.setIntegerProperty(props, SID_KEY, this.sid);
        PropertiesUtil.setProperty(props, BN_KEY, this.bn);
        PropertiesUtil.setProperty(props, MS_HOST_KEY, this.msHost);
        PropertiesUtil.setIntegerProperty(props, MS_PORT_KEY, this.msPort);
        PropertiesUtil.setProperty(props, INSTALL_DIR_KEY, this.installDir);
        PropertiesUtil.setProperty(props, DB_DRIVER_LOCATION, this.dbDriverLocation);
        PropertiesUtil.setProperty(props, JAVA_PATH_KEY, this.javaPath);
        return props;
    }

    public void setTaskProperties(Properties taskProperties) throws Exception {
        this.setSid(PropertiesUtil.getIntegerProperty(taskProperties, SID_KEY));
        this.setBn(PropertiesUtil.getProperty(taskProperties, BN_KEY));
        this.setMsHost(PropertiesUtil.getProperty(taskProperties, MS_HOST_KEY, "localhost"));
        this.setMsPort(PropertiesUtil.getIntegerProperty(taskProperties, MS_PORT_KEY, "3604"));
        this.setInstallDir(PropertiesUtil.getProperty(taskProperties, INSTALL_DIR_KEY));
        this.setDbDriverLocation(PropertiesUtil.getProperty(taskProperties, DB_DRIVER_LOCATION));
        this.setJavaPath(PropertiesUtil.getProperty(taskProperties, JAVA_PATH_KEY));
    }

    public void go(ConfigurationHandler cfgHandler) {
        PortsCalculator calculator = new PortsCalculator(this.sid, this.bn, "dispatcher");
        String prefix = calculator.getElementIdPrefix();
        try {
            Configuration rootCfg = cfgHandler.openConfiguration("cluster_data", 1);
            String instancePropsName = "instance.properties." + prefix;
            Configuration instancePropsCfg = rootCfg.existsSubConfiguration(instancePropsName) ? rootCfg.getSubConfiguration(instancePropsName) : rootCfg.createSubConfiguration(instancePropsName, 1);
            PropertySheet sheetProperties = instancePropsCfg.getPropertySheetInterface();
            TaskUtil.setPropertyEntryValue(sheetProperties, "instance.ms.host", this.msHost);
            TaskUtil.setPropertyEntryIntegerValue(sheetProperties, "instance.ms.port", this.msPort);
            TaskUtil.setPropertyEntryValue(sheetProperties, "instance.install.dir", this.installDir);
            TaskUtil.setPropertyEntryValue(sheetProperties, "instance.box.number", this.bn);
            TaskUtil.setPropertyEntryIntegerValue(sheetProperties, "instance.system.id", this.sid);
            Map bootStrapProps = null;
            try {
                Configuration bootStrapJvmCfg = cfgHandler.openConfiguration("cluster_data/bootstrap/jvm", 0);
                bootStrapProps = bootStrapJvmCfg.getPropertySheetInterface().getPropertyMap();
                cfgHandler.closeConfiguration(bootStrapJvmCfg);
            }
            catch (ConfigurationException ce) {
                this.fireCriticalLog("Error occurred while working with Configuration.", ce);
            }
            String bootStrapKeys = "bootstrap.";
            String bsClassPath = (String)bootStrapProps.get("java.class.path");
            TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeys + "ClassPath", bsClassPath.replace('\\', '/').replace(';', ':'));
            TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeys + "JavaParameters", ((String)bootStrapProps.get("java.parameters")).replace('\\', '/'));
            TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeys + "MainClass", (String)bootStrapProps.get("java.main.class"));
            String realPrefix = prefix.substring(2);
            realPrefix = "ID" + PortsCalculator.appendIntToString(realPrefix, 7);
            TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeys + "Parameters", bootStrapProps.get("java.main.class.parameters") + " " + realPrefix);
            TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeys + "RootPath", (this.installDir + File.separator + "cluster").replace('\\', '/'));
            if (this.javaPath != null) {
                TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeys + "JavaPath", this.javaPath.replace('\\', '/'));
            }
            TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeys + "Type", "bootstrap");
            TaskUtil.setPropertyEntryValue(sheetProperties, bootStrapKeys + "Name", "bootstrap");
            TaskUtil.setPropertyEntryIntegerValue(sheetProperties, bootStrapKeys + "MaxHeapSize", new Integer(512));
            this.installDir = this.installDir.replace('\\', '/');
            if (!this.installDir.endsWith("/")) {
                this.installDir = this.installDir + "/";
            }
            TaskUtil.setPropertyEntryValue(sheetProperties, "instance.osLibsPath", this.installDir + "os_libs");
            new File(this.installDir + File.separator + "cluster").mkdirs();
            String instancePropsFileName = this.installDir + File.separator + "cluster" + File.separator + "instance.properties";
            this.savePropertiesToFile(instancePropsFileName, sheetProperties.getProperties());
            cfgHandler.commit();
            cfgHandler.closeConfiguration(rootCfg);
        }
        catch (ConfigurationException ce) {
            this.fireCriticalLog("Error occurred while working with Configuration.", ce);
        }
    }

    private void savePropertiesToFile(String fileName, Properties props) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            Enumeration keys = ((Hashtable)props).keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String line = key + "=" + props.getProperty(key);
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
            writer.close();
        }
        catch (IOException ioe) {
            this.fireWarningLog("Error occurred while creating instance.properties file. Startup Framework won't work", ioe);
        }
    }

    public Integer getSid() {
        return this.sid;
    }

    public void setSid(Integer sid) {
        if (sid == null) {
            throw new IllegalArgumentException("Error occurred while reading system.id");
        }
        this.sid = sid;
    }

    public String getBn() {
        return this.bn;
    }

    public void setBn(String bn) {
        this.bn = bn;
    }

    public String getMsHost() {
        return this.msHost;
    }

    public void setMsHost(String msHost) {
        if (msHost == null) {
            throw new IllegalArgumentException("Error occurried while reading ms.host");
        }
        this.msHost = msHost;
    }

    public Integer getMsPort() {
        return this.msPort;
    }

    public void setMsPort(Integer msPort) {
        if (msPort == null) {
            throw new IllegalArgumentException("Error occurried while reading ms.port");
        }
        this.msPort = msPort;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(String installDir) {
        if (installDir == null) {
            throw new IllegalArgumentException("Error occurried while reading install.dir");
        }
        this.installDir = installDir;
    }

    public String getDbDriverLocation() {
        return this.dbDriverLocation;
    }

    public void setDbDriverLocation(String dbDriverLocation) {
        this.dbDriverLocation = dbDriverLocation;
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    public void setJavaPath(String javaPath) {
        this.javaPath = javaPath;
    }
}

