/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.PropertyMap;
import com.sap.engine.configtool.batch.task.ChangeManagerPropsTask;
import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.batch.task.TaskUtil;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import java.util.Map;
import java.util.Properties;

public final class ChangeServicePropsTask
extends Task {
    private static final String NAME = "change.service.properties";
    private static final String ELEMENT_NAME = "element.name";
    private static final String SERVICE_NAME = "service.name";
    private static final String STARTUP_MODE = "startup.mode";
    private String elementName;
    private String serviceName;
    private String startupMode;
    private PropertyMap serviceProperties = new PropertyMap();

    public ChangeServicePropsTask() {
        super(NAME);
    }

    public String getUniqueName() {
        return this.elementName + this.serviceName;
    }

    public Task newInstance() {
        return new ChangeServicePropsTask();
    }

    public void go(ConfigurationHandler cfgHandler) {
        block6: {
            try {
                try {
                    String elementPath = TaskUtil.getElementConfigurationPath(this.elementName, cfgHandler);
                    TaskUtil.changeProperties(cfgHandler, elementPath, "services", this.serviceName, this.serviceProperties);
                    if (this.startupMode != null) {
                        PropertyMap runtimeProps = new PropertyMap();
                        runtimeProps.put("startup-mode", this.startupMode);
                        TaskUtil.changeProperties(cfgHandler, elementPath, "services", this.serviceName + "-runtime", runtimeProps);
                    }
                    this.fireInfoLog("ChangeServicePropsTask has finished successfully. Service: " + this.serviceName + " on " + this.elementName);
                }
                catch (ConfigurationException ce) {
                    this.fireCriticalLog("Error occurred while working with Configuration.", ce);
                    Object var5_7 = null;
                    this.serviceProperties.clear();
                    break block6;
                }
                catch (IllegalArgumentException iae) {
                    this.fireWarningLog(iae.getMessage(), iae);
                    Object var5_8 = null;
                    this.serviceProperties.clear();
                }
                Object var5_6 = null;
                this.serviceProperties.clear();
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.serviceProperties.clear();
                throw throwable;
            }
        }
    }

    public Properties getTaskProperties() {
        Properties taskProperties = ChangeManagerPropsTask.toTaskProperties(this.serviceProperties);
        PropertiesUtil.setProperty(taskProperties, ELEMENT_NAME, this.elementName);
        PropertiesUtil.setProperty(taskProperties, SERVICE_NAME, this.serviceName);
        PropertiesUtil.setProperty(taskProperties, STARTUP_MODE, this.startupMode);
        return taskProperties;
    }

    public void setTaskProperties(Properties taskProperties) throws Exception {
        this.setElementName(PropertiesUtil.getProperty(taskProperties, ELEMENT_NAME));
        this.setServiceName(PropertiesUtil.getProperty(taskProperties, SERVICE_NAME));
        this.setStartupMode(PropertiesUtil.getProperty(taskProperties, STARTUP_MODE));
        this.serviceProperties = ChangeManagerPropsTask.fromTaskProperties(taskProperties);
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Error occurred while reading element.name");
        }
        this.elementName = elementName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("Error occurred while reading service.name");
        }
        this.serviceName = serviceName;
    }

    public String getStartupMode() {
        return this.startupMode;
    }

    public void setStartupMode(String startupMode) {
        this.startupMode = startupMode;
    }

    public PropertyMap getServiceProperties() {
        return this.serviceProperties;
    }

    public void setServiceProperties(PropertyMap serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public void addServiceProperties(PropertyMap serviceProperties) {
        this.serviceProperties.putAll((Map)serviceProperties);
    }
}

