/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.security.core.server.secstorefs.NotFoundException;
import com.sap.security.core.server.secstorefs.SecStoreFS;
import com.sap.security.core.server.secstorefs.SecStoreFSException;
import com.sap.sql.connect.OpenSQLConnectInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public final class ChangeSecStoreTask
extends Task {
    private static final String NAME = "change.secstore";
    private static final String SECSTORE_FILE = "secstore.file";
    private static final String SYSTEM_NAME = "system.name";
    private static final String SECSTORE_KEY = "secstore.key";
    private static final String ADD_EDIT_PREFIX = "add_edit.";
    private static final String DELETE_PREFIX = "delete.";
    private Properties addEditProperties;
    private Set forDelete;
    private String secStoreFile;
    private String secStoreKey;
    private String systemName;

    public ChangeSecStoreTask() {
        super(NAME);
    }

    public Task newInstance() {
        return new ChangeSecStoreTask();
    }

    public Properties getTaskProperties() {
        Properties result = new Properties();
        Iterator i = ((Hashtable)this.addEditProperties).keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            result.setProperty(ADD_EDIT_PREFIX + key, this.addEditProperties.getProperty(key));
        }
        Iterator i2 = this.forDelete.iterator();
        while (i2.hasNext()) {
            result.setProperty(DELETE_PREFIX + (String)i2.next(), "");
        }
        result.setProperty(SECSTORE_FILE, this.secStoreFile);
        result.setProperty(SECSTORE_KEY, this.secStoreKey);
        result.setProperty(SYSTEM_NAME, this.systemName);
        return result;
    }

    public void setTaskProperties(Properties taskProperties) throws Exception {
        this.setSecStoreFile(taskProperties.getProperty(SECSTORE_FILE));
        this.setSecStoreKey(taskProperties.getProperty(SECSTORE_KEY));
        this.setSystemName(taskProperties.getProperty(SYSTEM_NAME));
        this.addEditProperties = new Properties();
        this.forDelete = new TreeSet();
        Iterator i = ((Hashtable)taskProperties).keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (key.startsWith(ADD_EDIT_PREFIX)) {
                this.addEditProperties.setProperty(key.substring(ADD_EDIT_PREFIX.length()), taskProperties.getProperty(key));
                continue;
            }
            if (!key.startsWith(DELETE_PREFIX)) continue;
            this.forDelete.add(key.substring(DELETE_PREFIX.length()));
        }
    }

    public void addTaskProperties(Properties newProperties) throws Exception {
        Iterator i = ((Hashtable)newProperties).keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (key.startsWith(ADD_EDIT_PREFIX)) {
                if (this.forDelete.contains(key)) {
                    this.forDelete.remove(key);
                }
                this.addEditProperties.setProperty(key.substring(ADD_EDIT_PREFIX.length()), newProperties.getProperty(key));
                continue;
            }
            if (!key.startsWith(DELETE_PREFIX)) continue;
            if (((Hashtable)this.addEditProperties).containsKey(key)) {
                ((Hashtable)this.addEditProperties).remove(key);
            }
            this.forDelete.add(key.substring(DELETE_PREFIX.length()));
        }
    }

    public void go(ConfigurationHandler cfgHandler) {
        String connectionName = "jdbc/pool/" + this.systemName;
        String remoteConnectionName = connectionName + "_REMOTE";
        try {
            SecStoreFS store = new SecStoreFS();
            SecStoreFS.setSID((String)this.systemName);
            store.setFilenames(this.secStoreFile, this.secStoreKey);
            store.openExistingStore();
            Properties secStoreProps = store.getStringPairs();
            this.replaceJDBCConnectionInfo(connectionName, secStoreProps);
            try {
                this.replaceJDBCConnectionInfo(remoteConnectionName, secStoreProps);
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            store = new SecStoreFS();
            SecStoreFS.setSID((String)this.systemName);
            store.setFilenames(this.secStoreFile, this.secStoreKey);
            store.openExistingStore();
            Iterator i = this.forDelete.iterator();
            while (i.hasNext()) {
                store.deletePair((String)i.next());
            }
            Iterator i2 = ((Hashtable)this.addEditProperties).keySet().iterator();
            while (i2.hasNext()) {
                String key = (String)i2.next();
                if (((Hashtable)secStoreProps).containsKey(key)) {
                    store.updatePair(key, this.addEditProperties.getProperty(key));
                    continue;
                }
                store.insertPair(key, this.addEditProperties.getProperty(key));
            }
            this.fireInfoLog("Changes in Secure Store are performed successfully.");
        }
        catch (Exception e) {
            this.fireWarningLog(e.getMessage(), e);
        }
    }

    private void replaceJDBCConnectionInfo(String connectionName, Properties initSecStoreProps) throws SQLException, SecStoreFSException {
        OpenSQLConnectInfo connInfo = new OpenSQLConnectInfo(connectionName);
        connInfo.lookup();
        Properties connectProps = connInfo.getDataSourceProperties();
        Enumeration<?> e = connectProps.propertyNames();
        String pass = connectProps.getProperty("Password");
        String url = connectProps.getProperty("Url");
        String user = connectProps.getProperty("User");
        String className = connectProps.getProperty("ClassName");
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ((Hashtable)initSecStoreProps).remove(connectionName + "/" + key);
            String newValue = (String)((Hashtable)this.addEditProperties).get(connectionName + "/" + key);
            if (newValue == null) continue;
            if (key.equals("Password")) {
                pass = newValue;
            } else if (key.equals("Url")) {
                url = newValue;
            } else if (key.equals("ClassName")) {
                className = newValue;
            } else if (key.equals("User")) {
                user = newValue;
            }
            ((Hashtable)this.addEditProperties).remove(connectionName + "/" + key);
        }
        if (!className.equals("")) {
            connInfo.setDriverProperties(className, url, user, pass);
        }
        connInfo.rebind();
    }

    public void setAddEditProperties(Properties addEditProperties) {
        this.addEditProperties = addEditProperties;
    }

    public void setForDelete(Set forDelete) {
        this.forDelete = forDelete;
    }

    public void setSecStoreFile(String secStoreFile) {
        this.secStoreFile = secStoreFile;
    }

    public void setSecStoreKey(String secStoreKey) {
        this.secStoreKey = secStoreKey;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }
}

