/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.Property;
import com.sap.engine.configtool.PropertyMap;
import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.batch.task.TaskUtil;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class ChangeManagerPropsTask
extends Task {
    private static final String NAME = "change.manager.properties";
    private static final String ELEMENT_NAME = "element.name";
    private static final String MANAGER_NAME = "manager.name";
    private static final String PROP_PREFIX = "prop.";
    private static final String CUSTOM_POSTFIX = ".custom";
    private static final String DEFAULT_POSTFIX = ".default";
    private static final String SECURE_POSTFIX = ".secure";
    private String elementName;
    private String managerName;
    private PropertyMap managerProperties = new PropertyMap();

    public ChangeManagerPropsTask() {
        super(NAME);
    }

    public String getUniqueName() {
        return this.elementName + this.managerName;
    }

    public Task newInstance() {
        return new ChangeManagerPropsTask();
    }

    public Properties getTaskProperties() {
        Properties taskProperties = ChangeManagerPropsTask.toTaskProperties(this.managerProperties);
        PropertiesUtil.setProperty(taskProperties, ELEMENT_NAME, this.elementName);
        PropertiesUtil.setProperty(taskProperties, MANAGER_NAME, this.managerName);
        return taskProperties;
    }

    public void setTaskProperties(Properties taskProperties) throws Exception {
        this.setElementName(PropertiesUtil.getProperty(taskProperties, ELEMENT_NAME));
        this.setManagerName(PropertiesUtil.getProperty(taskProperties, MANAGER_NAME));
        this.managerProperties = ChangeManagerPropsTask.fromTaskProperties(taskProperties);
    }

    public void go(ConfigurationHandler cfgHandler) {
        block5: {
            try {
                try {
                    String elementPath = TaskUtil.getElementConfigurationPath(this.elementName, cfgHandler);
                    TaskUtil.changeProperties(cfgHandler, elementPath, "kernel", this.managerName, this.managerProperties);
                    this.fireInfoLog("ChangeManagerPropsTask has finished successfully. Manager: " + this.managerName + " on " + this.elementName);
                }
                catch (ConfigurationException ce) {
                    this.fireCriticalLog("Error occurred while working with Configuration.", ce);
                    Object var5_5 = null;
                    this.managerProperties.clear();
                    break block5;
                }
                catch (IllegalArgumentException iae) {
                    this.fireWarningLog(iae.getMessage(), iae);
                    Object var5_6 = null;
                    this.managerProperties.clear();
                }
                Object var5_4 = null;
                this.managerProperties.clear();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.managerProperties.clear();
                throw throwable;
            }
        }
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Error occurred while reading element.name");
        }
        this.elementName = elementName;
    }

    public String getManagerName() {
        return this.managerName;
    }

    public void setManagerName(String managerName) {
        if (managerName == null) {
            throw new IllegalArgumentException("Error occurred while reading manager.name");
        }
        this.managerName = managerName;
    }

    public PropertyMap getManagerProperties() {
        return this.managerProperties;
    }

    public void setManagerProperties(PropertyMap managerProperties) {
        this.managerProperties = managerProperties;
    }

    public void addManagerProperties(PropertyMap managerProperties) {
        this.managerProperties.putAll((Map)managerProperties);
    }

    public static PropertyMap fromTaskProperties(Properties taskProperties) {
        PropertyMap map = new PropertyMap();
        if (taskProperties != null) {
            Iterator keys = ((Hashtable)taskProperties).keySet().iterator();
            while (keys.hasNext()) {
                String propKey = (String)keys.next();
                if (!propKey.startsWith(PROP_PREFIX)) continue;
                String key = propKey.substring(propKey.indexOf(PROP_PREFIX) + PROP_PREFIX.length(), propKey.lastIndexOf("."));
                String value = taskProperties.getProperty(propKey);
                Property entry = (Property)map.get(key);
                if (entry == null) {
                    entry = new Property(key);
                    map.put(entry);
                }
                if (propKey.endsWith(CUSTOM_POSTFIX)) {
                    entry.setCustomValue(value);
                    continue;
                }
                if (propKey.endsWith(DEFAULT_POSTFIX)) {
                    entry.setDefaultValue(value);
                    continue;
                }
                if (!propKey.endsWith(SECURE_POSTFIX)) continue;
                boolean isSecure = value.equals("yes");
                entry.setSecure(isSecure);
            }
        }
        return map;
    }

    public static Properties toTaskProperties(PropertyMap managerProperties) {
        Properties taskProperties = new Properties();
        if (managerProperties != null) {
            Iterator keys = managerProperties.keySet().iterator();
            while (keys.hasNext()) {
                String defaultValue;
                Object key = keys.next();
                Object v = managerProperties.get(key);
                if (!(v instanceof Property)) continue;
                Property entry = (Property)v;
                String customValue = entry.getCustomValue();
                if (customValue != null) {
                    PropertiesUtil.setProperty(taskProperties, PROP_PREFIX + (String)key + CUSTOM_POSTFIX, customValue);
                }
                if ((defaultValue = entry.getDefaultValue()) != null) {
                    PropertiesUtil.setProperty(taskProperties, PROP_PREFIX + (String)key + DEFAULT_POSTFIX, defaultValue);
                }
                if (!entry.isSecure()) continue;
                PropertiesUtil.setProperty(taskProperties, PROP_PREFIX + (String)key + SECURE_POSTFIX, "yes");
            }
        }
        return taskProperties;
    }
}

