/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.task;

import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.batch.task.TaskUtil;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import java.util.Properties;

public class ChangeInstancePropsTask
extends Task {
    private static final String NAME = "change.instance.props";
    public static final String INSTANCE_PREFIX_KEY = "instance.prefix";
    private static final String INSTANCE_KEY = "instance.";
    private static final String SID_KEY = "system.id";
    private static final String BN_KEY = "box.number";
    private static final String MS_HOST_KEY = "ms.host";
    private static final String MS_PORT_KEY = "ms.port";
    private static final String BOOTSTRAP_JAVA_PATH_KEY = "bootstrap.java.path";
    private static final String BOOTSTRAP_JAVA_CLASSPATH_KEY = "bootstrap.java.classpath";
    private static final String BOOTSTRAP_JAVA_PARAMS_KEY = "bootstrap.java.parameters";
    private static final String BOOTSTRAP_JAVA_MAX_HEAP_SIZE_KEY = "bootstrap.java.max.heap.size";
    private static final String BOOTSTRAP_JAVA_MAIN_CLASS_KEY = "bootstrap.java.main.class";
    private static final String BOOTSTRAP_JAVA_MAIN_CLASS_PARAMETERS_KEY = "bootstrap.java.main.class.parameters";
    private String instancePrefix;
    private String bn;
    private Integer sid;
    private String msHost;
    private Integer msPort;
    private String bootstrapJavaPath;
    private String bootstrapJavaClassPath;
    private String bootstrapJavaParams;
    private Integer bootstrapJavaMaxHeapSize;
    private String bootstrapJavaMainClass;
    private String bootstrapJavaMainClassParams;

    public ChangeInstancePropsTask() {
        super(NAME);
    }

    public Task newInstance() {
        return new ChangeInstancePropsTask();
    }

    public String getUniqueName() {
        return this.instancePrefix;
    }

    public void go(ConfigurationHandler cfgHandler) {
        try {
            String instancePropsPath = "cluster_data/instance.properties." + this.instancePrefix;
            Configuration instancePropsConfig = cfgHandler.openConfiguration(instancePropsPath, 1);
            if (instancePropsConfig != null) {
                PropertySheet sheetProperties = instancePropsConfig.getPropertySheetInterface();
                TaskUtil.setPropertyEntryValue(sheetProperties, "instance.ms.host", this.msHost);
                TaskUtil.setPropertyEntryIntegerValue(sheetProperties, "instance.ms.port", this.msPort);
                String bootstrap = "bootstrap.";
                this.setPropertyEntryValue(sheetProperties, bootstrap + "JavaPath", this.bootstrapJavaPath);
                this.setPropertyEntryValue(sheetProperties, bootstrap + "ClassPath", this.bootstrapJavaClassPath);
                if (this.bootstrapJavaParams != null && this.bootstrapJavaParams.startsWith("prefix.please.ivkrasfam.")) {
                    String oldJavaParams;
                    this.bootstrapJavaParams = this.bootstrapJavaParams.substring("prefix.please.ivkrasfam.".length());
                    Properties instanceProperties = TaskUtil.getInstanceProperties(cfgHandler, this.instancePrefix);
                    if (instanceProperties != null && (oldJavaParams = instanceProperties.getProperty(bootstrap + "JavaParameters")) != null) {
                        this.bootstrapJavaParams = (oldJavaParams + " " + this.bootstrapJavaParams).trim();
                    }
                }
                this.setPropertyEntryValue(sheetProperties, bootstrap + "JavaParameters", this.bootstrapJavaParams);
                TaskUtil.setPropertyEntryIntegerValue(sheetProperties, bootstrap + "MaxHeapSize", this.bootstrapJavaMaxHeapSize);
                TaskUtil.setPropertyEntryValue(sheetProperties, bootstrap + "MainClass", this.bootstrapJavaMainClass);
                this.setPropertyEntryValue(sheetProperties, bootstrap + "Parameters", this.bootstrapJavaMainClassParams);
                TaskUtil.setPropertyIntegerValue(sheetProperties, "instance.system.id", this.sid, false);
                TaskUtil.setPropertyEntryValue(sheetProperties, "instance.box.number", this.bn);
            }
            cfgHandler.commit();
            cfgHandler.closeConfiguration(instancePropsConfig);
            this.fireInfoLog("ChangeInstancePropsTask has finished successfully on " + this.instancePrefix);
            if (this.bootstrapJavaClassPath != null || this.bootstrapJavaMainClass != null || this.bootstrapJavaMainClassParams != null || this.bootstrapJavaMaxHeapSize != null || this.bootstrapJavaParams != null || this.bootstrapJavaPath != null) {
                this.fireInfoLog("You need one additional restart to apply bootstrap changes.");
            }
        }
        catch (ConfigurationException ce) {
            this.fireCriticalLog("Error occurred while working with Configuration.", ce);
        }
    }

    public Properties getTaskProperties() {
        Properties taskProperties = new Properties();
        PropertiesUtil.setProperty(taskProperties, INSTANCE_PREFIX_KEY, this.instancePrefix);
        PropertiesUtil.setProperty(taskProperties, MS_HOST_KEY, this.msHost);
        PropertiesUtil.setIntegerProperty(taskProperties, MS_PORT_KEY, this.msPort);
        PropertiesUtil.setProperty(taskProperties, BOOTSTRAP_JAVA_PATH_KEY, this.bootstrapJavaPath);
        PropertiesUtil.setProperty(taskProperties, BOOTSTRAP_JAVA_CLASSPATH_KEY, this.bootstrapJavaClassPath);
        PropertiesUtil.setProperty(taskProperties, BOOTSTRAP_JAVA_PARAMS_KEY, this.bootstrapJavaParams);
        PropertiesUtil.setIntegerProperty(taskProperties, BOOTSTRAP_JAVA_MAX_HEAP_SIZE_KEY, this.bootstrapJavaMaxHeapSize);
        PropertiesUtil.setProperty(taskProperties, BOOTSTRAP_JAVA_MAIN_CLASS_KEY, this.bootstrapJavaMainClass);
        PropertiesUtil.setProperty(taskProperties, BOOTSTRAP_JAVA_MAIN_CLASS_PARAMETERS_KEY, this.bootstrapJavaMainClassParams);
        PropertiesUtil.setIntegerProperty(taskProperties, SID_KEY, this.sid);
        PropertiesUtil.setProperty(taskProperties, BN_KEY, this.bn);
        return taskProperties;
    }

    public void setTaskProperties(Properties taskProperties) throws Exception {
        this.setInstancePrefix(PropertiesUtil.getProperty(taskProperties, INSTANCE_PREFIX_KEY));
        this.setMsHost(PropertiesUtil.getProperty(taskProperties, MS_HOST_KEY));
        this.setMsPort(PropertiesUtil.getIntegerProperty(taskProperties, MS_PORT_KEY));
        this.setBootstrapJavaPath(PropertiesUtil.getProperty(taskProperties, BOOTSTRAP_JAVA_PATH_KEY));
        this.setBootstrapJavaClassPath(PropertiesUtil.getProperty(taskProperties, BOOTSTRAP_JAVA_CLASSPATH_KEY));
        this.setBootstrapJavaParams(PropertiesUtil.getProperty(taskProperties, BOOTSTRAP_JAVA_PARAMS_KEY));
        this.setBootstrapJavaMaxHeapSize(PropertiesUtil.getIntegerProperty(taskProperties, BOOTSTRAP_JAVA_MAX_HEAP_SIZE_KEY));
        this.setBootstrapJavaMainClass(PropertiesUtil.getProperty(taskProperties, BOOTSTRAP_JAVA_MAIN_CLASS_KEY));
        this.setBootstrapJavaMainClassParams(PropertiesUtil.getProperty(taskProperties, BOOTSTRAP_JAVA_MAIN_CLASS_PARAMETERS_KEY));
        this.setSid(PropertiesUtil.getIntegerProperty(taskProperties, SID_KEY));
        this.setBn(PropertiesUtil.getProperty(taskProperties, BN_KEY));
    }

    public String getInstancePrefix() {
        return this.instancePrefix;
    }

    public void setInstancePrefix(String instancePrefix) {
        if (instancePrefix == null) {
            throw new IllegalArgumentException("Error occurred while reading instance.prefix");
        }
        this.instancePrefix = instancePrefix;
    }

    public String getMsHost() {
        return this.msHost;
    }

    public void setMsHost(String msHost) {
        this.msHost = msHost;
    }

    public Integer getMsPort() {
        return this.msPort;
    }

    public void setMsPort(Integer msPort) {
        this.msPort = msPort;
    }

    public String getBootstrapJavaPath() {
        return this.bootstrapJavaPath;
    }

    public void setBootstrapJavaPath(String bootstrapJavaPath) {
        this.bootstrapJavaPath = bootstrapJavaPath;
    }

    public String getBootstrapJavaClassPath() {
        return this.bootstrapJavaClassPath;
    }

    public void setBootstrapJavaClassPath(String bootstrapJavaClassPath) {
        this.bootstrapJavaClassPath = bootstrapJavaClassPath;
    }

    public String getBootstrapJavaParams() {
        return this.bootstrapJavaParams;
    }

    public void setBootstrapJavaParams(String bootstrapJavaParams) {
        this.bootstrapJavaParams = bootstrapJavaParams;
    }

    public void setBootstrapAdditionalJavaParams(String additionalJavaParams) {
        if (additionalJavaParams != null && additionalJavaParams.trim().length() != 0) {
            this.bootstrapJavaParams = "prefix.please.ivkrasfam." + additionalJavaParams;
        }
    }

    public Integer getBootstrapJavaMaxHeapSize() {
        return this.bootstrapJavaMaxHeapSize;
    }

    public void setBootstrapJavaMaxHeapSize(Integer bootstrapJavaMaxHeapSize) {
        this.bootstrapJavaMaxHeapSize = bootstrapJavaMaxHeapSize;
    }

    public String getBootstrapJavaMainClass() {
        return this.bootstrapJavaMainClass;
    }

    public void setBootstrapJavaMainClass(String bootstrapJavaMainClass) {
        this.bootstrapJavaMainClass = bootstrapJavaMainClass;
    }

    public String getBootstrapJavaMainClassParams() {
        return this.bootstrapJavaMainClassParams;
    }

    public void setBootstrapJavaMainClassParams(String bootstrapJavaMainClassParams) {
        this.bootstrapJavaMainClassParams = bootstrapJavaMainClassParams;
    }

    private void setPropertyEntryValue(PropertySheet sheetProperties, String key, String value) throws ConfigurationException {
        if (value != null) {
            TaskUtil.setPropertyEntryValue(sheetProperties, key, value.replace('\\', '/').replace(';', ':'));
        }
    }

    public Integer getSid() {
        return this.sid;
    }

    public void setSid(Integer sid) {
        this.sid = sid;
    }

    public String getBn() {
        return this.bn;
    }

    public void setBn(String bn) {
        this.bn = bn;
    }
}

