/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.descriptor;

import com.sap.engine.configtool.batch.descriptor.BatchConfigDescriptor;
import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.batch.task.Tasks;
import com.sap.engine.lib.xml.StandardDOMParser;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class BatchConfigDescriptorDocument {
    public static final String NON_EXISTING_VALUE = "NON_EXISTING_VALUE_HIHI";
    public static final String DEFAULT_ATTRIBUTE_VALUE = "\"NON_EXISTING_VALUE_HIHI\"";
    public static final String DTD = "<!DOCTYPE config [\n<!ELEMENT config (dbproperties, task*)>\n   <!ELEMENT dbproperties (property*)>\n   <!ELEMENT task (property*)>\n     <!ATTLIST task name CDATA #REQUIRED>\n   <!ELEMENT property (#PCDATA)>\n     <!ATTLIST property key CDATA #REQUIRED>\n     <!ATTLIST property value CDATA #REQUIRED>\n]>";
    protected Document mainDocument;

    public BatchConfigDescriptorDocument() {
    }

    public BatchConfigDescriptorDocument(BatchConfigDescriptor descriptor) {
        this.writeDocumentFromDescriptor(descriptor);
    }

    public Document getMainDocument() {
        return this.mainDocument;
    }

    public void setMainDocument(Document mainDocument) {
        this.mainDocument = mainDocument;
    }

    private void setAttr(Element element, String attrKey, String attrValue) {
        if (element != null && attrKey != null) {
            if (attrValue == null) {
                attrValue = NON_EXISTING_VALUE;
            }
            Attr attr = this.mainDocument.createAttribute(attrKey);
            attr.setValue(attrValue);
            element.setAttributeNode(attr);
        }
    }

    private String getAttr(Element element, String attrKey) {
        String result = null;
        if (element != null && attrKey != null && (result = element.getAttribute(attrKey)).equals(NON_EXISTING_VALUE)) {
            result = null;
        }
        return result;
    }

    private Element createSimpleElement(Element parent, String tag) {
        return this.createSimpleElement(parent, tag, null);
    }

    private Element createSimpleElement(Element parent, String tag, String value) {
        Element newEl = null;
        if (parent != null && tag != null) {
            newEl = this.mainDocument.createElement(tag);
            if (value != null) {
                newEl.appendChild(this.mainDocument.createTextNode(value));
            }
            parent.appendChild(newEl);
        }
        return newEl;
    }

    public BatchConfigDescriptor readDescriptorFromDocument(Document document) throws Exception {
        return this.readDescriptorFromDocument(document.getDocumentElement());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BatchConfigDescriptor readDescriptorFromDocument(Element rootElement) throws Exception {
        Tasks tasks = new Tasks();
        BatchConfigDescriptor desc = new BatchConfigDescriptor();
        rootElement.normalize();
        NodeList childNodes = rootElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1) {
                String childNodeName = childNode.getNodeName();
                Element childElement = (Element)childNode;
                if (childNodeName.equals("dbproperties")) {
                    desc.setDbProperties(this.readProperties(childElement));
                } else {
                    if (!childNodeName.equals("task")) throw new Exception("Unknown Tag " + childNodeName);
                    String taskName = this.getAttr(childElement, "name");
                    Task task = tasks.getTask(taskName);
                    if (task == null) throw new Exception("Unknown Task " + taskName);
                    Properties taskProperties = this.readProperties(childElement);
                    task = task.newInstance();
                    task.setTaskProperties(taskProperties);
                    desc.addTask(task);
                }
            }
            ++i;
        }
        return desc;
    }

    private Properties readProperties(Element element) throws Exception {
        NodeList childNodes = element.getChildNodes();
        Properties props = new Properties();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1) {
                Element childElement = (Element)childNode;
                String nodeName = childNode.getNodeName();
                if (nodeName.equals("property")) {
                    ((Hashtable)props).put(this.getAttr(childElement, "key"), this.getAttr(childElement, "value"));
                } else {
                    throw new Exception("Unknown Tag " + nodeName);
                }
            }
            ++i;
        }
        return props;
    }

    public void writeDocumentFromDescriptor(BatchConfigDescriptor descriptor) {
        if (descriptor != null) {
            this.mainDocument = StandardDOMParser.createDocument();
            this.mainDocument.appendChild(this.writeElementFromDescriptor(descriptor));
        }
    }

    public Element writeElementFromDescriptor(BatchConfigDescriptor desc) {
        Element mainNode = this.mainDocument.createElement("config");
        Element elementNode = this.createSimpleElement(mainNode, "dbproperties");
        this.writeProperties(elementNode, desc.getDbProperties());
        this.writeTasksNode(mainNode, desc.getTasks());
        return mainNode;
    }

    private void writeTasksNode(Element configNode, ArrayList tasks) {
        if (tasks != null) {
            Iterator iterator = ((AbstractList)tasks).iterator();
            while (iterator.hasNext()) {
                Task task = (Task)iterator.next();
                Element taskEl = this.createSimpleElement(configNode, "task");
                this.setAttr(taskEl, "name", task.getName());
                this.writeProperties(taskEl, task.getTaskProperties());
            }
        }
    }

    private void writeProperties(Element element, Properties props) {
        if (props != null) {
            Enumeration enumeration = ((Hashtable)props).keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Element propertyEl = this.createSimpleElement(element, "property");
                this.setAttr(propertyEl, "key", key);
                this.setAttr(propertyEl, "value", (String)((Hashtable)props).get(key));
            }
        }
    }
}

