/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch.descriptor;

import com.sap.engine.configtool.batch.descriptor.BatchConfigDescriptorDocument;
import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.w3c.dom.Document;

public final class BatchConfigDescriptor {
    private Properties dbProperties;
    private ArrayList tasks;

    public BatchConfigDescriptor() {
        this(null, new ArrayList(11));
    }

    public BatchConfigDescriptor(Properties dbProperties, ArrayList tasks) {
        this.dbProperties = dbProperties;
        this.tasks = tasks;
    }

    public Properties getDbProperties() {
        return this.dbProperties;
    }

    public void setDbProperties(Properties dbProperties) {
        this.dbProperties = dbProperties;
    }

    public void addTask(Task task) {
        if (this.tasks == null) {
            this.tasks = new ArrayList(11);
        }
        this.tasks.add(task);
    }

    public ArrayList getTasks() {
        return this.tasks;
    }

    public void setTasks(ArrayList tasks) {
        this.tasks = tasks;
    }

    public void saveToFile(String xmlFileName) throws IOException {
        if (!xmlFileName.endsWith(".xml")) {
            xmlFileName = xmlFileName + ".xml";
        }
        StandardDOMWriter writer = new StandardDOMWriter();
        BatchConfigDescriptorDocument descDocument = new BatchConfigDescriptorDocument(this);
        writer.write(descDocument.getMainDocument(), xmlFileName, "<!DOCTYPE config [\n<!ELEMENT config (dbproperties, task*)>\n   <!ELEMENT dbproperties (property*)>\n   <!ELEMENT task (property*)>\n     <!ATTLIST task name CDATA #REQUIRED>\n   <!ELEMENT property (#PCDATA)>\n     <!ATTLIST property key CDATA #REQUIRED>\n     <!ATTLIST property value CDATA #REQUIRED>\n]>");
    }

    public static BatchConfigDescriptor loadFromFile(String xmlFileName) throws Exception {
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(xmlFileName));
        Document document = new StandardDOMParser().parse((InputStream)file);
        BatchConfigDescriptor result = new BatchConfigDescriptorDocument().readDescriptorFromDocument(document);
        file.close();
        return result;
    }
}

