/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch;

import com.sap.engine.configtool.SecStoreData;
import com.sap.security.core.server.secstorefs.FileIOException;
import com.sap.security.core.server.secstorefs.FileInvalidException;
import com.sap.security.core.server.secstorefs.FileMissingException;
import com.sap.security.core.server.secstorefs.InvalidStateException;
import com.sap.security.core.server.secstorefs.NoEncryptionException;
import com.sap.security.core.server.secstorefs.NoHashException;
import com.sap.security.core.server.secstorefs.NoKeyRequiredException;
import com.sap.security.core.server.secstorefs.NoSIDException;
import com.sap.security.core.server.secstorefs.SecStoreFS;
import com.sap.security.core.server.secstorefs.SecStoreFSException;
import com.sap.security.core.server.secstorefs.WrongKeyException;
import com.sap.sql.connect.OpenSQLConnectInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public final class SecureStoreScanner {
    private String secStoreFilename;
    private String secStoreKeyFilename;
    private String secStoreSystemName;
    private SecStoreFS store;

    public SecureStoreScanner(String secStoreFilename, String secStoreKeyFilename, String secStoreSystemName) throws InvalidStateException, FileIOException, FileMissingException, FileInvalidException, NoEncryptionException, WrongKeyException, NoHashException, NoSIDException {
        this.secStoreFilename = secStoreFilename;
        this.secStoreKeyFilename = secStoreKeyFilename;
        this.secStoreSystemName = secStoreSystemName;
        this.store = new SecStoreFS();
        this.store.setFilenames(secStoreFilename, secStoreKeyFilename);
        SecStoreFS.setSID((String)secStoreSystemName);
        this.store.openExistingStore();
    }

    public Properties listSecureStoreProps() throws InvalidStateException, FileIOException, FileMissingException, FileInvalidException, NoSIDException, NoHashException, NoEncryptionException, WrongKeyException, NoKeyRequiredException, SQLException, SecStoreFSException {
        Properties infos = this.store.getStringPairs();
        this.replaceJDBCConnectionInfo(infos, "jdbc/pool/" + this.secStoreSystemName);
        this.replaceJDBCConnectionInfo(infos, "jdbc/pool/" + this.secStoreSystemName + "_REMOTE");
        return infos;
    }

    private void replaceJDBCConnectionInfo(Properties props, String connectionName) throws SQLException, SecStoreFSException {
        if (((Hashtable)props).containsKey(connectionName)) {
            OpenSQLConnectInfo connInfo = new OpenSQLConnectInfo(connectionName);
            connInfo.lookup();
            Properties connectProps = connInfo.getDataSourceProperties();
            ((Hashtable)props).remove(connectionName);
            Enumeration<?> e = connectProps.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = connectProps.getProperty(key);
                if (key == null || value == null) continue;
                props.setProperty(connectionName + "/" + key, value);
            }
        }
    }

    public boolean isStoreEncrypted() throws InvalidStateException, FileIOException, FileMissingException, FileInvalidException, NoEncryptionException, WrongKeyException, NoHashException, NoSIDException {
        return this.store.isEncrypted();
    }

    public SecStoreData scan() throws InvalidStateException, FileIOException, FileMissingException, FileInvalidException, NoSIDException, NoHashException, NoEncryptionException, WrongKeyException, NoKeyRequiredException {
        SecStoreData secStoreData = null;
        try {
            Properties initProperties = this.listSecureStoreProps();
            secStoreData = new SecStoreData();
            secStoreData.setInitSecStoreFileProperties(initProperties);
            secStoreData.setSecStoreFileProperties(initProperties);
            secStoreData.setEncrypted(this.isStoreEncrypted());
            secStoreData.setEncryptionPossible(this.isSecStoreEncryptionPossible());
        }
        catch (Exception e) {
            System.out.println("An exception has occurred: " + e.getMessage());
        }
        return secStoreData;
    }

    public boolean isSecStoreEncryptionPossible() {
        return this.store.isEncryptionPossible();
    }

    public String getSecStoreFilename() {
        return this.secStoreFilename;
    }

    public void setSecStoreFilename(String secStoreFilename) {
        this.secStoreFilename = secStoreFilename;
    }

    public String getSecStoreKeyFilename() {
        return this.secStoreKeyFilename;
    }

    public void setSecStoreKeyFilename(String secStoreKeyFilename) {
        this.secStoreKeyFilename = secStoreKeyFilename;
    }

    public String getSecStoreSystemFilename() {
        return this.secStoreSystemName;
    }

    public void setSecStoreSystemFilename(String secStoreSystemFilename) {
        this.secStoreSystemName = secStoreSystemFilename;
    }
}

