/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch;

import com.sap.engine.configtool.ClusterData;
import com.sap.engine.configtool.ClusterElement;
import com.sap.engine.configtool.Instance;
import com.sap.engine.configtool.Manager;
import com.sap.engine.configtool.Service;
import com.sap.engine.configtool.batch.OfflinePersistenceAdapter;
import com.sap.engine.configtool.lib.ConfigurationUtil;
import com.sap.engine.configtool.log.LogFire;
import com.sap.engine.core.configuration.bootstrap.ConfigurationManagerBootstrapImpl;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public final class Scanner
extends LogFire {
    private static final String INSTANCE_PROPERTIES = "instance.properties.";
    private ConfigurationHandler cfgHandler;
    private ClusterData clusterData;

    public Scanner(ConfigurationHandler cfgHandler) {
        this.cfgHandler = cfgHandler;
    }

    public ClusterData scan() {
        try {
            Configuration cfg = this.cfgHandler.openConfiguration("cluster_data", 1);
            this.clusterData = new ClusterData();
            if (ConfigurationUtil.getSubConfiguration(cfg, "dispatcher") != null) {
                this.clusterData.setGlobalDispatcher(this.scanGlobalClusterElement(ConfigurationUtil.getSubConfiguration(cfg, "dispatcher/cfg"), "dispatcher", "dispatcher"));
            }
            if (ConfigurationUtil.getSubConfiguration(cfg, "server") != null) {
                this.clusterData.setGlobalServer(this.scanGlobalClusterElement(ConfigurationUtil.getSubConfiguration(cfg, "server/cfg"), "server", "server"));
            }
            this.clusterData.setInstances(this.scanInstances(cfg));
            this.cfgHandler.closeAllConfigurations();
        }
        catch (ConfigurationException ce) {
            this.fireCriticalLog("Error occurred while working with Configuration.", ce);
        }
        return this.clusterData;
    }

    private ClusterElement scanGlobalClusterElement(Configuration elementCfg, String elementName, String type) {
        ClusterElement clusterElement = new ClusterElement();
        clusterElement.setName(elementName);
        clusterElement.setType(type);
        clusterElement.setServices(this.scanElementServices(null, elementCfg));
        clusterElement.setManagers(this.scanElementManagers(null, elementCfg));
        return clusterElement;
    }

    private TreeMap scanInstances(Configuration rootCfg) {
        TreeMap<String, Instance> instances = null;
        Map allElementCfgs = ConfigurationUtil.getAllSubConfigurations(rootCfg);
        if (allElementCfgs != null) {
            instances = new TreeMap<String, Instance>();
            Iterator configNames = allElementCfgs.keySet().iterator();
            while (configNames.hasNext()) {
                String configName = (String)configNames.next();
                if (!configName.startsWith(INSTANCE_PROPERTIES)) continue;
                String instancePrefix = configName.substring(INSTANCE_PROPERTIES.length());
                instances.put(instancePrefix, this.scanInstance(rootCfg, instancePrefix));
            }
        }
        return instances;
    }

    private Instance scanInstance(Configuration rootCfg, String instancePrefix) {
        Configuration serverCfg;
        Instance instance = new Instance();
        instance.setInstancePrefix(instancePrefix);
        Properties instanceProperties = ConfigurationUtil.getProperties(ConfigurationUtil.getSubConfiguration(rootCfg, INSTANCE_PROPERTIES + instancePrefix));
        instance.setInstanceProperties(instanceProperties);
        try {
            Properties serverElementInfo = rootCfg.getSubConfiguration("server").getSubConfiguration("cfg").getSubConfiguration("element-info." + instancePrefix).getPropertySheetInterface().getProperties();
            instance.setElementInfo(serverElementInfo);
        }
        catch (ConfigurationException ce) {
            this.fireWarningLog("Can't read instance-global element info.", ce);
            try {
                Configuration server = rootCfg.getSubConfiguration("server");
                Configuration cfg = server.getSubConfiguration("cfg");
                Properties elementInfo = cfg.getSubConfiguration("element-info").getPropertySheetInterface().getProperties();
                Configuration newElementInfoCfg = cfg.createSubConfiguration("element-info." + instancePrefix, 1);
                Properties newElementInfo = new Properties();
                ((Hashtable)newElementInfo).putAll(elementInfo);
                try {
                    Properties localElementInfo = server.getSubConfiguration(instancePrefix + "50").getSubConfiguration("element-info").getPropertySheetInterface().getProperties();
                    newElementInfo.setProperty("os.name", localElementInfo.getProperty("os.name"));
                    newElementInfo.setProperty("os.bit.length", localElementInfo.getProperty("os.bit.length"));
                    newElementInfo.setProperty("os.unicode", localElementInfo.getProperty("os.unicode"));
                }
                catch (Exception e) {
                    this.fireCriticalLog("Can't find os parameters.", e);
                }
                newElementInfoCfg.getPropertySheetInterface().createPropertyEntries(newElementInfo);
                this.cfgHandler.commit();
                instance.setElementInfo(elementInfo);
            }
            catch (Exception e2) {
                this.fireCriticalLog("Can't create instance-global element info.", e2);
            }
        }
        Configuration dispCfg = ConfigurationUtil.getSubConfiguration(rootCfg, "dispatcher");
        if (dispCfg != null) {
            instance.addInstanceElements(this.scanElements(dispCfg, instancePrefix, "dispatcher", instance));
        }
        if ((serverCfg = ConfigurationUtil.getSubConfiguration(rootCfg, "server")) != null) {
            instance.addInstanceElements(this.scanElements(serverCfg, instancePrefix, "server", instance));
        }
        return instance;
    }

    private TreeMap scanElements(Configuration cfg, String instancePrefix, String type, Instance instance) {
        TreeMap<String, ClusterElement> elements = null;
        Map allElementCfgs = ConfigurationUtil.getAllSubConfigurations(cfg);
        if (allElementCfgs != null) {
            elements = new TreeMap<String, ClusterElement>();
            Iterator configNames = allElementCfgs.keySet().iterator();
            while (configNames.hasNext()) {
                String configName = (String)configNames.next();
                if (!configName.startsWith(instancePrefix)) continue;
                Configuration subCfg = (Configuration)allElementCfgs.get(configName);
                try {
                    if (!subCfg.existsSubConfiguration("element-info") || configName.equals("cfg")) continue;
                    elements.put(configName, this.scanClusterElement(cfg, subCfg, configName, type, instance));
                }
                catch (Exception e) {
                    this.fireWarningLog("Error occurred while scanElements.", e);
                }
            }
        }
        return elements;
    }

    private ClusterElement scanClusterElement(Configuration globalCfg, Configuration elementCfg, String elementName, String type, Instance instance) {
        ClusterElement clusterElement = new ClusterElement();
        ClusterElement globalElement = null;
        if (type.equals("dispatcher")) {
            globalElement = this.clusterData.getGlobalDispatcher();
        } else if (type.equals("server")) {
            globalElement = this.clusterData.getGlobalServer();
        }
        clusterElement.setName(elementName);
        clusterElement.setType(type);
        String bootstrapPrefix = "bootstrap_" + elementName + ".";
        clusterElement.setElementInfo(instance.getElementInfo(), ConfigurationUtil.getProperties(ConfigurationUtil.getSubConfiguration(elementCfg, "element-info"), bootstrapPrefix, instance.getInstanceProperties()));
        clusterElement.setServices(this.scanElementServices(globalElement, elementCfg));
        clusterElement.setManagers(this.scanElementManagers(globalElement, elementCfg));
        this.scanElementLogConfiguration(clusterElement, globalCfg, elementCfg);
        return clusterElement;
    }

    private TreeMap scanElementServices(ClusterElement globalElement, Configuration elementCfg) {
        Map allServiceCfgs;
        Configuration servicesCfg;
        TreeMap<String, Object> services = new TreeMap<String, Object>();
        if (globalElement != null) {
            TreeMap globalServices = globalElement.getServices();
            Iterator values = globalServices.values().iterator();
            while (values.hasNext()) {
                Service globalService = (Service)values.next();
                services.put(globalService.getName(), globalService.clone());
            }
        }
        if ((servicesCfg = ConfigurationUtil.getSubConfiguration(elementCfg, "services")) != null && (allServiceCfgs = ConfigurationUtil.getAllSubConfigurations(servicesCfg)) != null) {
            Iterator serviceNames = allServiceCfgs.keySet().iterator();
            while (serviceNames.hasNext()) {
                String serviceName = (String)serviceNames.next();
                if (serviceName.endsWith("-runtime")) {
                    String name = serviceName.substring(0, serviceName.length() - "-runtime".length());
                    Service service = (Service)services.get(name);
                    if (service == null) {
                        service = new Service(name);
                    }
                    Configuration serviceRuntimeCfg = (Configuration)allServiceCfgs.get(serviceName);
                    this.readServiceSettings(serviceRuntimeCfg, service);
                    services.put(name, service);
                    continue;
                }
                Service service = (Service)services.get(serviceName);
                if (service == null) {
                    service = new Service(serviceName);
                }
                Configuration serviceCfg = (Configuration)allServiceCfgs.get(serviceName);
                service.setProperties(ConfigurationUtil.getPropertyEntries(serviceCfg));
                services.put(serviceName, service);
            }
        }
        return services;
    }

    private void readServiceSettings(Configuration runtimeCfg, Service service) {
        Properties runtimeProps;
        if (runtimeCfg != null && (runtimeProps = ConfigurationUtil.getProperties(runtimeCfg)) != null) {
            service.setStartupMode((String)((Hashtable)runtimeProps).get("startup-mode"));
            service.setCore("true".equals(runtimeProps.getProperty("core-service")));
        }
    }

    private TreeMap scanElementManagers(ClusterElement globalElement, Configuration elementCfg) {
        String managerName;
        TreeMap<String, Manager> managers = new TreeMap<String, Manager>();
        if (globalElement != null) {
            TreeMap globalManagers = globalElement.getManagers();
            Iterator keys = globalManagers.keySet().iterator();
            while (keys.hasNext()) {
                managerName = (String)keys.next();
                managers.put(managerName, new Manager(managerName));
            }
        } else {
            try {
                Configuration kernelCfg = null;
                kernelCfg = elementCfg.getSubConfiguration("kernel");
                Properties kernelList = new Properties();
                kernelList.load(kernelCfg.getFile("kernel.properties"));
                Enumeration managerNames = ((Hashtable)kernelList).keys();
                while (managerNames.hasMoreElements()) {
                    String managerName2 = (String)managerNames.nextElement();
                    managers.put(managerName2, new Manager(managerName2));
                }
            }
            catch (Exception e) {
                this.fireWarningLog("Error occurred while scanElements.", e);
            }
        }
        Configuration managersCfg = ConfigurationUtil.getSubConfiguration(elementCfg, "kernel");
        if (managersCfg != null) {
            Iterator managerNames = managers.keySet().iterator();
            while (managerNames.hasNext()) {
                managerName = (String)managerNames.next();
                try {
                    if (!managersCfg.existsSubConfiguration(managerName)) continue;
                    Manager manager = (Manager)managers.get(managerName);
                    if (manager == null) {
                        manager = new Manager(managerName);
                    }
                    manager.setProperties(ConfigurationUtil.getPropertyEntries(managersCfg.getSubConfiguration(managerName)));
                    managers.put(managerName, manager);
                }
                catch (ConfigurationException e) {
                    this.fireWarningLog("Error occurred while scanElements.", e);
                }
            }
        }
        return managers;
    }

    public void scanElementLogConfiguration(ClusterElement element, Configuration global, Configuration local) {
        LogConfiguration result = new LogConfiguration();
        OfflinePersistenceAdapter kernelOPA = new OfflinePersistenceAdapter(global.getPath() + "/" + "cfg" + "/" + "kernel", local.getPath() + "/" + "kernel");
        element.setKernelOfflinePersistenceAdapter(kernelOPA);
        try {
            result.addLogConfiguration(kernelOPA.loadConfiguration(this.cfgHandler, ""));
        }
        catch (ConfigurationException e) {
            this.fireWarningLog("Error ocurred while scanning kernels log configuration.", e);
        }
        Configuration globalDescriptors = ConfigurationUtil.getSubConfiguration(global, "descriptors");
        Map allCfgs = ConfigurationUtil.getAllSubConfigurations(globalDescriptors);
        if (allCfgs != null) {
            Iterator names = allCfgs.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                Configuration globalCfg = ConfigurationUtil.getSubConfiguration(globalDescriptors, name);
                try {
                    String type;
                    if (!globalCfg.existsFile("log-configuration.xml") || (type = this.readType(globalCfg)) == null) continue;
                    String prefix = type + '_' + name + '_';
                    OfflinePersistenceAdapter opa = new OfflinePersistenceAdapter(globalCfg.getPath(), local + "/" + "descriptors" + "/" + name);
                    LogConfiguration lc = opa.loadConfiguration(this.cfgHandler, prefix);
                    result.addLogConfiguration(lc);
                }
                catch (Exception e) {
                    this.fireWarningLog("Error ocurred while scanning log configuration for '" + name + "'.", e);
                }
            }
        }
        if (element.getType().equals("server")) {
            Map vendorsCfgs;
            Configuration appsCfg = null;
            try {
                appsCfg = this.cfgHandler.openConfiguration("apps", 1);
            }
            catch (ConfigurationException e) {
                this.fireWarningLog("Error ocurred while scanning applications log configurations.", e);
            }
            if (appsCfg != null && (vendorsCfgs = ConfigurationUtil.getAllSubConfigurations(appsCfg)) != null) {
                Iterator vNames = vendorsCfgs.keySet().iterator();
                while (vNames.hasNext()) {
                    String vName = (String)vNames.next();
                    Configuration vendorCfg = ConfigurationUtil.getSubConfiguration(appsCfg, vName);
                    Map applicationsCfgs = ConfigurationUtil.getAllSubConfigurations(vendorCfg);
                    if (applicationsCfgs == null) continue;
                    Iterator aNames = applicationsCfgs.keySet().iterator();
                    while (aNames.hasNext()) {
                        String aName = (String)aNames.next();
                        Configuration applicationCfg = ConfigurationUtil.getSubConfiguration(vendorCfg, aName);
                        try {
                            if (!applicationCfg.existsSubConfiguration("Log Configurator")) continue;
                            OfflinePersistenceAdapter opa = new OfflinePersistenceAdapter(applicationCfg.getPath() + "/" + "Log Configurator");
                            LogConfiguration lc = opa.loadConfiguration(this.cfgHandler, "application_" + vName + '_' + aName);
                            result.addLogConfiguration(lc);
                        }
                        catch (ConfigurationException e) {
                            this.fireWarningLog("Error ocurred while scanning applications log configurations.", e);
                        }
                    }
                }
            }
        }
        element.setLogConfiguration(result);
    }

    /*
     * WARNING - void declaration
     */
    private String readType(Configuration cfg) throws ConfigurationException, IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(cfg.getFile("SAP_MANIFEST.MF")));
        while ((line = in.readLine()) != null) {
            void var3_3;
            if (!var3_3.startsWith("softwaretype")) continue;
            if (var3_3.endsWith("library")) {
                in.close();
                return "library";
            }
            in.close();
            return "service";
        }
        in.close();
        return null;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                String dbPropertiesFileName = args[0];
                Properties dbProperties = new Properties();
                dbProperties.load(new FileInputStream(dbPropertiesFileName));
                ConfigurationHandler cfgHandler = new ConfigurationManagerBootstrapImpl(dbProperties).getConfigurationHandler();
                ClusterData clusterData = new Scanner(cfgHandler).scan();
                System.out.println("globalDispatcher " + clusterData.getGlobalDispatcher());
                System.out.println("globalServer " + clusterData.getGlobalServer());
                System.out.println("Instances: " + clusterData.getInstances());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("\nSAP J2EE Engine. Scanner utility.\n\nUsage: Scanner db.properties");
        }
        System.exit(0);
    }
}

