/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.lib.logging.descriptors.LogFormatterDescriptor;
import com.sap.engine.lib.logging.descriptors.PersistenceAdapter;
import com.sap.engine.services.log_configurator.admin.LogXMLParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class OfflinePersistenceAdapter
extends PersistenceAdapter {
    private static final String TEMP_FILE_NAME = "temp_log_configuration.xml";
    private static final String SEPARATOR = "|";
    private String globalPath;
    private String globalName;
    private String localPath;

    public OfflinePersistenceAdapter(String path) {
        this(path, "log-configuration.xml", path);
    }

    public OfflinePersistenceAdapter(String globalPath, String localPath) {
        this(globalPath, "log-configuration.xml", localPath);
    }

    public OfflinePersistenceAdapter(String globalPath, String globalName, String localPath) {
        super((byte)1);
        this.globalPath = globalPath;
        this.localPath = localPath;
        this.globalName = globalName;
    }

    public LogConfiguration loadConfiguration(ConfigurationHandler cfgHandler, String prefix) throws ConfigurationException {
        LogXMLParser parser = new LogXMLParser();
        Configuration globalCfg = cfgHandler.openConfiguration(this.globalPath, 0);
        InputStream in = globalCfg.getFile(this.globalName);
        LogConfiguration result = parser.parse(in, (PersistenceAdapter)this, prefix);
        cfgHandler.closeConfiguration(globalCfg);
        Configuration localCfg = null;
        try {
            localCfg = cfgHandler.openConfiguration(this.localPath, 0);
            if (localCfg.existsFile("custom-log-configuration.xml")) {
                in = localCfg.getFile("custom-log-configuration.xml");
                result.addLogConfiguration(parser.parse(in, (PersistenceAdapter)this, prefix));
                cfgHandler.closeConfiguration(localCfg);
            }
        }
        catch (NameNotFoundException e) {
            // empty catch block
        }
        return result;
    }

    public LogConfiguration loadConfiguration(Configuration rootConfigua, String prefix) throws ConfigurationException {
        LogXMLParser parser = new LogXMLParser();
        Configuration globalCfg = rootConfigua.getSubConfiguration(this.globalPath);
        InputStream in = globalCfg.getFile(this.globalName);
        LogConfiguration result = parser.parse(in, (PersistenceAdapter)this, prefix);
        Configuration localCfg = null;
        try {
            localCfg = rootConfigua.getSubConfiguration(this.localPath);
            if (localCfg.existsFile("custom-log-configuration.xml")) {
                in = localCfg.getFile("custom-log-configuration.xml");
                result.addLogConfiguration(parser.parse(in, (PersistenceAdapter)this, prefix));
            }
        }
        catch (NameNotFoundException e) {
            // empty catch block
        }
        return result;
    }

    public void saveConfiguration(ConfigurationHandler cfgHandler, LogConfiguration addEditElements, LogConfiguration removedElements) throws ConfigurationException, IOException {
        String prefix = null;
        LogDestinationDescriptor[] descriptors = addEditElements.getLogDestinations();
        if (descriptors == null || descriptors.length == 0) {
            descriptors = removedElements.getLogDestinations();
        }
        if (descriptors == null || descriptors.length == 0) {
            LogFormatterDescriptor[] formatters = addEditElements.getLogFormatters();
            if (formatters == null || formatters.length == 0) {
                formatters = removedElements.getLogFormatters();
            }
            prefix = formatters == null || formatters.length == 0 ? "" : formatters[0].getPrefix();
        } else {
            prefix = descriptors[0].getPrefix();
        }
        LogConfiguration lc = this.loadConfiguration(cfgHandler, prefix);
        lc.removeLogConfiguration(removedElements);
        lc.addLogConfiguration(addEditElements);
        File tmpFile = new File(TEMP_FILE_NAME);
        LogXMLParser.writeToXml((OutputStream)new FileOutputStream(tmpFile), (LogConfiguration)lc);
        Configuration localCfg = null;
        Configuration descriptorsCfg = null;
        try {
            localCfg = cfgHandler.openConfiguration(this.localPath, 1);
        }
        catch (ConfigurationException e) {
            try {
                localCfg = cfgHandler.createSubConfiguration(this.localPath);
            }
            catch (NameNotFoundException ne) {
                int lastIndexOf = this.localPath.lastIndexOf("/");
                descriptorsCfg = cfgHandler.createSubConfiguration(this.localPath.substring(0, lastIndexOf));
                localCfg = descriptorsCfg.createSubConfiguration(this.localPath.substring(lastIndexOf + 1));
            }
        }
        localCfg.updateFileAsStream("custom-log-configuration.xml", (InputStream)new FileInputStream(tmpFile), true);
        tmpFile.delete();
        cfgHandler.commit();
        if (descriptorsCfg == null) {
            try {
                cfgHandler.closeConfiguration(localCfg);
            }
            catch (ConfigurationException e) {}
        } else {
            cfgHandler.closeConfiguration(descriptorsCfg);
        }
    }

    public String getGlobalPath() {
        return this.globalPath;
    }

    public String getGlobalName() {
        return this.globalName;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public String toString() {
        return this.globalPath + SEPARATOR + this.globalName + SEPARATOR + this.localPath;
    }

    public static OfflinePersistenceAdapter parseString(String str) throws NoSuchElementException {
        StringTokenizer st = new StringTokenizer(str, SEPARATOR);
        return new OfflinePersistenceAdapter(st.nextToken(), st.nextToken(), st.nextToken());
    }

    public InputStream getDefaultPersistentEntryStream() {
        return null;
    }

    public InputStream getPersistentEntryStream() {
        return null;
    }

    public void setPersistentEntryStream(InputStream inputStream) {
    }
}

