/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.batch;

import com.sap.engine.configtool.batch.descriptor.BatchConfigDescriptor;
import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.log.FileLogListenerImpl;
import com.sap.engine.configtool.log.Log;
import com.sap.engine.configtool.log.LogListener;
import com.sap.engine.core.configuration.bootstrap.ConfigurationManagerBootstrapImpl;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import java.util.ArrayList;
import java.util.Properties;

public final class BatchConfig
implements LogListener {
    private Properties dbProperties;
    private ArrayList tasks;
    private ConfigurationHandler cfgHandler;
    private FileLogListenerImpl fileLog;

    public BatchConfig(BatchConfigDescriptor batchConfigXml) throws Exception {
        this.dbProperties = batchConfigXml.getDbProperties();
        this.tasks = batchConfigXml.getTasks();
        this.fileLog = new FileLogListenerImpl("BatchConfig.log");
    }

    public void go() throws Exception {
        this.cfgHandler = new ConfigurationManagerBootstrapImpl(this.dbProperties).getConfigurationHandler();
        int i = 0;
        while (i < this.tasks.size()) {
            Task task = (Task)this.tasks.get(i);
            task.addLogListener(this.fileLog);
            task.addLogListener(this);
            task.go(this.cfgHandler);
            ++i;
        }
        this.fileLog.saveToFile();
    }

    public void logPerformed(Log log) {
        System.out.println(log.getMsg());
        if (log.getLevel().equals("CRITICAL")) {
            this.fileLog.saveToFile();
            System.exit(31415);
        }
    }

    public static void main(String[] args) {
        block7: {
            if (args.length > 0) {
                BatchConfigDescriptor batchConfigXml = null;
                String configXmlFileName = args[0];
                try {
                    batchConfigXml = BatchConfigDescriptor.loadFromFile(configXmlFileName);
                }
                catch (Exception e) {
                    System.out.println("Error while loading BatchConfig " + configXmlFileName + " definition file.");
                    e.printStackTrace();
                    System.exit(1);
                }
                BatchConfig batchConfig = null;
                try {
                    batchConfig = new BatchConfig(batchConfigXml);
                    batchConfig.go();
                }
                catch (Exception e) {
                    if (batchConfig != null) {
                        batchConfig.logPerformed(new Log("CRITICAL", e.getMessage(), null, e));
                        break block7;
                    }
                    e.printStackTrace();
                }
            } else {
                System.out.println("\nSAP J2EE Engine. BatchConfig utility.\n\nUsage: BatchConfig <batch_config_xml>");
            }
        }
        System.exit(0);
    }
}

