/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool;

import com.sap.engine.configtool.Property;
import com.sap.engine.configtool.PropertyMap;
import java.util.Iterator;
import java.util.Properties;

public class UMEConfigData {
    private PropertyMap _propertyMap = null;
    private PropertyMap _newPropertyMap = new PropertyMap();
    boolean changed = false;

    public void setProperties(PropertyMap pMap) {
        this._propertyMap = pMap;
    }

    public Property getProperty(String name) {
        if (this._propertyMap == null) {
            return null;
        }
        if (this._newPropertyMap.containsKey(name)) {
            return (Property)this._newPropertyMap.get(name);
        }
        if (this._propertyMap.containsKey(name)) {
            return (Property)this._propertyMap.get(name);
        }
        return null;
    }

    public void setProperty(String name, String value) {
        String oldValue;
        if (this._newPropertyMap.containsKey(name)) {
            this._newPropertyMap.remove(name);
        }
        if (this._propertyMap.containsKey(name) && ((oldValue = ((Property)this._propertyMap.get(name)).getCustomValue()) == null || oldValue != null && !oldValue.equals(value))) {
            this._newPropertyMap.put(new Property(name, value));
            this.changed = true;
        }
    }

    public Properties getChangedProperties() {
        Properties props = new Properties();
        Iterator keys = this._newPropertyMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            props.setProperty(key, ((Property)this._newPropertyMap.get(key)).getCustomValue());
        }
        return props;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void resetProperties() {
        this._newPropertyMap = new PropertyMap();
        this.changed = false;
    }

    public void applyChanges() {
        this.changed = false;
        Iterator it = this._newPropertyMap.keySet().iterator();
        while (it.hasNext()) {
            String prop = (String)it.next();
            String value = ((Property)this._newPropertyMap.get(prop)).getCustomValue();
            ((Property)this._propertyMap.get(prop)).setCustomValue(value);
        }
        this._newPropertyMap = new PropertyMap();
    }
}

