/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool;

public final class Property
implements Cloneable {
    private static final int ACTION_SET = 0;
    private static final int ACTION_DELETE = 1;
    private static final int ACTION_RESTORE_DEFAULT = 2;
    private String name;
    private String defaultValue;
    private String customValue;
    private String description;
    private boolean isSecure;
    private int action;

    public Property(String name) {
        this(name, null);
    }

    public Property(String name, String value) {
        this(name, value, value, "", false);
    }

    public Property(String name, String value, boolean isSecure) {
        this(name, value, value, "", isSecure);
    }

    public Property(String name, String defaultValue, String customValue, boolean isSecure) {
        this(name, defaultValue, customValue, "", isSecure);
    }

    public Property(String name, String defaultValue, String customValue, String description, boolean isSecure) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.customValue = customValue;
        this.description = description;
        this.isSecure = isSecure;
        this.action = 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getCustomValue() {
        return this.customValue;
    }

    public void setCustomValue(String customValue) {
        this.customValue = customValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setSecure(boolean secure) {
        this.isSecure = secure;
    }

    private int getAction() {
        return this.action;
    }

    public boolean isActionDelete() {
        return this.getAction() == 1;
    }

    public boolean isActionRestoreDefault() {
        return this.getAction() == 2;
    }

    public void setActionDelete() {
        this.setAction(1);
    }

    public void setActionRestoreDefault() {
        this.setAction(2);
    }

    private void setAction(int action) {
        this.action = action;
    }

    public Object clone() {
        Property property = new Property(this.name, this.defaultValue, this.customValue, this.description, this.isSecure);
        property.setAction(this.action);
        return property;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("name: " + this.name);
        result.append('\n');
        result.append("default value: " + this.defaultValue);
        result.append('\n');
        result.append("custom value: " + this.customValue);
        result.append('\n');
        result.append("is secure: " + this.isSecure);
        result.append('\n');
        result.append("action: " + (this.action == 2 ? "ACTION_RESTORE_DEFAULT" : (this.action == 1 ? "ACTION_DELETE" : "ACTION_SET")));
        result.append('\n');
        return result.toString();
    }
}

