/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool;

import com.sap.engine.configtool.Manager;
import com.sap.engine.configtool.Service;
import com.sap.engine.configtool.batch.OfflinePersistenceAdapter;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;

public final class ClusterElement {
    private String name;
    private String type;
    private Properties globalElementInfo;
    private Properties localElementInfo;
    private TreeMap managers;
    private TreeMap services;
    private LogConfiguration logConfiguration;
    private OfflinePersistenceAdapter kernelOfflinePersistenceAdapter;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Properties getElementInfo() {
        return PropertiesUtil.mergeProperties(this.globalElementInfo, this.localElementInfo);
    }

    public Properties getLocalElementInfo() {
        return this.localElementInfo;
    }

    public Properties getGlobalElementInfo() {
        return this.globalElementInfo;
    }

    public void setElementInfo(Properties globalElementInfo, Properties localElementInfo) {
        this.setGlobalElementInfo(globalElementInfo);
        this.setLocalElementInfo(localElementInfo);
    }

    public void setGlobalElementInfo(Properties globalElementInfo) {
        this.globalElementInfo = globalElementInfo;
    }

    public void setLocalElementInfo(Properties localElementInfo) {
        this.localElementInfo = localElementInfo;
    }

    public TreeMap getManagers() {
        return this.managers;
    }

    public void setManagers(TreeMap managers) {
        this.managers = managers;
    }

    public TreeMap getServices() {
        return this.services;
    }

    public void setServices(TreeMap services) {
        this.services = services;
    }

    public LogConfiguration getLogConfiguration() {
        return this.logConfiguration;
    }

    public void setLogConfiguration(LogConfiguration logConfiguration) {
        this.logConfiguration = logConfiguration;
    }

    public OfflinePersistenceAdapter getKernelOfflinePersistenceAdapter() {
        return this.kernelOfflinePersistenceAdapter;
    }

    public void setKernelOfflinePersistenceAdapter(OfflinePersistenceAdapter kernelOfflinePersistenceAdapter) {
        this.kernelOfflinePersistenceAdapter = kernelOfflinePersistenceAdapter;
    }

    public void mergeElement(ClusterElement globalElement) {
        if (globalElement != null) {
            TreeMap<String, Object> mergeManagers = new TreeMap<String, Object>();
            TreeMap globalManagers = globalElement.getManagers();
            if (globalManagers != null) {
                Iterator globalManagerNames = globalManagers.keySet().iterator();
                while (globalManagerNames.hasNext()) {
                    String globalManagerName = (String)globalManagerNames.next();
                    Manager globalManager = (Manager)globalManagers.get(globalManagerName);
                    mergeManagers.put(globalManagerName, globalManager.clone());
                }
            }
            if (this.managers != null) {
                mergeManagers.putAll(this.managers);
            }
            this.setManagers(mergeManagers);
            TreeMap<String, Object> mergeServices = new TreeMap<String, Object>();
            TreeMap globalServices = globalElement.getServices();
            if (globalServices != null) {
                Iterator globalServiceNames = globalServices.keySet().iterator();
                while (globalServiceNames.hasNext()) {
                    String globalServiceName = (String)globalServiceNames.next();
                    Service globalService = (Service)globalServices.get(globalServiceName);
                    mergeServices.put(globalServiceName, globalService.clone());
                }
            }
            if (this.services != null) {
                mergeServices.putAll(this.services);
            }
            this.setServices(mergeServices);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("name: " + this.name);
        result.append('\n');
        result.append("type: " + this.type);
        result.append('\n');
        result.append("elementInfo: " + PropertiesUtil.mergeProperties(this.globalElementInfo, this.localElementInfo));
        result.append('\n');
        result.append("-----");
        result.append('\n');
        result.append("services: " + this.services);
        result.append('\n');
        result.append("-----");
        result.append('\n');
        result.append("managers: " + this.managers);
        result.append('\n');
        result.append("-----");
        result.append('\n');
        result.append('\n');
        return result.toString();
    }
}

