/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.metadata.core;

import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.core.AbstractDescriptor;
import com.sap.tc.col.client.metadata.core.FieldDescriptor;
import com.sap.tc.col.client.metadata.core.ServiceModuleDescriptor;
import java.util.ArrayList;
import java.util.HashMap;

public class StructureDescriptor
extends AbstractDescriptor
implements IStructureDescriptor {
    private ServiceModuleDescriptor mServiceModuleDescriptor;
    private ArrayList fields;
    private HashMap fieldMap = new HashMap();

    public StructureDescriptor(ServiceModuleDescriptor serviceModuleDesc, String name, FieldDescriptor[] fieldArray) {
        super(name);
        this.mServiceModuleDescriptor = serviceModuleDesc;
        this.fields = new ArrayList(fieldArray.length);
        int i = 0;
        while (i < fieldArray.length) {
            if (!this.fieldMap.containsKey(fieldArray[i].getName())) {
                fieldArray[i].setStructureDescriptor(this);
                this.fields.add(fieldArray[i]);
                this.fieldMap.put(fieldArray[i].getName(), new Integer(i));
            }
            ++i;
        }
    }

    public StructureDescriptor(String name, FieldDescriptor[] fieldArray) {
        this(null, name, fieldArray);
    }

    public int getFieldIndex(String name) {
        Integer index = (Integer)this.fieldMap.get(name);
        if (index != null) {
            return index;
        }
        return -1;
    }

    public int size() {
        return this.fields.size();
    }

    public IFieldDescriptor getFieldDescriptor(int index) {
        return (IFieldDescriptor)this.fields.get(index);
    }

    public IFieldDescriptor getFieldDescriptor(String fieldName) {
        int fieldIndex = this.getFieldIndex(fieldName);
        if (fieldIndex >= 0) {
            return (IFieldDescriptor)this.fields.get(fieldIndex);
        }
        throw new IllegalArgumentException("No such field '" + fieldName + "' in structure '" + this.getName() + "'");
    }

    public IFieldDescriptor[] getFieldDescriptors() {
        IFieldDescriptor[] fieldDescriptors = new FieldDescriptor[this.fields.size()];
        this.fields.toArray(fieldDescriptors);
        return fieldDescriptors;
    }

    ServiceModuleDescriptor getServiceModuleDescriptor() {
        return this.mServiceModuleDescriptor;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("  <structure name=\"").append(this.getName()).append("\">").append(nl);
        int i = 0;
        while (i < this.fields.size()) {
            buf.append(this.fields.get(i));
            ++i;
        }
        buf.append("  </structure>").append(nl);
        return buf.toString();
    }

    public boolean hasField(String fieldName) {
        return this.fieldMap.containsKey(fieldName);
    }
}

