/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.metadata.core;

import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.core.AspectDescriptor;
import com.sap.tc.col.client.metadata.core.KeyAspectDescriptor;
import com.sap.tc.col.client.metadata.core.OperationDescriptor;
import com.sap.tc.col.client.metadata.core.ServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.core.StructureDescriptor;
import java.util.HashMap;

public class QueryDescriptor
extends OperationDescriptor
implements IQueryDescriptor {
    private HashMap mAttributes = new HashMap();
    private AspectDescriptor resultAspectDescriptor;
    private ServiceModuleDescriptor serviceModuleDescriptor;

    public QueryDescriptor(String name, String description, KeyAspectDescriptor inputKeysDescriptor, StructureDescriptor inputParameters, AspectDescriptor resultDescriptor, ServiceModuleDescriptor serviceModuleDescriptor) {
        super(name, description, inputParameters, inputKeysDescriptor);
        if (resultDescriptor == null) {
            throw new RuntimeException("resultAspectKeyDescriptor must not be null");
        }
        this.resultAspectDescriptor = resultDescriptor;
        if (serviceModuleDescriptor == null) {
            throw new RuntimeException("serviceModuleDescriptor must not be null");
        }
        this.serviceModuleDescriptor = serviceModuleDescriptor;
    }

    public IAspectDescriptor getResultAspectDescriptor() {
        return this.resultAspectDescriptor;
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor() {
        return this.serviceModuleDescriptor;
    }

    public void addAttribute(String attributeName, String value) {
        this.mAttributes.put(attributeName, value);
    }

    public String getAttributeStringValue(String attributeName) {
        return (String)this.mAttributes.get(attributeName);
    }

    public String[] getAttributeNames() {
        String[] attributes = new String[this.mAttributes.size()];
        this.mAttributes.keySet().toArray(attributes);
        return attributes;
    }

    public String getAttributePagingMode() {
        String value = this.getAttributeStringValue("COL_PAGING_MODE");
        if (value == null) {
            throw new UnsupportedOperationException("The system property 'COL_PAGING_MODE' is not provided by the backend!");
        }
        switch (new Integer(value)) {
            case 2: {
                return "FORWARD";
            }
        }
        return " ";
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("  <QueryDescriptor name=\"").append(this.getName()).append("\">").append(nl);
        if (this.hasInputParameters()) {
            buf.append(this.getInputParameters().toString());
        }
        buf.append("  </QueryDescriptor>").append(nl);
        return buf.toString();
    }

    public IStructureDescriptor getInputOptions() {
        return this.serviceModuleDescriptor.getInputOptionsStructure();
    }

    public IStructureDescriptor getSortingOptions() {
        return this.serviceModuleDescriptor.getSortingOptionsStructure();
    }

    public IStructureDescriptor getSelections() {
        return this.serviceModuleDescriptor.getSelectionsStructure();
    }

    public boolean hasInputKeys() {
        return this.getInputKeysDescriptor() != null;
    }
}

