/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.ExceptionHandling;
import com.sap.tc.logging.ExceptionManager;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Filter;
import com.sap.tc.logging.Group;
import com.sap.tc.logging.GroupFactory;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.interfaces.IObjectInfo;
import com.sap.tc.logging.interfaces.ISATChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public abstract class LogController
extends ExceptionHandling
implements IObjectInfo {
    private static String subLoc = "LogController";
    static final String MSG_GRP_NAME = null;
    static final String MSG_GRP_DESC = null;
    static final String MSG_SUB_LOC = null;
    static final Object[] MSG_ARGS = null;
    static final LogController[] MSG_RELATIVES = null;
    private static final int MAX_NUMBER_OF_OPEN_GROUP = 5;
    static final String NO_RELATIVE_EMSG = "No relative";
    static final String NO_RELATIVES_EMSG = "No relatives";
    static final String MSG_ASSERT = "Assertion failed: {0}";
    static final String MSG_THROWING = "Throwing {0}";
    static final String MSG_CATCHING = "Caught {0}";
    static final String NULL_STRING = "<null>";
    static final String POINTER = " \n[EXCEPTION]\n ";
    private String lcName;
    private String lcDescription;
    private String logVerInUse;
    private LogController parent;
    private LinkedList children = new LinkedList();
    private volatile boolean exceptionGuardian = false;
    private volatile String resourceBundleName = null;
    private volatile boolean resourceBundleSet = false;
    private volatile ClassLoader classLoader = null;
    private volatile boolean classLoaderSet = false;
    ThreadLocalInfo thrLocals;
    private volatile Collection filters = new HashSet();
    private volatile boolean parentLocalLogs = false;
    private volatile Collection logsRegistry = new HashSet();
    private volatile Collection logsNormal = new HashSet();
    private volatile Collection logsPrivate = new HashSet();
    private volatile Map logsLocal = new HashMap();
    private volatile int minSeverity = 0;
    private volatile int maxSeverity = 701;
    private volatile int prevMinSeverity = 0;
    private volatile int prevMaxSeverity = 701;
    volatile int effSeverity = 701;
    private Relations relations = new Relations();
    private Regarders regarders = new Regarders();
    private volatile int minEffRelationSeverity = 701;
    private int loggedSumCnt = 0;
    private int loggedCnt = 0;
    private boolean groupInUse = false;
    private static ISATChecker isActivityTracking;
    private int groupSize = 5;
    private static final Relation standardRelation;

    LogController(String name) {
        this.lcName = name;
        this.parent = null;
    }

    LogController(String name, LogController parent) {
        this.lcName = name;
        this.parent = parent;
        parent.addChild(this);
        this.initializeSeverities();
        this.initializeLogs();
    }

    public void release() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Regarders regarders;
            Object[] lcs = this.getChildrenInt().toArray();
            int i = 0;
            while (i < lcs.length) {
                ((LogController)lcs[i]).release();
                ++i;
            }
            Regarders regarders2 = regarders = this.getRegarders();
            synchronized (regarders2) {
                while (!regarders.isEmpty()) {
                    LogController lc = regarders.getFirst();
                    lc.setEffectiveSeverity(this);
                    regarders.remove(lc);
                }
            }
            this.closeGroupAllInt();
            this.removeLogs();
        }
        LoggingManager.getLoggingManager().release(this);
        APILogger.instrumentIntByAPI(subLoc + "[release()]", MSGCollection.CONFIGURATION_RESET_ID, MSGCollection.CONFIGURATION_RESET_TEXT, new Object[]{this.getName()});
    }

    public void reset() {
        this.resetInt();
        LoggingManager.getLoggingManager().notifyLogControllerReset(this, false);
        APILogger.instrumentIntByAPI(subLoc + "[reset()]", MSGCollection.CONFIGURATION_RESET_ID, MSGCollection.CONFIGURATION_RESET_TEXT, new Object[]{this.getName()});
    }

    public void resetAll() {
        this.resetAllInt();
        LoggingManager.getLoggingManager().notifyLogControllerReset(this, true);
        APILogger.instrumentIntByAPI(subLoc + "[resetAll()]", MSGCollection.CONFIGURATION_RESET_ID, MSGCollection.CONFIGURATION_RESET_TEXT, new Object[]{this.getName()});
    }

    public synchronized String getName() {
        return this.lcName;
    }

    public synchronized void setName(String name) {
        this.lcName = name;
    }

    public synchronized String getDescription() {
        return this.lcDescription;
    }

    public synchronized void setDescription(String value) {
        this.lcDescription = value;
    }

    public synchronized String getVerInUse() {
        return this.logVerInUse;
    }

    public Collection getChildren() {
        Collection children;
        Collection collection = children = this.getChildrenInt();
        synchronized (collection) {
            Collection collection2 = Collections.unmodifiableCollection(new ArrayList(children));
            return collection2;
        }
    }

    public void closeGroup() {
        this.closeGroupInt();
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(int size) {
        int oldValue = -1;
        int newValue = -1;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getGroupSize();
            this.groupSize = size;
            newValue = this.getGroupSize();
        }
        if (oldValue != newValue) {
            APILogger.instrumentIntByAPI(subLoc + "[setGroupSize(int size)]", MSGCollection.CONFIGURATION_IS_CHANGED_ID, MSGCollection.CONFIGURATION_IS_CHANGED_TEXT, new Object[]{"max group size", "LogController", this.getName(), "" + oldValue, "" + newValue});
        }
    }

    public LogRecord groupT(String msg) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityTInt(800, this, group.getRelatives(), group.getSubLocationName(), msg, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord groupT(String subloc, String msg) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityTInt(800, this, group.getRelatives(), subloc, msg, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord groupT(String msg, Object[] args) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityTInt(800, this, group.getRelatives(), group.getSubLocationName(), msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord groupT(String subloc, String msg, Object[] args) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityTInt(800, this, group.getRelatives(), subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord group(Object msgCode) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityInt(800, this, group.getRelatives(), group.getSubLocationName(), msgCode, null, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord group(String subloc, Object msgCode) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityInt(800, this, group.getRelatives(), subloc, msgCode, null, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord group(Object msgCode, Object[] args) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityInt(800, this, group.getRelatives(), group.getSubLocationName(), msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord group(String subloc, Object msgCode, Object[] args) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityInt(800, this, group.getRelatives(), subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord group(Object msgCode, String msgClear) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityInt(800, this, group.getRelatives(), group.getSubLocationName(), msgCode, msgClear, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord group(String subloc, Object msgCode, String msgClear) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityInt(800, this, group.getRelatives(), subloc, msgCode, msgClear, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord group(Object msgCode, Object[] args, String msgClear) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityInt(800, this, group.getRelatives(), group.getSubLocationName(), msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord group(String subloc, Object msgCode, Object[] args, String msgClear) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityInt(800, this, group.getRelatives(), subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord getRecord() {
        return LoggingManager.getLoggingManager().getRecord();
    }

    public int getMinimumSeverity() {
        return this.minSeverity;
    }

    public int getMinimumSeverity(LogController relative) {
        if (this.check(relative)) {
            int minRelationSeverity = this.relations.get((LogController)relative).minSeverity;
            return this.minSeverity < minRelationSeverity ? this.minSeverity : minRelationSeverity;
        }
        return this.minSeverity;
    }

    public int getMinimumSeverity(LogController[] relatives) {
        this.check(relatives);
        if (relatives != null) {
            int i = 0;
            while (i < relatives.length) {
                int minRelationSeverity = this.relations.get((LogController)relatives[i]).minSeverity;
                this.minSeverity = this.minSeverity < minRelationSeverity ? this.minSeverity : minRelationSeverity;
                ++i;
            }
            return this.minSeverity;
        }
        return this.minSeverity;
    }

    public int getEffectiveSeverity() {
        return this.effSeverity;
    }

    public int getEffectiveSeverity(LogController relative) {
        if (this.check(relative)) {
            int effRelationSeverity = this.relations.get((LogController)relative).effSeverity;
            return this.effSeverity < effRelationSeverity ? this.effSeverity : effRelationSeverity;
        }
        return this.effSeverity;
    }

    public int getEffectiveSeverity(LogController[] relatives) {
        if (relatives != null) {
            this.check(relatives);
            int i = 0;
            while (i < relatives.length) {
                int effRelationSeverity = this.relations.get((LogController)relatives[i]).effSeverity;
                this.effSeverity = this.effSeverity < effRelationSeverity ? this.effSeverity : effRelationSeverity;
                ++i;
            }
        }
        return this.effSeverity;
    }

    public int getMaximumSeverity() {
        return this.maxSeverity;
    }

    public int getMaximumSeverity(LogController relative) {
        if (this.check(relative)) {
            int maxRelationSeverity = this.relations.get((LogController)relative).maxSeverity;
            return this.maxSeverity < maxRelationSeverity ? this.maxSeverity : maxRelationSeverity;
        }
        return this.maxSeverity;
    }

    public int getMaximumSeverity(LogController[] relatives) {
        this.check(relatives);
        if (relatives != null) {
            int i = 0;
            while (i < relatives.length) {
                int maxRelationSeverity = this.relations.get((LogController)relatives[i]).maxSeverity;
                this.maxSeverity = this.maxSeverity < maxRelationSeverity ? this.maxSeverity : maxRelationSeverity;
                ++i;
            }
            return this.maxSeverity;
        }
        return this.maxSeverity;
    }

    public void setMinimumSeverity(int severity) {
        int oldValue = -1;
        int newValue = -1;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getMinimumSeverity();
            LogController parent = this.getParentInt();
            if (parent != null) {
                this.minSeverity = severity = Severity.correct(severity);
                if (this.maxSeverity < this.minSeverity) {
                    this.maxSeverity = this.minSeverity;
                }
                this.calculateEffectiveSeverity();
            } else {
                this.setEffectiveSeverity(severity);
            }
            newValue = this.getMinimumSeverity();
        }
        if (oldValue != newValue) {
            APILogger.instrumentIntByAPI(subLoc + "[setMinimumSeverity(int severity)]", MSGCollection.CONFIGURATION_IS_CHANGED_ID, MSGCollection.CONFIGURATION_IS_CHANGED_TEXT, new Object[]{"minimum severity", "LogController", this.getName(), Severity.toString(oldValue), Severity.toString(newValue)});
        }
    }

    public void setMinimumSeverity() {
        int oldValue = -1;
        int newValue = -1;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getMinimumSeverity();
            LogController parent = this.getParentInt();
            if (parent != null) {
                this.minSeverity = 0;
                this.calculateEffectiveSeverity();
            }
            newValue = this.getMinimumSeverity();
        }
        if (oldValue != newValue) {
            APILogger.instrumentIntByAPI(subLoc + "[setMinimumSeverity()]", MSGCollection.CONFIGURATION_IS_CHANGED_ID, MSGCollection.CONFIGURATION_IS_CHANGED_TEXT, new Object[]{"minimum severity", "LogController", this.getName(), Severity.toString(oldValue), Severity.toString(newValue)});
        }
    }

    public void setEffectiveSeverity(int severity) {
        int oldValue = -1;
        int newValue = -1;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getEffectiveSeverity();
            severity = Severity.correct(severity);
            LogController parent = this.getParentInt();
            if (parent == null) {
                this.effSeverity = severity;
            }
            this.minSeverity = severity;
            this.maxSeverity = severity;
            this.calculateEffectiveSeverity();
            newValue = this.getEffectiveSeverity();
        }
        if (oldValue != newValue) {
            APILogger.instrumentIntByAPI(subLoc + "[setEffectiveSeverity(int severity)]", MSGCollection.CONFIGURATION_IS_CHANGED_ID, MSGCollection.CONFIGURATION_IS_CHANGED_TEXT, new Object[]{"effective severity", "LogController", this.getName(), Severity.toString(oldValue), Severity.toString(newValue)});
        }
    }

    public void setEffectiveSeverity() {
        int oldValue = -1;
        int newValue = -1;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getEffectiveSeverity();
            LogController parent = this.getParentInt();
            if (parent != null) {
                this.minSeverity = 0;
                this.maxSeverity = 701;
                this.calculateEffectiveSeverity();
            }
            newValue = this.getEffectiveSeverity();
        }
        if (oldValue != newValue) {
            APILogger.instrumentIntByAPI(subLoc + "[setEffectiveSeverity()]", MSGCollection.CONFIGURATION_IS_CHANGED_ID, MSGCollection.CONFIGURATION_IS_CHANGED_TEXT, new Object[]{"effective severity", "LogController", this.getName(), Severity.toString(oldValue), Severity.toString(newValue)});
        }
    }

    public void setMaximumSeverity(int severity) {
        int oldValue = -1;
        int newValue = -1;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getMaximumSeverity();
            LogController parent = this.getParentInt();
            if (parent != null) {
                this.maxSeverity = severity = Severity.correct(severity);
                if (this.maxSeverity < this.minSeverity) {
                    this.minSeverity = this.maxSeverity;
                }
                this.calculateEffectiveSeverity();
            } else {
                this.setEffectiveSeverity(severity);
            }
            newValue = this.getMaximumSeverity();
        }
        if (oldValue != newValue) {
            APILogger.instrumentIntByAPI(subLoc + "[setMaximumSeverity(int severity)]", MSGCollection.CONFIGURATION_IS_CHANGED_ID, MSGCollection.CONFIGURATION_IS_CHANGED_TEXT, new Object[]{"maximum severity", "LogController", this.getName(), Severity.toString(oldValue), Severity.toString(newValue)});
        }
    }

    public void setMaximumSeverity() {
        int oldValue = -1;
        int newValue = -1;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getMaximumSeverity();
            LogController parent = this.getParentInt();
            if (parent != null) {
                this.maxSeverity = 701;
                this.calculateEffectiveSeverity();
            }
            newValue = this.getMaximumSeverity();
        }
        if (oldValue != newValue) {
            APILogger.instrumentIntByAPI(subLoc + "[setMaximumSeverity()]", MSGCollection.CONFIGURATION_IS_CHANGED_ID, MSGCollection.CONFIGURATION_IS_CHANGED_TEXT, new Object[]{"maximum severity", "LogController", this.getName(), Severity.toString(oldValue), Severity.toString(newValue)});
        }
    }

    public Collection getLogs() {
        Collection collection = this.logsNormal;
        synchronized (collection) {
            if (!this.logsNormal.isEmpty()) {
                Collection collection2 = Collections.unmodifiableCollection(this.logsNormal);
                return collection2;
            }
        }
        return Collections.EMPTY_SET;
    }

    public Collection getLocalLogs() {
        Map map = this.logsLocal;
        synchronized (map) {
            if (!this.logsLocal.isEmpty()) {
                Collection collection = Collections.unmodifiableCollection(this.logsLocal.keySet());
                return collection;
            }
        }
        return Collections.EMPTY_SET;
    }

    public Collection getPrivateLogs() {
        Collection collection = this.logsPrivate;
        synchronized (collection) {
            if (!this.logsPrivate.isEmpty()) {
                Collection collection2 = Collections.unmodifiableCollection(this.logsPrivate);
                return collection2;
            }
        }
        return Collections.EMPTY_SET;
    }

    public Collection getAllLogs() {
        Collection collection = this.logsRegistry;
        synchronized (collection) {
            if (!this.logsRegistry.isEmpty()) {
                Collection collection2 = Collections.unmodifiableCollection(this.logsRegistry);
                return collection2;
            }
        }
        return Collections.EMPTY_SET;
    }

    public void addLog(Log log) {
        boolean result = false;
        if (log != null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (this.addLogNormalInt(log)) {
                    result = true;
                    this.addLogToRegistry(log);
                    log.addOwner(this.getName());
                }
            }
            if (result) {
                LoggingManager.getLoggingManager().notifyAddLog(log);
                APILogger.instrumentIntByAPI(subLoc + "[addLog()]", MSGCollection.CONFIGURATION_NEW_ITEM_ID, MSGCollection.CONFIGURATION_NEW_ITEM_TEXT, new Object[]{"Log", log.getName(), this.getName()});
            }
        } else {
            APILogger.logIntByAPI(400, subLoc + "[addLog(Log log)]", MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, new String[]{"Normal Log", "LogController", this.getName()});
        }
    }

    public void addLocalLog(Log log) {
        boolean result = false;
        if (log != null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (this.addLogLocalInt(this, log)) {
                    result = true;
                    this.addLogToRegistry(log);
                    log.addOwner(this.getName());
                }
            }
            if (result) {
                LoggingManager.getLoggingManager().notifyAddLog(log);
                APILogger.instrumentIntByAPI(subLoc + "[addLocalLog()]", MSGCollection.CONFIGURATION_NEW_ITEM_ID, MSGCollection.CONFIGURATION_NEW_ITEM_TEXT, new Object[]{"Local log", log.getName(), this.getName()});
            }
        } else {
            APILogger.logIntByAPI(400, subLoc + "[addLocalLog(Log log)]", MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, new String[]{"Local Log", "LogController", this.getName()});
        }
    }

    public void addPrivateLog(Log log) {
        boolean result = false;
        if (log != null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (this.addLogPrivateInt(log)) {
                    result = true;
                    this.addLogToRegistry(log);
                    log.addOwner(this.getName());
                }
            }
            if (result) {
                LoggingManager.getLoggingManager().notifyAddLog(log);
                APILogger.instrumentIntByAPI(subLoc + "[addPrivateLog()]", MSGCollection.CONFIGURATION_NEW_ITEM_ID, MSGCollection.CONFIGURATION_NEW_ITEM_TEXT, new Object[]{"Private log", log.getName(), this.getName()});
            }
        } else {
            APILogger.logIntByAPI(400, subLoc + "[addPrivateLog(Log log)]", MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, new String[]{"Private Log", "LogController", this.getName()});
        }
    }

    public void removeLog(Log log) {
        if (log != null) {
            boolean result = false;
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (this.isLogInRegistry(log)) {
                    if (!this.logsNormal.isEmpty()) {
                        this.removeLogNormalInt(log);
                    }
                    if (!this.logsLocal.isEmpty()) {
                        this.removeLogLocalInt(log);
                    }
                    if (!this.logsPrivate.isEmpty()) {
                        this.removeLogPrivateInt(log);
                    }
                    result = true;
                }
            }
            if (result) {
                LoggingManager.getLoggingManager().notifyRemoveLog(log);
                APILogger.instrumentIntByAPI(subLoc + "[removeLog(Log log)]", MSGCollection.CONFIGURATION_REMOVE_ITEM_ID, MSGCollection.CONFIGURATION_REMOVE_ITEM_TEXT, new Object[]{"Log", log.getName(), this.getName()});
            }
        }
    }

    public void removeLogs() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!this.logsNormal.isEmpty()) {
                this.removeLogsNormalInt();
            }
            if (!this.logsLocal.isEmpty()) {
                this.removeLogsLocalInt();
            }
            if (!this.logsPrivate.isEmpty()) {
                this.removeLogsPrivateInt();
            }
        }
        APILogger.instrumentIntByAPI(subLoc + "[removeLogs()]", MSGCollection.CONFIGURATION_REMOVE_ITEM_ID, MSGCollection.CONFIGURATION_REMOVE_ITEM_TEXT, new Object[]{"Log", "ALL", this.getName()});
    }

    public boolean isFiltersAgreeing(LogRecord rec) {
        Collection filters;
        if (rec.getSeverity() != 800 && !(filters = this.getFiltersInt()).isEmpty()) {
            Iterator iter = filters.iterator();
            try {
                while (iter.hasNext()) {
                    if (((Filter)iter.next()).beLogged(rec)) continue;
                    return false;
                }
            }
            catch (Exception ex) {
                APILogger.logIntByAPI(400, subLoc + "[isFiltersAgreeing(LogRecord rec)]", MSGCollection.LOGGING_MSG_ID_FILTER_EXCEPTION, MSGCollection.LOGGING_MSG_STR_FILTER_EXCEPTION, new String[]{"LogController", this.getName()});
                APILogger.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
        }
        return true;
    }

    public Collection getFilters() {
        Collection collection = this.filters;
        synchronized (collection) {
            if (!this.filters.isEmpty()) {
                Collection collection2 = Collections.unmodifiableCollection(this.getFiltersInt());
                return collection2;
            }
        }
        return Collections.EMPTY_LIST;
    }

    Collection getFiltersInt() {
        Collection collection = this.filters;
        synchronized (collection) {
            if (!this.filters.isEmpty()) {
                Collection collection2 = this.filters;
                return collection2;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public void addFilter(Filter filter) {
        boolean result = false;
        if (filter != null) {
            Collection collection = this.filters;
            synchronized (collection) {
                if (!this.filters.contains(filter)) {
                    this.filters.add(filter);
                    result = true;
                }
            }
            if (result) {
                APILogger.instrumentIntByAPI(subLoc + "[addFilter()]", MSGCollection.CONFIGURATION_NEW_ITEM_ID, MSGCollection.CONFIGURATION_NEW_ITEM_TEXT, new Object[]{"Filter", filter.getClass().getName(), this.getName()});
            }
        } else {
            APILogger.logIntByAPI(400, subLoc + "[addFilter(Filter filter)]", MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, new String[]{"Filter", "LogController", this.getName()});
        }
    }

    public void removeFilter(Filter filter) {
        Collection collection = this.filters;
        synchronized (collection) {
            this.filters.remove(filter);
        }
        APILogger.instrumentIntByAPI(subLoc + "[removeFilter(Filter filter)]", MSGCollection.CONFIGURATION_REMOVE_ITEM_ID, MSGCollection.CONFIGURATION_REMOVE_ITEM_TEXT, new Object[]{"filter", filter.getClass().getName(), this.getName()});
    }

    public void removeFilters() {
        Collection collection = this.filters;
        synchronized (collection) {
            this.filters.clear();
        }
        APILogger.instrumentIntByAPI(subLoc + "[removeFilters()]", MSGCollection.CONFIGURATION_REMOVE_ITEM_ID, MSGCollection.CONFIGURATION_REMOVE_ITEM_TEXT, new Object[]{"Filter", "ALL", this.getName()});
    }

    public LogController[] getRelatives() {
        LogController[] logControlers = null;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.relations == null) {
                LogController[] logControllerArray = null;
                return logControllerArray;
            }
            if (!this.relations.relations.isEmpty()) {
                logControlers = this.relations.relations.keySet().toArray(new LogController[0]);
            }
        }
        return logControlers;
    }

    public String getResourceBundleName() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.resourceBundleSet) {
                String string = this.resourceBundleName;
                return string;
            }
        }
        LogController parent = this.getParentInt();
        if (parent != null) {
            return parent.getResourceBundleName();
        }
        return null;
    }

    public void setResourceBundleName(String resourceBundleName) {
        String oldValue = "";
        String newValue = "";
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getResourceBundleName();
            this.resourceBundleName = resourceBundleName;
            this.resourceBundleSet = true;
            newValue = this.getResourceBundleName();
        }
        APILogger.instrumentIntByAPI(subLoc + "[setResourceBundleName(String resourceBundleName)]", MSGCollection.CONFIGURATION_IS_CHANGED_ID, MSGCollection.CONFIGURATION_IS_CHANGED_TEXT, new Object[]{"resource bundle name", "LogController", this.getName(), oldValue, newValue});
    }

    public void setResourceBundleName() {
        String oldValue = "";
        String newValue = "";
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getResourceBundleName();
            this.resourceBundleName = null;
            this.resourceBundleSet = false;
            newValue = this.getResourceBundleName();
        }
        APILogger.instrumentIntByAPI(subLoc + "[setResourceBundleName()]", MSGCollection.CONFIGURATION_IS_CHANGED_ID, MSGCollection.CONFIGURATION_IS_CHANGED_TEXT, new Object[]{"resource bundle name", "LogController", this.getName(), oldValue, newValue});
    }

    public synchronized ClassLoader getClassLoader() {
        if (this.classLoaderSet) {
            return this.classLoader;
        }
        LogController parent = this.getParentInt();
        if (parent != null) {
            return parent.getClassLoader();
        }
        return null;
    }

    public synchronized void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.classLoaderSet = true;
    }

    public synchronized void setClassLoader() {
        this.classLoader = null;
        this.classLoaderSet = false;
    }

    public boolean beLogged(int severity) {
        return this.isActivityTracking() || severity >= this.effSeverity;
    }

    public boolean beLogged(int severity, LogController relative) {
        if (this.isActivityTracking() || severity >= this.effSeverity) {
            return true;
        }
        if (severity < this.minEffRelationSeverity) {
            return false;
        }
        return severity >= this.getEffectiveSeverity(relative);
    }

    public boolean beLogged(int severity, LogController[] relatives) {
        if (this.isActivityTracking() || severity >= this.effSeverity) {
            return true;
        }
        if (severity < this.minEffRelationSeverity) {
            return false;
        }
        return severity >= this.getEffectiveSeverity(relatives);
    }

    public boolean beDebug() {
        return this.isActivityTracking() || 100 >= this.effSeverity;
    }

    public boolean beDebug(LogController relative) {
        if (this.isActivityTracking() || 100 >= this.effSeverity) {
            return true;
        }
        if (100 < this.minEffRelationSeverity) {
            return false;
        }
        return 100 >= this.getEffectiveSeverity(relative);
    }

    public boolean beDebug(LogController[] relatives) {
        if (this.isActivityTracking() || 100 >= this.effSeverity) {
            return true;
        }
        if (100 < this.minEffRelationSeverity) {
            return false;
        }
        return 100 >= this.getEffectiveSeverity(relatives);
    }

    public boolean bePath() {
        return this.isActivityTracking() || 200 >= this.effSeverity;
    }

    public boolean bePath(LogController relative) {
        if (this.isActivityTracking() || 200 >= this.effSeverity) {
            return true;
        }
        if (200 < this.minEffRelationSeverity) {
            return false;
        }
        return 200 >= this.getEffectiveSeverity(relative);
    }

    public boolean bePath(LogController[] relatives) {
        if (this.isActivityTracking() || 200 >= this.effSeverity) {
            return true;
        }
        if (200 < this.minEffRelationSeverity) {
            return false;
        }
        return 200 >= this.getEffectiveSeverity(relatives);
    }

    public boolean beInfo() {
        return this.isActivityTracking() || 300 >= this.effSeverity;
    }

    public boolean beInfo(LogController relative) {
        if (this.isActivityTracking() || 300 >= this.effSeverity) {
            return true;
        }
        if (300 < this.minEffRelationSeverity) {
            return false;
        }
        return 300 >= this.getEffectiveSeverity(relative);
    }

    public boolean beInfo(LogController[] relatives) {
        if (this.isActivityTracking() || 300 >= this.effSeverity) {
            return true;
        }
        if (300 < this.minEffRelationSeverity) {
            return false;
        }
        return 300 >= this.getEffectiveSeverity(relatives);
    }

    public boolean beWarning() {
        return this.isActivityTracking() || 400 >= this.effSeverity;
    }

    public boolean beWarning(LogController relative) {
        if (this.isActivityTracking() || 400 >= this.effSeverity) {
            return true;
        }
        if (400 < this.minEffRelationSeverity) {
            return false;
        }
        return 400 >= this.getEffectiveSeverity(relative);
    }

    public boolean beWarning(LogController[] relatives) {
        if (this.isActivityTracking() || 400 >= this.effSeverity) {
            return true;
        }
        if (400 < this.minEffRelationSeverity) {
            return false;
        }
        return 400 >= this.getEffectiveSeverity(relatives);
    }

    public boolean beError() {
        return this.isActivityTracking() || 500 >= this.effSeverity;
    }

    public boolean beError(LogController relative) {
        if (this.isActivityTracking() || 500 >= this.effSeverity) {
            return true;
        }
        if (500 < this.minEffRelationSeverity) {
            return false;
        }
        return 500 >= this.getEffectiveSeverity(relative);
    }

    public boolean beError(LogController[] relatives) {
        if (this.isActivityTracking() || 500 >= this.effSeverity) {
            return true;
        }
        if (500 < this.minEffRelationSeverity) {
            return false;
        }
        return 500 >= this.getEffectiveSeverity(relatives);
    }

    public boolean beFatal() {
        return this.isActivityTracking() || 600 >= this.effSeverity;
    }

    public boolean beFatal(LogController relative) {
        if (this.isActivityTracking() || 600 >= this.effSeverity) {
            return true;
        }
        if (600 < this.minEffRelationSeverity) {
            return false;
        }
        return 600 >= this.getEffectiveSeverity(relative);
    }

    public boolean beFatal(LogController[] relatives) {
        if (this.isActivityTracking() || 600 >= this.effSeverity) {
            return true;
        }
        if (600 < this.minEffRelationSeverity) {
            return false;
        }
        return 600 >= this.getEffectiveSeverity(relatives);
    }

    public boolean beGroup() {
        return this.isActivityTracking() || this.beGroupInt(this.getCurrentGroup());
    }

    public boolean isActivityTracking() {
        return isActivityTracking != null && isActivityTracking.isActivity(this.getName());
    }

    public static synchronized void setActivityTracking(ISATChecker value) {
        isActivityTracking = value;
    }

    public int getLoggedCount() {
        return this.loggedSumCnt;
    }

    public void resetLoggedCount() {
        this.loggedSumCnt = 0;
    }

    public int getLoggedCnt() {
        return this.loggedCnt;
    }

    protected void resetThreadLocalInfo() {
        this.thrLocals = null;
    }

    protected ThreadLocalInfo getThreadLocalInfo() {
        if (this.thrLocals == null) {
            this.thrLocals = new ThreadLocalInfo();
        }
        return this.thrLocals;
    }

    protected boolean isGroupInUse() {
        return this.groupInUse;
    }

    void setGroupInUse(boolean value) {
        if (value) {
            this.initThreadLocals();
        } else if (!value) {
            this.thrLocals = null;
        }
        this.groupInUse = value;
    }

    protected Group getCurrentGroup() {
        if (this.thrLocals != null) {
            return this.thrLocals.getGroup();
        }
        return null;
    }

    void initThreadLocals() {
        if (this.thrLocals == null) {
            this.thrLocals = new ThreadLocalInfo();
        }
    }

    protected Map getLocalLogsMap() {
        if (this.logsLocal != null) {
            return this.logsLocal;
        }
        return Collections.EMPTY_MAP;
    }

    protected String[] convertRelatives(LogController[] relatives) {
        String[] tmpValues = null;
        if (relatives != null) {
            tmpValues = new String[relatives.length];
            int i = 0;
            while (i < relatives.length) {
                tmpValues[i] = relatives[i].getName();
                ++i;
            }
        }
        return tmpValues;
    }

    protected LogRecord logIntByAPI(int severity, Location loc, String subloc, Object msgCode, String msgClear, Object[] args) {
        return this.logInt(severity, loc, null, subloc, msgCode, msgClear, 1, args);
    }

    protected LogRecord catchingIntByAPI(Throwable exc) {
        return this.logTInt(200, this, MSG_RELATIVES, MSG_SUB_LOC, MSG_CATCHING, 1, new Object[]{ExceptionManager.getStackTrace(exc)});
    }

    protected LogRecord messageInternal(LogRecord rec) throws Exception {
        LogRecord writtenRec = null;
        if (this.isFiltersAgreeing(rec)) {
            LogRecord tmpRec;
            if (!this.logsNormal.isEmpty() && (tmpRec = this.writeToLogs(this.logsNormal, rec)) != null) {
                this.setSumLogged();
                writtenRec = tmpRec;
            }
            if (!this.logsLocal.isEmpty() && (tmpRec = this.writeToLocalLogs(this.logsLocal, rec)) != null) {
                this.setSumLogged();
                writtenRec = tmpRec;
            }
            if (!this.logsPrivate.isEmpty() && (tmpRec = this.writeToLogs(this.logsPrivate, rec)) != null) {
                this.setSumLogged();
                writtenRec = tmpRec;
            }
            if (writtenRec != null) {
                this.setRecord(writtenRec);
                this.setLogged();
                LoggingManager.getLoggingManager().notifyWriteMessage(rec);
            }
        }
        return writtenRec;
    }

    LogRecord logTInt(int severity, LogController loc, LogController[] relatives, String subloc, String msg, int msgType, Object[] args) {
        return this.logTInt(severity, loc, relatives, subloc, msg, msgType, args, null);
    }

    LogRecord logTInt(int severity, LogController loc, LogController[] relatives, String subloc, String msg, int msgType, Object[] args, Throwable msgExc) {
        LogRecord writtenRec = null;
        try {
            String locName = loc.getName();
            if (subloc != null) {
                locName = locName + '.' + subloc;
            }
            LogRecord rec = new LogRecord(this, locName, severity, this.convertRelatives(relatives), msgType, msg, this.checkArguments(args), msgExc);
            Group group = null;
            if (this.thrLocals != null) {
                group = this.getCurrentGroup();
                this.fillLogRecordWithGroupData(rec, group);
            }
            writtenRec = this.messageInternal(rec);
        }
        catch (Exception ex) {
            if (this.exceptionGuardian) {
                return writtenRec;
            }
            this.exceptionGuardian = true;
            APILogger.logIntByAPI(400, subLoc + "[logIntT(...)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
            this.handleException(ex, 3);
            this.exceptionGuardian = false;
        }
        return writtenRec;
    }

    LogRecord logSeverityTInt(int severity, LogController loc, LogController[] relatives, String subloc, String msg, int msgType, Object[] args) {
        return this.logSeverityTInt(severity, loc, relatives, subloc, msg, msgType, args, null);
    }

    LogRecord logSeverityTInt(int severity, LogController loc, LogController[] relatives, String subloc, String msg, int msgType, Object[] args, Throwable msgExc) {
        LogRecord writtenRec = null;
        writtenRec = this.logTInt(severity, loc, relatives, subloc, msg, msgType, args, msgExc);
        if (relatives != null) {
            int i = 0;
            while (i < relatives.length) {
                LogController[] newRelatives = this.copyRelatives(relatives[i], relatives);
                if (relatives[i].beLogged(severity, newRelatives)) {
                    relatives[i].logTInt(severity, loc, newRelatives, subloc, msg, msgType, args, msgExc);
                }
                ++i;
            }
        }
        return writtenRec;
    }

    LogRecord logInt(int severity, LogController logC, LogController[] relatives, String subloc, Object msgCode, String msgClear, int msgType, Object[] args) {
        return this.logInt(severity, logC, relatives, subloc, msgCode, msgClear, msgType, args, null);
    }

    LogRecord logInt(int severity, LogController logC, LogController[] relatives, String subloc, Object msgCode, String msgClear, int msgType, Object[] args, Throwable msgExc) {
        LogRecord writtenRec = null;
        try {
            String resBundleName = logC.getResourceBundleName();
            if (resBundleName == null) {
                resBundleName = this.getResourceBundleName();
            }
            String locName = logC.getName();
            if (subloc != null) {
                locName = locName + '.' + subloc;
            }
            LogRecord rec = new LogRecord(this, locName, severity, this.convertRelatives(relatives), msgType, msgCode, resBundleName, msgClear, this.checkArguments(args));
            Group group = null;
            if (this.thrLocals != null) {
                group = this.getCurrentGroup();
                this.fillLogRecordWithGroupData(rec, group);
            }
            writtenRec = this.messageInternal(rec);
        }
        catch (Exception ex) {
            if (this.exceptionGuardian) {
                return writtenRec;
            }
            this.exceptionGuardian = true;
            APILogger.logIntByAPI(400, subLoc + "[logInt(...)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
            this.handleException(ex, 3);
            this.exceptionGuardian = false;
        }
        return writtenRec;
    }

    LogRecord logSeverityInt(int severity, LogController loc, LogController[] relatives, String subloc, Object msgCode, String msgClear, int msgType, Object[] args) {
        return this.logSeverityInt(severity, loc, relatives, subloc, msgCode, msgClear, msgType, args, null);
    }

    LogRecord logSeverityInt(int severity, LogController loc, LogController[] relatives, String subloc, Object msgCode, String msgClear, int msgType, Object[] args, Throwable msgExc) {
        LogRecord writtenRec = this.logInt(severity, loc, relatives, subloc, msgCode, msgClear, msgType, args, msgExc);
        if (relatives != null) {
            int i = 0;
            while (i < relatives.length) {
                LogController[] newRelatives = this.copyRelatives(relatives[i], relatives);
                if (relatives[i].beLogged(severity, newRelatives)) {
                    relatives[i].logInt(severity, loc, newRelatives, subloc, msgCode, msgClear, msgType, args, msgExc);
                }
                ++i;
            }
        }
        return writtenRec;
    }

    void openGroupInt(String grpName, String grpDescription, int severity, String subloc) {
        if (this.beLogged(severity)) {
            this.setGroupInUse(true);
            GroupFactory.openGroup(this.getGroupSize(), this, MSG_RELATIVES, grpName, grpDescription, severity, subloc);
        }
    }

    void openGroupInt(String grpName, String grpDescription, int severity, String subloc, LogController logC) {
        if (this.beLogged(severity, logC)) {
            this.setGroupInUse(true);
            GroupFactory.openGroup(this.getGroupSize(), this, new LogController[]{logC}, grpName, grpDescription, severity, subloc);
        }
        logC.openGroupInt(grpName, grpDescription, severity, subloc);
    }

    void openGroupInt(String grpName, String grpDescription, int severity, String subloc, LogController[] logCs) {
        if (this.beLogged(severity, logCs)) {
            this.setGroupInUse(true);
            GroupFactory.openGroup(this.getGroupSize(), this, logCs, grpName, grpDescription, severity, subloc);
            int i = 0;
            while (i < logCs.length) {
                logCs[i].openGroupInt(grpName, grpDescription, severity, subloc);
                ++i;
            }
        }
    }

    void closeGroupInt() {
        this.closeGroupInt(this.getCurrentGroup());
    }

    void closeGroupInt(Group group) {
        if (group != null) {
            this.groupT("Closing group");
            GroupFactory.closeGroup(this, group);
        }
    }

    LogController getParentInt() {
        return this.parent;
    }

    Collection getChildrenInt() {
        return this.children;
    }

    void addChild(LogController child) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            LinkedList linkedList = this.children;
            synchronized (linkedList) {
                this.children.add(child);
            }
        }
    }

    Relations getRelations() {
        return this.relations;
    }

    Regarders getRegarders() {
        return this.regarders;
    }

    synchronized void resetInt() {
        this.setEffectiveSeverity();
        this.removeFilters();
        this.removeLogs();
        this.resetLogged();
        this.resetLoggedCount();
    }

    void resetAllInt() {
        this.resetInt();
        Collection children = this.getChildren();
        if (!children.isEmpty()) {
            this.resetChildren(children.toArray(new LogController[0]));
        }
    }

    void setSumLogged() {
        ++this.loggedSumCnt;
    }

    boolean wasLogged() {
        return this.loggedCnt > 0;
    }

    void resetLogged() {
        this.loggedCnt = 0;
    }

    void setLogged() {
        ++this.loggedCnt;
    }

    String getNewMsg(String msg, int argsLength) {
        return msg + POINTER + "{" + argsLength + "}";
    }

    Object[] getNewArgs(Object[] args, Throwable exc) {
        Object[] tmpArgs = args;
        if (args != null) {
            tmpArgs = new Object[args.length + 1];
            int i = 0;
            while (i < args.length) {
                tmpArgs[i] = args[i];
                ++i;
            }
            tmpArgs[tmpArgs.length - 1] = ExceptionManager.getStackTrace(exc);
        }
        return tmpArgs;
    }

    boolean beGroupInt(Group group) {
        if (group != null) {
            return this.beLogged(group.getSeverity());
        }
        return false;
    }

    void setRecord(LogRecord rec) {
        LoggingManager.getLoggingManager().setRecord(rec);
    }

    void setMinimumSeverity(LogController relative, int severity) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Relations relations = this.getRelations();
            LogController parent = this.getParentInt();
            if (parent != null) {
                severity = Severity.correct(severity);
                if (relative == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                }
                Relation relation = (Relation)relations.get(relative).clone();
                relation.setLocalMinimumSeverity(severity);
                relations.put(relative, relation);
                this.calculateEffectiveSeverity(relative);
            } else {
                this.setEffectiveSeverity(relative, severity);
            }
        }
    }

    void setMinimumSeverity(LogController relative) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Relations relations = this.getRelations();
            LogController parent = this.getParentInt();
            if (parent != null) {
                if (relative == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                }
                Relation relation = (Relation)relations.get(relative).clone();
                relation.setLocalMinimumSeverity();
                relations.put(relative, relation);
                this.calculateEffectiveSeverity(relative);
            }
        }
    }

    void setEffectiveSeverity(LogController relative, int severity) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            severity = Severity.correct(severity);
            if (relative == null) {
                this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
            }
            Relations relations = this.getRelations();
            LogController parent = this.getParentInt();
            Relation relation = relations.get(relative);
            relation = (Relation)relation.clone();
            relation.setLocalMinimumSeverity(severity);
            relation.setLocalMaximumSeverity(severity);
            relations.put(relative, relation);
            this.calculateEffectiveSeverity(relative);
        }
    }

    void setEffectiveSeverity(LogController relative) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Relations relations = this.getRelations();
            LogController parent = this.getParentInt();
            if (parent != null) {
                if (relative == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                }
                Relation relation = (Relation)relations.get(relative).clone();
                relation.setEffectiveSeverity();
                relations.put(relative, relation);
                this.calculateEffectiveSeverity(relative);
            }
        }
    }

    void setMaximumSeverity(LogController relative, int severity) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Relations relations = this.getRelations();
            LogController parent = this.getParentInt();
            if (parent != null) {
                severity = Severity.correct(severity);
                if (relative == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                }
                Relation relation = (Relation)relations.get(relative).clone();
                relation.setLocalMaximumSeverity(severity);
                relations.put(relative, relation);
                this.calculateEffectiveSeverity(relative);
            } else {
                this.setEffectiveSeverity(relative, severity);
            }
        }
    }

    void setMaximumSeverity(LogController relative) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Relations relations = this.getRelations();
            LogController parent = this.getParentInt();
            if (parent != null) {
                if (relative == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                }
                Relation relation = (Relation)relations.get(relative).clone();
                relation.setLocalMaximumSeverity();
                relations.put(relative, relation);
                this.calculateEffectiveSeverity(relative);
            }
        }
    }

    boolean beLogged(LogRecord rec) {
        int severity = rec.getSeverity();
        return this.beLogged(severity) && this.isFiltersAgreeing(rec);
    }

    private boolean beLoggedInt(int severity, LogController[] relatives) {
        if (this.isActivityTracking() || severity >= this.effSeverity) {
            return true;
        }
        if (severity < this.minEffRelationSeverity) {
            return false;
        }
        return severity >= this.getEffectiveSeverity(relatives);
    }

    private void initializeSeverities() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.calculateEffectiveSeverityInt();
            LogController parent = this.getParentInt();
            if (parent != null) {
                Iterator iter = parent.getRelations().entrySet().iterator();
                while (iter.hasNext()) {
                    Relation relation;
                    Map.Entry entry = (Map.Entry)iter.next();
                    Relation parentRelation = (Relation)entry.getValue();
                    if (parentRelation.getMinimumSeverity() == 0 && parentRelation.getMaximumSeverity() == 701) {
                        relation = parentRelation;
                    } else {
                        relation = new Relation();
                        relation.calculateEffectiveSeverity(parentRelation.getEffectiveSeverity());
                    }
                    this.getRelations().put((LogController)entry.getKey(), relation);
                }
                this.minEffRelationSeverity = parent.minEffRelationSeverity;
                iter = parent.getRegarders().iterator();
                while (iter.hasNext()) {
                    LogController regarder = (LogController)iter.next();
                    Relations regarderRelations = regarder.getRelations();
                    Relation regarderRelation = new Relation();
                    Relation regarderParentRelation = regarderRelations.get(parent);
                    regarderRelation.calculateMinimumSeverity(regarderParentRelation.getMinimumSeverity());
                    regarderRelation.calculateMaximumSeverity(regarderParentRelation.getMaximumSeverity());
                    LogController parentRegarder = regarder.getParentInt();
                    if (parentRegarder != null) {
                        Relation parentRegarderRelation = parentRegarder.getRelations().get(this);
                        int parentRegarderMinSeverity = parentRegarderRelation.getMinimumSeverity();
                        int parentRegarderMaxSeverity = parentRegarderRelation.getMaximumSeverity();
                        if (parentRegarderMinSeverity == 0 && regarderRelation.getMinimumSeverity() == parentRegarderMinSeverity && parentRegarderMaxSeverity == 701 && regarderRelation.getMaximumSeverity() == parentRegarderMaxSeverity) {
                            regarderRelation = parentRegarderRelation;
                        } else {
                            regarderRelation.calculateEffectiveSeverity(parentRegarderRelation.getEffectiveSeverity());
                        }
                    } else {
                        regarderRelation.calculateEffectiveSeverity(regarderParentRelation.getEffectiveSeverity());
                    }
                    regarderRelations.put(this, regarderRelation);
                }
            }
        }
    }

    private void calculateEffectiveSeverity() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.isUnchanged()) {
                return;
            }
            this.calculateEffectiveSeverityInt();
        }
    }

    private void calculateEffectiveSeverityInt() {
        LogController parent = this.getParentInt();
        if (parent != null) {
            int parentSeverity = parent.getEffectiveSeverity();
            this.effSeverity = parentSeverity < this.minSeverity ? this.minSeverity : (this.maxSeverity < parentSeverity ? this.maxSeverity : parentSeverity);
        }
        Iterator iter = this.getChildrenInt().iterator();
        while (iter.hasNext()) {
            ((LogController)iter.next()).calculateEffectiveSeverityInt();
        }
    }

    private void calculateEffectiveSeverity(LogController relative) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.getRelations().get(relative).isUnchanged()) {
                return;
            }
            this.calculateEffectiveSeverityInt(relative);
        }
    }

    private void calculateEffectiveSeverityInt(LogController relative) {
        Relations relations = this.getRelations();
        Relation relation = (Relation)relations.get(relative).clone();
        int prevEffSeverity = relation.getEffectiveSeverity();
        LogController parentRelative = relative.getParentInt();
        Relation parentRelativeRelation = relations.get(parentRelative);
        if (parentRelative != null) {
            relation.calculateMinimumSeverity(parentRelativeRelation.getMinimumSeverity());
            relation.calculateMaximumSeverity(parentRelativeRelation.getMaximumSeverity());
        } else {
            relation.calculateMinimumSeverity(relation.getLocalMinimumSeverity());
            relation.calculateMaximumSeverity(relation.getLocalMaximumSeverity());
        }
        LogController parent = this.getParentInt();
        if (parent != null) {
            Relation parentRelation = parent.getRelations().get(relative);
            int parentMinSeverity = parentRelation.getMinimumSeverity();
            int parentMaxSeverity = parentRelation.getMaximumSeverity();
            if (parentMinSeverity == 0 && relation.getMinimumSeverity() == parentMinSeverity && parentMaxSeverity == 701 && relation.getMaximumSeverity() == parentMaxSeverity) {
                relation = parentRelation;
            } else {
                relation.calculateEffectiveSeverity(parentRelation.getEffectiveSeverity());
            }
        } else {
            relation.calculateEffectiveSeverity(parentRelativeRelation.getEffectiveSeverity());
        }
        relations.put(relative, relation);
        int effSeverity = relation.getEffectiveSeverity();
        if (effSeverity < this.minEffRelationSeverity) {
            this.minEffRelationSeverity = effSeverity;
        } else if (effSeverity != this.minEffRelationSeverity && this.minEffRelationSeverity >= prevEffSeverity) {
            Iterator iter = this.getRelations().values().iterator();
            this.minEffRelationSeverity = 701;
            while (iter.hasNext()) {
                effSeverity = ((Relation)iter.next()).getEffectiveSeverity();
                if (effSeverity >= this.minEffRelationSeverity) continue;
                this.minEffRelationSeverity = effSeverity;
            }
        }
        Iterator iter = this.getChildrenInt().iterator();
        while (iter.hasNext()) {
            ((LogController)iter.next()).calculateEffectiveSeverityInt(relative);
        }
        iter = relative.getChildrenInt().iterator();
        while (iter.hasNext()) {
            this.calculateEffectiveSeverityInt((LogController)iter.next());
        }
    }

    private boolean isUnchanged() {
        if (this.minSeverity == this.prevMinSeverity && this.maxSeverity == this.prevMaxSeverity) {
            return true;
        }
        this.prevMinSeverity = this.minSeverity;
        this.prevMaxSeverity = this.maxSeverity;
        return false;
    }

    private Object[] checkArguments(Object[] args) {
        Object[] argValues = args;
        if (argValues != null) {
            int i = 0;
            while (i < argValues.length) {
                if (argValues[i] == null) {
                    argValues[i] = NULL_STRING;
                }
                ++i;
            }
        }
        return argValues;
    }

    private LogController[] copyRelatives(LogController logLC, LogController[] relatives) {
        LogController[] tmpRelatives = new LogController[relatives.length];
        int i = 0;
        while (i < relatives.length) {
            tmpRelatives[i] = relatives[i] != logLC ? relatives[i] : this;
            ++i;
        }
        return tmpRelatives;
    }

    private void fillLogRecordWithGroupData(LogRecord rec, Group group) {
        if (group != null) {
            rec.setGroupID(group.getId().toString());
            rec.setGroupName(group.getName());
            rec.setGroupDescription(group.getDescription());
            rec.setGroupLevel(group.getLevel());
            rec.setGroupIndent(group.getIndent());
        }
    }

    private void closeGroupAllInt() {
        while (this.thrLocals != null) {
            this.closeGroupInt();
        }
    }

    private void resetChildren(LogController[] logControlers) {
        int i = 0;
        while (i < logControlers.length) {
            logControlers[i].resetAllInt();
            ++i;
        }
    }

    private LogRecord writeToLogs(Collection logs, LogRecord rec) throws Exception {
        LogRecord writtenRec = null;
        Iterator iter = logs.iterator();
        while (iter.hasNext()) {
            Log log = (Log)iter.next();
            if (!log.beLogged(rec)) continue;
            writtenRec = log.writeInternalByAPI(rec);
        }
        return writtenRec;
    }

    private LogRecord writeToLocalLogs(Map logs, LogRecord rec) throws Exception {
        LogRecord writtenRec = null;
        Iterator iter = logs.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Log log = (Log)entry.getKey();
            LogController lc = (LogController)entry.getValue();
            if (lc.equals(this) || !lc.beLogged(rec)) continue;
            writtenRec = log.writeInternalByAPI(rec);
        }
        return writtenRec;
    }

    private void initializeLogs() {
        Iterator<Object> iter;
        LogController parent = this.getParentInt();
        if (parent != null) {
            iter = parent.getLogs().iterator();
            while (iter.hasNext()) {
                Log log = (Log)iter.next();
                this.addLogNormalInt(log);
                this.addLogToRegistry(log);
            }
        }
        if (parent != null) {
            iter = parent.getLocalLogsMap().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                Log log = (Log)entry.getKey();
                LogController lc = (LogController)entry.getValue();
                this.addLogLocalInt(lc, log);
                this.addLogToRegistry(log);
            }
        }
    }

    private boolean isLogInRegistry(Log log) {
        return this.logsRegistry.contains(log);
    }

    private synchronized void addLogToRegistry(Log log) {
        if (!this.logsRegistry.contains(log)) {
            HashSet<Log> newLogs = new HashSet<Log>(this.logsRegistry);
            newLogs.add(log);
            this.logsRegistry = newLogs;
        }
    }

    private synchronized void removeLogFromRegistry(Log log) {
        if (this.logsRegistry.contains(log)) {
            log.close();
            HashSet newLogs = new HashSet(this.logsRegistry);
            newLogs.remove(log);
            this.logsRegistry = newLogs;
            log.removeOwner(this.getName());
        }
    }

    private synchronized boolean addLogNormalInt(Log log) {
        if (this.isLogInRegistry(log)) {
            return false;
        }
        if (!this.logsNormal.contains(log)) {
            HashSet<Log> newLogs = new HashSet<Log>(this.logsNormal);
            newLogs.add(log);
            this.logsNormal = newLogs;
            Iterator iter = this.getChildrenInt().iterator();
            while (iter.hasNext()) {
                ((LogController)iter.next()).addLogNormalInt(log);
            }
            return true;
        }
        return false;
    }

    private synchronized boolean addLogLocalInt(LogController parent, Log log) {
        if (this.isLogInRegistry(log)) {
            return false;
        }
        if (!this.logsLocal.containsValue(log)) {
            HashMap<Log, LogController> newLogs = new HashMap<Log, LogController>(this.logsLocal);
            newLogs.put(log, parent);
            this.logsLocal = newLogs;
            Iterator iter = this.getChildrenInt().iterator();
            while (iter.hasNext()) {
                ((LogController)iter.next()).addLogLocalInt(parent, log);
            }
            return true;
        }
        return false;
    }

    private synchronized boolean addLogPrivateInt(Log log) {
        if (this.isLogInRegistry(log)) {
            return false;
        }
        if (!this.logsPrivate.contains(log)) {
            HashSet<Log> newLogs = new HashSet<Log>(this.logsPrivate);
            newLogs.add(log);
            this.logsPrivate = newLogs;
            return true;
        }
        return false;
    }

    private void removeLogsNormalInt() {
        Log[] aLogs;
        Collection collection = this.logsNormal;
        synchronized (collection) {
            aLogs = this.logsNormal.toArray(new Log[this.logsNormal.size()]);
        }
        int i = 0;
        while (i < aLogs.length) {
            this.removeLogNormalInt(aLogs[i]);
            LoggingManager.getLoggingManager().notifyRemoveLog(aLogs[i]);
            ++i;
        }
    }

    private void removeLogsLocalInt() {
        Log[] aLogs;
        Map map = this.logsLocal;
        synchronized (map) {
            aLogs = this.logsLocal.keySet().toArray(new Log[this.logsLocal.size()]);
        }
        int i = 0;
        while (i < aLogs.length) {
            this.removeLogLocalInt(aLogs[i]);
            LoggingManager.getLoggingManager().notifyRemoveLog(aLogs[i]);
            ++i;
        }
    }

    private void removeLogsPrivateInt() {
        Log[] aLogs;
        Collection collection = this.logsPrivate;
        synchronized (collection) {
            aLogs = this.logsPrivate.toArray(new Log[this.logsPrivate.size()]);
        }
        int i = 0;
        while (i < aLogs.length) {
            this.removeLogPrivateInt(aLogs[i]);
            LoggingManager.getLoggingManager().notifyRemoveLog(aLogs[i]);
            ++i;
        }
    }

    private synchronized void removeLogNormalInt(Log log) {
        if (this.logsNormal.contains(log)) {
            HashSet newLogs = new HashSet(this.logsNormal);
            newLogs.remove(log);
            this.logsNormal = newLogs;
            this.removeLogFromRegistry(log);
            Iterator iter = this.getChildrenInt().iterator();
            while (iter.hasNext()) {
                ((LogController)iter.next()).removeLogNormalInt(log);
            }
        }
    }

    private synchronized void removeLogLocalInt(Log log) {
        if (this.logsLocal.containsKey(log)) {
            HashMap newLogs = new HashMap(this.logsLocal);
            newLogs.remove(log);
            this.logsLocal = newLogs;
            this.removeLogFromRegistry(log);
            Iterator iter = this.getChildrenInt().iterator();
            while (iter.hasNext()) {
                ((LogController)iter.next()).removeLogLocalInt(log);
            }
        }
    }

    private synchronized void removeLogPrivateInt(Log log) {
        if (this.logsPrivate.contains(log)) {
            HashSet newLogs = new HashSet(this.logsPrivate);
            newLogs.remove(log);
            this.logsPrivate = newLogs;
            this.removeLogFromRegistry(log);
        }
    }

    private boolean check(LogController relative) {
        if (relative != null) {
            return true;
        }
        this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
        return false;
    }

    private boolean check(LogController[] relatives) {
        if (relatives != null) {
            int i = 0;
            while (i < relatives.length) {
                if (relatives[i] == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                    return false;
                }
                ++i;
            }
            return true;
        }
        this.handleException(new IllegalArgumentException(NO_RELATIVES_EMSG));
        return false;
    }

    protected LogRecord messageInt(LogRecord rec) {
        LogRecord writtenRec = null;
        try {
            writtenRec = this.messageInternal(rec);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return writtenRec;
    }

    static {
        Category.SYS_LOGGING = Category.getCategoryInt("/System/Logging");
        Category.SYS_CONFIGURATION_LOGGING = Category.getCategoryInt("/System/Configuration/Logging");
        String flagAPI = System.getProperty("eventLog");
        if (flagAPI != null && flagAPI.length() > 0) {
            if (flagAPI.equalsIgnoreCase("all") || flagAPI.equalsIgnoreCase("log")) {
                Category.SYS_LOGGING.setEffectiveSeverity(0);
                Category.SYS_LOGGING.addLog(new FileLog("loggingAPI.log"));
            }
            if (flagAPI.equalsIgnoreCase("all") || flagAPI.equalsIgnoreCase("trace")) {
                Location.getLocation("com.sap.tc.logging").setEffectiveSeverity(0);
                Location.getLocation("com.sap.tc.logging").addLog(new FileLog("loggingAPI.trc"));
            }
        }
        standardRelation = new Relation();
    }

    class ThreadLocalInfo
    extends ThreadLocal {
        ThreadLocalInfo() {
        }

        protected Object initialValue() {
            return new Locals();
        }

        public Group getGroup() {
            return ((Locals)super.get()).getGroup();
        }

        public void setGroup(Group group) {
            ((Locals)super.get()).group = group;
        }
    }

    private static class Locals {
        public Group group;

        private Locals() {
        }

        public Group getGroup() {
            return this.group;
        }
    }

    private static class Regarders {
        private LinkedList ordered = new LinkedList();
        private HashSet contained = new HashSet();

        private Regarders() {
        }

        public void put(LogController regarder) {
            if (!this.contained.contains(regarder)) {
                LogController parent = regarder.getParentInt();
                while (parent != null && !this.contained.contains(parent)) {
                    parent = parent.getParentInt();
                }
                if (parent != null) {
                    ListIterator<LogController> iter = this.ordered.listIterator();
                    while (iter.hasNext()) {
                        if (iter.next() != parent) continue;
                        iter.add(regarder);
                        break;
                    }
                } else {
                    this.ordered.addFirst(regarder);
                }
                this.contained.add(regarder);
            }
        }

        public void remove(LogController regarder) {
            if (this.contained.contains(regarder)) {
                this.ordered.remove(regarder);
                this.contained.remove(regarder);
            }
        }

        public boolean isEmpty() {
            return this.ordered.isEmpty();
        }

        public LogController getFirst() {
            return (LogController)this.ordered.getFirst();
        }

        public Iterator iterator() {
            return this.ordered.iterator();
        }
    }

    private class Relations {
        private HashMap relations = new HashMap();

        public Relation get(LogController relative) {
            Relation relation;
            HashMap hashMap = this.relations;
            synchronized (hashMap) {
                relation = (Relation)this.relations.get(relative);
            }
            if (relation == null) {
                relation = standardRelation;
            }
            return relation;
        }

        public void put(LogController relative, Relation relation) {
            if (!relation.equals(standardRelation)) {
                HashMap hashMap = this.relations;
                synchronized (hashMap) {
                    this.relations.put(relative, relation);
                }
                relative.getRegarders().put(LogController.this);
            } else {
                HashMap hashMap = this.relations;
                synchronized (hashMap) {
                    this.relations.remove(relative);
                }
                relative.getRegarders().remove(LogController.this);
            }
        }

        public Set entrySet() {
            return this.relations.entrySet();
        }

        public Collection values() {
            return this.relations.values();
        }
    }

    private static class Relation
    implements Cloneable {
        public volatile int localMinSeverity = 0;
        public volatile int minSeverity = 0;
        public volatile int localMaxSeverity = 701;
        public volatile int maxSeverity = 701;
        public volatile int effSeverity = 701;
        private volatile int prevLocalMinSeverity = 0;
        private volatile int prevLocalMaxSeverity = 701;

        private Relation() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException exc) {
                return null;
            }
        }

        public int getLocalMinimumSeverity() {
            return this.localMinSeverity;
        }

        public int getMinimumSeverity() {
            return this.minSeverity;
        }

        public int getEffectiveSeverity() {
            return this.effSeverity;
        }

        public int getLocalMaximumSeverity() {
            return this.localMaxSeverity;
        }

        public int getMaximumSeverity() {
            return this.maxSeverity;
        }

        public synchronized void setLocalMinimumSeverity(int severity) {
            this.localMinSeverity = severity;
            if (this.localMinSeverity > this.localMaxSeverity) {
                this.localMaxSeverity = this.localMinSeverity;
            }
        }

        public void setLocalMinimumSeverity() {
            this.localMinSeverity = 0;
        }

        public synchronized void calculateMinimumSeverity(int parentSeverity) {
            this.minSeverity = parentSeverity < this.localMinSeverity ? this.localMinSeverity : (this.localMaxSeverity < parentSeverity ? this.localMaxSeverity : parentSeverity);
        }

        public void setEffectiveSeverity(int severity) {
            this.effSeverity = severity;
        }

        public void setEffectiveSeverity() {
            this.localMinSeverity = 0;
            this.localMaxSeverity = 701;
        }

        public synchronized void calculateEffectiveSeverity(int parentSeverity) {
            this.effSeverity = parentSeverity < this.minSeverity ? this.minSeverity : (this.maxSeverity < parentSeverity ? this.maxSeverity : parentSeverity);
        }

        public synchronized void setLocalMaximumSeverity(int severity) {
            this.localMaxSeverity = severity;
            if (this.localMinSeverity > this.localMaxSeverity) {
                this.localMinSeverity = this.localMaxSeverity;
            }
        }

        public void setLocalMaximumSeverity() {
            this.localMaxSeverity = 701;
        }

        public synchronized void calculateMaximumSeverity(int parentSeverity) {
            this.maxSeverity = this.localMaxSeverity < parentSeverity ? this.localMaxSeverity : (parentSeverity < this.localMinSeverity ? this.localMinSeverity : parentSeverity);
        }

        public synchronized boolean isUnchanged() {
            if (this.localMinSeverity == this.prevLocalMinSeverity && this.localMaxSeverity == this.prevLocalMaxSeverity) {
                return true;
            }
            this.prevLocalMinSeverity = this.localMinSeverity;
            this.prevLocalMaxSeverity = this.localMaxSeverity;
            return false;
        }
    }
}

