/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.HelperLib;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.MsgType;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.Version;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ListFormatter
extends Formatter {
    private static Location classLoc = Location.getLocation(class$com$sap$tc$logging$ListFormatter == null ? (class$com$sap$tc$logging$ListFormatter = ListFormatter.class$("com.sap.tc.logging.ListFormatter")) : class$com$sap$tc$logging$ListFormatter);
    static final String EMPTY_STRING = "";
    private static final String DEAFULT_COMPATIBILE_VERSION = "1.5";
    private static final int INITIAL_CAPACITY = 512;
    private static final String DATE_STRING_PATTERN = "EEE MMM dd HH:mm:ss z yyyy";
    private static final int F_MIN = -1;
    private static final int F_VERSION = 0;
    private static final String F_NAME_VERSION = "LR_VERSION";
    private static final int F_GUID = 1;
    private static final String F_NAME_GUID = "LR_ID";
    private static final int F_DATE_TIME = 2;
    public static final String F_NAME_DATE_TIME = "LR_DATE";
    private static final int F_SOURCE_NAME = 3;
    public static final String F_NAME_SOURCE = "LR_SOURCE";
    private static final int F_APPLICATION_NAME = 4;
    public static final String F_NAME_APPLICATION = "LR_APPLICATION";
    private static final int F_LOCATION_NAME = 5;
    public static final String F_NAME_LOCATION = "LR_LOCATION";
    private static final int F_USER = 6;
    public static final String F_NAME_USER = "LR_USER";
    private static final int F_SESSION = 7;
    public static final String F_NAME_SESSION = "LR_SESSION";
    private static final int F_TRANSACTION = 8;
    public static final String F_NAME_TRANSACTION = "LR_TRANSACTION";
    private static final int F_DSR_COMPONENT = 9;
    public static final String F_NAME_DSR_COMPONENT = "LR_DSR_COMPONENT";
    private static final int F_DSR_USER = 10;
    public static final String F_NAME_DSR_USER = "LR_DSR_USER";
    private static final int F_DSR_TRANSACTION = 11;
    public static final String F_NAME_DSR_TRANSACTION = "LR_DSR_TRANSACTION";
    private static final int F_THREAD_NAME = 12;
    public static final String F_NAME_THREAD_NAME = "LR_THREAD_NAME";
    private static final int F_GROUP_ID = 13;
    private static final String F_NAME_GROUP_ID = "LR_GROUP_ID";
    private static final int F_GROUP_LEVEL = 14;
    private static final String F_NAME_GROUP_LEVEL = "LR_GROUP_LEVEL";
    private static final int F_GROUP_INDENT = 15;
    private static final String F_NAME_GROUP_INDENT = "LR_GROUP_IDENT";
    private static final int F_SEVERITY = 16;
    public static final String F_NAME_SEVERITY = "LR_SEVERITY";
    private static final int F_RELATIVES_CNT = 17;
    private static final String F_NAME_RELATIVES_CNT = "LR_RELATIVES_COUNT";
    private static final int F_RELATIVES = 18;
    private static final String F_NAME_RELATIVES = "LR_RELATIVES";
    private static final int F_MSG_TYPE = 19;
    private static final String F_NAME_MSG_TYPE = "LR_MSG_TYPE";
    private static final int F_MSG_CODE = 20;
    private static final String F_NAME_MSG_CODE = "LR_MSG_CODE";
    private static final int F_RES_BUNDLE = 21;
    private static final String F_NAME_RES_BOUNDLE = "LR_RESOURCE_BUNDLE";
    private static final int F_MSG_CLEAR = 22;
    public static final String F_NAME_MSG_CLEAR = "LR_MESSAGE";
    private static final int F_MSG_ARGS_CNT = 23;
    private static final String F_NAME_ARGS_CNT = "LR_MESSAGE ARGS COUNT";
    private static final int F_MSG_ARGS = 24;
    private static final String F_NAME_ARGS = "LR_ARGUMENTS";
    private static final int F_MAX = 25;
    private static final int F_MIN_No_FIELD_VALUES_16 = 10;
    private static final int F_MIN_No_FIELD_VALUES_15 = 10;
    private static final int F_MIN_No_FIELD_VALUES_14 = 10;
    private static final int F_MIN_No_FIELD_VALUES_13 = 10;
    private static final int F_MIN_No_FIELD_VALUES_12 = 10;
    private static final int F_MIN_No_DELIMITERS_16 = 10;
    private static final int F_MIN_No_DELIMITERS_15 = 23;
    private static final int F_MIN_No_DELIMITERS_14 = 10;
    private static final int F_MIN_No_DELIMITERS_13 = 10;
    private static final int F_MIN_No_DELIMITERS_12 = 10;
    private static Map columns = new HashMap();
    static /* synthetic */ Class class$com$sap$tc$logging$ListFormatter;

    public static Map getFields() {
        return Collections.unmodifiableMap(columns);
    }

    public static boolean compareField(int fieldIndex, int operater, String valueA, String valueB) {
        switch (fieldIndex) {
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 22: {
                return valueA.equalsIgnoreCase(valueB);
            }
            case 2: {
                try {
                    Date d1 = new Date(Long.parseLong(valueA));
                    Date d2 = new Date(Long.parseLong(valueB));
                    return HelperLib.compareTwoDates(operater, d1, d2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public String format(LogRecord rec) {
        StringBuffer res = new StringBuffer(512);
        StringBuffer esc = new StringBuffer();
        res.append('#');
        res.append(this.getWorkingVersion());
        res.append('#');
        res.append(rec.getId());
        res.append('#');
        res.append(rec.getTime().getTime());
        res.append('#');
        res.append(this.escape(rec.getSourceName(), esc));
        res.append('#');
        res.append(this.escape(rec.getApplication(), esc));
        res.append('#');
        res.append(this.escape(rec.getLocationName(), esc));
        res.append('#');
        res.append(this.escape(rec.getUser(), esc));
        res.append('#');
        res.append(this.escape(rec.getSession(), esc));
        res.append('#');
        res.append(this.escape(rec.getTransaction(), esc));
        res.append('#');
        res.append(this.escape(rec.getDsrComponent(), esc));
        res.append('#');
        res.append(this.escape(rec.getDsrUser(), esc));
        res.append('#');
        res.append(this.escape(rec.getDsrTransaction(), esc));
        res.append('#');
        res.append(this.escape(rec.getThreadName(), esc));
        res.append('#');
        res.append(rec.getGroupID());
        res.append('#');
        res.append(rec.getGroupLevel());
        res.append('#');
        res.append(rec.getGroupIndent());
        res.append('#');
        res.append(Severity.toString(rec.getSeverity()));
        String[] relatives = rec.getRelativesInt();
        res.append('#');
        if (relatives != null && relatives.length > 0) {
            res.append(relatives.length);
            res.append('#');
            int i = 0;
            while (i < relatives.length) {
                if (i > 0) {
                    res.append('#');
                }
                res.append(relatives[i]);
                ++i;
            }
        }
        res.append('#');
        res.append(MsgType.toString(rec.getMsgType()));
        res.append('#');
        res.append(rec.getMsgCode());
        res.append('#');
        res.append(rec.getResourceBundleName());
        res.append('#');
        res.append(this.escape(rec.getMsgClear(), esc));
        switch (rec.getMsgType()) {
            case 0: {
                break;
            }
            case 1: {
                Object[] args = rec.getArgsInt();
                res.append('#');
                if (args == null || args.length <= 0) break;
                res.append(args.length);
                res.append('#');
                int i = 0;
                while (i < args.length) {
                    if (i > 0) {
                        res.append('#');
                    }
                    res.append(this.escape(args[i].toString(), esc));
                    ++i;
                }
                break;
            }
        }
        res.append('#');
        res.append(Formatter.EOL);
        return res.toString();
    }

    public LogRecord parseMsg(String completeMsgData) throws ParseException {
        StringTokenizer strTok = new StringTokenizer(completeMsgData, "#", true);
        String nextTok = strTok.nextToken();
        if (nextTok.equals("1.2")) {
            return this.parseMsg12(strTok);
        }
        if (nextTok.equals("#")) {
            String ver = strTok.nextToken();
            if (ver.equals(DEAFULT_COMPATIBILE_VERSION)) {
                if (strTok.countTokens() < 10) {
                    APILogger.logIntByAPI(400, classLoc, "[parseMsg(String completeMsgData)]", MSGCollection.LOGGING_MSG_ID_MISSING_FIELDS, MSGCollection.LOGGING_MSG_STR_MISSING_FIELDS, new String[]{"23", EMPTY_STRING + strTok.countTokens()});
                }
                return this.parseMsgLatest(strTok);
            }
            if (ver.equals("1.4")) {
                if (strTok.countTokens() < 29) {
                    APILogger.logIntByAPI(400, classLoc, "[parseMsg(String completeMsgData)]", MSGCollection.LOGGING_MSG_ID_MISSING_FIELDS, MSGCollection.LOGGING_MSG_STR_MISSING_FIELDS, new String[]{"29", EMPTY_STRING + strTok.countTokens()});
                }
                return this.parseMsg14(strTok);
            }
            if (ver.equals("1.3")) {
                if (strTok.countTokens() < 25) {
                    APILogger.logIntByAPI(400, classLoc, "[parseMsg(String completeMsgData)]", MSGCollection.LOGGING_MSG_ID_MISSING_FIELDS, MSGCollection.LOGGING_MSG_STR_MISSING_FIELDS, new String[]{"29", EMPTY_STRING + strTok.countTokens()});
                }
                return this.parseMsg13(strTok);
            }
        }
        APILogger.logIntByAPI(400, classLoc, "[parseMsg(String completeMsgData)]", MSGCollection.LOGGING_MSG_ID_PARSING, MSGCollection.LOGGING_MSG_STR_PARSING, null);
        return null;
    }

    public LogRecord parseMsg(byte[] msgChunk) throws ParseException {
        if (msgChunk == null || msgChunk.length == 0) {
            return null;
        }
        int delimiterIndex = -1;
        int relativesCnt = 0;
        int relativesIndex = 0;
        int argsCnt = 0;
        int argsIndex = 0;
        int severity = 0;
        int level = 0;
        int indent = 0;
        int msgType = 0;
        Date time = null;
        String msgId = null;
        String source = null;
        String loc = null;
        String groupId = null;
        String application = null;
        String user = null;
        String session = null;
        String transaction = null;
        String dsrComponent = null;
        String dsrUser = null;
        String dsrTransaction = null;
        String thr = null;
        String msgCode = null;
        String resourceBundleName = null;
        String msg = null;
        String[] args = null;
        String[] relativesAsStrings = null;
        boolean isField = false;
        int length = 0;
        int fieldStartPos = 0;
        int fieldEndPos = 0;
        try {
            int i = 0;
            while (i < msgChunk.length) {
                block40: {
                    block42: {
                        block38: {
                            block41: {
                                block39: {
                                    if (msgChunk[i] != 35) break block38;
                                    if (i <= 1 || msgChunk[i - 1] != 92) break block39;
                                    ++length;
                                    break block40;
                                }
                                if (fieldStartPos >= true) break block41;
                                fieldStartPos = i + 1;
                                ++delimiterIndex;
                                break block40;
                            }
                            fieldEndPos = --i;
                            isField = true;
                            break block42;
                        }
                        ++length;
                    }
                    if (isField) {
                        String nextToken = new String(msgChunk, fieldStartPos, length);
                        switch (delimiterIndex) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                msgId = nextToken;
                                break;
                            }
                            case 2: {
                                time = new Date(Long.parseLong(nextToken));
                                break;
                            }
                            case 3: {
                                source = this.revertEscape(nextToken);
                                break;
                            }
                            case 4: {
                                application = this.revertEscape(nextToken);
                                break;
                            }
                            case 5: {
                                loc = this.revertEscape(nextToken);
                                break;
                            }
                            case 6: {
                                user = this.revertEscape(nextToken);
                                break;
                            }
                            case 7: {
                                session = this.revertEscape(nextToken);
                                break;
                            }
                            case 8: {
                                transaction = this.revertEscape(nextToken);
                                break;
                            }
                            case 9: {
                                dsrComponent = this.revertEscape(nextToken);
                                break;
                            }
                            case 10: {
                                dsrUser = this.revertEscape(nextToken);
                                break;
                            }
                            case 11: {
                                dsrTransaction = this.revertEscape(nextToken);
                                break;
                            }
                            case 12: {
                                thr = this.revertEscape(nextToken);
                                break;
                            }
                            case 13: {
                                groupId = nextToken;
                                break;
                            }
                            case 14: {
                                level = Integer.parseInt(nextToken);
                                break;
                            }
                            case 15: {
                                indent = Integer.parseInt(nextToken);
                                break;
                            }
                            case 16: {
                                severity = Severity.parse(nextToken);
                                break;
                            }
                            case 17: {
                                if (nextToken.length() != 0) {
                                    relativesCnt = Integer.parseInt(nextToken);
                                    break;
                                }
                                ++delimiterIndex;
                                break;
                            }
                            case 18: {
                                if (relativesCnt <= 0) break;
                                if (relativesAsStrings == null) {
                                    relativesAsStrings = new String[relativesCnt];
                                }
                                relativesAsStrings[relativesIndex] = new String(msgChunk, fieldStartPos, fieldEndPos - fieldStartPos + 1);
                                if (++relativesIndex >= relativesCnt) break;
                                --delimiterIndex;
                                break;
                            }
                            case 19: {
                                msgType = MsgType.parse(nextToken);
                                break;
                            }
                            case 20: {
                                msgCode = nextToken;
                                break;
                            }
                            case 21: {
                                resourceBundleName = nextToken;
                                break;
                            }
                            case 22: {
                                msg = this.revertEscape(nextToken);
                                break;
                            }
                            case 23: {
                                if (msgType == 0 || nextToken.equals(Formatter.EOL)) {
                                    --delimiterIndex;
                                    break;
                                }
                                if (nextToken.length() != 0) {
                                    argsCnt = Integer.parseInt(nextToken);
                                    args = new String[argsCnt];
                                    break;
                                }
                                ++delimiterIndex;
                                break;
                            }
                            case 24: {
                                args[argsIndex] = this.revertEscape(nextToken);
                                if (argsIndex < argsCnt - 1) {
                                    --delimiterIndex;
                                }
                                ++argsIndex;
                                break;
                            }
                            default: {
                                APILogger.logIntByAPI(400, classLoc, "[parseMsgLatest(StringTokenizer _strTok)]", MSGCollection.LOGGING_MSG_ID_PARSING_FIELD, MSGCollection.LOGGING_MSG_STR_PARSING_FIELD, new String[]{EMPTY_STRING + delimiterIndex, msgId});
                                i = msgChunk.length;
                            }
                        }
                        length = 0;
                        fieldStartPos = 0;
                        isField = false;
                    }
                }
                ++i;
            }
            if (msgId != null) {
                return new LogRecord(msgId, msgChunk.length, time, source, severity, loc, relativesAsStrings, groupId, level, indent, thr, msgType, msgCode, resourceBundleName, msg, args, application, user, session, transaction, dsrComponent, dsrUser, dsrTransaction);
            }
        }
        catch (Exception ex) {
            APILogger.logIntByAPI(400, classLoc, "[parseMsgLatest(StringTokenizer _strTok)]", MSGCollection.LOGGING_MSG_ID_PARSING_FIELD, MSGCollection.LOGGING_MSG_STR_PARSING_FIELD, new String[]{EMPTY_STRING + delimiterIndex, msgId});
            APILogger.catchingIntByAPI(ex);
            throw new ParseException("Field " + delimiterIndex + " cannot be parsed! Message ID : " + msgId, delimiterIndex);
        }
        return null;
    }

    protected String escape(String s, StringBuffer buf) {
        int len = 0;
        if (s == null) {
            s = EMPTY_STRING;
        }
        len = s.length();
        buf.setLength(0);
        buf.append(s);
        int i = 0;
        while (i < len) {
            switch (buf.charAt(i)) {
                case '#': {
                    buf.replace(i, i + 1, "\\#");
                    ++len;
                    ++i;
                    break;
                }
                case '\\': {
                    buf.replace(i, i + 1, "\\\\");
                    ++len;
                    ++i;
                }
            }
            ++i;
        }
        return new String(buf);
    }

    private String[] parseDelimitedItems(int itemSize, byte delimiter, int startTokenPos, int endTokenPos, byte[] message) {
        boolean isMasked = false;
        int itemCounter = 0;
        String[] items = new String[itemSize];
        int startItemPos = startTokenPos;
        int endItemPos = endTokenPos;
        if (itemSize > 1) {
            int i = startTokenPos;
            while (i < endTokenPos + 1) {
                if (message[i] == 92) {
                    isMasked = true;
                } else if (!isMasked && message[i] == delimiter) {
                    if (startItemPos == startTokenPos) {
                        startItemPos = i + 1;
                    } else {
                        endItemPos = i - 1;
                    }
                } else if (endItemPos != 0) {
                    items[itemCounter] = new String(message, startItemPos, endItemPos - startItemPos + 1);
                    ++itemCounter;
                    endItemPos = 0;
                }
                isMasked = false;
                ++i;
            }
        } else {
            items[itemCounter] = new String(message, startItemPos, endItemPos - startItemPos + 1);
        }
        return items;
    }

    private String getWorkingVersion() {
        return DEAFULT_COMPATIBILE_VERSION;
    }

    private LogRecord parseMsgLatest(StringTokenizer _strTok) {
        int delimiterIndex = 0;
        int severity = 0;
        int level = 0;
        int indent = 0;
        int msgType = 0;
        Date time = null;
        String msgId = null;
        String source = null;
        String loc = null;
        String groupId = null;
        String application = null;
        String user = null;
        String session = null;
        String transaction = null;
        String dsrComponent = null;
        String dsrUser = null;
        String dsrTransaction = null;
        String thr = null;
        String msgCode = null;
        String resourceBundleName = null;
        String msg = null;
        Object[] args = null;
        String[] relativesAsStrings = null;
        LFStringTokenizer stringTokenizer = new LFStringTokenizer(_strTok);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String nextToken = stringTokenizer.getNextTokenResolved();
                if (nextToken.equals("#")) {
                    ++delimiterIndex;
                    continue;
                }
                switch (delimiterIndex) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        msgId = nextToken;
                        break;
                    }
                    case 2: {
                        time = new Date(Long.parseLong(nextToken));
                        break;
                    }
                    case 3: {
                        source = this.revertEscape(nextToken);
                        break;
                    }
                    case 4: {
                        application = this.revertEscape(nextToken);
                        break;
                    }
                    case 5: {
                        loc = this.revertEscape(nextToken);
                        break;
                    }
                    case 6: {
                        user = this.revertEscape(nextToken);
                        break;
                    }
                    case 7: {
                        session = this.revertEscape(nextToken);
                        break;
                    }
                    case 8: {
                        transaction = this.revertEscape(nextToken);
                        break;
                    }
                    case 9: {
                        dsrComponent = this.revertEscape(nextToken);
                        break;
                    }
                    case 10: {
                        dsrUser = this.revertEscape(nextToken);
                        break;
                    }
                    case 11: {
                        dsrTransaction = this.revertEscape(nextToken);
                        break;
                    }
                    case 12: {
                        thr = this.revertEscape(nextToken);
                        break;
                    }
                    case 13: {
                        groupId = nextToken;
                        break;
                    }
                    case 14: {
                        level = Integer.parseInt(nextToken);
                        break;
                    }
                    case 15: {
                        indent = Integer.parseInt(nextToken);
                        break;
                    }
                    case 16: {
                        severity = Severity.parse(nextToken);
                        break;
                    }
                    case 17: 
                    case 18: {
                        relativesAsStrings = this.populateRelativesAndMessageArgs(stringTokenizer, nextToken);
                        ++delimiterIndex;
                        if (!stringTokenizer.isNextDelimiterConsumed()) break;
                        ++delimiterIndex;
                        break;
                    }
                    case 19: {
                        msgType = MsgType.parse(nextToken);
                        break;
                    }
                    case 20: {
                        msgCode = nextToken;
                        break;
                    }
                    case 21: {
                        resourceBundleName = nextToken;
                        break;
                    }
                    case 22: {
                        msg = this.revertEscape(nextToken);
                        break;
                    }
                    case 23: 
                    case 24: {
                        if (msgType == 0 || nextToken.equals(Formatter.EOL)) break;
                        args = this.populateRelativesAndMessageArgs(stringTokenizer, nextToken);
                        if (!stringTokenizer.isNextDelimiterConsumed()) break;
                        ++delimiterIndex;
                        break;
                    }
                    default: {
                        APILogger.logIntByAPI(400, classLoc, "[parseMsgLatest(StringTokenizer _strTok)]", MSGCollection.LOGGING_MSG_ID_PARSING_FIELD, MSGCollection.LOGGING_MSG_STR_PARSING_FIELD, new String[]{EMPTY_STRING + delimiterIndex});
                    }
                }
                if (!stringTokenizer.isNextDelimiterConsumed()) continue;
                ++delimiterIndex;
            }
            return new LogRecord(msgId, time, source, severity, loc, relativesAsStrings, groupId, level, indent, thr, msgType, msgCode, resourceBundleName, msg, args, application, user, session, transaction, dsrComponent, dsrUser, dsrTransaction);
        }
        catch (Exception ex) {
            APILogger.logIntByAPI(400, classLoc, "[parseMsgLatest(StringTokenizer _strTok)]", MSGCollection.LOGGING_MSG_ID_PARSING_FIELD, MSGCollection.LOGGING_MSG_STR_PARSING_FIELD, new String[]{EMPTY_STRING + delimiterIndex});
            APILogger.catchingIntByAPI(ex);
            return null;
        }
    }

    private String[] populateRelativesAndMessageArgs(LFStringTokenizer strTok, String nextTok) {
        int numRel = Integer.parseInt(nextTok);
        String[] destination = new String[numRel];
        if (!strTok.isNextDelimiterConsumed()) {
            strTok.getNextTokenResolved();
        }
        int i = 0;
        while (i < numRel) {
            String temp = strTok.getNextTokenResolved();
            if ("#".equals(temp)) {
                destination[i] = EMPTY_STRING;
            } else {
                destination[i] = this.revertEscape(temp);
                if (!strTok.isNextDelimiterConsumed() && i != numRel - 1) {
                    strTok.getNextTokenResolved();
                }
            }
            ++i;
        }
        return destination;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isCompleteMessage(String msg) {
        if (this.getWorkingVersion().equals("1.2")) {
            return true;
        }
        if (msg != null) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            if (msg.endsWith(Formatter.EOL)) {
                msg = msg.substring(0, msg.length() - Formatter.EOL.length());
                continue;
            }
            return false;
lbl9:
            // 2 sources

            ** while (!msg.endsWith((String)"#"))
        }
lbl10:
        // 1 sources

        try {
            if (msg.substring(0, msg.length() - 1).endsWith("\\")) {
                i = 0;
                while (msg.substring(0, msg.length() - i - 1).endsWith("\\")) {
                    ++i;
                }
                if (i % 2 != 0) {
                    return false;
                }
                return this.isEnoughDelimiter(msg);
            }
            return this.isEnoughDelimiter(msg);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isStartMsg(int messageSize, byte[] message) {
        if (messageSize < 6) {
            return false;
        }
        return Version.getVersionIndex(new String(message, 1, 3)) != 0;
    }

    public boolean isCompleteMessage(int messageSize, byte[] message, int delimiterSize, int[] delimiter) {
        if (messageSize < 2) {
            return false;
        }
        switch (Version.getVersionIndex(new String(message, 1, 3))) {
            case 15: {
                return this.isCompleteMessageOld(messageSize, message, delimiterSize, delimiter, 23, 17, 23);
            }
            case 14: {
                break;
            }
            case 13: {
                break;
            }
            case 12: {
                break;
            }
            case 16: {
                return this.isCompleteMessage16(message, delimiterSize);
            }
        }
        return false;
    }

    private boolean isCompleteMessageOld(int messageSize, byte[] message, int delimiterSize, int[] delimiter, int minNumOfDelimiters, int posOfRelatives, int posOfArgs) {
        if (delimiterSize < minNumOfDelimiters) {
            return false;
        }
        int relativesCnt = 0;
        String relativesToken = new String(message, delimiter[posOfRelatives], 2);
        if (relativesToken.length() > 0 && (relativesCnt = this.parseInt(relativesToken)) != 0 && delimiterSize - relativesCnt < minNumOfDelimiters) {
            return false;
        }
        int argsDelIndex = posOfArgs - 1 + relativesCnt;
        String argsToken = new String(message, delimiter[argsDelIndex], 2);
        if (delimiterSize - 1 - argsDelIndex > 1 && argsToken.length() > 0) {
            int argsCnt = this.parseInt(argsToken);
            int realDelimiterSize = delimiterSize - (argsCnt + 1 + relativesCnt);
            if (argsCnt != 0 && delimiterSize - (argsCnt + 1 + relativesCnt) < minNumOfDelimiters) {
                return false;
            }
        }
        if (messageSize > 0 && message[messageSize - 1] == 10) {
            int msgSize;
            if (messageSize > 1 && message[messageSize - 2] == 13) {
                msgSize = this.findLastCharacter(messageSize, message);
                return msgSize > 3 && message[msgSize - 1] != 92 && msgSize > 4 && message[msgSize] == 35;
            }
            msgSize = this.findLastCharacter(messageSize, message);
            return msgSize > 2 && message[msgSize - 1] != 92 && msgSize > 1 && message[msgSize] == 35;
        }
        return false;
    }

    private int findLastCharacter(int messageSize, byte[] message) {
        int i = messageSize - 1;
        while (i >= 0) {
            if (message[i] != 10 && message[i] != 13) {
                return i;
            }
            --i;
        }
        return 0;
    }

    private int parseInt(String value) {
        int i = 0;
        i = 0;
        while (i < value.length()) {
            if (!Character.isDigit(value.charAt(i))) break;
            ++i;
        }
        if (i > 0) {
            return Integer.parseInt(value.substring(0, i));
        }
        return 0;
    }

    private boolean isCompleteMessage16(byte[] line, int numOfDelimiters) {
        return true;
    }

    public boolean isParsable() {
        return true;
    }

    public boolean isStartMessage(String msg) {
        if (this.getWorkingVersion().equals("1.2")) {
            return true;
        }
        if (msg == null) {
            return false;
        }
        String validStart = "#";
        if (!msg.startsWith(validStart)) {
            return false;
        }
        if (msg.length() == 1) {
            return false;
        }
        LFStringTokenizer strTok = new LFStringTokenizer(new StringTokenizer(msg, "#", true));
        if (strTok.countTokens() < 26) {
            return false;
        }
        int j = 0;
        while (strTok.hasMoreTokens()) {
            String nextTok = strTok.getNextTokenResolved();
            ++j;
        }
        return j >= 26;
    }

    private boolean isEnoughDelimiter(String msg) {
        LFStringTokenizer strTok = new LFStringTokenizer(new StringTokenizer(msg, "#", true));
        if (strTok.countTokens() < 27) {
            return false;
        }
        strTok.getNextTokenResolved();
        String versionRead = strTok.getNextTokenResolved();
        int numArgs = 0;
        int baseNumDelim = 0;
        if (versionRead.equals("1.3")) {
            baseNumDelim = 15;
        } else if (versionRead.equals("1.4")) {
            baseNumDelim = 19;
        } else if (versionRead.equals(DEAFULT_COMPATIBILE_VERSION)) {
            baseNumDelim = 22;
        }
        int numDelim = 0;
        while (strTok.hasMoreTokens()) {
            String nextTok = strTok.getNextTokenResolved();
            if (nextTok.equals("#")) {
                if (!(++numDelim == 10 && versionRead.equals("1.3") || numDelim == 14 && versionRead.equals("1.4")) && (numDelim != 17 || !versionRead.equals(DEAFULT_COMPATIBILE_VERSION))) continue;
                nextTok = strTok.getNextTokenResolved();
                if (nextTok.equals("#")) {
                    ++numDelim;
                    continue;
                }
                int numRel = Integer.parseInt(nextTok);
                int i = 0;
                while (i < numRel && strTok.hasMoreTokens()) {
                    if (!strTok.isNextDelimiterConsumed()) {
                        strTok.getNextTokenResolved();
                    }
                    strTok.getNextTokenResolved();
                    ++i;
                }
                continue;
            }
            if (numDelim == baseNumDelim) {
                numArgs = Integer.parseInt(nextTok);
            }
            if (!strTok.isNextDelimiterConsumed()) continue;
            ++numDelim;
        }
        if (numArgs > 0) {
            return numDelim == baseNumDelim + numArgs + 1;
        }
        return numDelim == baseNumDelim;
    }

    protected String revertEscape(String s) {
        StringBuffer buf = new StringBuffer(s);
        int len = s.length();
        int i = 0;
        while (i < len) {
            switch (buf.charAt(i)) {
                case '\\': {
                    buf.deleteCharAt(i);
                    --len;
                }
            }
            ++i;
        }
        return buf.toString();
    }

    private LogRecord parseMsg14(StringTokenizer _strTok) throws ParseException {
        int numDelim = 0;
        String msgId = null;
        Date time = null;
        String source = null;
        int severity = 0;
        String loc = null;
        String groupId = null;
        int level = 0;
        int indent = 0;
        String thr = null;
        int msgType = 0;
        String msgCode = null;
        String resourceBundleName = null;
        String msg = null;
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<String> relatives = null;
        String app = null;
        String user = null;
        String session = null;
        String tranx = null;
        int numArgs = 0;
        LFStringTokenizer strTok = new LFStringTokenizer(_strTok);
        try {
            int i;
            while (strTok.hasMoreTokens()) {
                String nextTok = strTok.getNextTokenResolved();
                if (nextTok.equals("#")) {
                    if (++numDelim != 14) continue;
                    nextTok = strTok.getNextTokenResolved();
                    if (nextTok.equals("#")) {
                        ++numDelim;
                        continue;
                    }
                    int numRel = Integer.parseInt(nextTok);
                    relatives = new ArrayList<String>();
                    i = 0;
                    while (i < numRel) {
                        if (!strTok.isNextDelimiterConsumed()) {
                            strTok.getNextTokenResolved();
                        }
                        relatives.add(this.revertEscape(strTok.getNextTokenResolved()));
                        ++i;
                    }
                    if (!strTok.isNextDelimiterConsumed()) continue;
                    ++numDelim;
                    continue;
                }
                switch (numDelim) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        msgId = nextTok;
                        break;
                    }
                    case 2: {
                        time = new Date(Long.parseLong(nextTok));
                        break;
                    }
                    case 3: {
                        source = this.revertEscape(nextTok);
                        break;
                    }
                    case 4: {
                        app = this.revertEscape(nextTok);
                        break;
                    }
                    case 5: {
                        loc = this.revertEscape(nextTok);
                        break;
                    }
                    case 6: {
                        user = this.revertEscape(nextTok);
                        break;
                    }
                    case 7: {
                        session = this.revertEscape(nextTok);
                        break;
                    }
                    case 8: {
                        tranx = this.revertEscape(nextTok);
                        break;
                    }
                    case 9: {
                        thr = this.revertEscape(nextTok);
                        break;
                    }
                    case 10: {
                        groupId = nextTok;
                        break;
                    }
                    case 11: {
                        level = Integer.parseInt(nextTok);
                        break;
                    }
                    case 12: {
                        indent = Integer.parseInt(nextTok);
                        break;
                    }
                    case 13: {
                        severity = Severity.parse(nextTok);
                        break;
                    }
                    case 15: {
                        msgType = MsgType.parse(nextTok);
                        break;
                    }
                    case 16: {
                        msgCode = nextTok;
                        break;
                    }
                    case 17: {
                        resourceBundleName = nextTok;
                        break;
                    }
                    case 18: {
                        msg = this.revertEscape(nextTok);
                        break;
                    }
                    case 19: {
                        if (nextTok.equals(Formatter.EOL)) break;
                        if (msgType == 0) {
                            throw new ParseException(nextTok, numDelim);
                        }
                        numArgs = Integer.parseInt(nextTok);
                        break;
                    }
                    default: {
                        if (numDelim <= 19) break;
                        if (numArgs == 0) {
                            throw new ParseException(this.revertEscape(nextTok), numDelim);
                        }
                        if (numDelim > 19 + numArgs * 2) {
                            throw new ParseException(this.revertEscape(nextTok), numDelim);
                        }
                        if (nextTok.equals(Formatter.EOL)) break;
                        args.add(this.revertEscape(nextTok));
                    }
                }
                if (!strTok.isNextDelimiterConsumed()) continue;
                ++numDelim;
            }
            Object[] _argsArray = null;
            if (!args.isEmpty()) {
                _argsArray = new String[args.size()];
                args.toArray(_argsArray);
            }
            String[] relativesArr = null;
            if (relatives != null) {
                relativesArr = new String[relatives.size()];
                i = 0;
                while (i < relatives.size()) {
                    String lcName = (String)relatives.get(i);
                    relativesArr[i] = lcName.startsWith("/") ? lcName : lcName;
                    ++i;
                }
            }
            return new LogRecord(msgId, time, source, severity, loc, relativesArr, groupId, level, indent, thr, msgType, msgCode, resourceBundleName, msg, _argsArray, app, user, session, tranx, null, null, null);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), numDelim);
        }
    }

    private LogRecord parseMsg13(StringTokenizer _strTok) throws ParseException {
        int numDelim = 0;
        String msgId = null;
        Date time = null;
        String source = null;
        int severity = 0;
        String loc = null;
        String groupId = null;
        int level = 0;
        int indent = 0;
        String thr = null;
        int msgType = 0;
        String msgCode = null;
        String resourceBundleName = null;
        String msg = null;
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<String> relatives = null;
        int numArgs = 0;
        LFStringTokenizer strTok = new LFStringTokenizer(_strTok);
        try {
            int i;
            while (strTok.hasMoreTokens()) {
                String nextTok = strTok.getNextTokenResolved();
                if (nextTok.equals("#")) {
                    if (++numDelim != 10) continue;
                    nextTok = strTok.getNextTokenResolved();
                    if (nextTok.equals("#")) {
                        ++numDelim;
                        continue;
                    }
                    int numRel = Integer.parseInt(nextTok);
                    relatives = new ArrayList<String>();
                    i = 0;
                    while (i < numRel) {
                        if (!strTok.isNextDelimiterConsumed()) {
                            strTok.getNextTokenResolved();
                        }
                        relatives.add(this.revertEscape(strTok.getNextTokenResolved()));
                        ++i;
                    }
                    if (!strTok.isNextDelimiterConsumed()) continue;
                    ++numDelim;
                    continue;
                }
                switch (numDelim) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        msgId = nextTok;
                        break;
                    }
                    case 2: {
                        time = new Date(Long.parseLong(nextTok));
                        break;
                    }
                    case 3: {
                        source = this.revertEscape(nextTok);
                        break;
                    }
                    case 4: {
                        loc = this.revertEscape(nextTok);
                        break;
                    }
                    case 5: {
                        thr = this.revertEscape(nextTok);
                        break;
                    }
                    case 6: {
                        groupId = nextTok;
                        break;
                    }
                    case 7: {
                        level = Integer.parseInt(nextTok);
                        break;
                    }
                    case 8: {
                        indent = Integer.parseInt(nextTok);
                        break;
                    }
                    case 9: {
                        severity = Severity.parse(nextTok);
                        break;
                    }
                    case 11: {
                        msgType = MsgType.parse(nextTok);
                        break;
                    }
                    case 12: {
                        msgCode = nextTok;
                        break;
                    }
                    case 13: {
                        resourceBundleName = nextTok;
                        break;
                    }
                    case 14: {
                        msg = this.revertEscape(nextTok);
                        break;
                    }
                    case 15: {
                        if (nextTok.equals(Formatter.EOL)) break;
                        if (msgType == 0) {
                            throw new ParseException(nextTok, numDelim);
                        }
                        numArgs = Integer.parseInt(nextTok);
                        break;
                    }
                    default: {
                        if (numDelim <= 15) break;
                        if (numArgs == 0) {
                            throw new ParseException(this.revertEscape(nextTok), numDelim);
                        }
                        if (numDelim > 15 + numArgs * 2) {
                            throw new ParseException(this.revertEscape(nextTok), numDelim);
                        }
                        if (nextTok.equals(Formatter.EOL)) break;
                        args.add(this.revertEscape(nextTok));
                    }
                }
                if (!strTok.isNextDelimiterConsumed()) continue;
                ++numDelim;
            }
            Object[] _argsArray = null;
            if (!args.isEmpty()) {
                _argsArray = new String[args.size()];
                args.toArray(_argsArray);
            }
            String[] relativesArr = null;
            if (relatives != null) {
                relativesArr = new String[relatives.size()];
                i = 0;
                while (i < relatives.size()) {
                    String lcName = (String)relatives.get(i);
                    relativesArr[i] = lcName.startsWith("/") ? lcName : lcName;
                    ++i;
                }
            }
            return new LogRecord(msgId, time, source, severity, loc, relativesArr, groupId, level, indent, thr, msgType, msgCode, resourceBundleName, msg, _argsArray, null, null, null, null, null, null, null);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), numDelim);
        }
    }

    private LogRecord parseMsg12(StringTokenizer _strTok) throws ParseException {
        int numDelim = 0;
        String msgId = null;
        Date time = null;
        String source = null;
        int severity = 0;
        String loc = null;
        String groupId = null;
        int level = 0;
        int indent = 0;
        String thr = null;
        int msgType = 0;
        String msgCode = null;
        String resourceBundleName = null;
        String msg = null;
        ArrayList<String> args = new ArrayList<String>();
        LFStringTokenizer strTok = new LFStringTokenizer(_strTok);
        block18: while (strTok.hasMoreTokens()) {
            String nextTok = strTok.getNextTokenResolved();
            if (nextTok.equals("#")) {
                ++numDelim;
                continue;
            }
            switch (numDelim) {
                case 1: {
                    msgId = nextTok;
                    break;
                }
                case 2: {
                    try {
                        time = new Date(new SimpleDateFormat(DATE_STRING_PATTERN).parse(nextTok).getTime());
                        break;
                    }
                    catch (Exception e) {
                        throw new ParseException("invalid timestamp: " + e.getMessage(), 0);
                    }
                }
                case 3: {
                    source = this.revertEscape(nextTok);
                    break;
                }
                case 4: {
                    severity = Severity.parse(nextTok);
                    break;
                }
                case 5: {
                    loc = this.revertEscape(nextTok);
                    break;
                }
                case 6: {
                    groupId = nextTok;
                    break;
                }
                case 7: {
                    level = Integer.parseInt(nextTok);
                    break;
                }
                case 8: {
                    indent = Integer.parseInt(nextTok);
                    break;
                }
                case 9: {
                    thr = this.revertEscape(nextTok);
                    break;
                }
                case 10: {
                    msgType = MsgType.parse(nextTok);
                    break;
                }
                case 11: {
                    msgCode = nextTok;
                    break;
                }
                case 12: {
                    resourceBundleName = nextTok;
                    break;
                }
                case 13: {
                    msg = this.revertEscape(nextTok);
                    break;
                }
                case 14: {
                    break;
                }
                default: {
                    if (numDelim <= 14 || nextTok.equals(Formatter.EOL)) continue block18;
                    args.add(this.revertEscape(nextTok));
                }
            }
        }
        Object[] _argsArray = null;
        if (!args.isEmpty()) {
            _argsArray = new String[args.size()];
            args.toArray(_argsArray);
        }
        return new LogRecord(msgId, time, source, severity, loc, null, groupId, level, indent, thr, msgType, msgCode, resourceBundleName, msg, _argsArray, null, null, null, null, null, null, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        columns.put(F_NAME_VERSION, new Integer(0));
        columns.put(F_NAME_GUID, new Integer(1));
        columns.put(F_NAME_DATE_TIME, new Integer(2));
        columns.put(F_NAME_SOURCE, new Integer(3));
        columns.put(F_NAME_APPLICATION, new Integer(4));
        columns.put(F_NAME_LOCATION, new Integer(5));
        columns.put(F_NAME_USER, new Integer(6));
        columns.put(F_NAME_SESSION, new Integer(7));
        columns.put(F_NAME_TRANSACTION, new Integer(8));
        columns.put(F_NAME_DSR_COMPONENT, new Integer(9));
        columns.put(F_NAME_DSR_USER, new Integer(10));
        columns.put(F_NAME_DSR_TRANSACTION, new Integer(11));
        columns.put(F_NAME_THREAD_NAME, new Integer(12));
        columns.put(F_NAME_GROUP_ID, new Integer(13));
        columns.put(F_NAME_GROUP_LEVEL, new Integer(14));
        columns.put(F_NAME_GROUP_INDENT, new Integer(15));
        columns.put(F_NAME_SEVERITY, new Integer(16));
        columns.put(F_NAME_RELATIVES_CNT, new Integer(17));
        columns.put(F_NAME_RELATIVES, new Integer(18));
        columns.put(F_NAME_MSG_TYPE, new Integer(19));
        columns.put(F_NAME_MSG_CODE, new Integer(20));
        columns.put(F_NAME_RES_BOUNDLE, new Integer(21));
        columns.put(F_NAME_MSG_CLEAR, new Integer(22));
        columns.put(F_NAME_ARGS_CNT, new Integer(23));
        columns.put(F_NAME_ARGS, new Integer(24));
    }

    private class LFStringTokenizer {
        StringTokenizer theTokenizer;
        boolean nextDelimConsumed = false;

        LFStringTokenizer(StringTokenizer strTok) {
            this.theTokenizer = strTok;
        }

        String getNextTokenResolved() {
            if (!this.theTokenizer.hasMoreTokens()) {
                return null;
            }
            this.nextDelimConsumed = false;
            String nextTok = this.theTokenizer.nextToken();
            while (nextTok.endsWith("\\")) {
                int i = 0;
                while (nextTok.substring(0, nextTok.length() - i).endsWith("\\")) {
                    ++i;
                }
                if (i % 2 == 0) break;
                nextTok = nextTok.substring(0, nextTok.length() - 1);
                if (this.theTokenizer.hasMoreTokens()) {
                    nextTok = nextTok.concat(this.theTokenizer.nextToken());
                }
                if (!this.theTokenizer.hasMoreTokens()) continue;
                String tmpStr = this.theTokenizer.nextToken();
                if (tmpStr.equals("#")) {
                    this.nextDelimConsumed = true;
                    break;
                }
                nextTok = nextTok.concat(tmpStr);
            }
            return nextTok;
        }

        boolean hasMoreTokens() {
            return this.theTokenizer.hasMoreTokens();
        }

        int countTokens() {
            return this.theTokenizer.countTokens();
        }

        boolean isNextDelimiterConsumed() {
            return this.nextDelimConsumed;
        }
    }
}

