/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.ExceptionManager;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.MSGCollection;
import java.util.HashMap;

public class Category
extends LogController {
    private static Location classLoc = Location.getLocation(class$com$sap$tc$logging$Category == null ? (class$com$sap$tc$logging$Category = Category.class$("com.sap.tc.logging.Category")) : class$com$sap$tc$logging$Category);
    public static final String ROOT_NAME = "/";
    public static final char SEPARATOR = '/';
    public static final Category SYSTEM = Category.getCategoryInt("/System");
    public static Category APPLICATION = Category.getCategoryInt("/Applications");
    public static Category APPLICATIONS = Category.getCategoryInt("/Applications");
    public static Category APPS_COMMON = Category.getCategory(APPLICATIONS, "Common");
    public static Category APPS_COMMON_SECURITY = Category.getCategory(APPS_COMMON, "Security");
    public static Category APPS_COMMON_BACKUP = Category.getCategory(APPS_COMMON, "Backup");
    public static Category APPS_COMMON_ARCHIVING = Category.getCategory(APPS_COMMON, "Archiving");
    public static Category APPS_COMMON_RESOURCES = Category.getCategory(APPS_COMMON, "Resources");
    public static Category APPS_COMMON_CONFIGURATION = Category.getCategory(APPS_COMMON, "Configuration");
    public static Category APPS_COMMON_FAILOVER = Category.getCategory(APPS_COMMON, "Failover");
    public static Category APPS_COMMON_INFRASTRUCTURE = Category.getCategory(APPS_COMMON, "Infrastructure");
    public static Category PERFORMANCE = Category.getCategoryInt("/Performance");
    public static Category SYS_DATABASE = Category.getCategory(SYSTEM, "Database");
    public static Category SYS_NETWORK = Category.getCategory(SYSTEM, "Network");
    public static Category SYS_SERVER = Category.getCategory(SYSTEM, "Server");
    public static Category SYS_SECURITY = Category.getCategory(SYSTEM, "Security");
    public static Category SYS_USER_INTERFACE = Category.getCategory(SYSTEM, "UserInterface");
    public static Category SYS_CONFIGURATION = Category.getCategory(SYSTEM, "Configuration");
    public static Category SYS_LOGGING = Category.getCategory(SYSTEM, "Logging");
    public static Category SYS_ENTERPRISE_SERVICES = Category.getCategory(SYSTEM, "EnterpriseServices");
    protected static Category SYS_CONFIGURATION_LOGGING = Category.getCategory(SYS_CONFIGURATION, "Logging");
    static HashMap PREDEF_CATEGORIES = new HashMap();
    static final String NO_LOCATION_EMSG = "no location";
    static /* synthetic */ Class class$com$sap$tc$logging$Category;

    Category(String name) {
        super(name);
    }

    Category(String name, Category parent) {
        super(name, parent);
    }

    public static Category getRoot() {
        return Category.getCategoryInt(ROOT_NAME);
    }

    public Category getParent() {
        return (Category)this.getParentInt();
    }

    public static Category getCategory(Category category, String name) {
        if (category != Category.getRoot()) {
            return Category.getCategoryInt(category.getName() + '/' + name);
        }
        return Category.getCategoryInt(category.getName() + name);
    }

    public LogRecord logT(int severity, Location loc, String msg) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityTInt(severity, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logTInt(severity, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Location loc, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityTInt(severity, loc, new LogController[]{loc}, subloc, msg, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logTInt(severity, loc, new LogController[]{this}, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Location loc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityTInt(severity, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msg, 1, args);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logTInt(severity, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Location loc, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityTInt(severity, loc, new LogController[]{loc}, subloc, msg, 1, args);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logTInt(severity, loc, new LogController[]{this}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, subloc, msgCode, null, 1, args);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord infoT(Location loc, String msg) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityTInt(300, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logTInt(300, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord infoT(Location loc, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityTInt(300, loc, new LogController[]{loc}, subloc, msg, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logTInt(300, loc, new LogController[]{this}, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord infoT(Location loc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityTInt(300, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msg, 1, args);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logTInt(300, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord infoT(Location loc, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityTInt(300, loc, new LogController[]{loc}, subloc, msg, 1, args);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logTInt(300, loc, new LogController[]{this}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, subloc, msgCode, null, 1, args);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warningT(Location loc, String msg) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityTInt(400, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logTInt(400, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warningT(Location loc, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityTInt(400, loc, new LogController[]{loc}, subloc, msg, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logTInt(400, loc, new LogController[]{this}, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warningT(Location loc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityTInt(400, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msg, 1, args);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logTInt(400, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warningT(Location loc, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityTInt(400, loc, new LogController[]{loc}, subloc, msg, 1, args);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logTInt(400, loc, new LogController[]{this}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, subloc, msgCode, null, 1, args);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord errorT(Location loc, String msg) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityTInt(500, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beError(this)) {
            loc.logTInt(500, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord errorT(Location loc, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityTInt(500, loc, new LogController[]{loc}, subloc, msg, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beError(this)) {
            loc.logTInt(500, loc, new LogController[]{this}, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord errorT(Location loc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityTInt(500, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msg, 1, args);
        } else if (loc != null && loc.beError(this)) {
            loc.logTInt(500, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord errorT(Location loc, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityTInt(500, loc, new LogController[]{loc}, subloc, msg, 1, args);
        } else if (loc != null && loc.beError(this)) {
            loc.logTInt(500, loc, new LogController[]{this}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, subloc, msgCode, null, 1, args);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Location loc, String msg) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityTInt(500, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beError(this)) {
            loc.logTInt(500, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Location loc, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityTInt(600, loc, new LogController[]{loc}, subloc, msg, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logTInt(600, loc, new LogController[]{this}, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Location loc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityTInt(600, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msg, 1, args);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logTInt(600, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Location loc, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityTInt(600, loc, new LogController[]{loc}, subloc, msg, 1, args);
        } else if (loc != null && loc.beError(this)) {
            loc.logTInt(500, loc, new LogController[]{this}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, subloc, msgCode, null, 1, args);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord logThrowableT(int severity, Location loc, String msg, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS, exc);
        }
        msg = this.getNewMsg(msg, 0);
        Object[] args = new Object[]{ExceptionManager.getStackTrace(exc)};
        if (loc != null) {
            loc.logTInt(severity, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msg, 1, args, exc);
        } else {
            this.handleLCNull("logThrowableT(int severity, Location loc, String subloc, String msg, Throwable exc)", msg, args);
        }
        return writtenRec;
    }

    public LogRecord logThrowableT(int severity, Location loc, String subloc, String msg, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, loc, new LogController[]{this}, subloc, msg, 0, LogController.MSG_ARGS, exc);
        }
        msg = this.getNewMsg(msg, 0);
        Object[] args = new Object[]{ExceptionManager.getStackTrace(exc)};
        if (loc != null) {
            loc.logTInt(severity, loc, new LogController[]{this}, subloc, msg, 1, args, exc);
        } else {
            this.handleLCNull("logThrowableT(int severity, Location loc, String subloc, String msg, Throwable exc)", msg, args);
        }
        return writtenRec;
    }

    public LogRecord logThrowableT(int severity, Location loc, String msg, Object[] args, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msg, 1, args, exc);
        }
        if (args == null) {
            args = new Object[]{ExceptionManager.getStackTrace(exc)};
        }
        msg = this.getNewMsg(msg, args.length);
        args = this.getNewArgs(args, exc);
        if (loc != null) {
            loc.logTInt(severity, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msg, 1, args, exc);
        } else {
            this.handleLCNull("logThrowableT(int severity, Location loc, String msg, Object[] args, Throwable exc)", msg, args);
        }
        return writtenRec;
    }

    public LogRecord logThrowableT(int severity, Location loc, String subloc, String msg, Object[] args, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, loc, new LogController[]{this}, subloc, msg, 1, args, exc);
        }
        if (args == null) {
            args = new Object[]{ExceptionManager.getStackTrace(exc)};
        }
        msg = this.getNewMsg(msg, args.length);
        args = this.getNewArgs(args, exc);
        if (loc != null) {
            loc.logTInt(severity, loc, new LogController[]{this}, subloc, msg, 1, args, exc);
        } else {
            this.handleLCNull("logThrowableT(int severity, Location loc, String subloc, String msg, Object[] args, Throwable exc)", msg, args);
        }
        return writtenRec;
    }

    public LogRecord logThrowable(int severity, Location loc, Object msgCode, String msgClear, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logInt(severity, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS, exc);
        }
        msgClear = this.getNewMsg(msgClear, 0);
        Object[] args = new Object[]{ExceptionManager.getStackTrace(exc)};
        if (loc != null) {
            loc.logInt(severity, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args, exc);
        } else {
            this.handleLCNull("logThrowable(int severity, Location loc, Object\tmsgCode, String msgClear, Throwable exc)", msgClear, args);
        }
        return writtenRec;
    }

    public LogRecord logThrowable(int severity, Location loc, String subloc, Object msgCode, String msgClear, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logInt(severity, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS, exc);
        }
        msgClear = this.getNewMsg(msgClear, 0);
        Object[] args = new Object[]{ExceptionManager.getStackTrace(exc)};
        if (loc != null) {
            loc.logInt(severity, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, args, exc);
        } else {
            this.handleLCNull("logThrowable(int severity, Location loc, String subloc, Object\tmsgCode, String msgClear, Throwable exc)", msgClear, args);
        }
        return writtenRec;
    }

    public LogRecord logThrowable(int severity, Location loc, Object msgCode, Object[] args, String msgClear, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logInt(severity, loc, new LogController[]{loc}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args, exc);
        }
        if (args == null) {
            args = new Object[]{ExceptionManager.getStackTrace(exc)};
        }
        msgClear = this.getNewMsg(msgClear, args.length);
        args = this.getNewArgs(args, exc);
        if (loc != null) {
            loc.logInt(severity, loc, new LogController[]{this}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args, exc);
        } else {
            this.handleLCNull("logThrowable(int severity, Location loc, Object\tmsgCode, Object[] args, String msgClear, Throwable exc)", msgClear, args);
        }
        return writtenRec;
    }

    public LogRecord logThrowable(int severity, Location loc, String subloc, Object msgCode, Object[] args, String msgClear, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logInt(severity, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 1, args, exc);
        }
        if (args == null) {
            args = new Object[]{ExceptionManager.getStackTrace(exc)};
        }
        msgClear = this.getNewMsg(msgClear, args.length);
        args = this.getNewArgs(args, exc);
        if (loc != null) {
            loc.logInt(severity, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, args, exc);
        } else {
            this.handleLCNull("logThrowable(int severity, Location loc, String subloc, Object\tmsgCode, Object[] args, String msgClear, Throwable exc)", msgClear, args);
        }
        return writtenRec;
    }

    public void openGroup(int severity, Location loc) {
        this.openGroupInt(LogController.MSG_GRP_NAME, LogController.MSG_GRP_DESC, severity, LogController.MSG_SUB_LOC, loc);
    }

    public void openGroup(int severity, Location loc, String subloc) {
        this.openGroupInt(LogController.MSG_GRP_NAME, LogController.MSG_GRP_DESC, severity, subloc, loc);
    }

    public void setMinimumSeverity(Location relative, int severity) {
        super.setMinimumSeverity(relative, severity);
    }

    public void setMinimumSeverity(Location relative) {
        super.setMinimumSeverity(relative);
    }

    public void setEffectiveSeverity(Location relative, int severity) {
        super.setEffectiveSeverity(relative, severity);
    }

    public void setEffectiveSeverity(Location relative) {
        super.setEffectiveSeverity(relative);
    }

    public void setMaximumSeverity(Location relative, int severity) {
        super.setMaximumSeverity(relative, severity);
    }

    public void setMaximumSeverity(Location relative) {
        super.setMaximumSeverity(relative);
    }

    static Category getCategoryInt(String name) {
        return LoggingManager.getLoggingManager().getCategory(name);
    }

    private void handleLCNull(String methodName, String msgClear, Object[] args) {
        SYS_LOGGING.logIntByAPI(400, classLoc, methodName, MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, MSGCollection.LOGGING_MSG_STR_OBJECT_IS_NULL, new String[]{"Location", "Category", this.getName()});
        SYS_LOGGING.logIntByAPI(400, classLoc, methodName, MSGCollection.LOGGING_MSG_ID_UNHANDLED, MSGCollection.LOGGING_MSG_STR_UNHANDLED + msgClear, args);
        this.handleException(new NullPointerException("No filter"), 4);
    }

    public static Category getCategory(String name) {
        return Category.getCategoryInt(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PREDEF_CATEGORIES.put(ROOT_NAME, "no-parent");
        PREDEF_CATEGORIES.put("/Performance", ROOT_NAME);
        PREDEF_CATEGORIES.put("/Applications", ROOT_NAME);
        PREDEF_CATEGORIES.put("/Applications/Common", "/Applications");
        PREDEF_CATEGORIES.put("/Applications/Common/Security", "/Applications/Common");
        PREDEF_CATEGORIES.put("/Applications/Common/Backup", "/Applications/Common");
        PREDEF_CATEGORIES.put("/Applications/Common/Archiving", "/Applications/Common");
        PREDEF_CATEGORIES.put("/Applications/Common/Resources", "/Applications/Common");
        PREDEF_CATEGORIES.put("/Applications/Common/Configuration", "/Applications/Common");
        PREDEF_CATEGORIES.put("/Applications/Common/Failover", "/Applications/Common");
        PREDEF_CATEGORIES.put("/Applications/Common/Infrastructure", "/Applications/Common");
        PREDEF_CATEGORIES.put("/System", ROOT_NAME);
        PREDEF_CATEGORIES.put("/System/Database", "/System");
        PREDEF_CATEGORIES.put("/System/Network", "/System");
        PREDEF_CATEGORIES.put("/System/Server", "/System");
        PREDEF_CATEGORIES.put("/System/Security", "/System");
        PREDEF_CATEGORIES.put("/System/UserInterface", "/System");
        PREDEF_CATEGORIES.put("/System/Configuration", "/System");
        PREDEF_CATEGORIES.put("/System/Configuration/Logging", "/System/Configuration");
        PREDEF_CATEGORIES.put("/System/Logging", "/System");
        PREDEF_CATEGORIES.put("/System/EnterpriseServices", "/System");
    }
}

