/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.xmi;

import com.sap.ip.mmr.foundation.JmiException;
import com.sap.ip.mmr.xmi.XmiContext;
import com.sap.ip.mmr.xmi.XmiElement;
import javax.jmi.model.PrimitiveType;
import org.xml.sax.Attributes;

public class XmiPrimitiveValue
extends XmiElement {
    private String xmiValue;
    private String valueAsText = "";
    private PrimitiveType type;
    private boolean xmiAnyValueEndExpected = false;
    private boolean stopCharsReading = false;

    public XmiPrimitiveValue(XmiElement parent, XmiContext context, PrimitiveType type, Attributes attrs) {
        super(parent, context);
        this.type = type;
        this.xmiValue = attrs.getValue("xmi.value");
    }

    public XmiPrimitiveValue(XmiContext context) {
        super(context);
    }

    public void init(XmiElement parent, PrimitiveType type, Attributes attrs) {
        this.parent = parent;
        this.type = type;
        this.xmiValue = attrs.getValue("xmi.value");
        this.valueAsText = "";
        this.xmiAnyValueEndExpected = false;
        this.stopCharsReading = false;
    }

    public void characters(char[] buf, int offset, int len) {
        if (!this.stopCharsReading && buf != null && len > 0 && offset + len <= buf.length) {
            this.valueAsText = this.valueAsText + new String(buf, offset, len);
        }
    }

    public XmiElement startSubElement(String qName, Attributes attrs) {
        if (!qName.equals("XMI.any")) {
            throw new JmiException("2137", new Object[]{qName});
        }
        this.xmiAnyValueEndExpected = true;
        this.valueAsText = "";
        return this;
    }

    public XmiElement endElement(String qName) {
        if (this.xmiAnyValueEndExpected) {
            this.stopCharsReading = true;
            this.xmiAnyValueEndExpected = false;
            return this;
        }
        if (this.xmiValue != null) {
            this.valueAsText = this.xmiValue;
        }
        this.parent.receiveValue(XmiContext.resolvePrimitiveValue(this.type, this.valueAsText));
        return this.parent;
    }
}

