/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.tools;

import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.search.QueryFilter;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.ip.mmr.tools.XMIImport;
import com.sap.tc.logging.Location;
import java.util.Iterator;
import java.util.List;
import javax.resource.ResourceException;

public class QueryMetadata {
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$tools$QueryMetadata == null ? (class$com$sap$ip$mmr$tools$QueryMetadata = QueryMetadata.class$("com.sap.ip.mmr.tools.QueryMetadata")) : class$com$sap$ip$mmr$tools$QueryMetadata);
    private IConnection cx;
    static /* synthetic */ Class class$com$sap$ip$mmr$tools$QueryMetadata;

    public QueryMetadata(Workspace w) {
        ConnectionSpec cxs = new ConnectionSpec();
        if (w != null) {
            cxs.getWorkspacesM1().add(w);
        }
        ConnectionFactory cxf = new ConnectionFactory();
        try {
            this.cx = cxf.getConnection(cxs);
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
    }

    public static void main(String[] args) {
        QueryFilters filters = new QueryFilters();
        String qualifiedNamePackage = null;
        Workspace w = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '-') {
                System.err.println("Parameter must start with a - sign: " + args[i]);
                System.err.println("");
                QueryMetadata.writeUsage();
                return;
            }
            String param = XMIImport.getParameter(args[i]);
            String value = XMIImport.getValue(args[i]);
            if (param == null) {
                QueryMetadata.writeUsage();
                return;
            }
            if (param.compareToIgnoreCase("srcpath") == 0) {
                w = new Workspace(value);
                w.setPath(value);
                continue;
            }
            if (param.compareToIgnoreCase("package") == 0) {
                qualifiedNamePackage = value;
                continue;
            }
            if (param.compareToIgnoreCase("filter") != 0) continue;
            filters = QueryMetadata.getFilters(value);
        }
        QueryMetadata dm = new QueryMetadata(w);
        if (qualifiedNamePackage != null) {
            dm.query(Utilities.getUtilities().decodeQualifiedName(qualifiedNamePackage), filters, false);
        } else {
            dm.query(null, filters, false);
        }
        dm.close();
    }

    private static QueryFilters getFilters(String value) {
        QueryFilters filters = new QueryFilters();
        List l = Utilities.getUtilities().splitByChar(value, ',');
        if (l != null) {
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                String s = (String)iter.next();
                List l1 = Utilities.getUtilities().splitByChar(s, ':');
                if (l1 == null || l1.size() < 2) continue;
                String an = (String)l1.get(0);
                String av = (String)l1.get(1);
                QueryFilter qf = new QueryFilter(an, 0, av);
                filters.add(qf);
            }
        }
        return filters;
    }

    public static void writeUsage() {
        System.err.println("Usage: QueryMetadata [-options]");
        System.err.println("where options include:");
        System.err.println("    -srcpath=<source directory with XMI files or Jar file>");
        System.err.println("    -package=[qualified name of M2-layer package]");
        System.err.println("    -filter=[attributeName:attributevalue,[attributeName:attributevalue[,...]]]");
    }

    public void close() {
        try {
            this.cx.close();
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
    }

    public void query(List qualifiedNamePackage, QueryFilters filters, boolean includeSubTypes) {
        try {
            List l = this.cx.queryM1(qualifiedNamePackage, filters, includeSubTypes);
            System.out.println(l);
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

