/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.generate.jmi;

import com.sap.ip.mmr.foundation.JavaSource;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.generate.jmi.Generator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.ModelElement;
import javax.jmi.model.Namespace;

public class GeneratorEnumerationType {
    public static String getJavaInterfaceName(EnumerationType enumerationType) {
        return Generator.getJMIIdentifier((ModelElement)enumerationType);
    }

    public static String getJavaInterfaceNameQualified(EnumerationType enumerationType) {
        return Generator.getJMIIdentifierQualified((Namespace)enumerationType);
    }

    public static String getJavaClassName(EnumerationType enumerationType) {
        return Generator.getJMIIdentifier((ModelElement)enumerationType) + "Enum";
    }

    public static String getJavaClassNameQualified(EnumerationType enumerationType) {
        return Generator.getJMIIdentifierQualified((Namespace)enumerationType) + "Enum";
    }

    public JavaSource generateTemplate(EnumerationType enumerationType, boolean noJavaDocs, boolean generateInterfaces) {
        StringBuffer code = new StringBuffer(1000);
        String javaInterfaceName = GeneratorEnumerationType.getJavaInterfaceName(enumerationType);
        String javaInterfaceNameQualified = GeneratorEnumerationType.getJavaInterfaceNameQualified(enumerationType);
        String javaClassName = GeneratorEnumerationType.getJavaClassName(enumerationType);
        String javaClassNameQualified = GeneratorEnumerationType.getJavaClassNameQualified(enumerationType);
        Generator.generatePackageStatement(code, (Namespace)enumerationType);
        Generator.generateDefaultIncludes(code);
        if (!noJavaDocs) {
            Generator.generateAnnotationTemplate(code, (ModelElement)enumerationType);
        }
        if (generateInterfaces) {
            code.append("public interface ");
            code.append(javaInterfaceName);
        } else {
            code.append("public class ");
            code.append(javaClassName);
        }
        if (generateInterfaces) {
            code.append(" extends javax.jmi.reflect.RefEnum ");
        } else {
            code.append(" implements ");
            code.append(javaInterfaceNameQualified);
        }
        code.append(" {");
        code.append(Utilities.SystemLineSeparator);
        if (!generateInterfaces) {
            this.generateTemplateEnumClass(enumerationType, code, javaClassName, javaClassNameQualified, javaInterfaceNameQualified);
        }
        code.append("}");
        code.append(Utilities.SystemLineSeparator);
        JavaSource source = null;
        source = generateInterfaces ? new JavaSource(javaInterfaceNameQualified) : new JavaSource(javaClassNameQualified);
        source.setSourceCode(code.toString());
        return source;
    }

    private void generateTemplateEnumClass(EnumerationType enumerationType, StringBuffer code, String javaClassName, String javaClassNameQualified, String javaInterfaceNameQualified) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("// enumeration literals");
        Iterator iter = Generator.getAllEnumrationLabels(enumerationType).iterator();
        while (iter.hasNext()) {
            String label = (String)iter.next();
            l.add("public static final " + javaClassNameQualified + " " + Generator.correctConstant(label) + " = new " + javaClassNameQualified + "(\"" + label + "\");");
        }
        l.add("");
        l.add("private static final java.util.List typeName;");
        l.add("private final java.lang.String literalName;");
        l.add("");
        l.add("static {");
        l.add("  java.util.ArrayList temp = new java.util.ArrayList();");
        iter = enumerationType.getQualifiedName().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            l.add("  temp.add(\"" + name + "\");");
        }
        l.add("  typeName = java.util.Collections.unmodifiableList(temp);");
        l.add("}");
        l.add("");
        l.add("private " + javaClassName + "(java.lang.String literalName) {");
        l.add("  this.literalName = literalName;");
        l.add("}");
        l.add("");
        l.add("public java.lang.String toString() {");
        l.add("  return literalName;");
        l.add("}");
        l.add("");
        l.add("public static " + javaInterfaceNameQualified + " forName(java.lang.String value) {");
        Collection labels = Generator.getAllEnumrationLabels(enumerationType);
        iter = labels.iterator();
        while (iter.hasNext()) {
            String label = (String)iter.next();
            l.add("  if(value.equals(" + Generator.correctConstant(label) + ".literalName)) return " + Generator.correctConstant(label) + ";");
        }
        l.add("   throw new IllegalArgumentException(\"This enumeration label is not defined: \"+value);");
        l.add("}");
        l.add("");
        l.add("public java.util.List refTypeName() {");
        l.add("  return typeName;");
        l.add("}");
        l.add("");
        l.add("public int hashCode() {");
        l.add("  return literalName.hashCode();");
        l.add("}");
        l.add("");
        l.add("public boolean equals(Object o) {");
        l.add("  if (o instanceof " + javaClassNameQualified + ") return (o == this);");
        l.add("  else if (o instanceof " + javaInterfaceNameQualified + ") return (o.toString().equals(literalName));");
        l.add("  else return ((o instanceof javax.jmi.reflect.RefEnum) && ((javax.jmi.reflect.RefEnum) o).refTypeName().equals(typeName) && o.toString().equals(literalName));");
        l.add("}");
        l.add("");
        l.add("protected Object readResolve() throws java.io.ObjectStreamException {");
        l.add("  try {");
        l.add("    return forName(literalName);");
        l.add("  } catch(IllegalArgumentException iae) {");
        l.add("    throw new java.io.InvalidObjectException(iae.getMessage());");
        l.add("  }");
        l.add("}");
        l.add("");
        Generator.addToCode(code, l);
    }
}

