/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.foundation;

import com.sap.ip.mmr.foundation.HierarchyNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class HierarchyNodeText
extends HierarchyNode {
    static final long serialVersionUID = 5324629125421527180L;
    private Map texts = new HashMap();

    public HierarchyNodeText(String name) {
        super(name);
    }

    public void addDescription(Locale locale, String text) {
        this.setChanged(true, false);
        this.texts.put(locale, text);
    }

    public void removeDescription(Locale locale) {
        this.setChanged(true, false);
        this.texts.remove(locale);
    }

    public String getDescription(Locale locale) {
        return (String)this.texts.get(locale);
    }

    public String getDescription() {
        return (String)this.texts.get(Locale.getDefault());
    }

    public void writeXMLTagStart(StringBuffer b) {
        b.append('<');
        b.append("nodeText");
        b.append(' ');
        b.append("mofId");
        b.append("=\"");
        b.append(this.getMofId());
        b.append("\" ");
        b.append("name");
        b.append("=\"");
        b.append(this.getName());
        b.append("\"");
        b.append('>');
        Iterator iter = this.texts.keySet().iterator();
        while (iter.hasNext()) {
            Locale locale = (Locale)iter.next();
            b.append('<');
            b.append("description");
            b.append(' ');
            if (locale.getLanguage() != null) {
                b.append("localeLanguage");
                b.append("=\"");
                b.append(locale.getLanguage());
                b.append("\" ");
            }
            if (locale.getCountry() != null) {
                b.append("localeCountry");
                b.append("=\"");
                b.append(locale.getCountry());
                b.append("\" ");
            }
            if (locale.getVariant() != null) {
                b.append("localeVariant");
                b.append("=\"");
                b.append(locale.getVariant());
                b.append("\" ");
            }
            b.append('>');
            b.append("<![CDATA[");
            b.append(this.texts.get(locale).toString());
            b.append("]]>");
            b.append("</");
            b.append("description");
            b.append('>');
        }
    }

    public void writeXMLTagEnd(StringBuffer b) {
        b.append("</");
        b.append("nodeText");
        b.append('>');
    }

    public String toString() {
        String txt = this.getDescription();
        if (txt == null) {
            txt = "";
        } else if (txt.length() > 20) {
            txt = txt.substring(0, 20) + " ...";
        }
        return super.toString() + "  \"" + txt + "\"";
    }
}

