/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr;

import com.sap.exception.BaseException;
import com.sap.exception.BaseRuntimeException;
import com.sap.ip.mmr.Connection;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.IConnectionFactory;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.ResourceException;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Reference;
import javax.resource.cci.ResourceAdapterMetaData;

public class ConnectionFactory
implements IConnectionFactory {
    static final long serialVersionUID = -927573549207804296L;
    private transient Reference referenceJNDI = null;
    private static transient Map connections = new HashMap();
    protected static final transient Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$ConnectionFactory == null ? (class$com$sap$ip$mmr$ConnectionFactory = ConnectionFactory.class$("com.sap.ip.mmr.ConnectionFactory")) : class$com$sap$ip$mmr$ConnectionFactory);
    static /* synthetic */ Class class$com$sap$ip$mmr$ConnectionFactory;

    public Connection getConnection() throws ResourceException {
        String method = "getConnection()";
        Connection con = new Connection(this, this.createConnectionSpec());
        connections.put(con.getConnectionId(), con);
        location.debugT("getConnection()", MMRResourceAccessor.getInstance().getMessageText(con, "2300"), new Object[]{con.getConnectionId()});
        return con;
    }

    public Connection getConnection(javax.resource.cci.ConnectionSpec properties) throws ResourceException {
        String method = "getConnection(javax.resource.cci.ConnectionSpec properties)";
        location.entering("getConnection(javax.resource.cci.ConnectionSpec properties)");
        Connection con = new Connection(this, properties);
        connections.put(con.getConnectionId(), con);
        if (properties instanceof ConnectionSpec) {
            ConnectionSpec cs = (ConnectionSpec)properties;
            if (cs.getLog() == null) {
                Log log = Utilities.getUtilities().getConsoleLog(System.err);
                log.setEffectiveSeverity(400);
                cs.setLog(log);
            }
            RepositoryServer.getRepositoryServer().addLog(cs.getLog());
            Repository.getCategory().addLog(cs.getLog());
            List wsaM1 = con.getWorkspacesAvailableM1();
            if (cs.getWorkspacesM1() == null || cs.getWorkspacesM1().size() <= 0) {
                Iterator iter = wsaM1.iterator();
                while (iter.hasNext()) {
                    Workspace w = (Workspace)iter.next();
                    cs.getWorkspacesM1().add(w);
                }
            }
            HashSet seta = new HashSet();
            seta.addAll(wsaM1);
            Set set = cs.getWorkspacesM1();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                Workspace w = (Workspace)iter.next();
                if (seta.contains(w)) continue;
                RepositoryServer.getRepositoryServer().registerWorkspace(w, 1);
            }
            List wsaM2 = con.getWorkspacesAvailableM2();
            if (cs.getWorkspacesM2().size() <= 0) {
                cs.getWorkspacesM2().addAll(wsaM2);
            } else {
                iter = cs.getWorkspacesM2().iterator();
                while (iter.hasNext()) {
                    Workspace w = (Workspace)iter.next();
                    RepositoryServer.getRepositoryServer().registerWorkspace(w, 2);
                }
            }
        }
        location.debugT("getConnection(javax.resource.cci.ConnectionSpec properties)", MMRResourceAccessor.getInstance().getMessageText(con, "2300"), new Object[]{con.getConnectionId()});
        location.exiting("getConnection(javax.resource.cci.ConnectionSpec properties)");
        return con;
    }

    public Connection getConnection(String connectionId) throws ResourceException {
        return (Connection)connections.get(connectionId);
    }

    public javax.resource.cci.ConnectionSpec createConnectionSpec() throws ResourceException {
        return new ConnectionSpec();
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        return null;
    }

    public void setReference(Reference reference) {
        this.referenceJNDI = reference;
    }

    public Reference getReference() {
        return this.referenceJNDI;
    }

    public void connectionClose(Connection connection) {
        if (connection == null) {
            return;
        }
        RepositoryServer.getRepositoryServer().removeLog(connection.getConnectionSpec().getLog());
        connections.remove(connection.getConnectionId());
        if (connections.size() == 0) {
            try {
                RepositoryServer.getRepositoryServer().finalizer();
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
    }

    public static String getConnectionsDescription() {
        StringBuffer state = new StringBuffer();
        state.append("<table cellspacing=\"0\" cellpadding=\"5\" width=\"100%\">");
        Iterator iter = connections.values().iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            state.append("<tr>");
            state.append("<td>");
            state.append(con.getConnectionId());
            state.append("</td>");
            state.append("<td>");
            state.append(con.getConnectionSpec().isReadOnly());
            state.append("</td>");
            state.append("<td>");
            state.append(con.getConnectionSpec().getProperties().toString());
            state.append("</td>");
            state.append("</tr>");
        }
        state.append("</table>");
        return state.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

