/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr;

import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.LocalTransaction;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.ResourceException;
import com.sap.ip.mmr.foundation.FilterTypes;
import com.sap.ip.mmr.foundation.HashMapBidirectional;
import com.sap.ip.mmr.foundation.Hierarchy;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.PerformanceData;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofPackage;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import javax.resource.NotSupportedException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.ResultSetInfo;

public class Connection
implements IConnection {
    private static final String JARM_COMPONENT = "BI:MMR:Connection";
    private IRepository repository;
    private ConnectionSpec properties;
    private ConnectionFactory connectionFactory;
    private String connectionId = null;
    protected static final Location location = Location.getLocation((Class)(class$com$sap$ip$mmr$Connection == null ? (class$com$sap$ip$mmr$Connection = Connection.class$("com.sap.ip.mmr.Connection")) : class$com$sap$ip$mmr$Connection));
    private boolean closed = false;
    private Set createdPackgesM1 = null;
    private PerformanceData performanceData = null;
    private Object jarmMonitor = null;
    static /* synthetic */ Class class$com$sap$ip$mmr$Connection;
    static /* synthetic */ Class class$java$lang$String;

    public Connection(ConnectionFactory connectionFactory, javax.resource.cci.ConnectionSpec properties) {
        this.connectionFactory = connectionFactory;
        String method = "Connection(ConnectionFactory connectionFactory, javax.resource.cci.ConnectionSpec properties)";
        location.entering("Connection(ConnectionFactory connectionFactory, javax.resource.cci.ConnectionSpec properties)");
        this.createdPackgesM1 = new HashSet();
        Utilities utils = Utilities.getUtilities();
        this.connectionId = utils.getGUID();
        if (properties instanceof ConnectionSpec) {
            this.properties = (ConnectionSpec)properties;
        }
        if (this.properties.getDbType() != -1) {
            RepositoryServer.getConfiguration().setDatabaseType(this.properties.getDbType());
        }
        this.startJarmComponent();
        this.repository = Repository.createInstance(this);
        this.endJarmComponent();
        location.exiting("Connection(ConnectionFactory connectionFactory, javax.resource.cci.ConnectionSpec properties)");
    }

    private void createJarmMonitor() {
        if (this.jarmMonitor == null) {
            try {
                Class<?> cTaskMonitor = Class.forName("com.sap.util.monitor.jarm.TaskMonitor");
                if (cTaskMonitor != null) {
                    Class[] types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Connection.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Connection.class$("java.lang.String")) : class$java$lang$String};
                    Method m = cTaskMonitor.getMethod("getRequestMonitor", types);
                    if (m != null) {
                        Object[] args = new Object[]{this.properties.getUserName(), JARM_COMPONENT};
                        this.jarmMonitor = m.invoke(cTaskMonitor, args);
                    }
                }
            }
            catch (Exception e) {
                this.jarmMonitor = null;
            }
            catch (Error e) {
                this.jarmMonitor = null;
            }
        }
    }

    private void startJarmComponent() {
        this.createJarmMonitor();
        if (this.jarmMonitor != null) {
            try {
                Class<?> c = Class.forName("com.sap.util.monitor.jarm.TaskMonitor");
                if (c != null) {
                    Class[] types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Connection.class$("java.lang.String")) : class$java$lang$String};
                    Method m = c.getMethod("startComponent", types);
                    Object[] args = new Object[]{JARM_COMPONENT};
                    m.invoke(this.jarmMonitor, args);
                }
            }
            catch (Exception e) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }

    private void endJarmComponent() {
        this.createJarmMonitor();
        if (this.jarmMonitor != null) {
            try {
                Class<?> c = Class.forName("com.sap.util.monitor.jarm.TaskMonitor");
                if (c != null) {
                    Class[] types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Connection.class$("java.lang.String")) : class$java$lang$String};
                    Method m = c.getMethod("endComponent", types);
                    Object[] args = new Object[]{JARM_COMPONENT};
                    m.invoke(this.jarmMonitor, args);
                }
            }
            catch (Exception e) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }

    public Interaction createInteraction() throws javax.resource.ResourceException {
        throw new NotSupportedException(MMRResourceAccessor.getInstance().getMessageText(this.getConnectionSpec().getLocale(), "0000"));
    }

    public ConnectionMetaData getMetaData() throws javax.resource.ResourceException {
        throw new NotSupportedException(MMRResourceAccessor.getInstance().getMessageText(this.getConnectionSpec().getLocale(), "0000"));
    }

    public ResultSetInfo getResultSetInfo() throws javax.resource.ResourceException {
        throw new NotSupportedException(MMRResourceAccessor.getInstance().getMessageText(this.getConnectionSpec().getLocale(), "0000"));
    }

    public javax.resource.cci.LocalTransaction getLocalTransaction() throws javax.resource.ResourceException {
        return new LocalTransaction(this.repository);
    }

    public void close() throws javax.resource.ResourceException {
        this.startJarmComponent();
        this.connectionFactory.connectionClose(this);
        this.repository.finalizer();
        this.closed = true;
        this.endJarmComponent();
    }

    public void setAutoCommit(boolean flag) {
    }

    public boolean getAutoCommit() {
        return false;
    }

    public ModelPackage getTopLevelPackageM2() throws ResourceException {
        return this.repository.getTopLevelPackageM2();
    }

    public List collectM2(Collection elementSearch, String associationId, FilterTypes filterTypes, int searchDepth, boolean sortResult, Set treeResult) throws ResourceException {
        return this.repository.queryElementsM2(elementSearch, associationId, filterTypes, searchDepth, sortResult, treeResult);
    }

    public Collection read(InputStream stream, String URI2, RefPackage extent) throws IOException, MalformedXMIException {
        String method = "read(InputStream stream,String URI,javax.jmi.reflect.RefPackage extent))";
        Repository.getCategory().infoT(location, "read(InputStream stream,String URI,javax.jmi.reflect.RefPackage extent))", MMRResourceAccessor.getInstance().getMessageText(this, "2100"));
        long time = System.currentTimeMillis();
        Collection col = this.repository.read(stream, URI2, extent);
        int n = 0;
        if (col != null) {
            n = col.size();
        }
        time = System.currentTimeMillis() - time;
        Repository.getCategory().infoT(location, "read(InputStream stream,String URI,javax.jmi.reflect.RefPackage extent))", MMRResourceAccessor.getInstance().getMessageText(this, "2101"), new Object[]{new Integer(n), new Float((double)time / 1000.0)});
        return col;
    }

    public Collection read(String URI2, RefPackage extent) throws IOException, MalformedXMIException {
        String method = "read(String URI, javax.jmi.reflect.RefPackage extent)";
        Repository.getCategory().infoT(location, "read(String URI, javax.jmi.reflect.RefPackage extent)", MMRResourceAccessor.getInstance().getMessageText(this, "2100"));
        long time = System.currentTimeMillis();
        Collection col = this.repository.read(URI2, extent);
        int n = 0;
        if (col != null) {
            n = col.size();
        }
        time = System.currentTimeMillis() - time;
        Repository.getCategory().infoT(location, "read(String URI, javax.jmi.reflect.RefPackage extent)", MMRResourceAccessor.getInstance().getMessageText(this, "2101"), new Object[]{new Integer(n), new Float((double)time / 1000.0)});
        return col;
    }

    public void write(OutputStream stream, RefPackage extent, String xmiVersion) throws IOException {
        this.repository.write(stream, extent, xmiVersion);
    }

    public void write(OutputStream stream, Collection objects, String xmiVersion) throws IOException {
        this.repository.write(stream, objects, xmiVersion);
    }

    public RefPackage getTopLevelPackageM1() throws ResourceException {
        return this.repository.getTopLevelPackageM1();
    }

    public MofPackage getMofPackageRootM2() throws ResourceException {
        return this.repository.getMofPackageRootM2();
    }

    public ConnectionSpec getConnectionSpec() {
        return this.properties;
    }

    public List queryM1(List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) throws ResourceException {
        return this.repository.queryM1(qualifiedNameOfType, filters, includeSubTypes);
    }

    public List queryM2(List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) throws ResourceException {
        return this.repository.queryM2(qualifiedNameOfType, filters, includeSubTypes);
    }

    public Hierarchy createHierarchyM1(String name) {
        return this.repository.createHierarchy(1, name);
    }

    public Hierarchy getHierarchyM1(String mofId) {
        return this.repository.getHierarchy(1, mofId);
    }

    public Hierarchy getHierarchyM1ByName(String name) {
        return this.repository.getHierarchy(1, name);
    }

    public List getWorkspacesAvailableM1() {
        return this.repository.getWorkspacesAvailableM1();
    }

    public List getWorkspacesAvailableM2() {
        return this.repository.getWorkspacesAvailableM2();
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public Collection resolveFilesM2(ModelElement modelElement) {
        return this.repository.resolveFilesM2(modelElement);
    }

    public Collection resolveFilesM1(RefObject rbo) {
        return this.repository.resolveFilesM1(rbo);
    }

    public ModelElement resolveQualifiedNameM2(List qualifiedName) {
        return this.repository.resolveQualifiedNameM2(qualifiedName);
    }

    public boolean runTask(String classNameOfTask, Map properties) {
        return this.repository.runTask(classNameOfTask, properties);
    }

    public Collection selectM1(Collection mofIds, boolean forUpdate) {
        return this.repository.selectM1(mofIds, forUpdate);
    }

    public boolean equals(Object obj) {
        boolean res = false;
        if (obj instanceof IConnection) {
            IConnection c = (IConnection)obj;
            res = this.getConnectionId().compareTo(c.getConnectionId()) == 0;
        }
        return res;
    }

    public int hashCode() {
        return this.getConnectionId().hashCode();
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public MofPackage getMofPackageRootM3() throws ResourceException {
        return (MofPackage)this.repository.selectM3("MOF_PACKAGE_M3_ROOT");
    }

    public RefPackage createRefPackageM1(List qualifiedName) throws ResourceException {
        RefPackage topRefPck = this.getTopLevelPackageM1();
        String packageName = Utilities.getUtilities().encodeQualifiedName(qualifiedName);
        RefPackage refPck = topRefPck.refPackage(packageName);
        if (this.createdPackgesM1.contains(packageName)) {
            refPck = (RefPackage)RepositoryServer.getRepositoryServer().createCloneM1(this.repository, (IMMRObject)refPck);
        } else {
            this.createdPackgesM1.add(packageName);
        }
        return refPck;
    }

    public String getMofIdForQualifiedNameM1(String qualifiedName) {
        HashMapBidirectional map = this.repository.getMappingMofIdsQnM1();
        String mofId = (String)map.getBackward(qualifiedName);
        if (mofId == null) {
            mofId = Utilities.getUtilities().getGUID();
            this.putMofIdAndQualifiedName(mofId, qualifiedName);
        }
        return mofId;
    }

    public String getQualifiedNameForMofIdM1(String mofId) {
        HashMapBidirectional map = this.repository.getMappingMofIdsQnM1();
        return (String)map.getForward(mofId);
    }

    public void putMofIdAndQualifiedName(String mofId, String qualifiedName) {
        HashMapBidirectional map = this.repository.getMappingMofIdsQnM1();
        map.put(mofId, qualifiedName);
    }

    public void incrementCounter(String nameOfComponent, String nameOfCounter) {
        if (this.performanceData != null) {
            this.performanceData.incrementCounter(nameOfComponent, nameOfCounter);
        }
    }

    public PerformanceData getPerformanceData() {
        return this.performanceData;
    }

    public void setPerformanceData(PerformanceData performanceData) {
        this.performanceData = performanceData;
    }

    public long getTimeLastDeployment() {
        return this.repository.getTimeLastDeployment();
    }

    public void workspaceContentHasChanged(Workspace workspace) {
        this.repository.workspaceContentHasChanged(workspace);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Log logger = Utilities.getUtilities().getConsoleLog();
        logger.setEffectiveSeverity(400);
        location.addLog(logger);
        location.setEffectiveSeverity(400);
    }
}

