/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.ExType;
import java.text.Format;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StringUtil {
    public static String format(Object value, Format format) throws DdException {
        if (value == null) {
            return "";
        }
        try {
            if (format != null) {
                return format.format(value);
            }
        }
        catch (IllegalArgumentException ex) {
            throw DdException.createInstance(ex, ExType.FORMAT_ERROR);
        }
        return value.toString();
    }

    public static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static boolean isEmptyAfterTrim(String text) {
        return text == null || text.trim().length() == 0;
    }

    public static Object parse(String value, Format format) throws DdException {
        if (value != null) {
            value.trim();
        }
        if (StringUtil.isEmpty(value)) {
            throw new DdException(ExType.PARSE_ERROR, ExTexts.get("006"));
        }
        if (format == null) {
            return null;
        }
        ParsePosition position = new ParsePosition(0);
        return format.parseObject(value, position);
    }

    public static String enumerationToString(Set enumeration, Map enumerationTexts) {
        String s = "";
        if (enumeration != null) {
            Iterator iter = enumeration.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                s = s + obj + "  ";
                if (enumerationTexts != null) {
                    s = s + enumerationTexts.get(obj);
                }
                s = s + "\n";
            }
        }
        return s;
    }

    public static String hashMapToString(HashMap map) {
        String s = "";
        if (map != null) {
            Set set = map.keySet();
            Iterator iter = set.iterator();
            Object obj = null;
            while (iter.hasNext()) {
                obj = iter.next();
                s = "    " + s + (String)obj + "  " + (String)map.get(obj) + "\n";
            }
        }
        return s;
    }

    public static String getQualifiedClassName(String packageName, String unqualifiedClassName) {
        if (packageName == null || "".equals(packageName)) {
            return unqualifiedClassName;
        }
        return packageName + "." + unqualifiedClassName;
    }

    public static String getUnqualifiedClassName(Class clazz) {
        return StringUtil.getUnqualifiedClassName(clazz.getName());
    }

    public static String getUnqualifiedClassName(String fullClassName) {
        int index = fullClassName.lastIndexOf(46);
        return index < 0 ? fullClassName : fullClassName.substring(index + 1);
    }

    public static String getPackageName(Class clazz) {
        return StringUtil.getPackageName(clazz.getName());
    }

    public static String getPackageName(String fullClassName) {
        int index = fullClassName.lastIndexOf(46);
        return index < 0 ? "" : fullClassName.substring(0, index);
    }

    protected static String ConversionExitAlphaInput(String s, int length) {
        String t = s;
        int ls = t.length();
        StringBuffer b = null;
        int digitPos = -1;
        int spacePos = -1;
        boolean notOnlyDigits = false;
        int i = 0;
        while (i < ls) {
            char ch = t.charAt(i);
            if (!Character.isDigit(ch) && ch != ' ') {
                notOnlyDigits = true;
                break;
            }
            if (Character.isDigit(ch)) {
                digitPos = i;
                if (spacePos < i && spacePos != -1) {
                    notOnlyDigits = true;
                    break;
                }
            } else if (ch == ' ' && digitPos != -1) {
                spacePos = i;
            }
            ++i;
        }
        if (notOnlyDigits || t.trim().equalsIgnoreCase("")) {
            b = new StringBuffer(s);
            int i2 = s.length();
            while (i2 < length) {
                b.append(' ');
                ++i2;
            }
        } else {
            t = s.trim();
            b = new StringBuffer(t);
            int i3 = t.length();
            while (i3 < length) {
                b.insert(0, '0');
                ++i3;
            }
        }
        return b.toString();
    }

    protected static String ConversionExitAlphaOutput(String s) {
        int ls = s.length();
        StringBuffer b = new StringBuffer(ls);
        StringBuffer leadingSpaces = new StringBuffer("");
        int relevantZeroPos = -1;
        int zero = 0;
        boolean end = false;
        int i = 0;
        while (i < ls) {
            if (!end) {
                if (s.charAt(i) == ' ') {
                    leadingSpaces.insert(0, ' ');
                } else {
                    end = true;
                }
            }
            ++i;
        }
        if (StringUtil.isEmptyAfterTrim(s)) {
            return "";
        }
        String t = s.trim();
        b = new StringBuffer(t);
        int lsAfterTrim = t.length();
        b = new StringBuffer(ls);
        int i2 = 0;
        while (i2 < lsAfterTrim) {
            char ch = t.charAt(i2);
            if (!Character.isDigit(ch)) {
                t = leadingSpaces.toString() + t;
                return t;
            }
            if (Character.isDigit(ch)) {
                if (ch != '0') {
                    relevantZeroPos = i2;
                    b.append(ch);
                } else if (relevantZeroPos != -1) {
                    b.append(ch);
                } else {
                    ++zero;
                }
            }
            ++i2;
        }
        if (zero == lsAfterTrim) {
            return "0";
        }
        return b.toString();
    }

    protected static boolean isNumericValue(String value) {
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (!Character.isDigit(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

