/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdCheckException;
import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdTypeNumber;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.typeservices.ISimpleValueServices;
import java.text.ParseException;
import java.util.Locale;

public class DdTypeInteger
extends DdTypeNumber
implements DdConstants {
    private Integer minInclusive = null;
    private Integer maxInclusive = null;
    private Integer minExclusive = null;
    private Integer maxExclusive = null;
    private Integer defaultValue = null;
    static /* synthetic */ Class class$java$lang$Integer;

    public DdTypeInteger(IDataProvider provider, Locale locale, XmlMap xmlMap) {
        super(provider, locale, xmlMap);
        XmlMap tmap = xmlMap.getXmlMap("SimpleType");
        XmlMap smap = tmap.getXmlMap("SchemaType");
        XmlMap emap = tmap.getXmlMap("ExternalRepresentation");
        XmlMap enumMap = tmap.getXmlMap("EnumerationValues");
        if (enumMap != null) {
            this.setEnum(enumMap.getIntegerSet("EnumerationValue", "value"));
        }
        this.minInclusive = smap.getIntegerObject("minInclusive");
        this.maxInclusive = smap.getIntegerObject("maxInclusive");
        this.minExclusive = smap.getIntegerObject("minExclusive");
        this.maxExclusive = smap.getIntegerObject("maxExclusive");
        this.defaultValue = emap.getIntegerObject("defaultValue");
    }

    public Class getAttributeClass() {
        return class$java$lang$Integer == null ? (class$java$lang$Integer = DdTypeInteger.class$("java.lang.Integer")) : class$java$lang$Integer;
    }

    public String formatOfDefaultValue() {
        if (this.defaultValue == null) {
            return "";
        }
        return this.format(this.defaultValue);
    }

    public Object parse(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        return this.parseIntegerObject(text);
    }

    public Integer parse(Integer value, String text) throws ParseException {
        return this.parseIntegerObject(text);
    }

    public Integer parseIntegerObject(String text) throws ParseException {
        Integer value = super.parseInteger(text);
        this.checkAfterParse(value);
        return value;
    }

    public boolean isValid(Object value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        if (value instanceof Integer) {
            return this.isValid((Integer)value);
        }
        throw new IllegalArgumentException();
    }

    public boolean isValid(Integer value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        return !(this.minInclusive != null && value.compareTo(this.minInclusive) < 0 || this.maxInclusive != null && value.compareTo(this.maxInclusive) > 0 || this.minExclusive != null && value.compareTo(this.minExclusive) <= 0 || this.maxExclusive != null && value.compareTo(this.maxExclusive) >= 0 || !this.matchesPattern(value) || !this.matchesEnumeration(value));
    }

    public void checkValid(Object value) throws DdCheckException {
        if (value == null) {
            if (!super.isValidNull(value)) {
                throw new DdCheckException(DdConstants.NULL_NOT_VALID, new Object[0]);
            }
            return;
        }
        Integer integerValue = null;
        if (!(value instanceof Integer)) {
            throw new DdCheckException(DdConstants.NOT_VALID, new Object[]{value.toString(), value.getClass().getName()});
        }
        integerValue = (Integer)value;
        int maxExtLength = this.getMaxExternalLength();
        if (maxExtLength != 0 && integerValue.toString().length() > maxExtLength) {
            throw new DdCheckException(DdConstants.WRONG_MAX_EXT_LENGTH, new Object[]{value.toString(), new Integer(maxExtLength).toString()});
        }
        if (this.minInclusive != null && integerValue.compareTo(this.minInclusive) < 0) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_INCL, new Object[]{value.toString(), this.minInclusive.toString()});
        }
        if (this.maxInclusive != null && integerValue.compareTo(this.maxInclusive) > 0) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_INCL, new Object[]{value.toString(), this.maxInclusive.toString()});
        }
        if (this.minExclusive != null && integerValue.compareTo(this.minExclusive) <= 0) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_EXCL, new Object[]{value.toString(), this.minExclusive.toString()});
        }
        if (this.maxExclusive != null && integerValue.compareTo(this.maxExclusive) >= 0) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_EXCL, new Object[]{value.toString(), this.maxExclusive.toString()});
        }
        if (!this.matchesPattern(integerValue)) {
            throw new DdCheckException(DdConstants.NO_PATTERN_MATCHING, new Object[]{value.toString(), this.getPattern()});
        }
        if (!this.matchesEnumeration(integerValue)) {
            throw new DdCheckException(DdConstants.NO_ENUM_MATCHING, new Object[]{value.toString()});
        }
    }

    private boolean matchesPattern(Integer value) {
        return true;
    }

    private boolean matchesEnumeration(Object value) {
        if (this.getEnum() == null) {
            return true;
        }
        if (value instanceof Integer) {
            return this.matchesEnumeration((Integer)value);
        }
        throw new IllegalArgumentException();
    }

    private boolean matchesEnumeration(Integer value) {
        ISimpleValueServices svServices;
        if (this.hasSVService() && (svServices = this.getSVServices()) != null) {
            return svServices.validate((Object)value);
        }
        return this.getEnum() == null || this.getEnum().contains(value);
    }

    public void setMinInclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.minInclusive = null;
            } else if (value instanceof Integer) {
                this.minInclusive = (Integer)value;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxInclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.maxInclusive = null;
            } else if (value instanceof Integer) {
                this.maxInclusive = (Integer)value;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMinExclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.minExclusive = null;
            } else if (value instanceof Integer) {
                this.minExclusive = (Integer)value;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxExclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.maxExclusive = null;
            } else if (value instanceof Integer) {
                this.maxExclusive = (Integer)value;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public Object getMinInclusive() {
        return this.minInclusive;
    }

    public Object getMaxInclusive() {
        return this.maxInclusive;
    }

    public Object getMinExclusive() {
        return this.minExclusive;
    }

    public Object getMaxExclusive() {
        return this.maxExclusive;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return super.toString() + "  SchemaType" + "\n" + "    minInclusive         : " + this.getMinInclusive() + "\n" + "    maxInclusive         : " + this.getMaxInclusive() + "\n" + "    minExclusive         : " + this.getMinExclusive() + "\n" + "    maxExclusive         : " + this.getMaxExclusive() + "\n" + StringUtil.enumerationToString(this.getEnum(), this.getEnumerationTexts());
    }

    private void checkAfterParse(Integer value) throws ParseException {
        if (this.isValidationAfterParse() && !this.isValid(value)) {
            throw new ParseException(value + " " + ExTexts.get("002"), 0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

